/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.io.File;
import java.lang.management.RuntimeMXBean;
import javax.management.remote.JMXServiceURL;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.jmx.EnvironmentProvider;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;

public final class JmxApplication
extends Application {
    private int pid = -1;
    private final JMXServiceURL url;
    private EnvironmentProvider envProvider;
    private final Storage storage;
    public Jvm jvm;

    public JmxApplication(Host host, JMXServiceURL url, EnvironmentProvider envProvider, Storage storage) {
        super(host, JmxApplication.createId(url, envProvider, storage));
        this.url = url;
        this.envProvider = envProvider;
        this.storage = storage;
    }

    public JMXServiceURL getJMXServiceURL() {
        return this.url;
    }

    public EnvironmentProvider getEnvironmentProvider() {
        return this.envProvider;
    }

    public int getPid() {
        String name;
        RuntimeMXBean rt;
        JvmMXBeans mxbeans;
        JmxModel jmxModel;
        if (this.pid == -1 && (jmxModel = JmxModelFactory.getJmxModelFor((Application)this)) != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null && (rt = mxbeans.getRuntimeMXBean()) != null && (name = rt.getName()) != null && name.indexOf("@") != -1) {
            name = name.substring(0, name.indexOf("@"));
            this.pid = Integer.parseInt(name);
        }
        return this.pid;
    }

    public void setStateImpl(int newState) {
        if (newState != 1) {
            this.pid = -1;
            this.jvm = null;
        }
        this.setState(newState);
    }

    public boolean supportsUserRemove() {
        return true;
    }

    protected Storage createStorage() {
        return this.storage != null ? this.storage : super.createStorage();
    }

    protected void remove() {
        if (this.getStorage().directoryExists()) {
            Utils.delete((File)this.getStorage().getDirectory(), (boolean)true);
        }
    }

    public String toString() {
        return "JmxApplication [id: " + this.getId() + "]";
    }

    private static String createId(JMXServiceURL url, EnvironmentProvider envProvider, Storage storage) {
        String urlId = url.toString();
        if (envProvider == null) {
            return urlId;
        }
        String envId = envProvider.getEnvironmentId(storage);
        if (envId == null || "".equals(envId)) {
            return urlId;
        }
        return envId + "-" + urlId;
    }
}

