/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.server;

import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.tools.chromeinspector.InspectorDebugger;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.InspectorProfiler;
import com.oracle.truffle.tools.chromeinspector.InspectorRuntime;
import com.oracle.truffle.tools.chromeinspector.commands.Command;
import com.oracle.truffle.tools.chromeinspector.commands.ErrorResponse;
import com.oracle.truffle.tools.chromeinspector.commands.Params;
import com.oracle.truffle.tools.chromeinspector.commands.Result;
import com.oracle.truffle.tools.chromeinspector.domains.DebuggerDomain;
import com.oracle.truffle.tools.chromeinspector.domains.Domain;
import com.oracle.truffle.tools.chromeinspector.domains.ProfilerDomain;
import com.oracle.truffle.tools.chromeinspector.domains.RuntimeDomain;
import com.oracle.truffle.tools.chromeinspector.events.Event;
import com.oracle.truffle.tools.chromeinspector.events.EventHandler;
import com.oracle.truffle.tools.chromeinspector.server.CommandProcessException;
import com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import com.oracle.truffle.tools.chromeinspector.server.JSONMessageListener;
import com.oracle.truffle.tools.chromeinspector.types.CallArgument;
import com.oracle.truffle.tools.chromeinspector.types.Location;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONException;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.graalvm.polyglot.io.MessageEndpoint;

public final class InspectServerSession
implements MessageEndpoint {
    private final RuntimeDomain runtime;
    private final DebuggerDomain debugger;
    private final ProfilerDomain profiler;
    private final ReadWriteLock domainLock;
    final InspectorExecutionContext context;
    private volatile MessageEndpoint messageEndpoint;
    private volatile JSONMessageListener jsonMessageListener;
    private volatile CommandProcessThread processThread;
    private Runnable onClose;

    private InspectServerSession(RuntimeDomain runtime, DebuggerDomain debugger, ProfilerDomain profiler, InspectorExecutionContext context, ReadWriteLock domainLock) {
        this.runtime = runtime;
        this.debugger = debugger;
        this.profiler = profiler;
        this.context = context;
        this.domainLock = domainLock;
    }

    public static InspectServerSession create(InspectorExecutionContext context, boolean debugBreak, ConnectionWatcher connectionWatcher) {
        ReentrantReadWriteLock domainLock = new ReentrantReadWriteLock();
        InspectorRuntime runtime = new InspectorRuntime(context);
        InspectorDebugger debugger = new InspectorDebugger(context, debugBreak, domainLock);
        InspectorProfiler profiler = new InspectorProfiler(context, connectionWatcher);
        return new InspectServerSession(runtime, debugger, profiler, context, domainLock);
    }

    public void onClose(Runnable onCloseTask) {
        this.onClose = onCloseTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendClose() {
        Runnable onCloseRunnable = null;
        Lock lock = this.domainLock.writeLock();
        lock.lock();
        try {
            this.runtime.disable();
            this.debugger.disable();
            this.profiler.disable();
        }
        finally {
            lock.unlock();
        }
        this.context.reset();
        InspectServerSession inspectServerSession = this;
        synchronized (inspectServerSession) {
            this.messageEndpoint = null;
            this.processThread.dispose();
            this.processThread = null;
            onCloseRunnable = this.onClose;
        }
        if (onCloseRunnable != null) {
            onCloseRunnable.run();
        }
    }

    public DebuggerDomain getDebugger() {
        return this.debugger;
    }

    public synchronized void setMessageListener(MessageEndpoint messageListener) {
        this.messageEndpoint = messageListener;
        if (messageListener != null && this.processThread == null) {
            EventHandlerImpl eh = new EventHandlerImpl();
            this.runtime.setEventHandler(eh);
            this.debugger.setEventHandler(eh);
            this.profiler.setEventHandler(eh);
            this.processThread = new CommandProcessThread();
            this.processThread.start();
        }
    }

    public synchronized void setJSONMessageListener(JSONMessageListener messageListener) {
        this.jsonMessageListener = messageListener;
        if (messageListener != null && this.processThread == null) {
            EventHandlerImpl eh = new EventHandlerImpl();
            this.runtime.setEventHandler(eh);
            this.debugger.setEventHandler(eh);
            this.profiler.setEventHandler(eh);
            this.processThread = new CommandProcessThread();
            this.processThread.start();
        }
    }

    public void sendText(String message) {
        Command cmd;
        try {
            cmd = new Command(message);
        }
        catch (JSONException ex) {
            PrintWriter err = this.context.getErr();
            if (err != null) {
                err.println("Illegal message: '" + message + "' " + ex.getLocalizedMessage());
            }
            return;
        }
        CommandProcessThread pt = this.processThread;
        if (pt != null) {
            pt.push(cmd);
        }
    }

    public void sendCommand(Command cmd) {
        if (this.context.isSynchronous()) {
            this.sendCommandSync(cmd);
        } else {
            CommandProcessThread pt = this.processThread;
            if (pt != null) {
                pt.push(cmd);
            }
        }
    }

    private static boolean isDomainEnabledChange(String domainMethod) {
        switch (domainMethod) {
            case "enable": 
            case "disable": {
                return true;
            }
        }
        return false;
    }

    private Domain getDomain(String name) throws CommandProcessException {
        switch (name) {
            case "Debugger": {
                return this.debugger;
            }
            case "Runtime": {
                return this.runtime;
            }
            case "Profiler": {
                return this.profiler;
            }
            case "Schema": {
                return null;
            }
        }
        throw new CommandProcessException("Unknown domain '" + name + "'.");
    }

    private void sendCommandSync(Command cmd) {
        JSONMessageListener jsonListener;
        CommandPostProcessor postProcessor = new CommandPostProcessor();
        JSONObject result = this.processCommand(cmd, postProcessor);
        if (result != null && (jsonListener = this.jsonMessageListener) != null) {
            try {
                jsonListener.onMessage(result);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                this.context.logException(e);
            }
        }
        postProcessor.run();
    }

    public void consoleAPICall(String type, Object text) {
        this.runtime.notifyConsoleAPICalled(type, text);
    }

    public void sendBinary(ByteBuffer data) {
        throw new UnsupportedOperationException("Binary messages are not supported.");
    }

    public void sendPing(ByteBuffer data) {
    }

    public void sendPong(ByteBuffer data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject processCommand(Command cmd, CommandPostProcessor postProcessor) {
        Object result;
        int dot;
        String method = cmd.getMethod();
        boolean isEnabledChange = InspectServerSession.isDomainEnabledChange(method.substring((dot = method.indexOf(46)) + 1));
        Lock lock = isEnabledChange ? this.domainLock.writeLock() : this.domainLock.readLock();
        lock.lock();
        try {
            Domain domain;
            Domain domain2 = domain = dot > 0 ? this.getDomain(method.substring(0, dot)) : null;
            if (domain != null && !isEnabledChange && !domain.isEnabled()) {
                throw new CommandProcessException("Domain " + method.substring(0, dot) + " is disabled.");
            }
            Params resultParams = this.doProcessCommand(cmd, postProcessor);
            result = resultParams == null ? Result.emptyResult(cmd.getId()) : (resultParams.getJSONObject() != null ? new Result(resultParams).toJSON(cmd.getId()) : null);
        }
        catch (CommandProcessException cpex) {
            result = new ErrorResponse(cmd.getId(), -32601L, cpex.getLocalizedMessage()).toJSON();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            PrintWriter err = this.context.getErr();
            if (err != null) {
                t.printStackTrace(err);
            }
            result = new ErrorResponse(cmd.getId(), -32601L, "Processing of '" + cmd.getMethod() + "' has caused " + t.getLocalizedMessage()).toJSON();
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    private Params doProcessCommand(Command cmd, CommandPostProcessor postProcessor) throws CommandProcessException {
        Params resultParams = null;
        switch (cmd.getMethod()) {
            case "Runtime.enable": {
                this.runtime.enable();
                break;
            }
            case "Runtime.disable": {
                this.runtime.disable();
                break;
            }
            case "Runtime.compileScript": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.runtime.compileScript(json.optString("expression"), json.optString("sourceURL"), json.optBoolean("persistScript"), json.optInt("executionContextId", -1));
                break;
            }
            case "Runtime.evaluate": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.runtime.evaluate(json.optString("expression"), json.optString("objectGroup"), json.optBoolean("includeCommandLineAPI"), json.optBoolean("silent"), json.optInt("contextId", -1), json.optBoolean("returnByValue"), json.optBoolean("generatePreview"), json.optBoolean("awaitPromise"));
                break;
            }
            case "Runtime.runIfWaitingForDebugger": {
                this.runtime.runIfWaitingForDebugger(postProcessor);
                break;
            }
            case "Runtime.getProperties": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.runtime.getProperties(json.optString("objectId"), json.optBoolean("ownProperties"), json.optBoolean("accessorPropertiesOnly"), json.optBoolean("generatePreview"));
                break;
            }
            case "Runtime.callFunctionOn": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.runtime.callFunctionOn(json.optString("objectId"), json.optString("functionDeclaration"), json.optJSONArray("arguments"), json.optBoolean("silent"), json.optBoolean("returnByValue"), json.optBoolean("generatePreview"), json.optBoolean("awaitPromise"));
                break;
            }
            case "Runtime.setCustomObjectFormatterEnabled": {
                JSONObject json = cmd.getParams().getJSONObject();
                this.runtime.setCustomObjectFormatterEnabled(json.optBoolean("enabled"));
                break;
            }
            case "Debugger.enable": {
                this.debugger.enable();
                break;
            }
            case "Debugger.disable": {
                this.debugger.disable();
                break;
            }
            case "Debugger.evaluateOnCallFrame": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.debugger.evaluateOnCallFrame(json.optString("callFrameId"), json.optString("expression"), json.optString("objectGroup"), json.optBoolean("includeCommandLineAPI"), json.optBoolean("silent"), json.optBoolean("returnByValue"), json.optBoolean("generatePreview"), json.optBoolean("throwOnSideEffect"));
                break;
            }
            case "Debugger.getPossibleBreakpoints": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.debugger.getPossibleBreakpoints(Location.create(json.optJSONObject("start")), Location.create(json.optJSONObject("end")), json.optBoolean("restrictToFunction"));
                break;
            }
            case "Debugger.getScriptSource": {
                resultParams = this.debugger.getScriptSource(cmd.getParams().getScriptId());
                break;
            }
            case "Debugger.pause": {
                this.debugger.pause();
                break;
            }
            case "Debugger.resume": {
                this.debugger.resume(postProcessor);
                break;
            }
            case "Debugger.stepInto": {
                this.debugger.stepInto(postProcessor);
                break;
            }
            case "Debugger.stepOver": {
                this.debugger.stepOver(postProcessor);
                break;
            }
            case "Debugger.stepOut": {
                this.debugger.stepOut(postProcessor);
                break;
            }
            case "Debugger.searchInContent": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.debugger.searchInContent(json.optString("scriptId"), json.optString("query"), json.optBoolean("caseSensitive", false), json.optBoolean("isRegex", false));
                break;
            }
            case "Debugger.setAsyncCallStackDepth": {
                this.debugger.setAsyncCallStackDepth(cmd.getParams().getMaxDepth());
                break;
            }
            case "Debugger.setBlackboxPatterns": {
                this.debugger.setBlackboxPatterns(cmd.getParams().getPatterns());
                break;
            }
            case "Debugger.setPauseOnExceptions": {
                this.debugger.setPauseOnExceptions(cmd.getParams().getState());
                break;
            }
            case "Debugger.setBreakpointsActive": {
                this.debugger.setBreakpointsActive(cmd.getParams().getBoolean("active"));
                break;
            }
            case "Debugger.setSkipAllPauses": {
                this.debugger.setSkipAllPauses(cmd.getParams().getBoolean("skip"));
                break;
            }
            case "Debugger.setBreakpointByUrl": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.debugger.setBreakpointByUrl(json.optString("url"), json.optString("urlRegex"), json.optInt("lineNumber", -1) + 1, json.optInt("columnNumber", -1) + 1, json.optString("condition"));
                break;
            }
            case "Debugger.setBreakpoint": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.debugger.setBreakpoint(Location.create(json.getJSONObject("location")), json.optString("condition"));
                break;
            }
            case "Debugger.setBreakpointOnFunctionCall": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.debugger.setBreakpointOnFunctionCall(json.optString("objectId"), json.optString("condition"));
                break;
            }
            case "Debugger.removeBreakpoint": {
                this.debugger.removeBreakpoint(cmd.getParams().getBreakpointId());
                break;
            }
            case "Debugger.continueToLocation": {
                this.debugger.continueToLocation(Location.create(cmd.getParams().getJSONObject().getJSONObject("location")), postProcessor);
                break;
            }
            case "Debugger.restartFrame": {
                JSONObject json = cmd.getParams().getJSONObject();
                resultParams = this.debugger.restartFrame(cmd.getId(), json.optString("callFrameId"), postProcessor);
                break;
            }
            case "Debugger.setReturnValue": {
                JSONObject json = cmd.getParams().getJSONObject();
                this.debugger.setReturnValue(CallArgument.get(json.getJSONObject("newValue")));
                break;
            }
            case "Debugger.setVariableValue": {
                JSONObject json = cmd.getParams().getJSONObject();
                this.debugger.setVariableValue(json.optInt("scopeNumber", -1), json.optString("variableName"), CallArgument.get(json.getJSONObject("newValue")), json.optString("callFrameId"));
                break;
            }
            case "Profiler.enable": {
                this.profiler.enable();
                break;
            }
            case "Profiler.disable": {
                this.profiler.disable();
                break;
            }
            case "Profiler.setSamplingInterval": {
                this.profiler.setSamplingInterval(cmd.getParams().getSamplingInterval());
                break;
            }
            case "Profiler.start": {
                this.profiler.start();
                break;
            }
            case "Profiler.stop": {
                resultParams = this.profiler.stop();
                break;
            }
            case "Profiler.startPreciseCoverage": {
                Params params = cmd.getParams();
                if (params != null) {
                    JSONObject json = params.getJSONObject();
                    this.profiler.startPreciseCoverage(json.optBoolean("callCount"), json.optBoolean("detailed"));
                    break;
                }
                this.profiler.startPreciseCoverage(false, false);
                break;
            }
            case "Profiler.stopPreciseCoverage": {
                this.profiler.stopPreciseCoverage();
                break;
            }
            case "Profiler.takePreciseCoverage": {
                resultParams = this.profiler.takePreciseCoverage();
                break;
            }
            case "Profiler.getBestEffortCoverage": {
                resultParams = this.profiler.getBestEffortCoverage();
                break;
            }
            case "Profiler.startTypeProfile": {
                this.profiler.startTypeProfile();
                break;
            }
            case "Profiler.stopTypeProfile": {
                this.profiler.stopTypeProfile();
                break;
            }
            case "Profiler.takeTypeProfile": {
                resultParams = this.profiler.takeTypeProfile();
                break;
            }
            case "Schema.getDomains": {
                resultParams = InspectServerSession.getDomains();
                break;
            }
            default: {
                throw new CommandProcessException("'" + cmd.getMethod() + "' wasn't found");
            }
        }
        return resultParams;
    }

    private static Params getDomains() {
        JSONArray domains = new JSONArray();
        domains.put((Object)InspectServerSession.createJsonDomain("Runtime"));
        domains.put((Object)InspectServerSession.createJsonDomain("Debugger"));
        domains.put((Object)InspectServerSession.createJsonDomain("Profiler"));
        domains.put((Object)InspectServerSession.createJsonDomain("Schema"));
        JSONObject domainsObj = new JSONObject();
        domainsObj.put("domains", (Object)domains);
        return new Params(domainsObj);
    }

    private static JSONObject createJsonDomain(String name) {
        JSONObject dom = new JSONObject();
        dom.put("name", (Object)name);
        dom.put("version", (Object)"1.2");
        return dom;
    }

    private class CommandProcessThread
    extends Thread {
        private volatile boolean disposed;
        private final BlockingQueue<Command> commands;

        CommandProcessThread() {
            super("chromeinspector.server.CommandProcessThread");
            this.disposed = false;
            this.commands = new LinkedBlockingQueue<Command>();
            this.setDaemon(true);
        }

        void push(Command cmd) {
            if (this.disposed) {
                return;
            }
            try {
                this.commands.put(cmd);
            }
            catch (InterruptedException iex) {
                this.dispose();
            }
        }

        void dispose() {
            this.disposed = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.disposed) {
                Command cmd;
                try {
                    cmd = this.commands.take();
                }
                catch (InterruptedException iex) {
                    break;
                }
                CommandPostProcessor postProcessor = new CommandPostProcessor();
                JSONObject result = InspectServerSession.this.processCommand(cmd, postProcessor);
                if (result != null) {
                    JSONMessageListener jsonListener;
                    MessageEndpoint listener = InspectServerSession.this.messageEndpoint;
                    if (listener != null) {
                        try {
                            listener.sendText(result.toString());
                        }
                        catch (IOException ex) {
                            InspectServerSession.this.context.logException(ex);
                        }
                    }
                    if ((jsonListener = InspectServerSession.this.jsonMessageListener) != null) {
                        try {
                            jsonListener.onMessage(result);
                        }
                        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                            InspectServerSession.this.context.logException(e);
                        }
                    }
                }
                postProcessor.run();
            }
        }
    }

    public final class CommandPostProcessor {
        private Runnable postProcessJob;

        public void setPostProcessJob(Runnable postProcessJob) {
            assert (this.postProcessJob == null);
            this.postProcessJob = postProcessJob;
        }

        void run() {
            if (this.postProcessJob != null) {
                this.postProcessJob.run();
            }
        }
    }

    private class EventHandlerImpl
    implements EventHandler {
        private EventHandlerImpl() {
        }

        @Override
        public void event(Event event) {
            JSONMessageListener jsonListener;
            MessageEndpoint listener = InspectServerSession.this.messageEndpoint;
            if (listener != null) {
                try {
                    listener.sendText(event.toJSONString());
                }
                catch (IOException ex) {
                    InspectServerSession.this.context.logException(ex);
                }
            }
            if ((jsonListener = InspectServerSession.this.jsonMessageListener) != null) {
                try {
                    jsonListener.onMessage(event.toJSON());
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    InspectServerSession.this.context.logException(e);
                }
            }
        }
    }
}

