/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.Pointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Indexable;
import java.nio.Buffer;

public abstract class Indexer
implements AutoCloseable {
    protected static final long[] ONE_STRIDE = new long[]{1L};
    protected long[] sizes;
    protected long[] strides;
    protected Indexable indexable;

    @Override
    public void close() throws Exception {
        this.release();
    }

    protected Indexer(long[] sizes, long[] strides) {
        this.sizes = sizes;
        this.strides = strides;
    }

    public long[] sizes() {
        return this.sizes;
    }

    public long[] strides() {
        return this.strides;
    }

    public long rows() {
        return this.sizes[0];
    }

    public long cols() {
        return this.sizes[1];
    }

    public long width() {
        return this.sizes[1];
    }

    public long height() {
        return this.sizes[0];
    }

    public long channels() {
        return this.sizes[2];
    }

    protected static final long checkIndex(long i, long size) {
        if (i < 0L || i >= size) {
            throw new IndexOutOfBoundsException(Long.toString(i));
        }
        return i;
    }

    public long index(long ... indices) {
        long index = 0L;
        for (int i = 0; i < indices.length && i < this.strides.length; ++i) {
            index += indices[i] * this.strides[i];
        }
        return index;
    }

    public Indexable indexable() {
        return this.indexable;
    }

    public Indexer indexable(Indexable indexable) {
        this.indexable = indexable;
        return this;
    }

    public Object array() {
        return null;
    }

    public Buffer buffer() {
        return null;
    }

    public Pointer pointer() {
        return null;
    }

    public abstract void release();

    public abstract double getDouble(long ... var1);

    public abstract Indexer putDouble(long[] var1, double var2);

    public String toString() {
        long rows = this.sizes.length > 0 ? this.sizes[0] : 1L;
        long cols = this.sizes.length > 1 ? this.sizes[1] : 1L;
        long channels = this.sizes.length > 2 ? this.sizes[2] : 1L;
        StringBuilder s = new StringBuilder(rows > 1L ? "\n[ " : "[ ");
        int i = 0;
        while ((long)i < rows) {
            int j = 0;
            while ((long)j < cols) {
                if (channels > 1L) {
                    s.append("(");
                }
                int k = 0;
                while ((long)k < channels) {
                    double v = this.getDouble(i, j, k);
                    s.append((float)v);
                    if ((long)k < channels - 1L) {
                        s.append(", ");
                    }
                    ++k;
                }
                if (channels > 1L) {
                    s.append(")");
                }
                if ((long)j < cols - 1L) {
                    s.append(", ");
                }
                ++j;
            }
            if ((long)i < rows - 1L) {
                s.append("\n  ");
            }
            ++i;
        }
        s.append(" ]");
        return s.toString();
    }
}

