/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.RootScanner;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm29.j9.walkers.J9MemTagIterator;
import com.ibm.j9ddr.vm29.j9.walkers.MemoryCategoryIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITConfigPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategoryPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.structure.J9JITConfig;
import com.ibm.j9ddr.vm29.structure.J9JavaVM;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClassloader;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaHeap;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaRuntimeMemoryCategory;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaThread;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaVMInitArgs;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJMemoryTagRuntimeMemorySection;
import com.ibm.j9ddr.vm29.view.dtfj.java.corrupt.AddCorruptionToListListener;
import com.ibm.j9ddr.vm29.view.dtfj.java.j9.DTFJMonitorIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public class DTFJJavaRuntime
implements JavaRuntime {
    private final DTFJJavaVMInitArgs vminitargs = new DTFJJavaVMInitArgs();
    private List<Object> references;
    private Properties systemProperties;
    private LinkedList<Object> classLoaders = null;
    private List<ImageSection> mergedHeapSections = null;
    private List<Object> compiledMethods = null;

    public boolean equals(Object object) {
        if (!(object instanceof JavaRuntime)) {
            return false;
        }
        try {
            return this.getJavaVM().equals((Object)((JavaRuntime)object).getJavaVM());
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getJavaVM().hashCode();
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
            return 0;
        }
    }

    public Iterator getCompiledMethods() {
        if (this.compiledMethods == null) {
            this.compiledMethods = new ArrayList<Object>();
            Iterator iterator = this.getJavaClassLoaders();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof CorruptData) {
                    this.compiledMethods.add(e);
                    continue;
                }
                Iterator iterator2 = ((JavaClassLoader)e).getDefinedClasses();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    if (e2 instanceof CorruptData) {
                        this.compiledMethods.add(e2);
                        continue;
                    }
                    Iterator iterator3 = ((JavaClass)e2).getDeclaredMethods();
                    while (iterator3.hasNext()) {
                        Object e3 = iterator3.next();
                        if (e3 instanceof CorruptData) {
                            this.compiledMethods.add(e3);
                        }
                        if (!((JavaMethod)e3).getCompiledSections().hasNext()) continue;
                        this.compiledMethods.add(e3);
                    }
                }
            }
        }
        return this.compiledMethods.iterator();
    }

    public Iterator getHeapRoots() {
        if (null == this.references) {
            this.scanReferences();
        }
        return this.references.iterator();
    }

    public boolean isJITEnabled() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9JITConfigPointer j9JITConfigPointer = DTFJContext.getVm().jitConfig();
            return j9JITConfigPointer.notNull() && j9JITConfigPointer.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public Properties getJITProperties() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties properties = new Properties();
        try {
            J9JITConfigPointer j9JITConfigPointer = DTFJContext.getVm().jitConfig();
            if (j9JITConfigPointer.notNull()) {
                if (j9JITConfigPointer.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED)) {
                    properties.setProperty("JIT", "enabled");
                } else {
                    properties.setProperty("JIT", "disabled");
                }
                if (j9JITConfigPointer.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_AOT_ATTACHED)) {
                    properties.setProperty("AOT", "enabled");
                } else {
                    properties.setProperty("AOT", "disabled");
                }
                if (!j9JITConfigPointer.fsdEnabled().eq(new UDATA(0L))) {
                    properties.setProperty("FSD", "enabled");
                } else {
                    properties.setProperty("FSD", "disabled");
                }
                if (DTFJContext.getVm().requiredDebugAttributes().allBitsIn(J9JavaVM.J9VM_DEBUG_ATTRIBUTE_CAN_REDEFINE_CLASSES)) {
                    properties.setProperty("HCR", "enabled");
                } else {
                    properties.setProperty("HCR", "disabled");
                }
            } else {
                throw new DataUnavailable("JIT not enabled");
            }
            return properties;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    private void scanReferences() {
        this.references = new LinkedList<Object>();
        AddCorruptionToListListener addCorruptionToListListener = new AddCorruptionToListListener(this.references);
        EventManager.register(addCorruptionToListListener);
        try {
            DTFJRootScanner dTFJRootScanner = new DTFJRootScanner();
            dTFJRootScanner.setScanStackSlots(false);
            dTFJRootScanner.scanAllSlots();
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            this.references.add(corruptData);
        }
        EventManager.unregister(addCorruptionToListListener);
    }

    public Iterator getHeaps() throws UnsupportedOperationException {
        try {
            LinkedList<DTFJJavaHeap> linkedList = new LinkedList<DTFJJavaHeap>();
            VoidPointer voidPointer = DTFJContext.getVm().defaultMemorySpace();
            MM_MemorySpacePointer mM_MemorySpacePointer = MM_MemorySpacePointer.cast(voidPointer);
            U8Pointer u8Pointer = mM_MemorySpacePointer._name();
            String string = "No name";
            if (u8Pointer != null && !u8Pointer.isNull()) {
                try {
                    string = u8Pointer.getCStringAtOffset(0L);
                }
                catch (CorruptDataException corruptDataException) {
                    string = "<<corrupt heap name>>";
                }
            }
            linkedList.add(new DTFJJavaHeap(mM_MemorySpacePointer, string, DTFJContext.getImagePointer(voidPointer.getAddress())));
            return linkedList.iterator();
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    public Iterator getJavaClassLoaders() {
        GCClassLoaderIterator gCClassLoaderIterator;
        if (this.classLoaders != null) {
            return this.classLoaders.iterator();
        }
        this.classLoaders = new LinkedList();
        try {
            gCClassLoaderIterator = GCClassLoaderIterator.from();
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            this.classLoaders.add(corruptData);
            return this.classLoaders.iterator();
        }
        AddCorruptionToListListener addCorruptionToListListener = new AddCorruptionToListListener(this.classLoaders);
        EventManager.register(addCorruptionToListListener);
        try {
            while (!addCorruptionToListListener.fatalCorruption() && gCClassLoaderIterator.hasNext()) {
                J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                if (j9ClassLoaderPointer == null) continue;
                this.classLoaders.add(new DTFJJavaClassloader(j9ClassLoaderPointer));
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            this.classLoaders.add(corruptData);
        }
        EventManager.unregister(addCorruptionToListListener);
        return this.classLoaders.iterator();
    }

    public ImagePointer getJavaVM() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getImagePointer(DTFJContext.getVm().getAddress());
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        return this.vminitargs;
    }

    public Iterator getMonitors() {
        try {
            return new DTFJMonitorIterator();
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
    }

    public JavaObject getObjectAtAddress(ImagePointer imagePointer) throws com.ibm.dtfj.image.CorruptDataException, IllegalArgumentException, MemoryAccessException, DataUnavailable {
        try {
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(imagePointer.getAddress());
            if (j9ObjectPointer.anyBitsIn(ObjectModel.getObjectAlignmentInBytes() - 1L)) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject. Address = " + imagePointer);
            }
            if (this.validHeapAddress(imagePointer)) {
                return new DTFJJavaObject(null, j9ObjectPointer);
            }
            throw new IllegalArgumentException("Object address " + imagePointer + " is not in any heap");
        }
        catch (Throwable throwable) {
            Class[] classArray = new Class[]{IllegalArgumentException.class};
            throw J9DDRDTFJUtils.handleAllButMemAccExAndDataUnavailAsCorruptDataException(DTFJContext.getProcess(), throwable, classArray);
        }
    }

    private synchronized void mergeSections() {
        Object object;
        Object object2;
        if (this.mergedHeapSections != null) {
            return;
        }
        Iterator iterator = this.getHeaps();
        LinkedList<ImageSection> linkedList = new LinkedList<ImageSection>();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            object2 = (DTFJJavaHeap)iterator.next();
            object = ((DTFJJavaHeap)object2).getSections();
            while (object.hasNext()) {
                linkedList.add((ImageSection)object.next());
            }
        }
        Collections.sort(linkedList, new Comparator<ImageSection>(){

            @Override
            public int compare(ImageSection imageSection, ImageSection imageSection2) {
                U64 u64;
                U64 u642 = new U64(imageSection.getBaseAddress().getAddress());
                if (u642.lt(u64 = new U64(imageSection2.getBaseAddress().getAddress()))) {
                    return -1;
                }
                if (u642.gt(u64)) {
                    return 1;
                }
                return 0;
            }
        });
        this.mergedHeapSections = new LinkedList<ImageSection>();
        object2 = linkedList.iterator();
        object = (ImageSection)object2.next();
        while (object2.hasNext()) {
            ImageSection imageSection = (ImageSection)object2.next();
            if (object.getBaseAddress().getAddress() + object.getSize() == imageSection.getBaseAddress().getAddress()) {
                object = new J9DDRImageSection(DTFJContext.getProcess(), object.getBaseAddress().getAddress(), object.getSize() + imageSection.getSize(), null);
                continue;
            }
            this.mergedHeapSections.add((ImageSection)object);
            object = imageSection;
        }
        this.mergedHeapSections.add((ImageSection)object);
    }

    private boolean validHeapAddress(ImagePointer imagePointer) {
        if (this.mergedHeapSections == null) {
            this.mergeSections();
        }
        U64 u64 = new U64(imagePointer.getAddress());
        for (ImageSection imageSection : this.mergedHeapSections) {
            U64 u642 = new U64(imageSection.getBaseAddress().getAddress());
            if (u642.gt(u64)) {
                return false;
            }
            U64 u643 = new U64(imageSection.getBaseAddress().getAddress() + imageSection.getSize());
            if (!u643.gt(u64)) continue;
            return true;
        }
        return false;
    }

    public DTFJJavaHeap getHeapFromAddress(ImagePointer imagePointer) {
        try {
            VoidPointer voidPointer = VoidPointer.cast(imagePointer.getAddress());
            Iterator iterator = this.getHeaps();
            while (iterator.hasNext()) {
                DTFJJavaHeap dTFJJavaHeap = (DTFJJavaHeap)iterator.next();
                Iterator iterator2 = dTFJJavaHeap.getSections();
                while (iterator2.hasNext()) {
                    ImageSection imageSection = (ImageSection)iterator2.next();
                    VoidPointer voidPointer2 = VoidPointer.cast(imageSection.getBaseAddress().getAddress());
                    VoidPointer voidPointer3 = voidPointer2.addOffset(imageSection.getSize());
                    if (!voidPointer.gte(voidPointer2) || !voidPointer.lt(voidPointer3)) continue;
                    return dTFJJavaHeap;
                }
            }
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return null;
    }

    public Iterator getThreads() {
        GCVMThreadListIterator gCVMThreadListIterator;
        try {
            gCVMThreadListIterator = GCVMThreadListIterator.from();
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            return J9DDRDTFJUtils.corruptIterator(corruptData);
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        AddCorruptionToListListener addCorruptionToListListener = new AddCorruptionToListListener(linkedList);
        EventManager.register(addCorruptionToListListener);
        try {
            while (gCVMThreadListIterator.hasNext() && !addCorruptionToListListener.fatalCorruption()) {
                J9VMThreadPointer j9VMThreadPointer = gCVMThreadListIterator.next();
                if (j9VMThreadPointer == null) continue;
                linkedList.add(new DTFJJavaThread(j9VMThreadPointer));
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            linkedList.add(corruptData);
        }
        EventManager.unregister(addCorruptionToListListener);
        return linkedList.iterator();
    }

    public Object getTraceBuffer(String string, boolean bl) throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRCorruptData(DTFJContext.getProcess(), "Trace buffers are not available");
    }

    public String getFullVersion() throws com.ibm.dtfj.image.CorruptDataException {
        return this.getVersion();
    }

    public String getVersion() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getVm().j9ras().serviceLevel().getCStringAtOffset(0L);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    private String getRequiredSystemProperty(String string) throws com.ibm.dtfj.image.CorruptDataException {
        String string2 = null;
        SystemPropertiesEventListener systemPropertiesEventListener = new SystemPropertiesEventListener();
        EventManager.register(systemPropertiesEventListener);
        try {
            string2 = this.getSystemProperties().getProperty(string);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        finally {
            EventManager.unregister(systemPropertiesEventListener);
        }
        if (string2 != null) {
            return string2;
        }
        if (systemPropertiesEventListener.corruption) {
            throw new DTFJCorruptDataException(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), systemPropertiesEventListener.exception));
        }
        throw new DTFJCorruptDataException(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find required system property " + string));
    }

    private Properties getSystemProperties() throws CorruptDataException {
        if (this.systemProperties == null) {
            this.systemProperties = J9JavaVMHelper.getSystemProperties(DTFJContext.getVm());
        }
        return this.systemProperties;
    }

    private String getServiceLevel() {
        try {
            U8Pointer u8Pointer = DataType.getJ9RASPointer().serviceLevel();
            String string = u8Pointer.getCStringAtOffset(0L);
            if (string != null && string.length() > 0) {
                return string;
            }
        }
        catch (Throwable throwable) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
        return "unknown";
    }

    public String toString() {
        return "Java Runtime 0x" + Long.toHexString(DTFJContext.getVm().getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<?> getMemoryCategories() throws DataUnavailable {
        final LinkedList<DTFJJavaRuntimeMemoryCategory> linkedList = new LinkedList<DTFJJavaRuntimeMemoryCategory>();
        IEventListener iEventListener = new IEventListener(){

            @Override
            public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
                linkedList.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException));
            }
        };
        EventManager.register(iEventListener);
        try {
            Iterator<? extends OMRMemCategoryPointer> iterator = MemoryCategoryIterator.iterateCategoryRootSet(DTFJContext.getVm().portLibrary());
            while (iterator.hasNext()) {
                linkedList.add(new DTFJJavaRuntimeMemoryCategory(this, iterator.next()));
            }
        }
        catch (Throwable throwable) {
            CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
            linkedList.add((DTFJJavaRuntimeMemoryCategory)corruptData);
        }
        finally {
            EventManager.unregister(iEventListener);
        }
        return Collections.unmodifiableList(linkedList).iterator();
    }

    public Iterator<?> getMemorySections(boolean bl) throws DataUnavailable {
        if (bl) {
            return IteratorHelpers.combineIterators(new MemTagMemorySectionIterator(J9MemTagIterator.iterateAllocatedHeaders()), new MemTagMemorySectionIterator(J9MemTagIterator.iterateFreedHeaders()), DTFJJavaRuntime.getNonMallocMemorySections());
        }
        return IteratorHelpers.combineIterators(new MemTagMemorySectionIterator(J9MemTagIterator.iterateAllocatedHeaders()), DTFJJavaRuntime.getNonMallocMemorySections());
    }

    private static Iterator<Object> getNonMallocMemorySections() {
        LinkedList linkedList = new LinkedList();
        return linkedList.iterator();
    }

    public JavaObject getNestedPackedObject(JavaClass javaClass, ImagePointer imagePointer) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public JavaObject getNestedPackedArrayObject(JavaClass javaClass, ImagePointer imagePointer, int n) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public long getStartTime() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getVm().j9ras().startTimeMillis().longValue();
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    public long getStartTimeNanos() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            return DTFJContext.getVm().j9ras().startTimeNanos().longValue();
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), throwable);
        }
    }

    private class MemTagMemorySectionIterator
    implements Iterator<Object> {
        private final J9MemTagIterator memTagIt;
        private final List<Object> buffer = new ArrayList<Object>(2);
        private final IEventListener eventListener = new IEventListener(){

            @Override
            public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
                MemTagMemorySectionIterator.this.buffer.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), corruptDataException));
            }
        };

        MemTagMemorySectionIterator(J9MemTagIterator j9MemTagIterator) {
            this.memTagIt = j9MemTagIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.buffer.size() > 0) {
                return true;
            }
            EventManager.register(this.eventListener);
            try {
                if (this.memTagIt.hasNext()) {
                    this.buffer.add(new DTFJMemoryTagRuntimeMemorySection(DTFJJavaRuntime.this, this.memTagIt.next()));
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                this.buffer.add(corruptData);
                boolean bl = true;
                return bl;
            }
            finally {
                EventManager.unregister(this.eventListener);
            }
        }

        @Override
        public Object next() {
            if (this.hasNext()) {
                return this.buffer.remove(0);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SystemPropertiesEventListener
    implements IEventListener {
        protected boolean corruption = false;
        protected CorruptDataException exception;

        private SystemPropertiesEventListener() {
        }

        @Override
        public void corruptData(String string, CorruptDataException corruptDataException, boolean bl) {
            this.corruption = true;
            this.exception = corruptDataException;
        }
    }

    public class DTFJRootScanner
    extends RootScanner {
        DTFJRootScanner() throws CorruptDataException {
        }

        private int getReachabilityCode() {
            switch (this.getReachability()) {
                case STRONG: {
                    return 1;
                }
                case WEAK: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown reachability: " + (Object)((Object)this.getReachability()) + " found");
        }

        @Override
        protected void doClassLoader(J9ClassLoaderPointer j9ClassLoaderPointer) {
            if (j9ClassLoaderPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClassloader(j9ClassLoaderPointer).getObject(), "ClassLoader", 0, 10, this.getReachabilityCode()));
                }
                catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                    DTFJJavaRuntime.this.references.add(corruptDataException.getCorruptData());
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doClassSlot(J9ClassPointer j9ClassPointer) {
            if (j9ClassPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(j9ClassPointer), "Class", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doFinalizableObject(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "FinalizableObject", 0, 8, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doJNIGlobalReferenceSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "JNIGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doJNIWeakGlobalReference(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "JNIWeakGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doJVMTIObjectTagSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "JVMTIObjectTagTable", 0, 0, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doMonitorReference(J9ObjectMonitorPointer j9ObjectMonitorPointer) {
            if (j9ObjectMonitorPointer.notNull()) {
                try {
                    J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer = J9ThreadAbstractMonitorPointer.cast(j9ObjectMonitorPointer.monitor());
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(j9ThreadAbstractMonitorPointer.userData())), "MonitorReference", 0, 3, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doPhantomReferenceSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "PhantomReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doRememberedSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "RememberedSlot", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doSoftReferenceSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "SoftReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doStringTableSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "StringTable", 0, 11, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doStringCacheTableSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "StringCacheTable", 0, 11, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doUnfinalizedObject(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "UnfinalizedObject", 0, 9, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doVMClassSlot(J9ClassPointer j9ClassPointer) {
            if (j9ClassPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(j9ClassPointer), "VMClassSlot", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doVMThreadJNISlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doVMThreadMonitorRecordSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doNonCollectableObjectSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "Reference from an immortal/scoped region", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doMemorySpaceSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "MemorySpace reference to Java MemoryArea object", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doVMThreadSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doWeakReferenceSlot(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "WeakReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doClass(J9ClassPointer j9ClassPointer) {
            this.doClassSlot(j9ClassPointer);
        }

        @Override
        protected void doStackSlot(J9ObjectPointer j9ObjectPointer) {
        }

        @Override
        protected void doOwnableSynchronizerObject(J9ObjectPointer j9ObjectPointer) {
            if (j9ObjectPointer.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(j9ObjectPointer), "OwnableSynchronizerObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }

        @Override
        protected void doMonitorLookupCacheSlot(J9ObjectMonitorPointer j9ObjectMonitorPointer) {
            if (j9ObjectMonitorPointer.notNull()) {
                try {
                    J9ThreadAbstractMonitorPointer j9ThreadAbstractMonitorPointer = J9ThreadAbstractMonitorPointer.cast(j9ObjectMonitorPointer.monitor());
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(j9ThreadAbstractMonitorPointer.userData())), "MonitorReference", 0, 3, this.getReachabilityCode()));
                }
                catch (Throwable throwable) {
                    CorruptData corruptData = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), throwable);
                    DTFJJavaRuntime.this.references.add(corruptData);
                }
            }
        }
    }
}

