/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.LockInfoUtil;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MonitorInfoUtil;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class ThreadInfoUtil {
    private static CompositeType compositeType;

    public static CompositeType getCompositeType() {
        block3: {
            if (compositeType == null) {
                try {
                    String[] stringArray = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    String[] stringArray2 = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    OpenType[] openTypeArray = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, LockInfoUtil.getCompositeType(), SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, StackTraceElementUtil.getCompositeType()), new ArrayType(1, MonitorInfoUtil.getCompositeType()), new ArrayType(1, LockInfoUtil.getCompositeType())};
                    compositeType = new CompositeType(ThreadInfo.class.getName(), ThreadInfo.class.getName(), stringArray, stringArray2, openTypeArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeType;
    }

    public static CompositeData toCompositeData(ThreadInfo threadInfo) {
        CompositeDataSupport compositeDataSupport;
        block6: {
            compositeDataSupport = null;
            if (threadInfo != null) {
                StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
                CompositeData[] compositeDataArray = new CompositeData[stackTraceElementArray.length];
                for (int i = 0; i < compositeDataArray.length; ++i) {
                    compositeDataArray[i] = StackTraceElementUtil.toCompositeData(stackTraceElementArray[i]);
                }
                MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
                CompositeData[] compositeDataArray2 = new CompositeData[monitorInfoArray.length];
                for (int i = 0; i < compositeDataArray2.length; ++i) {
                    compositeDataArray2[i] = MonitorInfoUtil.toCompositeData(monitorInfoArray[i]);
                }
                LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
                CompositeData[] compositeDataArray3 = new CompositeData[lockInfoArray.length];
                for (int i = 0; i < compositeDataArray3.length; ++i) {
                    compositeDataArray3[i] = LockInfoUtil.toCompositeData(lockInfoArray[i]);
                }
                CompositeType compositeType = ThreadInfoUtil.getCompositeType();
                String[] stringArray = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                Object[] objectArray = new Object[]{threadInfo.getThreadId(), threadInfo.getThreadName(), threadInfo.getThreadState().name(), threadInfo.isSuspended(), threadInfo.isInNative(), threadInfo.getBlockedCount(), threadInfo.getBlockedTime(), threadInfo.getWaitedCount(), threadInfo.getWaitedTime(), LockInfoUtil.toCompositeData(threadInfo.getLockInfo()), threadInfo.getLockName(), threadInfo.getLockOwnerId(), threadInfo.getLockOwnerName(), compositeDataArray, compositeDataArray2, compositeDataArray3};
                try {
                    compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
                }
                catch (OpenDataException openDataException) {
                    if (!ManagementUtils.VERBOSE_MODE) break block6;
                    openDataException.printStackTrace(System.err);
                }
            }
        }
        return compositeDataSupport;
    }

    private ThreadInfoUtil() {
    }
}

