/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.PointerGenerator;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructureStubGenerator {
    final Map<String, String> opts = new HashMap<String, String>();
    StructureReader structureReader;
    File outputDir;

    public StructureStubGenerator() {
        this.opts.put("-p", null);
        this.opts.put("-o", null);
        this.opts.put("-f", null);
        this.opts.put("-s", null);
        this.opts.put("-l", "false");
    }

    public static void main(String[] stringArray) throws Exception {
        StructureStubGenerator structureStubGenerator = new StructureStubGenerator();
        structureStubGenerator.parseArgs(stringArray);
        structureStubGenerator.generateClasses();
        System.out.println("Processing complete");
    }

    private void generateClasses() {
        String string = this.opts.get("-f");
        String string2 = this.opts.get("-s");
        try {
            J9DDRStructureStore j9DDRStructureStore = new J9DDRStructureStore(string, string2);
            System.out.println("superset directory name : " + string);
            System.out.println("superset file name : " + j9DDRStructureStore.getSuperSetFileName());
            InputStream object = j9DDRStructureStore.getSuperset();
            this.structureReader = new StructureReader(object);
            object.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not find file: " + string + "/" + string2);
            return;
        }
        this.outputDir = this.getOutputDir();
        for (StructureReader.StructureDescriptor structureDescriptor : this.structureReader.getStructures()) {
            String string3;
            try {
                if (FlagStructureList.isFlagsStructure(structureDescriptor.getName())) continue;
                this.generateClass(structureDescriptor);
            }
            catch (FileNotFoundException fileNotFoundException) {
                string3 = String.format("File Not Found processing: %s: %s", structureDescriptor.getName(), fileNotFoundException.getMessage());
                System.out.println(string3);
            }
            catch (IOException iOException) {
                string3 = String.format("IOException processing: %s: %s", structureDescriptor.getName(), iOException.getMessage());
                System.out.println(string3);
            }
        }
    }

    private void generateClass(StructureReader.StructureDescriptor structureDescriptor) throws IOException {
        Closeable closeable;
        File file = new File(this.outputDir, structureDescriptor.getName() + ".java");
        byte[] byArray = null;
        int n = 0;
        if (file.exists()) {
            n = (int)file.length();
            byArray = new byte[n];
            closeable = new FileInputStream(file);
            ((FileInputStream)closeable).read(byArray);
            ((FileInputStream)closeable).close();
        }
        closeable = new ByteArrayOutputStream(n);
        PrintWriter printWriter = new PrintWriter((OutputStream)closeable);
        StructureStubGenerator.writeCopyright(printWriter);
        printWriter.format("package %s;%n", this.opts.get("-p"));
        printWriter.println();
        StructureStubGenerator.writeClassComment(printWriter, structureDescriptor.getName());
        printWriter.format("public final class %s {%n", structureDescriptor.getName());
        printWriter.println();
        StructureStubGenerator.writeConstants(printWriter, structureDescriptor);
        printWriter.println();
        this.writeOffsetStubs(printWriter, structureDescriptor);
        printWriter.println();
        this.writeStaticInitializer(printWriter, structureDescriptor);
        printWriter.println("}");
        printWriter.close();
        byte[] byArray2 = ((ByteArrayOutputStream)closeable).toByteArray();
        if (null == byArray || !Arrays.equals(byArray, byArray2)) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray2);
            fileOutputStream.close();
        }
    }

    private static void writeConstants(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        printWriter.println("\t// VM Constants");
        printWriter.println();
        printWriter.format("\tpublic static final long %s;%n", "SIZEOF");
        Collections.sort(structureDescriptor.getConstants());
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            printWriter.format("\tpublic static final long %s;%n", constantDescriptor.getName());
        }
    }

    private static void writeConstantInitializer(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        printWriter.format("\t\t%s = 0;%n", "SIZEOF");
        Collections.sort(structureDescriptor.getConstants());
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            printWriter.format("\t\t%s = 0;%n", constantDescriptor.getName());
        }
    }

    private void writeStaticInitializer(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        printWriter.println("\t// Static Initializer");
        printWriter.println();
        printWriter.println("\tprivate static final boolean RUNTIME = false;");
        printWriter.println();
        printWriter.println("\tstatic {");
        printWriter.println("\t\tif (!RUNTIME) {");
        printWriter.println("\t\t\tthrow new IllegalArgumentException(\"This stub class should not be on your classpath\");");
        printWriter.println("\t\t}");
        printWriter.println();
        StructureStubGenerator.writeConstantInitializer(printWriter, structureDescriptor);
        this.writeOffsetInitializer(printWriter, structureDescriptor);
        printWriter.println("\t}");
        printWriter.println();
    }

    private static void writeClassComment(PrintWriter printWriter, String string) {
        printWriter.println("/**");
        printWriter.format(" * Structure: %s%n", string);
        printWriter.println(" *");
        printWriter.println(" * This stub class represents a class that can return in memory offsets");
        printWriter.println(" * to VM C and C++ structures.");
        printWriter.println(" *");
        printWriter.println(" * This particular implementation exists only to allow StructurePointer code to");
        printWriter.println(" * compile at development time.  This is never loaded at run time.");
        printWriter.println(" *");
        printWriter.println(" * At runtime generated byte codes returning actual offset values from the core file");
        printWriter.println(" * will be loaded by the StructureClassLoader.");
        printWriter.println(" */");
    }

    private String getOffsetConstant(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        if (this.opts.get("-l").equals("true")) {
            return PointerGenerator.getOffsetConstant(string);
        }
        return string;
    }

    private void writeOffsetStubs(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        List<StructureReader.FieldDescriptor> list = structureDescriptor.getFields();
        if (list.isEmpty()) {
            return;
        }
        printWriter.println("\t// Offsets");
        printWriter.println();
        Collections.sort(list);
        for (StructureReader.FieldDescriptor fieldDescriptor : list) {
            if (!this.getOffsetConstant(fieldDescriptor).equals(fieldDescriptor.getName()) || PointerGenerator.omitFieldImplementation(structureDescriptor, fieldDescriptor)) continue;
            StructureStubGenerator.writeOffsetStub(printWriter, fieldDescriptor, structureDescriptor.getName(), "Offset");
        }
    }

    private static void writeOffsetStub(PrintWriter printWriter, StructureReader.FieldDescriptor fieldDescriptor, String string, String string2) {
        String string3 = fieldDescriptor.getName();
        CTypeParser cTypeParser = new CTypeParser(fieldDescriptor.getType());
        if (cTypeParser.getSuffix().contains(":")) {
            printWriter.format("\tpublic static final int _%s_s_;%n", string3);
            printWriter.format("\tpublic static final int _%s_b_;%n", string3);
        } else {
            printWriter.format("\tpublic static final int _%s%s_;%n", string3, string2);
        }
    }

    private void writeOffsetInitializer(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        Collections.sort(structureDescriptor.getFields());
        for (StructureReader.FieldDescriptor fieldDescriptor : structureDescriptor.getFields()) {
            String string = fieldDescriptor.getName();
            if (!this.getOffsetConstant(fieldDescriptor).equals(string) || PointerGenerator.omitFieldImplementation(structureDescriptor, fieldDescriptor)) continue;
            CTypeParser cTypeParser = new CTypeParser(fieldDescriptor.getType());
            if (cTypeParser.getSuffix().contains(":")) {
                String string2 = string;
                printWriter.format("\t\t_%s_s_ = 0;%n", string2);
                printWriter.format("\t\t_%s_b_ = 0;%n", string2);
                continue;
            }
            printWriter.format("\t\t_%sOffset_ = 0;%n", string);
        }
    }

    private void parseArgs(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length % 2 != 0) {
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (this.opts.containsKey(stringArray[i])) {
                this.opts.put(stringArray[i], stringArray[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + stringArray[i]);
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
        for (String string : this.opts.keySet()) {
            String string2 = this.opts.get(string);
            if (string2 != null || string.equals("-s")) continue;
            System.err.println("The option " + string + " has not been set.\n");
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava PointerGenerator -p <package name> -o <output path> -f <path to structure file> [-s <superset file name> -l <legacy mode>]\n");
        System.out.println("<package name>           : the package name for all the generated classes e.g. com.ibm.dtfj.j9.structures");
        System.out.println("<relative output path>   : where to write out the class files.  Full path to base of package hierarchy e.g. c:\\src\\");
        System.out.println("<path to structure file> : full path to the J9 structure file");
        System.out.println("<superset file name>     : optional file name of the superset to be used for input / output");
        System.out.println("<legacy mode>            : optional flag set to true or false indicating if legacy DDR is used");
    }

    private File getOutputDir() {
        String string = this.opts.get("-o").replace('\\', '/');
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + this.opts.get("-p").replace('.', '/');
        System.out.println("Writing generated classes to " + string);
        File file = new File(string);
        file.mkdirs();
        return file;
    }

    private static void writeCopyright(PrintWriter printWriter) {
        int n = Calendar.getInstance().get(1);
        printWriter.println("/*******************************************************************************");
        printWriter.println(" * Copyright (c) 1991, " + n + " IBM Corp. and others");
        printWriter.println(" *");
        printWriter.println(" * This program and the accompanying materials are made available under");
        printWriter.println(" * the terms of the Eclipse Public License 2.0 which accompanies this");
        printWriter.println(" * distribution and is available at https://www.eclipse.org/legal/epl-2.0/");
        printWriter.println(" * or the Apache License, Version 2.0 which accompanies this distribution");
        printWriter.println(" * and is available at https://www.apache.org/licenses/LICENSE-2.0.");
        printWriter.println(" *");
        printWriter.println(" * This Source Code may also be made available under the following");
        printWriter.println(" * Secondary Licenses when the conditions for such availability set");
        printWriter.println(" * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU");
        printWriter.println(" * General Public License, version 2 with the GNU Classpath");
        printWriter.println(" * Exception [1] and GNU General Public License, version 2 with the");
        printWriter.println(" * OpenJDK Assembly Exception [2].");
        printWriter.println(" *");
        printWriter.println(" * [1] https://www.gnu.org/software/classpath/license.html");
        printWriter.println(" * [2] http://openjdk.java.net/legal/assembly-exception.html");
        printWriter.println(" *");
        printWriter.println(" * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception");
        printWriter.println(" *******************************************************************************/");
    }
}

