/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.mvs;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.mvs.LsedTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lses1lsed1Template;
import com.ibm.dtfj.corereaders.zos.mvs.LseslsedTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lsestate1Template;
import com.ibm.dtfj.corereaders.zos.mvs.LsestateTemplate;
import java.io.IOException;

public class Lse {
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private long address;
    private long lsesptr;
    public static final int LSEDPC = 5;
    public static final int LSED1PC = 13;
    public static final int LSED1BAKR = 12;

    public Lse(AddressSpace addressSpace, long l) {
        this.space = addressSpace;
        this.inputStream = addressSpace.getImageInputStream();
        this.address = l;
        this.lsesptr = l + (long)LseslsedTemplate.length();
    }

    public long address() {
        return this.address;
    }

    public int lsestyp7() throws IOException {
        return (int)LseslsedTemplate.getLsestyp7(this.inputStream, this.lsesptr + (long)LsestateTemplate.getLses_ed$offset());
    }

    public int lses1typ7() throws IOException {
        return (int)Lses1lsed1Template.getLses1typ7(this.inputStream, this.lsesptr + (long)Lsestate1Template.getLses1_ed1$offset());
    }

    public long lsestarg() throws IOException {
        return LsestateTemplate.getLsestarg(this.inputStream, this.lsesptr);
    }

    public long lsespsw() throws IOException {
        return LsestateTemplate.getLsespsw(this.inputStream, this.lsesptr);
    }

    public long lses1pswh() throws IOException {
        return Lsestate1Template.getLses1pswh(this.inputStream, this.lsesptr);
    }

    public long lsesgrs(int n) throws IOException {
        if (n < 0 || n > 15) {
            throw new IndexOutOfBoundsException("gpr out of range 0-15: " + n);
        }
        return this.space.readLong(this.lsesptr + (long)LsestateTemplate.getLsesgrs$offset() + (long)(n * 4));
    }

    public long lses1grs(int n) throws IOException {
        if (n < 0 || n > 15) {
            throw new IndexOutOfBoundsException("gpr out of range 0-15: " + n);
        }
        return this.space.readLong(this.lsesptr + (long)Lsestate1Template.getLses1grs$offset() + (long)(n * 8));
    }

    public int lses1pasn() throws IOException {
        return (int)Lsestate1Template.getLses1pasn(this.inputStream, this.lsesptr);
    }

    public boolean isZArchitecture() throws IOException {
        long l = LsedTemplate.getLsednes(this.inputStream, this.address);
        return l == (long)Lsestate1Template.length();
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }
}

