/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import sun.management.jdp.JdpBroadcaster;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpJmxPacket;

public final class JdpController {
    private static JDPControllerRunner controller = null;

    private JdpController() {
    }

    private static int getInteger(String string, int n, String string2) throws JdpException {
        try {
            return string == null ? n : Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JdpException(string2);
        }
    }

    private static InetAddress getInetAddress(String string, InetAddress inetAddress, String string2) throws JdpException {
        try {
            return string == null ? inetAddress : InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new JdpException(string2);
        }
    }

    private static Integer getProcessId() {
        try {
            return 0;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized void startDiscoveryService(InetAddress inetAddress, int n, String string, String string2) throws IOException, JdpException {
        Object object;
        int n2 = JdpController.getInteger(System.getProperty("com.sun.management.jdp.ttl"), 1, "Invalid jdp packet ttl");
        int n3 = JdpController.getInteger(System.getProperty("com.sun.management.jdp.pause"), 5, "Invalid jdp pause");
        n3 *= 1000;
        InetAddress inetAddress2 = JdpController.getInetAddress(System.getProperty("com.sun.management.jdp.source_addr"), null, "Invalid source address provided");
        UUID uUID = UUID.randomUUID();
        JdpJmxPacket jdpJmxPacket = new JdpJmxPacket(uUID, string2);
        String string3 = System.getProperty("sun.java.command");
        if (string3 != null) {
            object = string3.split(" ", 2);
            jdpJmxPacket.setMainClass(object[0]);
        }
        jdpJmxPacket.setInstanceName(string);
        object = System.getProperty("java.rmi.server.hostname");
        jdpJmxPacket.setRmiHostname((String)object);
        jdpJmxPacket.setBroadcastInterval(new Integer(n3).toString());
        Integer n4 = JdpController.getProcessId();
        if (n4 != null) {
            jdpJmxPacket.setProcessId(n4.toString());
        }
        JdpBroadcaster jdpBroadcaster = new JdpBroadcaster(inetAddress, inetAddress2, n, n2);
        JdpController.stopDiscoveryService();
        controller = new JDPControllerRunner(jdpBroadcaster, jdpJmxPacket, n3);
        Thread thread = new Thread((Runnable)controller, "JDP broadcaster");
        thread.setDaemon(true);
        thread.start();
    }

    public static synchronized void stopDiscoveryService() {
        if (controller != null) {
            controller.stop();
            controller = null;
        }
    }

    private static class JDPControllerRunner
    implements Runnable {
        private final JdpJmxPacket packet;
        private final JdpBroadcaster bcast;
        private final int pause;
        private volatile boolean shutdown = false;

        private JDPControllerRunner(JdpBroadcaster jdpBroadcaster, JdpJmxPacket jdpJmxPacket, int n) {
            this.bcast = jdpBroadcaster;
            this.packet = jdpJmxPacket;
            this.pause = n;
        }

        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    this.bcast.sendPacket(this.packet);
                    try {
                        Thread.sleep(this.pause);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.stop();
                this.bcast.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void stop() {
            this.shutdown = true;
        }
    }
}

