/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.JavaVMOption;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.EnvironmentUtils;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRBaseImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageModule;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9DDRStubImageThread;
import com.ibm.j9ddr.view.dtfj.image.J9RASImageDataFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class J9DDRImageProcess
implements ImageProcess {
    private static final String JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE = "IBM_JAVA_COMMAND_LINE";
    private final IProcess process;
    private boolean processDataSet = false;
    private J9RASImageDataFactory.ProcessData j9rasProcessData;
    private String version;
    private WeakReference<Map<Long, Object>> cachedThreads = null;
    private static final int J9PORT_SIG_FLAG_SIGSEGV = 4;
    private static final int J9PORT_SIG_FLAG_SIGBUS = 8;
    private static final int J9PORT_SIG_FLAG_SIGILL = 16;
    private static final int J9PORT_SIG_FLAG_SIGFPE = 32;
    private static final int J9PORT_SIG_FLAG_SIGTRAP = 64;
    private static final int J9PORT_SIG_FLAG_SIGQUIT = 1024;
    private static final int J9PORT_SIG_FLAG_SIGABRT = 2048;
    private static final int J9PORT_SIG_FLAG_SIGTERM = 4096;
    private static final int J9PORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO = 262176;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO = 524320;
    private static final int J9PORT_SIG_FLAG_SIGFPE_INT_OVERFLOW = 0x100020;
    private static final String[] SIGNAL_NAMES = new String[]{"ZERO", "SIGHUP", "SIGINT", "SIGQUIT", "SIGILL", "SIGTRAP", "SIGABRT", "SIGEMT", "SIGFPE", "SIGKILL", "SIGBUS", "SIGSEGV", "SIGSYS", "SIGPIPE", "SIGALRM", "SIGTERM", "SIGUSR1", "SIGUSR2", "SIGCHLD", "SIGPWR", "SIGWINCH", "SIGURG/BREAK", "SIGPOLL/ABRT", "SIGSTOP", "SIGTSTP", "SIGCONT", "SIGTTIN", "SIGTTOU", "SIGVTALRM", "SIGPROF", "SIGXCPU", "SIGXFSZ", "SIGWAITING", "SIGLWP", "SIGAIO", "SIGFPE_DIV_BY_ZERO", "SIGFPE_INT_DIV_BY_ZERO", "SIGFPE_INT_OVERFLOW"};

    public J9DDRImageProcess(IProcess iProcess) {
        this.process = iProcess;
    }

    public IProcess getIProcess() {
        return this.process;
    }

    public String getCommandLine() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Properties properties = this.getEnvironment();
            String string = properties.getProperty(JAVA_COMMAND_LINE_ENVIRONMENT_VARIABLE);
            if (string != null) {
                return string;
            }
            return this.process.getCommandLine();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(this.process, corruptDataException);
        }
        catch (DataUnavailableException dataUnavailableException) {
            throw new DataUnavailable(dataUnavailableException.getMessage());
        }
    }

    private void checkFailureInfo() {
        if (!this.processDataSet) {
            this.j9rasProcessData = J9RASImageDataFactory.getProcessData(this.process);
            this.processDataSet = true;
        }
    }

    public ImageThread getCurrentThread() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                long l;
                try {
                    l = this.j9rasProcessData.tid();
                }
                catch (DataUnavailable dataUnavailable) {
                    Iterator<? extends IOSThread> iterator = this.process.getThreads().iterator();
                    if (iterator.hasNext()) {
                        IOSThread iOSThread = iterator.next();
                        return new J9DDRImageThread(this.process, iOSThread);
                    }
                    return null;
                }
                for (IOSThread iOSThread : this.process.getThreads()) {
                    if (iOSThread.getThreadId() != l) continue;
                    return new J9DDRImageThread(this.process, iOSThread);
                }
                if (l == 0L && this.process.getPlatform() == Platform.ZOS) {
                    for (IOSThread iOSThread : this.process.getThreads()) {
                        Properties properties = iOSThread.getProperties();
                        String string = properties.getProperty("Task Completion Code");
                        if (string == null || string.equals("0x0")) continue;
                        return new J9DDRImageThread(this.process, iOSThread);
                    }
                }
                return new J9DDRStubImageThread(this.process, l);
            }
            return null;
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(this.process, corruptDataException);
        }
    }

    public Properties getEnvironment() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    Properties properties;
                    long l = this.j9rasProcessData.getEnvironment();
                    if (this.process.getPlatform() == Platform.WINDOWS && this.j9rasProcessData.version() > 4) {
                        properties = EnvironmentUtils.readEnvironmentStrings(this.process, l);
                    } else {
                        long l2 = this.process.getPointerAt(l);
                        properties = EnvironmentUtils.readEnvironment(this.process, l2);
                    }
                    if (null == properties || 0 == properties.size()) {
                        throw new CorruptDataException("");
                    }
                    return properties;
                }
                catch (CorruptDataException corruptDataException) {
                    return this.process.getEnvironmentVariables();
                }
            }
            return this.process.getEnvironmentVariables();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(this.process, corruptDataException);
        }
        catch (DataUnavailableException dataUnavailableException) {
            throw new DataUnavailable(dataUnavailableException.getMessage());
        }
    }

    public ImageModule getExecutable() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        IModule iModule;
        try {
            iModule = this.process.getExecutable();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, corruptDataException));
        }
        if (iModule == null) {
            throw new DataUnavailable("executable not found");
        }
        if (this.process.getPlatform() == Platform.LINUX) {
            String string = this.getExecutablePath();
            if (null == string) {
                return new J9DDRImageModule(this.process, iModule);
            }
            return new J9DDRImageModule(this.process, iModule, string);
        }
        return new J9DDRImageModule(this.process, iModule);
    }

    String getExecutablePath() {
        String string;
        try {
            string = this.getCommandLine();
        }
        catch (Exception exception) {
            return this.getExecutablePathFromSystemProperties();
        }
        int n = string.indexOf(" ");
        String string2 = null;
        string2 = n != -1 ? string.substring(0, n) : string;
        return string2;
    }

    private String getExecutablePathFromSystemProperties() {
        Iterator<?> iterator = this.getRuntimes();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof JavaRuntime)) continue;
            JavaRuntime javaRuntime = (JavaRuntime)obj;
            try {
                JavaVMInitArgs javaVMInitArgs = javaRuntime.getJavaVMInitArgs();
                Iterator iterator2 = javaVMInitArgs.getOptions();
                Pattern pattern = Pattern.compile("-Djava.home=(.*)");
                while (iterator2.hasNext()) {
                    JavaVMOption javaVMOption;
                    Matcher matcher;
                    Object e = iterator2.next();
                    if (!(e instanceof JavaVMOption) || !(matcher = pattern.matcher((javaVMOption = (JavaVMOption)e).getOptionString())).find()) continue;
                    String string = matcher.group(1);
                    return string + "/bin/java";
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public String getID() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            this.checkFailureInfo();
            if (this.j9rasProcessData != null) {
                try {
                    return Long.toString(this.j9rasProcessData.pid());
                }
                catch (DataUnavailable dataUnavailable) {
                    return Long.toString(this.process.getProcessId());
                }
            }
            return Long.toString(this.process.getProcessId());
        }
        catch (CorruptDataException corruptDataException) {
            return "<Unknown>";
        }
    }

    public String toString() {
        try {
            return "ImageProcess: " + this.getID();
        }
        catch (Exception exception) {
            return "ImageProcess";
        }
    }

    public Iterator<?> getLibraries() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            Collection<? extends IModule> collection = this.process.getModules();
            ArrayList<J9DDRImageModule> arrayList = new ArrayList<J9DDRImageModule>();
            for (IModule iModule : collection) {
                arrayList.add(new J9DDRImageModule(this.process, iModule));
            }
            return arrayList.iterator();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DTFJCorruptDataException(new J9DDRCorruptData(this.process, corruptDataException));
        }
    }

    public int getPointerSize() {
        return this.process.bytesPerPointer() * 8;
    }

    public Iterator<?> getRuntimes() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            IVMData iVMData = VMDataFactory.getVMData(this.process);
            this.version = iVMData.getVersion();
            Object[] objectArray = new Object[1];
            try {
                iVMData.bootstrapRelative("view.dtfj.DTFJBootstrapShim", objectArray, this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    iVMData.bootstrap("com.ibm.j9ddr.view.nativert.Bootstrap", objectArray, this);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new Error(classNotFoundException2);
                }
            }
            if (objectArray[0] != null) {
                linkedList.add(objectArray[0]);
            }
        }
        catch (IOException iOException) {
            linkedList.add(new J9DDRCorruptData(this.process, "Unsupported JVM level: " + iOException.getMessage()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            linkedList.add(new J9DDRCorruptData(this.process, "Unsupported JVM level"));
        }
        catch (Exception exception) {
            linkedList.add(new J9DDRCorruptData(this.process, exception.getMessage()));
        }
        return linkedList.iterator();
    }

    public String getSignalName() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        int n = this.getSignalNumber();
        if (n == 0) {
            return null;
        }
        if (n > 0 && n < SIGNAL_NAMES.length) {
            return SIGNAL_NAMES[n];
        }
        return "Unknown signal number " + n;
    }

    public int getSignalNumber() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        this.checkFailureInfo();
        try {
            if (this.j9rasProcessData.gpInfo() != null) {
                int n = (int)J9DDRImageProcess.longByResolvingRawKey(this.j9rasProcessData.gpInfo(), "J9Generic_Signal_Number");
                if (n == 0) {
                    n = (int)J9DDRImageProcess.longByResolvingRawKey(this.j9rasProcessData.gpInfo(), "J9Generic_Signal");
                }
                if (n != 0) {
                    return this.resolveGenericSignal(n);
                }
                return 0;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        try {
            return this.process.getSignalNumber();
        }
        catch (DataUnavailableException dataUnavailableException) {
            return 0;
        }
    }

    private Map<Long, Object> getThreadMap() {
        HashMap<Long, Object> hashMap = null;
        if (this.cachedThreads != null) {
            hashMap = (HashMap<Long, Object>)this.cachedThreads.get();
        }
        if (hashMap == null) {
            Collection<? extends IOSThread> collection = null;
            long l = -1L;
            try {
                collection = this.process.getThreads();
            }
            catch (CorruptDataException corruptDataException) {
                return Collections.singletonMap(l, new J9DDRCorruptData(this.process, corruptDataException));
            }
            boolean bl = this.process.getPlatform() == Platform.LINUX && collection.size() == 1;
            hashMap = new HashMap<Long, Object>();
            if (bl) {
                try {
                    J9DDRBaseImageThread j9DDRBaseImageThread = (J9DDRBaseImageThread)this.getCurrentThread();
                    if (j9DDRBaseImageThread != null) {
                        hashMap.put(j9DDRBaseImageThread.getThreadId(), j9DDRBaseImageThread);
                    }
                }
                catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                    hashMap.put(l--, new J9DDRCorruptData(this.process, corruptDataException.getMessage()));
                }
                catch (CorruptDataException corruptDataException) {
                    hashMap.put(l--, new J9DDRCorruptData(this.process, corruptDataException.getMessage()));
                }
            }
            for (IOSThread iOSThread : collection) {
                try {
                    hashMap.put(iOSThread.getThreadId(), new J9DDRImageThread(this.process, iOSThread));
                }
                catch (CorruptDataException corruptDataException) {
                    hashMap.put(l--, new J9DDRImageThread(this.process, iOSThread));
                }
            }
            this.cachedThreads = new WeakReference(hashMap);
        }
        return hashMap;
    }

    public Iterator<?> getThreads() {
        Map<Long, Object> map = this.getThreadMap();
        return map.values().iterator();
    }

    public J9DDRBaseImageThread getThread(long l) {
        Map<Long, Object> map = this.getThreadMap();
        return (J9DDRBaseImageThread)map.get(l);
    }

    private int resolveGenericSignal(int n) {
        if ((n & 0x400) != 0) {
            return 3;
        }
        if ((n & 0x10) != 0) {
            return 4;
        }
        if ((n & 0x40) != 0) {
            return 5;
        }
        if ((n & 0x800) != 0) {
            return 6;
        }
        if ((n & 0x20) != 0) {
            if (n == 262176) {
                return 35;
            }
            if (n == 524320) {
                return 36;
            }
            if (n == 0x100020) {
                return 37;
            }
            return 8;
        }
        if ((n & 8) != 0) {
            return 10;
        }
        if ((n & 4) != 0) {
            return 11;
        }
        if ((n & 0x1000) != 0) {
            return 15;
        }
        return n;
    }

    private static long longByResolvingRawKey(String string, String string2) {
        int n;
        long l = 0L;
        int n2 = string.indexOf(string2);
        while (n2 > 0 && !Character.isWhitespace(string.charAt(n2 - 1))) {
            n2 = string.indexOf(string2, n2 + 1);
        }
        if (n2 >= 0 && (n = string.indexOf("=", n2)) > n2) {
            int n3;
            for (n3 = n + 1; n3 < string.length() && !Character.isWhitespace(string.charAt(n3)); ++n3) {
            }
            String string3 = "0x" + string.substring(n + 1, n3);
            l = J9DDRImageProcess.longFromString(string3, 0L);
        }
        return l;
    }

    private static long longFromString(String string, long l) {
        long l2 = l;
        int n = 10;
        if (null != string) {
            if (string.startsWith("0x")) {
                string = string.substring(2);
                n = 16;
                if (16 == string.length()) {
                    String string2 = string.substring(0, 8);
                    String string3 = string.substring(8, 16);
                    long l3 = Long.parseLong(string2, n);
                    long l4 = Long.parseLong(string3, n);
                    l2 = l3 << 32 | l4;
                } else {
                    l2 = Long.parseLong(string, n);
                }
            } else {
                l2 = Long.parseLong(string, n);
            }
        }
        return l2;
    }

    public String getVersion() {
        return this.version;
    }

    boolean isFailingProcess() throws DataUnavailableException {
        return this.process.isFailingProcess();
    }

    public Properties getProperties() {
        return new Properties();
    }
}

