/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.editors;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class FontEditor
extends Panel
implements PropertyEditor {
    private static final long serialVersionUID = 6732704486002715933L;
    private Font font;
    private Toolkit toolkit;
    private String sampleText = "Abcde...";
    private Label sample;
    private Choice familyChoser;
    private Choice styleChoser;
    private Choice sizeChoser;
    private String[] fonts;
    private String[] styleNames = new String[]{"plain", "bold", "italic"};
    private int[] styles = new int[]{0, 1, 2};
    private int[] pointSizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 36, 48};
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public FontEditor() {
        int n;
        this.setLayout(null);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.fonts = this.toolkit.getFontList();
        this.familyChoser = new Choice();
        for (n = 0; n < this.fonts.length; ++n) {
            this.familyChoser.addItem(this.fonts[n]);
        }
        this.add(this.familyChoser);
        this.familyChoser.reshape(20, 5, 100, 30);
        this.styleChoser = new Choice();
        for (n = 0; n < this.styleNames.length; ++n) {
            this.styleChoser.addItem(this.styleNames[n]);
        }
        this.add(this.styleChoser);
        this.styleChoser.reshape(145, 5, 70, 30);
        this.sizeChoser = new Choice();
        for (n = 0; n < this.pointSizes.length; ++n) {
            this.sizeChoser.addItem("" + this.pointSizes[n]);
        }
        this.add(this.sizeChoser);
        this.sizeChoser.reshape(220, 5, 70, 30);
        this.resize(300, 40);
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(300, 40);
    }

    @Override
    public void setValue(Object object) {
        int n;
        this.font = (Font)object;
        if (this.font == null) {
            return;
        }
        this.changeFont(this.font);
        for (n = 0; n < this.fonts.length; ++n) {
            if (!this.fonts[n].equals(this.font.getFamily())) continue;
            this.familyChoser.select(n);
            break;
        }
        for (n = 0; n < this.styleNames.length; ++n) {
            if (this.font.getStyle() != this.styles[n]) continue;
            this.styleChoser.select(n);
            break;
        }
        for (n = 0; n < this.pointSizes.length; ++n) {
            if (this.font.getSize() > this.pointSizes[n]) continue;
            this.sizeChoser.select(n);
            break;
        }
    }

    private void changeFont(Font font) {
        this.font = font;
        if (this.sample != null) {
            this.remove(this.sample);
        }
        this.sample = new Label(this.sampleText);
        this.sample.setFont(this.font);
        this.add(this.sample);
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).invalidate();
            ((Component)container).layout();
        }
        this.invalidate();
        this.layout();
        this.repaint();
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public Object getValue() {
        return this.font;
    }

    @Override
    public String getJavaInitializationString() {
        if (this.font == null) {
            return "null";
        }
        return "new java.awt.Font(\"" + this.font.getName() + "\", " + this.font.getStyle() + ", " + this.font.getSize() + ")";
    }

    @Override
    public boolean action(Event event, Object object) {
        String string = this.familyChoser.getSelectedItem();
        int n = this.styles[this.styleChoser.getSelectedIndex()];
        int n2 = this.pointSizes[this.sizeChoser.getSelectedIndex()];
        try {
            Font font = new Font(string, n, n2);
            this.changeFont(font);
        }
        catch (Exception exception) {
            System.err.println("Couldn't create font " + string + "-" + this.styleNames[n] + "-" + n2);
        }
        return false;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Font font = graphics.getFont();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(this.sampleText, 0, rectangle.height - n);
        graphics.setFont(font);
    }

    @Override
    public String getAsText() {
        boolean bl;
        if (this.font == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.font.getName());
        stringBuilder.append(' ');
        boolean bl2 = this.font.isBold();
        if (bl2) {
            stringBuilder.append("BOLD");
        }
        if (bl = this.font.isItalic()) {
            stringBuilder.append("ITALIC");
        }
        if (bl2 || bl) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(this.font.getSize());
        return stringBuilder.toString();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string == null ? null : Font.decode(string));
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

