/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageBuilder;
import com.ibm.dtfj.javacore.builder.IImageBuilderFactory;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.IErrorListener;
import com.ibm.dtfj.javacore.parser.framework.parser.ILookAheadBuffer;
import com.ibm.dtfj.javacore.parser.framework.parser.IParserController;
import com.ibm.dtfj.javacore.parser.framework.parser.ISectionParser;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.IScannerManager;
import com.ibm.dtfj.javacore.parser.framework.scanner.ScannerException;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ParserController
implements IParserController {
    private List fFramework;
    private IErrorListener fListener;
    private IImageBuilderFactory fImageBuilderFactory;
    private static final String DEFAULT_IMAGE_BUILDER = "default_image_builder";
    private static final String DEFAULT_IMAGE_ADDRESS_SPACE_BUILDER = "default_image_address_space_builder";
    private static final String DEFAULT_IMAGE_PROCESS_BUILDER = "default_image_process_builder";
    private static final String DEFAULT_JAVA_RUNTIME_BUILDER = "default_java_runtime_builder";

    public ParserController(List list, IImageBuilderFactory iImageBuilderFactory) throws ParserException {
        if (iImageBuilderFactory == null) {
            throw new ParserException("Must pass a valid image builder factory");
        }
        this.fFramework = list;
        this.fImageBuilderFactory = iImageBuilderFactory;
    }

    @Override
    public Image parse(IScannerManager iScannerManager) throws ParserException {
        Object object;
        ILookAheadBuffer iLookAheadBuffer = iScannerManager.getLookAheadBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 1; i <= 2 && i <= iLookAheadBuffer.maxDepth(); ++i) {
                object = iLookAheadBuffer.lookAhead(i);
                if (object == null) continue;
                stringBuffer.append(object.getValue());
            }
        }
        catch (IOException iOException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (ScannerException scannerException) {
            throw new ParserException(scannerException);
        }
        stringBuffer.setLength(Math.min(300, stringBuffer.length()));
        String string = stringBuffer.toString();
        object = null;
        try {
            object = this.generateImageBuilder();
        }
        catch (BuilderFailureException builderFailureException) {
            throw new ParserException(builderFailureException);
        }
        boolean bl = false;
        try {
            iLookAheadBuffer.init();
            Iterator iterator = this.fFramework.iterator();
            while (iterator.hasNext()) {
                this.processUnknownData(iLookAheadBuffer);
                ISectionParser iSectionParser = (ISectionParser)iterator.next();
                iSectionParser.readIntoDTFJ(iLookAheadBuffer, (IImageBuilder)object);
                Iterator iterator2 = iSectionParser.getErrors();
                if (this.fListener != null && iterator2.hasNext()) {
                    while (iterator2.hasNext()) {
                        this.fListener.handleEvent(iterator2.next().toString());
                    }
                }
                bl |= iSectionParser.anyMatched();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (ScannerException scannerException) {
            throw new ParserException(scannerException);
        }
        if (!bl) {
            throw new ParserException("Not a javacore file. First line: " + string);
        }
        return object.getImage();
    }

    private void processUnknownData(ILookAheadBuffer iLookAheadBuffer) throws IOException, ScannerException {
        J9TagManager j9TagManager = J9TagManager.getCurrent();
        boolean bl = false;
        while (!iLookAheadBuffer.allConsumed() && !bl) {
            IParserToken iParserToken = iLookAheadBuffer.lookAhead(1);
            if (iParserToken != null) {
                String string = iParserToken.getType();
                if (!j9TagManager.hasTag(string) || j9TagManager.isTagInSection(string, "common")) {
                    iLookAheadBuffer.consume();
                    continue;
                }
                bl = true;
                continue;
            }
            iLookAheadBuffer.consume();
        }
    }

    private IImageBuilder generateImageBuilder() throws BuilderFailureException {
        IImageBuilder iImageBuilder = this.fImageBuilderFactory.generateImageBuilder(DEFAULT_IMAGE_BUILDER);
        IImageAddressSpaceBuilder iImageAddressSpaceBuilder = iImageBuilder.generateAddressSpaceBuilder(DEFAULT_IMAGE_ADDRESS_SPACE_BUILDER);
        IImageProcessBuilder iImageProcessBuilder = iImageAddressSpaceBuilder.generateImageProcessBuilder(DEFAULT_IMAGE_PROCESS_BUILDER);
        iImageProcessBuilder.generateJavaRuntimeBuilder(DEFAULT_JAVA_RUNTIME_BUILDER);
        return iImageBuilder;
    }

    @Override
    public void addErrorListener(IErrorListener iErrorListener) {
        this.fListener = iErrorListener;
    }
}

