/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IScalar;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;

public class U64
extends UDATA {
    public static final int SIZEOF = 8;
    public static final long MASK = -1L;
    public static final U64 MIN = new U64(0L);
    public static final U64 MAX = new U64(-1L);

    public U64(long l) {
        super(l);
        this.data = l;
    }

    public U64(Scalar scalar) {
        super(scalar);
    }

    public U64 add(int n) {
        return new U64(this.data + (long)n);
    }

    @Override
    public U64 add(long l) {
        return new U64(this.data + l);
    }

    @Override
    public U64 add(UScalar uScalar) {
        return this.add(new U64(uScalar));
    }

    @Override
    public U64 add(U64 u64) {
        return new U64(this.data + u64.data);
    }

    @Override
    public U64 add(IScalar iScalar) {
        return this.add(new U64(iScalar));
    }

    public U64 sub(int n) {
        return new U64(this.data - (long)n);
    }

    @Override
    public U64 sub(long l) {
        return new U64(this.data - l);
    }

    @Override
    public U64 sub(UScalar uScalar) {
        return this.sub(new U64(uScalar));
    }

    @Override
    public U64 sub(U64 u64) {
        return new U64(this.data - u64.data);
    }

    @Override
    public U64 sub(I8 i8) {
        return this.sub(new U64(i8));
    }

    @Override
    public U64 sub(I16 i16) {
        return this.sub(new U64(i16));
    }

    @Override
    public U64 sub(I32 i32) {
        return this.sub(new U64(i32));
    }

    public U64 sub(I64 i64) {
        return this.sub(new U64(i64));
    }

    @Override
    public int intValue() {
        long l = this.data;
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new InvalidDataTypeException("U64 contains value larger than Integer.MAX_VALUE");
        }
        return (int)l;
    }

    @Override
    public long longValue() {
        long l = this.data;
        if (l < 0L) {
            throw new InvalidDataTypeException("U64 contains value larger than Long.MAX_VALUE");
        }
        return l;
    }

    @Override
    public U64 bitOr(int n) {
        return new U64(this.data | (long)n);
    }

    @Override
    public U64 bitOr(long l) {
        return new U64(this.data | l);
    }

    @Override
    public U64 bitOr(UScalar uScalar) {
        return this.bitOr(new U64(uScalar));
    }

    @Override
    public U64 bitOr(U64 u64) {
        return new U64(this.data | u64.data);
    }

    @Override
    public U64 bitOr(I8 i8) {
        return this.bitOr(new U64(i8));
    }

    @Override
    public U64 bitOr(I16 i16) {
        return this.bitOr(new U64(i16));
    }

    @Override
    public U64 bitOr(I32 i32) {
        return this.bitOr(new U64(i32));
    }

    public U64 bitOr(I64 i64) {
        return this.bitOr(new U64(i64));
    }

    @Override
    public U64 bitXor(int n) {
        return new U64(this.data ^ (long)n);
    }

    @Override
    public U64 bitXor(long l) {
        return new U64(this.data ^ l);
    }

    @Override
    public U64 bitXor(Scalar scalar) {
        return this.bitXor(new U64(scalar));
    }

    @Override
    public U64 bitXor(U64 u64) {
        return new U64(this.data ^ u64.data);
    }

    @Override
    public U64 bitAnd(int n) {
        return new U64(this.data & (long)n);
    }

    @Override
    public U64 bitAnd(long l) {
        return new U64(this.data & l);
    }

    @Override
    public U64 bitAnd(UScalar uScalar) {
        return this.bitAnd(new U64(uScalar));
    }

    @Override
    public U64 bitAnd(U64 u64) {
        return new U64(this.data & u64.data);
    }

    @Override
    public U64 bitAnd(I8 i8) {
        return this.bitAnd(new U64(i8));
    }

    @Override
    public U64 bitAnd(I16 i16) {
        return this.bitAnd(new U64(i16));
    }

    @Override
    public U64 bitAnd(I32 i32) {
        return this.bitAnd(new U64(i32));
    }

    public U64 bitAnd(I64 i64) {
        return this.bitAnd(new U64(i64));
    }

    @Override
    public boolean gt(Scalar scalar) {
        this.checkComparisonValid(scalar);
        if ((this.data ^ scalar.data) < 0L) {
            return this.data < scalar.data;
        }
        return this.data > scalar.data;
    }

    @Override
    public boolean lt(Scalar scalar) {
        this.checkComparisonValid(scalar);
        if ((this.data ^ scalar.data) < 0L) {
            return this.data > scalar.data;
        }
        return this.data < scalar.data;
    }

    @Override
    public U64 leftShift(int n) {
        return new U64(this.data << n);
    }

    @Override
    public U64 rightShift(int n) {
        return new U64(this.data >>> n);
    }

    @Override
    public U64 bitNot() {
        return new U64(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public U64 mult(int n) {
        return new U64(this.data * (long)n);
    }

    @Override
    public U64 mult(long l) {
        return new U64(this.data * l);
    }

    @Override
    public boolean eq(long l) {
        return l == this.data;
    }

    @Override
    public boolean eq(Scalar scalar) {
        if (scalar.isSigned()) {
            return this.eq(new U64(scalar));
        }
        return this.data == scalar.data;
    }

    @Override
    public int sizeof() {
        return 8;
    }
}

