/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.monitors;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.monitors.DeadlockUtils;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.monitors.NativeDeadlockGraphNode;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class DeadlockDetector {
    public static void findDeadlocks(PrintStream printStream) throws DDRInteractiveCommandException {
        HashMap<Integer, NativeDeadlockGraphNode> hashMap = new HashMap<Integer, NativeDeadlockGraphNode>();
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            HashMap<J9ObjectPointer, Object> hashMap2 = DeadlockUtils.readObjectMonitors(j9JavaVMPointer);
            J9ThreadLibraryPointer j9ThreadLibraryPointer = j9JavaVMPointer.mainThread().osThread().library();
            J9PoolPointer j9PoolPointer = j9ThreadLibraryPointer.thread_pool();
            Pool<J9ThreadPointer> pool = Pool.fromJ9Pool(j9PoolPointer, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> slotIterator = pool.iterator();
            J9ThreadPointer j9ThreadPointer = null;
            while (slotIterator.hasNext()) {
                j9ThreadPointer = (J9ThreadPointer)slotIterator.next();
                DeadlockUtils.findThreadCycle(j9ThreadPointer, hashMap, hashMap2);
                J9VMThreadPointer j9VMThreadPointer = J9ThreadHelper.getVMThread(j9ThreadPointer);
                if (null == j9VMThreadPointer || !j9VMThreadPointer.notNull() || !j9VMThreadPointer.publicFlags().allBitsIn(J9Consts.J9_PUBLIC_FLAGS_HALT_THREAD_INSPECTION)) continue;
                break;
            }
            int n = 0;
            Iterator iterator = hashMap.entrySet().iterator();
            block3: while (iterator.hasNext()) {
                NativeDeadlockGraphNode nativeDeadlockGraphNode = (NativeDeadlockGraphNode)iterator.next().getValue();
                ++n;
                while (null != nativeDeadlockGraphNode) {
                    if (nativeDeadlockGraphNode.cycle > 0) {
                        if (nativeDeadlockGraphNode.cycle != n) continue block3;
                        printStream.println("Deadlock Detected !!!");
                        printStream.println("---------------------");
                        printStream.println();
                        NativeDeadlockGraphNode nativeDeadlockGraphNode2 = nativeDeadlockGraphNode;
                        boolean bl = true;
                        do {
                            DeadlockUtils.writeDeadlockNode(nativeDeadlockGraphNode, bl, hashMap2, printStream);
                            nativeDeadlockGraphNode = nativeDeadlockGraphNode.next;
                            bl = false;
                        } while (nativeDeadlockGraphNode != nativeDeadlockGraphNode2);
                        printStream.println(nativeDeadlockGraphNode.toString());
                        continue block3;
                    }
                    nativeDeadlockGraphNode.cycle = n;
                    nativeDeadlockGraphNode = nativeDeadlockGraphNode.next;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

