/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public class StructureHeader {
    private static final String DEFAULT_J9_PACKAGE_PREFIX = "vm";
    private int coreVersion;
    private byte sizeofBool;
    private byte sizeofUDATA;
    private byte bitfieldFormat;
    private int structDataSize;
    private int stringTableDataSize;
    private int structureCount;
    private byte configVersion;
    private BlobID blobID = BlobID.J9;
    private int blobVersion;
    private String packageID = "vm";
    private final long headerSize;

    public StructureHeader(ImageInputStream imageInputStream) throws IOException {
        long l = imageInputStream.getStreamPosition();
        this.readCommonData(imageInputStream);
        switch (this.coreVersion) {
            case 2: {
                this.readBlobVersion(imageInputStream);
            }
        }
        this.headerSize = imageInputStream.getStreamPosition() - l;
    }

    public StructureHeader(byte by) {
        this.configVersion = by;
        this.headerSize = -1L;
    }

    public StructureHeader(BlobID blobID, int n, String string) {
        this.blobID = blobID;
        this.blobVersion = n;
        this.packageID = string;
        this.headerSize = -1L;
    }

    public StructureHeader(InputStream inputStream) {
        this.headerSize = -1L;
    }

    private void readCommonData(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.mark();
        this.coreVersion = imageInputStream.readInt();
        if (this.coreVersion > 65535) {
            if (imageInputStream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            imageInputStream.reset();
            this.coreVersion = imageInputStream.readInt();
        }
        this.sizeofBool = imageInputStream.readByte();
        this.sizeofUDATA = imageInputStream.readByte();
        this.bitfieldFormat = imageInputStream.readByte();
        this.configVersion = imageInputStream.readByte();
        this.structDataSize = imageInputStream.readInt();
        this.stringTableDataSize = imageInputStream.readInt();
        this.structureCount = imageInputStream.readInt();
    }

    public void readBlobVersion(ImageInputStream imageInputStream) throws IOException {
        switch (this.configVersion) {
            case 1: {
                int n = imageInputStream.readInt();
                this.blobID = n >= BlobID.unknown.ordinal() ? BlobID.unknown : BlobID.values()[n];
                this.blobVersion = imageInputStream.readInt();
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                for (int i = 0; i < 32; ++i) {
                    char c = (char)imageInputStream.readByte();
                    if (c == '\u0000') {
                        bl |= bl;
                        continue;
                    }
                    if (bl) continue;
                    stringBuilder.append(c);
                }
                this.packageID = stringBuilder.toString();
                break;
            }
            default: {
                throw new IOException("Blob config version " + this.configVersion + " is not supported");
            }
        }
    }

    public int getCoreVersion() {
        return this.coreVersion;
    }

    public byte getSizeofBool() {
        return this.sizeofBool;
    }

    public byte getSizeofUDATA() {
        return this.sizeofUDATA;
    }

    public byte getBitfieldFormat() {
        return this.bitfieldFormat;
    }

    public int getStructDataSize() {
        return this.structDataSize;
    }

    public int getStringTableDataSize() {
        return this.stringTableDataSize;
    }

    public int getStructureCount() {
        return this.structureCount;
    }

    public byte getConfigVersion() {
        return this.configVersion;
    }

    public BlobID getBlobID() {
        return this.blobID;
    }

    public int getBlobVersion() {
        return this.blobVersion;
    }

    public int[] getBlobVersionArray() {
        int[] nArray = new int[]{this.blobVersion & 0xFF, this.blobVersion >> 8 & 0xFF, this.blobVersion >> 16 & 0xFF, this.blobVersion >> 24 & 0xFF};
        return nArray;
    }

    public String getPackageID() {
        return this.packageID;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }

    public static enum BlobID {
        J9("IBM J9 VM"),
        node("node.js"),
        unknown("unknown");

        private final String name;

        private BlobID(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

