/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Vector;

public class TraceRecord50
implements Comparable {
    public static final int INTERNAL_WRAP_SPLIT_TP = -1;
    public static final int EXTERNAL_WRAP_SPLIT_TP = -2;
    private BigInteger timeStamp;
    private BigInteger wrapTime;
    private BigInteger writePlatform = BigInteger.ZERO;
    private BigInteger writeSystem = BigInteger.ZERO;
    private long threadID = 0L;
    private long threadSyn1 = 0L;
    private long threadSyn2 = 0L;
    private int firstEntry;
    private int nextEntry;
    private String threadName;
    private BigInteger upperTimeWord = BigInteger.ZERO;
    private String threadIDString = null;
    private String fromFileName = null;
    private long offsetInFile = -1L;
    private int bufferLength = -1;
    private int traceRecordType = -1;
    private Vector tps = new Vector();
    private int dataStart;
    private int dataEnd;
    private int dataLength;
    private byte[] overspillData = null;
    private BigInteger overspillUpperWord = null;
    private boolean primed = false;
    private byte[] traceRecordBytes;
    private TraceFile traceFile;
    private int offset;
    private int tplength;
    private long absolutePositionInFile;
    private byte[] dataAtEndOfBuffer;
    private boolean isMiddleOfTracePoint = false;
    private long lostRecordCount = 0L;
    private BigInteger earliestTimeStamp = null;

    public int processTraceBufferHeader(TraceFile traceFile, long l, int n) throws IOException {
        this.fromFileName = traceFile.toString();
        this.offsetInFile = l;
        this.bufferLength = n;
        this.traceFile = traceFile;
        traceFile.seek(l);
        this.timeStamp = traceFile.readBigInteger(8);
        this.wrapTime = traceFile.readBigInteger(8);
        this.writePlatform = traceFile.readBigInteger(8);
        this.writeSystem = traceFile.readBigInteger(8);
        this.threadID = traceFile.readL();
        this.threadSyn1 = traceFile.readL();
        this.threadSyn2 = traceFile.readL();
        this.firstEntry = traceFile.readI();
        this.nextEntry = traceFile.readI();
        this.threadName = traceFile.readString(this.firstEntry - 64);
        this.upperTimeWord = this.timeStamp.shiftRight(32);
        this.threadIDString = Util.formatAsHexString(this.threadID);
        this.dataStart = this.firstEntry;
        this.dataEnd = this.nextEntry;
        if (this.dataEnd < 0) {
            this.isMiddleOfTracePoint = true;
            this.dataLength = n - this.dataStart;
            Util.Debug.println("Found a middle section - dataLength == " + this.dataLength);
        } else {
            this.dataLength = this.dataEnd - this.dataStart;
        }
        if (this.nextEntry >= 0 && (this.nextEntry < this.dataStart || this.nextEntry > n)) {
            this.dataLength = 0;
            ++TraceFormat.invalidBuffers;
        }
        Util.Debug.println("Buffer is at offset " + Long.toHexString(l) + " in " + traceFile);
        Util.Debug.println("  First TracePoint in buffer is at offset " + this.firstEntry);
        Util.Debug.println("  Last TracePoint in buffer is at offset  " + this.nextEntry);
        Util.Debug.println("  timeStamp:    " + this.timeStamp);
        Util.Debug.println("  wrapTime:     " + this.wrapTime);
        Util.Debug.println("  writePlatform " + this.writePlatform);
        Util.Debug.println("  writeSystem   " + this.writeSystem);
        if (this.writePlatform.compareTo(TraceFormat.lastWritePlatform) > 0) {
            Util.Debug.println("updating lastWritePlatform" + this.writePlatform);
            Util.Debug.println("updating lastWriteSystem  " + this.writeSystem);
            TraceFormat.lastWritePlatform = this.writePlatform;
            TraceFormat.lastWriteSystem = this.writeSystem;
        }
        if (this.wrapTime.compareTo(TraceFormat.first) < 0) {
            TraceFormat.first = this.wrapTime;
        }
        if (this.timeStamp.compareTo(TraceFormat.last) > 0) {
            TraceFormat.last = this.timeStamp;
        }
        if (this.writeSystem.compareTo(traceFile.lastWriteSystem) > 0) {
            traceFile.lastWriteSystem = this.writeSystem;
            traceFile.wrapOffset = l;
        }
        return 1;
    }

    public TracePoint getNextTracePoint() {
        TracePoint tracePoint = null;
        if (!this.primed) {
            try {
                this.primeRecord(this.traceFile);
                this.primed = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.tps.isEmpty()) {
            Util.Debug.println("Reached end of buffer ");
            tracePoint = null;
        } else {
            tracePoint = (TracePoint)this.tps.elementAt(0);
            this.tps.removeElementAt(0);
        }
        return tracePoint;
    }

    public boolean addOverspillData(byte[] byArray, BigInteger bigInteger) {
        this.overspillData = byArray;
        return true;
    }

    public boolean isMiddleOfTracePoint() {
        return this.isMiddleOfTracePoint;
    }

    public byte[] getExtraData() {
        if (this.isMiddleOfTracePoint) {
            if (!this.primed) {
                try {
                    this.primeRecord(this.traceFile);
                    this.primed = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return null;
                }
            }
            if (this.traceRecordBytes != null) {
                Util.Debug.println("returning " + this.traceRecordBytes.length + " bytes of middle");
            } else {
                Util.Debug.println("returning some null stuff for the middle");
            }
            return this.traceRecordBytes;
        }
        return this.dataAtEndOfBuffer;
    }

    private byte[] readRecord(TraceFile traceFile) throws IOException {
        int n;
        this.absolutePositionInFile = this.offsetInFile + (long)this.dataStart;
        traceFile.seek(this.absolutePositionInFile);
        long l = 0L;
        byte[] byArray = new byte[this.dataLength + 1];
        int n2 = traceFile.read(byArray);
        if (n2 != this.dataLength + 1) {
            System.err.println("*** Incorrect data length read, expecting " + (this.dataLength + 1) + " found " + n2 + " skipping this TraceBuffer");
            throw new IOException("Can't read record from tracefile");
        }
        if (this.dataEnd < 0) {
            Util.Debug.println("this is the middle - dataLength == " + this.dataLength);
            Util.Debug.println("dataStart " + this.dataStart + " dataEnd " + this.dataEnd + " bufferLength " + this.bufferLength);
            this.dataEnd = this.dataStart;
        }
        if ((n = this.bufferLength - this.dataEnd) > 0) {
            this.dataAtEndOfBuffer = new byte[n];
            l = (long)this.dataEnd + this.offsetInFile;
            traceFile.seek(l);
            n2 = traceFile.read(this.dataAtEndOfBuffer);
            if (n2 != n) {
                TraceFormat.outStream.println("*** Can't read the last " + n + "bytes from a trace record. Record begins at file offset " + this.offsetInFile + " data to be read should start at " + this.dataEnd);
                TraceFormat.outStream.println("  * will continue processing the remainder of the buffer");
            } else {
                Util.Debug.println("Read some excess data from end of buffer at offset " + ((long)this.dataEnd + this.offsetInFile) + " in " + traceFile);
            }
        }
        return byArray;
    }

    public boolean primeRecord(TraceFile traceFile) throws IOException {
        this.traceRecordBytes = this.readRecord(traceFile);
        this.offset = this.traceRecordBytes.length - 1;
        if (this.offset < 0) {
            return true;
        }
        long l = this.absolutePositionInFile + (long)this.offset;
        long l2 = -3L;
        TracePoint tracePoint = null;
        byte[] byArray = new byte[this.bufferLength];
        boolean bl = false;
        boolean bl2 = false;
        if (this.traceRecordBytes[0] == 0 && this.traceRecordBytes[1] == 0 && this.traceRecordBytes[2] == 1 && this.traceRecordBytes[3] == 0 && this.traceRecordBytes.length >= 8) {
            this.lostRecordCount = Util.constructUnsignedInt(this.traceRecordBytes, 4);
            TraceFormat.lostRecordCount += this.lostRecordCount;
            this.overspillData = null;
        }
        do {
            int n;
            if (!bl2) {
                this.tplength = Util.constructUnsignedByte(this.traceRecordBytes, this.offset);
            }
            bl2 = false;
            boolean bl3 = false;
            l2 = l - (long)this.tplength;
            if (tracePoint != null && tracePoint.isLongTracePoint()) {
                n = tracePoint.longTracePointLength();
                Util.Debug.println("Processing long tracepoint - length = " + n);
                this.tplength = n;
                bl2 = true;
            }
            tracePoint = null;
            if (this.tplength > this.offset) {
                byte[] byArray2;
                byte[] byArray3;
                bl3 = true;
                if (bl) break;
                n = this.tplength - this.offset;
                if (this.traceRecordType == 0) {
                    l2 = -1L;
                    if (this.dataAtEndOfBuffer != null) {
                        byArray3 = this.dataAtEndOfBuffer;
                        byArray2 = new byte[byArray3.length + this.offset + 1];
                        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                        System.arraycopy(this.traceRecordBytes, 0, byArray2, byArray3.length, this.offset + 1);
                        Util.Debug.println(" coalesced the buffers successfully! ");
                        bl = true;
                        this.traceRecordBytes = byArray2;
                        this.offset = byArray2.length - 1;
                        continue;
                    }
                    Util.Debug.println(" TraceRecord50 wrapped an internal buffer which doesn't seem to have any extra data at the end");
                    break;
                }
                l2 = -2L;
                if (this.overspillData != null) {
                    byArray3 = this.overspillData;
                    byArray2 = new byte[byArray3.length + this.offset + 1];
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                    System.arraycopy(this.traceRecordBytes, 0, byArray2, byArray3.length, this.offset + 1);
                    Util.Debug.println(" coalesced the buffers successfully! ");
                    bl = true;
                    this.traceRecordBytes = byArray2;
                    this.offset = byArray2.length - 1;
                    continue;
                }
                if (this.lostRecordCount > 0L) {
                    tracePoint = new TracePoint(this.traceRecordBytes, 8, this.upperTimeWord, this.threadID, traceFile.toString(), this.absolutePositionInFile, this.absolutePositionInFile + 8L, false);
                }
                Util.Debug.println(" TraceRecord50 walked back off the beginning of this buffer, but found no overspill data");
                break;
            }
            this.offset -= this.tplength;
            if (tracePoint == null) {
                if (byArray.length < this.tplength) {
                    byArray = new byte[this.tplength + 1];
                }
                System.arraycopy(this.traceRecordBytes, this.offset, byArray, 0, this.tplength);
                tracePoint = new TracePoint(byArray, this.tplength, this.upperTimeWord, this.threadID, traceFile.toString(), l2, l, bl3);
            }
            if (tracePoint.isTimerUpperWord()) {
                this.upperTimeWord = BigInteger.valueOf(tracePoint.getNewTimerUpperWord());
            } else if (tracePoint.isLostRecord()) {
                if (this.earliestTimeStamp != null) {
                    tracePoint.setRawTimeStamp(this.earliestTimeStamp);
                } else {
                    tracePoint.setRawTimeStamp(this.timeStamp);
                }
                if (this.tps.size() > 0) {
                    this.tps.insertElementAt(tracePoint, this.tps.size() - 1);
                } else {
                    this.tps.add(tracePoint);
                }
            }
            if (tracePoint.isNormalTracepoint()) {
                this.tps.add(tracePoint);
                this.earliestTimeStamp = tracePoint.getRawTimeStamp();
            }
            l -= (long)this.tplength;
        } while (this.tplength > 0 && this.offset >= 0);
        if (this.offset != 0) {
            Util.Debug.println("TraceRecord ended with some extra data");
        }
        Util.Debug.print("About to sort");
        Collections.sort(this.tps);
        Util.Debug.println(" ... sorted");
        if (!this.isMiddleOfTracePoint) {
            this.traceRecordBytes = null;
        }
        return true;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadIDAsLong() {
        return this.threadID;
    }

    public String getFileName() {
        return this.fromFileName;
    }

    public long getOffsetInFile() {
        return this.offsetInFile;
    }

    public BigInteger getTimeStamp() {
        return this.timeStamp;
    }

    public BigInteger getLastTimerWrap() {
        return this.wrapTime;
    }

    public void setTimeStamp(BigInteger bigInteger) {
        this.timeStamp = bigInteger;
    }

    public int compareTo(Object object) {
        if (this.writeSystem == BigInteger.ZERO || ((TraceRecord50)object).writeSystem == BigInteger.ZERO) {
            Util.Debug.println("TraceRecord50.compareTo() found trace record with a zero system write time");
            return 0;
        }
        int n = this.writeSystem.compareTo(((TraceRecord50)object).writeSystem);
        if (n == 0) {
            if (this.offsetInFile <= this.traceFile.wrapOffset && ((TraceRecord50)object).offsetInFile > this.traceFile.wrapOffset) {
                return 1;
            }
            if (this.offsetInFile > this.traceFile.wrapOffset && ((TraceRecord50)object).offsetInFile <= this.traceFile.wrapOffset) {
                return -1;
            }
        }
        return n;
    }

    public int getTraceType() {
        return this.traceRecordType;
    }

    public void setTraceType(int n) {
        this.traceRecordType = n;
    }

    public BigInteger getLastUpperWord() {
        return this.upperTimeWord;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TraceRecord50:");
        stringBuffer.append(this.timeStamp);
        stringBuffer.append(":offset in file ");
        stringBuffer.append(this.absolutePositionInFile);
        stringBuffer.append(":len ");
        stringBuffer.append(this.bufferLength);
        return stringBuffer.toString();
    }
}

