/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import java.util.Iterator;
import java.util.Vector;

public class JCJavaMethod
implements JavaMethod {
    private final String fName;
    private final JavaClass fJavaClass;
    private String fSignature;
    private Vector fBytecodeSections;
    private Vector fCompiledSections;

    public JCJavaMethod(String string, JCJavaClass jCJavaClass) throws JCInvalidArgumentsException {
        if (string == null) {
            throw new JCInvalidArgumentsException("A method from a javacore must have a valid name.");
        }
        if (jCJavaClass == null) {
            throw new JCInvalidArgumentsException("A method must have a valid declaring class.");
        }
        this.fName = string;
        this.fJavaClass = jCJavaClass;
        this.fSignature = null;
        this.fBytecodeSections = new Vector();
        this.fCompiledSections = new Vector();
        jCJavaClass.addMethod(this);
    }

    @Override
    public Iterator getBytecodeSections() {
        return this.fBytecodeSections.iterator();
    }

    @Override
    public Iterator getCompiledSections() {
        return this.fCompiledSections.iterator();
    }

    @Override
    public JavaClass getDeclaringClass() throws CorruptDataException, DataUnavailable {
        if (this.fJavaClass == null) {
            throw new DataUnavailable();
        }
        return this.fJavaClass;
    }

    @Override
    public int getModifiers() throws CorruptDataException {
        throw new CorruptDataException(new JCCorruptData(null));
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.fName == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fName;
    }

    @Override
    public String getSignature() throws CorruptDataException {
        if (this.fSignature == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fSignature;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JCJavaMethod jCJavaMethod = (JCJavaMethod)object;
        return this.fName.equals(jCJavaMethod.fName) && this.fJavaClass.equals(jCJavaMethod.fJavaClass);
    }

    @Override
    public int hashCode() {
        return this.fName.hashCode() ^ this.fJavaClass.hashCode();
    }

    public String toString() {
        try {
            return this.getDeclaringClass().getName() + "." + this.getName();
        }
        catch (CorruptDataException corruptDataException) {
            return super.toString();
        }
        catch (DataUnavailable dataUnavailable) {
            return super.toString();
        }
    }
}

