/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithIntArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.reflect.Array;

final class CollectHandle
extends MethodHandle {
    final MethodHandle next;
    final int collectArraySize;
    final int collectPosition;
    final Object emptyArray;
    private static final ThunkTable _thunkTable = new ThunkTable();

    CollectHandle(MethodHandle methodHandle, int n, int n2) {
        super(CollectHandle.collectMethodType(methodHandle.type(), n, n2), (byte)10, new int[]{n, n2});
        this.collectPosition = n2;
        this.collectArraySize = n;
        this.next = methodHandle;
        this.emptyArray = n == 0 ? Array.newInstance(methodHandle.type.arguments[n2].getComponentType(), 0) : null;
    }

    CollectHandle(CollectHandle collectHandle, MethodType methodType) {
        super(collectHandle, methodType);
        this.collectPosition = collectHandle.collectPosition;
        this.collectArraySize = collectHandle.collectArraySize;
        this.next = collectHandle.next;
        this.emptyArray = collectHandle.emptyArray;
    }

    private static final MethodType collectMethodType(MethodType methodType, int n, int n2) {
        int n3 = methodType.parameterCount();
        if (0 == n3) {
            throw new IllegalArgumentException(Msg.getString("K05ca", n2));
        }
        Class<?> clazz = methodType.parameterType(n2).getComponentType();
        if (null == clazz) {
            throw new IllegalArgumentException(Msg.getString("K05ca", n2));
        }
        MethodType methodType2 = methodType.changeParameterType(n2, clazz);
        if (0 == n) {
            methodType2 = methodType2.dropParameterTypes(n2, n2 + 1);
        } else if (n > 1) {
            Class[] classArray = new Class[n - 1];
            int n4 = classArray.length;
            for (int i = 0; i < n4; ++i) {
                classArray[i] = clazz;
            }
            methodType2 = methodType2.insertParameterTypes(n2 + 1, classArray);
        }
        return methodType2;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new CollectHandle(this, methodType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object object) {
        int[] nArray = (int[])object;
        return this.thunkTable().get(new ThunkKeyWithIntArray(ThunkKey.computeThunkableType(this.type()), nArray));
    }

    private static final Object allocateArray(CollectHandle collectHandle) {
        return Array.newInstance(collectHandle.next.type.arguments[collectHandle.collectPosition].getComponentType(), collectHandle.collectArraySize);
    }

    private static native int numArgsToCollect();

    private static native int collectionStart();

    private static native int numArgsAfterCollectArray();

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int n) throws Throwable {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        ILGenMacros.populateArray(ILGenMacros.push(this.collectArraySize == 0 ? this.emptyArray : CollectHandle.allocateArray(this)), ILGenMacros.middleN(CollectHandle.collectionStart(), CollectHandle.numArgsToCollect(), n));
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(CollectHandle.collectionStart(), n), ILGenMacros.pop_L(), ILGenMacros.lastN(CollectHandle.numArgsAfterCollectArray(), n)));
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof CollectHandle) {
            ((CollectHandle)methodHandle).compareWithCollect(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithCollect(CollectHandle collectHandle, Comparator comparator) {
        comparator.compareStructuralParameter(collectHandle.collectArraySize, this.collectArraySize);
        comparator.compareStructuralParameter(collectHandle.collectPosition, this.collectPosition);
        comparator.compareChildHandle(collectHandle.next, this.next);
    }
}

