/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoMmapCommand
extends BaseJdmpviewCommand {
    public InfoMmapCommand() {
        this.addCommand("info mmap", "[address] [-verbose] [-sort:<size|address>]", "Outputs a list of all memory segments in the address space");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        boolean bl = false;
        ImagePointer imagePointer = null;
        Comparator<ImageSection> comparator = null;
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        for (String string2 : stringArray) {
            if ("-sort:size".equals(string2)) {
                comparator = new SizeComparator();
                continue;
            }
            if ("-sort:address".equals(string2)) {
                comparator = new AddressComparator();
                continue;
            }
            if ("-verbose".equals(string2)) {
                bl = true;
                continue;
            }
            Long l = Utils.longFromString(string2);
            if (l == null) {
                printStream.println("\"info mmap\" -unknown parameter " + string2);
                return;
            }
            imagePointer = this.ctx.getAddressSpace().getPointer(l.longValue());
        }
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.ctx.getAddressSpace().getImageSections();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        if (comparator != null) {
            Collections.sort(linkedList, comparator);
        }
        int n = this.ctx.getProcess().getPointerSize() == 64 ? 16 : 8;
        int n2 = 0;
        int n3 = 0;
        if (n == 16) {
            n3 = String.format("%016x", Long.MAX_VALUE).length();
            n2 = String.format("(%,d)", Long.MAX_VALUE).length();
        } else {
            n3 = String.format("%08x", Integer.MAX_VALUE).length();
            n2 = String.format("(%,d)", Integer.MAX_VALUE).length();
        }
        printStream.printf("%-" + n3 + "s\t%-" + n3 + "s\t%-" + n3 + "s\t%-" + n2 + "s\tRead/Write/Execute", "Start Address", "End Address", "Size", "Size");
        printStream.println();
        long l = 0L;
        long l2 = 0L;
        Iterator iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            ImageSection imageSection = (ImageSection)iterator2.next();
            if (imagePointer != null && (imageSection.getBaseAddress().getAddress() > imagePointer.getAddress() || imageSection.getBaseAddress().add(imageSection.getSize()).getAddress() <= imagePointer.getAddress())) continue;
            long l3 = imageSection.getBaseAddress().getAddress();
            long l4 = imageSection.getSize();
            long l5 = l3 + l4 - 1L;
            l += l4;
            String string3 = String.format("(%,d)", l4);
            printStream.printf("0x%0" + n3 + "x\t0x%0" + n3 + "x\t0x%0" + n3 + "x\t%-" + n2 + "s\t", l3, l5, l4, string3);
            Properties properties = imageSection.getProperties();
            if (properties != null) {
                boolean bl2 = false;
                if (Boolean.TRUE.toString().equals(properties.get("readable"))) {
                    printStream.print("R");
                    bl2 = true;
                }
                if (Boolean.TRUE.toString().equals(properties.get("writable"))) {
                    printStream.print("W");
                    bl2 = true;
                }
                if (Boolean.TRUE.toString().equals(properties.get("executable"))) {
                    printStream.print("X");
                    bl2 = true;
                }
                if (bl2) {
                    l2 += l4;
                }
            }
            if (bl || imagePointer != null) {
                printStream.println();
                printStream.println("Name:\t" + imageSection.getName());
                Object[] objectArray = properties.keySet().toArray(new String[0]);
                ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
                int n4 = 0;
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    String string4 = String.format("%s=%s", object, properties.get(object));
                    arrayList.add(string4);
                    n4 = Math.max(n4, string4.length());
                }
                Iterator iterator3 = arrayList.iterator();
                String string5 = "\t%-" + n4 + "s\t%-" + n4 + "s\n";
                while (iterator3.hasNext()) {
                    printStream.printf(string5, iterator3.next(), iterator3.hasNext() ? iterator3.next() : "");
                }
                printStream.println();
                continue;
            }
            printStream.println();
        }
        if (imagePointer == null) {
            if (l2 > 0L && l != l2) {
                printStream.printf("Total size (Readable, Writable or Executable): 0x%1$x (%1$,d) bytes\n", l2);
            }
            printStream.printf("Total size: 0x%1$x (%1$,d) bytes\n", l);
        }
    }

    private static int cmp(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l > l2) {
            return 1;
        }
        return -1;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("outputs a list of all memory segments in the address space\n\nparameters: none, an address in memory, sort flags, verbose output\n\nIf no address is specified outputs a list all memory segments (ImageSections) in the address space with start address, size and properties\nThis output may be sorted using the -sort:address,  or -sort:size flags.\nIf -verbose is specified then each memory segment is followed by any further detailed information.If an address is specified then just the memory segment containing that address is output.\n");
    }

    private class AddressComparator
    implements Comparator<ImageSection> {
        private AddressComparator() {
        }

        @Override
        public int compare(ImageSection imageSection, ImageSection imageSection2) {
            long l = imageSection.getBaseAddress().getAddress();
            long l2 = imageSection2.getBaseAddress().getAddress();
            return InfoMmapCommand.cmp(l, l2);
        }
    }

    private class SizeComparator
    implements Comparator<ImageSection> {
        private SizeComparator() {
        }

        @Override
        public int compare(ImageSection imageSection, ImageSection imageSection2) {
            long l = imageSection.getSize();
            long l2 = imageSection2.getSize();
            return InfoMmapCommand.cmp(l, l2);
        }
    }
}

