/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class HexdumpCommand
extends BaseJdmpviewCommand {
    public HexdumpCommand() {
        this.addCommand("hexdump", "<hex address>", "outputs a section of memory in hexadecimal, ascii and ebcdic");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        this.doCommand(stringArray);
    }

    public void doCommand(String[] stringArray) {
        long l;
        Long l2;
        StringBuffer stringBuffer = new StringBuffer();
        ImageAddressSpace imageAddressSpace = this.ctx.getAddressSpace();
        if (null == imageAddressSpace) {
            this.out.println("Could not find an address space which contains a process in this core file");
            return;
        }
        long l3 = 0L;
        int n = 256;
        int n2 = 0;
        if (stringArray.length != 0) {
            l2 = Utils.longFromString(stringArray[0]);
            if (null == l2) {
                this.out.println("Specified address is invalid");
                return;
            }
        } else {
            this.out.println("\"hexdump\" requires at least an address parameter");
            return;
        }
        l3 = l2;
        if (stringArray.length > 1) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                this.out.println("Specified length is invalid");
                return;
            }
        }
        l2 = imageAddressSpace.getPointer(l3);
        boolean bl = false;
        try {
            bl = this.ctx.getImage().getSystemType().toLowerCase().indexOf("z/os") >= 0;
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        String string = "";
        String string2 = "";
        for (l = 0L; l < (long)n; ++l) {
            ImagePointer imagePointer = l2.add(l);
            try {
                String string3;
                byte by = imagePointer.getByteAt(0L);
                n2 = by & 0xFF;
                String string4 = Integer.toHexString(n2);
                String string5 = string3 = this.fixHexStringLength(string4);
                if (0L == l % 4L) {
                    string5 = " " + string5;
                }
                if (0L == l % 16L) {
                    string5 = "\n" + Long.toHexString(imagePointer.getAddress()) + ":" + string5;
                    string = "  |";
                    string2 = " |";
                }
                stringBuffer.append(string5);
                string = string + "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................".substring(n2, n2 + 1);
                if (15L == l % 16L && l != 0L) {
                    string = string + "|";
                    stringBuffer.append(string);
                }
                if (!bl) continue;
                string2 = string2 + ".................................................................................................................................abcdefghi.......jklmnopqr........stuvwxyz.......................ABCDEFGHI.......JKLMNOPQR........STUVWXYZ......0123456789......".substring(n2, n2 + 1);
                if (15L != l % 16L || l == 0L) continue;
                string2 = string2 + "|";
                stringBuffer.append(string2);
                continue;
            }
            catch (MemoryAccessException memoryAccessException) {
                this.out.println("Address not in memory - 0x" + Long.toHexString(imagePointer.getAddress()));
                return;
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("Dump data is corrupted");
                return;
            }
        }
        long l4 = 16L - l % 16L;
        if (16L != l4) {
            stringBuffer.append(this.padSpace(l4, string));
            if (bl) {
                int n3 = 0;
                while ((long)n3 < l4) {
                    string2 = " " + string2;
                    ++n3;
                }
                stringBuffer.append(" " + string2);
            }
        }
        stringBuffer.append("\n");
        this.out.println(new String(stringBuffer));
        this.ctx.getProperties().put("currentMemPtrAddress", (Object)l3);
        this.ctx.getProperties().put("currentNumBytes", (Object)n);
    }

    private String padSpace(long l, String string) {
        int n = 0;
        while ((long)n < 2L * l + l / 4L) {
            string = " " + string;
            ++n;
        }
        return string;
    }

    private String fixHexStringLength(String string) {
        int n = string.length();
        if (1 == n) {
            return "0" + string;
        }
        if (2 == n) {
            return string;
        }
        if (8 == n) {
            return string.substring(6, 8);
        }
        return "ERROR fixHexStringLength";
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("outputs a section of memory in hexadecimal, ascii and ebcdic\n\nparameters: <hex_address> <bytes_to_print>\n\noutputs <bytes_to_print> bytes of memory contents starting from <hex_address>, ebcdic output is provided for z/OS dumps");
    }
}

