/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;
import jdk.crypto.jniprovider.NativeCrypto;

abstract class NativeDigest
extends MessageDigestSpi
implements Cloneable {
    private long context;
    private byte[] oneByte;
    private final String algorithm;
    private final int digestLength;
    private final int algIndx;
    private long bytesProcessed;
    private static NativeCrypto nativeCrypto = NativeCrypto.getNativeCrypto();

    NativeDigest(String string, int n, int n2) {
        this.algorithm = string;
        this.digestLength = n;
        this.algIndx = n2;
        this.context = nativeCrypto.DigestCreateContext(0L, n2);
        if (this.context == -1L) {
            throw new ProviderException("Error in Native Digest");
        }
    }

    @Override
    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    @Override
    protected final void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected final synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.bytesProcessed += (long)n2;
        int n3 = nativeCrypto.DigestUpdate(this.context, byArray, n, n2);
        if (n3 == -1) {
            throw new ProviderException("Error in Native Digest");
        }
    }

    @Override
    protected final synchronized void engineReset() {
        if (this.bytesProcessed == 0L) {
            return;
        }
        nativeCrypto.DigestReset(this.context);
        this.bytesProcessed = 0L;
    }

    @Override
    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw (ProviderException)new ProviderException("Internal error").initCause(digestException);
        }
        return byArray;
    }

    @Override
    protected final synchronized int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength + " for " + this.algorithm + "digests");
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new DigestException("Buffer too short to store digest");
        }
        int n3 = nativeCrypto.DigestComputeAndReset(this.context, null, 0, 0, byArray, n, n2);
        if (n3 == -1) {
            throw new DigestException("Error in Native Digest");
        }
        this.bytesProcessed = 0L;
        return this.digestLength;
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        NativeDigest nativeDigest = (NativeDigest)super.clone();
        nativeDigest.context = nativeCrypto.DigestCreateContext(this.context, this.algIndx);
        if (nativeDigest.context == -1L) {
            throw new ProviderException("Error in Native Digest");
        }
        return nativeDigest;
    }

    public void finalize() {
        nativeCrypto.DigestDestroyContext(this.context);
    }
}

