/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.HeapDoubleBufferR;

class HeapDoubleBuffer
extends DoubleBuffer {
    HeapDoubleBuffer(int n, int n2) {
        super(-1, 0, n2, n, new double[n], 0);
    }

    HeapDoubleBuffer(double[] dArray, int n, int n2) {
        super(-1, n, n + n2, dArray.length, dArray, 0);
    }

    protected HeapDoubleBuffer(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, dArray, n5);
    }

    @Override
    public DoubleBuffer slice() {
        return new HeapDoubleBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new HeapDoubleBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new HeapDoubleBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public double get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public double get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public DoubleBuffer get(double[] dArray, int n, int n2) {
        HeapDoubleBuffer.checkBounds(n, n2, dArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy((Object)this.hb, this.ix(this.position()), (Object)dArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public DoubleBuffer put(double d) {
        this.hb[this.ix((int)this.nextPutIndex())] = d;
        return this;
    }

    @Override
    public DoubleBuffer put(int n, double d) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = d;
        return this;
    }

    @Override
    public DoubleBuffer put(double[] dArray, int n, int n2) {
        HeapDoubleBuffer.checkBounds(n, n2, dArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy((Object)dArray, n, (Object)this.hb, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    @Override
    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer instanceof HeapDoubleBuffer) {
            if (doubleBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapDoubleBuffer heapDoubleBuffer = (HeapDoubleBuffer)doubleBuffer;
            int n = heapDoubleBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy((Object)heapDoubleBuffer.hb, heapDoubleBuffer.ix(heapDoubleBuffer.position()), (Object)this.hb, this.ix(this.position()), n);
            heapDoubleBuffer.position(heapDoubleBuffer.position() + n);
            this.position(this.position() + n);
        } else if (doubleBuffer.isDirect()) {
            int n = doubleBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            doubleBuffer.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(doubleBuffer);
        }
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        System.arraycopy((Object)this.hb, this.ix(this.position()), (Object)this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

