/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.lang.management.CpuLoadCalculationConstants;
import com.ibm.lang.management.internal.SysinfoCpuTime;

final class CpuUtilizationHelper
implements CpuLoadCalculationConstants {
    SysinfoCpuTime oldestTime = null;
    SysinfoCpuTime interimTime = null;
    SysinfoCpuTime latestTime = null;

    CpuUtilizationHelper() {
    }

    synchronized double getSystemCpuLoad() {
        double d = -1.0;
        this.latestTime = SysinfoCpuTime.getCpuUtilizationImpl();
        if (null == this.latestTime) {
            return -4.0;
        }
        int n = this.latestTime.getStatus();
        if (n < 0) {
            return n;
        }
        if (null == this.oldestTime) {
            this.oldestTime = this.interimTime = this.latestTime;
            return -1.0;
        }
        if (this.latestTime.getTimestamp() - this.interimTime.getTimestamp() >= 10000000L) {
            d = CpuUtilizationHelper.calculateCpuLoad(this.latestTime, this.interimTime);
            if (d >= 0.0) {
                this.oldestTime = this.interimTime;
                this.interimTime = this.latestTime;
                return d;
            }
            this.interimTime = this.latestTime;
        }
        if (this.latestTime.getTimestamp() - this.oldestTime.getTimestamp() >= 10000000L && (d = CpuUtilizationHelper.calculateCpuLoad(this.latestTime, this.oldestTime)) < 0.0) {
            this.oldestTime = this.latestTime;
        }
        return d;
    }

    private static double calculateCpuLoad(SysinfoCpuTime sysinfoCpuTime, SysinfoCpuTime sysinfoCpuTime2) {
        double d = sysinfoCpuTime.getTimestamp() - sysinfoCpuTime2.getTimestamp();
        double d2 = sysinfoCpuTime.getCpuTime() - sysinfoCpuTime2.getCpuTime();
        if (d <= 0.0 || d2 < 0.0) {
            return -1.0;
        }
        return Math.min(d2 / ((double)sysinfoCpuTime.getNumberOfCpus() * d), 1.0);
    }
}

