/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.framework.tag;

import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.scanner.TokenManager;
import com.ibm.dtfj.javacore.parser.framework.tag.ILineRule;
import com.ibm.dtfj.javacore.parser.j9.AttributeValueMapFactory;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import java.util.HashMap;
import java.util.regex.Matcher;

public abstract class LineRule
implements ILineRule {
    protected final StringBuffer fSource = new StringBuffer();
    protected final StringBuffer fCharSubSet = new StringBuffer();
    protected int fLineNumber = 0;
    protected int fOffSet = 0;
    private HashMap fTokenList;

    @Override
    public IAttributeValueMap parseLine(String string, int n, int n2) {
        this.fSource.delete(0, this.fSource.length());
        this.fSource.append(string);
        this.fLineNumber = n;
        this.fTokenList = new HashMap();
        this.processLine(string, n2);
        return AttributeValueMapFactory.createAttributeValueMap(this.fTokenList);
    }

    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected abstract void processLine(String var1, int var2);

    protected IParserToken addToken(String string, Matcher matcher) {
        return this.internalAddToken(string, matcher);
    }

    protected void addToken(IParserToken iParserToken) {
        if (iParserToken != null) {
            this.fTokenList.put(iParserToken.getType(), iParserToken);
        }
    }

    protected IParserToken addToken(String string, String string2) {
        IParserToken iParserToken = TokenManager.getToken(string2.length(), this.fOffSet, this.fLineNumber, string, string2);
        this.addToken(iParserToken);
        return iParserToken;
    }

    protected IParserToken addAllCharactersAsTokenAndConsumeFirstMatch(String string, Matcher matcher) {
        matcher.reset(this.fSource);
        IParserToken iParserToken = null;
        if (matcher.find()) {
            int n = matcher.start();
            int n2 = matcher.end() - n;
            iParserToken = this.addAllCharactersAsTokenUntilIndex(string, n, false);
            this.fSource.delete(0, n2);
        }
        return iParserToken;
    }

    protected IParserToken addAllCharactersAsTokenUntilFirstMatch(String string, Matcher matcher) {
        matcher.reset(this.fSource);
        IParserToken iParserToken = null;
        if (matcher.find()) {
            iParserToken = this.addAllCharactersAsTokenUntilIndex(string, matcher.start(), false);
        }
        return iParserToken;
    }

    protected IParserToken addAllCharactersAsTokenUntilIndex(String string, int n, boolean bl) {
        int n2;
        if (n > this.fSource.length() || n < 0) {
            throw new IndexOutOfBoundsException(n + ":" + this.fSource.length());
        }
        int n3 = n - 1;
        if (bl) {
            for (n2 = n3; n2 >= 0 && Character.isWhitespace(this.fSource.charAt(n2)); --n2) {
            }
            n3 = n2;
        }
        this.fCharSubSet.delete(0, this.fCharSubSet.length());
        for (n2 = 0; n2 <= n3; ++n2) {
            this.fCharSubSet.append(this.fSource.charAt(n2));
        }
        this.fSource.delete(0, n);
        IParserToken iParserToken = TokenManager.getToken(this.fCharSubSet.length(), this.fOffSet, this.fLineNumber, string, this.fCharSubSet.toString());
        this.addToken(iParserToken);
        return iParserToken;
    }

    protected IParserToken addNonPrefixedHexToken(String string) {
        Matcher matcher = CommonPatternMatchers.hex;
        matcher.reset(this.fSource);
        IParserToken iParserToken = null;
        if (matcher.find()) {
            this.fCharSubSet.delete(0, this.fCharSubSet.length());
            int n = matcher.start();
            int n2 = matcher.end();
            this.fCharSubSet.append('0');
            this.fCharSubSet.append('x');
            for (int i = n; i < n2; ++i) {
                this.fCharSubSet.append(this.fSource.charAt(i));
            }
            String string2 = this.fCharSubSet.toString();
            this.fSource.delete(0, n2);
            iParserToken = this.addToken(string, string2);
        }
        return iParserToken;
    }

    protected IParserToken addPrefixedHexToken(String string) {
        return this.addToken(string, CommonPatternMatchers.hex_0x);
    }

    private IParserToken internalAddToken(String string, Matcher matcher) {
        String string2 = null;
        IParserToken iParserToken = null;
        int n = this.fOffSet;
        string2 = this.matchAndConsumeValue(matcher);
        if (string2 != null) {
            iParserToken = TokenManager.getToken(string2.length(), n, this.fLineNumber, string, string2);
            this.fTokenList.put(iParserToken.getType(), iParserToken);
        }
        return iParserToken;
    }

    protected String matchAndConsumeValue(Matcher matcher) {
        matcher.reset(this.fSource);
        String string = null;
        if (matcher.find()) {
            string = matcher.group();
            this.fSource.delete(0, matcher.start() + string.length());
        }
        return string;
    }

    protected String consumeCharacters(int n, int n2) {
        String string = this.fSource.substring(n, n2);
        this.fSource.delete(n, n2);
        return string;
    }

    protected boolean consumeUntilFirstMatch(Matcher matcher) {
        matcher.reset(this.fSource);
        boolean bl = false;
        bl = matcher.find();
        if (bl) {
            this.fSource.delete(0, matcher.end());
        }
        return bl;
    }

    protected boolean findFirst(Matcher matcher) {
        matcher.reset(this.fSource);
        return matcher.find();
    }

    protected int indexOfLast(Matcher matcher) {
        int n = -1;
        matcher.reset(this.fSource);
        while (matcher.find()) {
            n = matcher.start();
        }
        return n;
    }
}

