/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckClassHeap;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckClassLoaders;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckEngine;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckFinalizableList;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckJNIGlobalReferences;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckJNIWeakGlobalReferences;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckJVMTIObjectTagTables;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckMonitorTable;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckObjectHeap;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckOwnableSynchronizerList;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckRememberedSet;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporter;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckStringTable;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckUnfinalizedList;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckVMClassSlots;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckVMThreadStacks;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckVMThreads;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

class CheckCycle {
    private static final String[] checkNames;
    private static final Class<Check>[] checkClasses;
    private int _checkFlags;
    private int _miscFlags;
    private int _errorCount;
    private Check[] _checks = null;
    private CheckEngine _engine;
    private boolean _printHelp;

    public CheckCycle(J9JavaVMPointer j9JavaVMPointer, CheckEngine checkEngine, String string) {
        this._engine = checkEngine;
        this.initialize(string);
    }

    private void printHelp() {
        CheckReporter checkReporter = this._engine.getReporter();
        checkReporter.println("GC Check for J9, Version 2.7");
        checkReporter.println();
        checkReporter.println("Usage: -Xcheck:gc[:scanOption,...][:verifyOption,...][:miscOption,...]");
        checkReporter.println("scan options (default is all):");
        checkReporter.println("  all");
        checkReporter.println("  none");
        for (int i = 0; i < checkNames.length; ++i) {
            checkReporter.println("  [no]" + checkNames[i]);
        }
        checkReporter.println("  heap");
        checkReporter.println("  help");
        checkReporter.println();
        checkReporter.println("verify options (default is all):");
        checkReporter.println("  all");
        checkReporter.println("  none");
        checkReporter.println("  classslot");
        checkReporter.println("  range");
        checkReporter.println("  flags");
        checkReporter.println();
        checkReporter.println("misc options (default is verbose,check):");
        checkReporter.println("  verbose");
        checkReporter.println("  quiet");
        checkReporter.println("  [no]scan");
        checkReporter.println("  [no]check");
        checkReporter.println("  maxErrors=X");
        checkReporter.println("  darkmatter");
        checkReporter.println("  midscavenge");
        checkReporter.println("  scavengerbackout");
        checkReporter.println("  ownablesynchronizerconsistency");
        checkReporter.println();
    }

    private void initialize(String string) {
        int n;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Check> arrayList2 = new ArrayList<Check>();
        int n2 = 0;
        int n3 = 1025;
        for (n = 0; n < checkNames.length; ++n) {
            hashMap.put(checkNames[n], false);
        }
        if (string.equalsIgnoreCase("help")) {
            this._printHelp = true;
        } else {
            Object object;
            Object object2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
                object = new ArrayList();
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    ((ArrayList)object).add(((StringTokenizer)object2).nextToken());
                }
                arrayList.add(object);
            }
            if (arrayList.size() > 0) {
                object2 = (ArrayList)arrayList.get(0);
                if (((ArrayList)object2).size() == 0) {
                    for (int i = 0; i < checkNames.length; ++i) {
                        hashMap.put(checkNames[i], true);
                    }
                } else {
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext()) {
                        String string2 = (String)object.next();
                        if (string2.equals("all")) {
                            for (int i = 0; i < checkNames.length; ++i) {
                                hashMap.put(checkNames[i], true);
                            }
                            continue;
                        }
                        if (string2.equals("none")) {
                            for (int i = 0; i < checkNames.length; ++i) {
                                hashMap.put(checkNames[i], false);
                            }
                            continue;
                        }
                        if (hashMap.containsKey(string2)) {
                            hashMap.put(string2, true);
                            continue;
                        }
                        if (string2.equals("heap")) {
                            hashMap.put("objectheap", true);
                            hashMap.put("classheap", true);
                            continue;
                        }
                        if (string2.startsWith("no")) {
                            String string3 = string2.substring(2);
                            if (hashMap.containsKey(string3)) {
                                hashMap.put(string3, false);
                                continue;
                            }
                            if (string3.equals("heap")) {
                                hashMap.put("objectheap", false);
                                hashMap.put("classheap", false);
                                continue;
                            }
                        }
                        this._printHelp = true;
                        this._engine.getReporter().println("GC Check: unrecognized option '" + string2 + "'");
                    }
                }
            } else {
                for (int i = 0; i < checkNames.length; ++i) {
                    hashMap.put(checkNames[i], true);
                }
            }
            if (arrayList.size() > 1) {
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3.size() == 0) {
                    n2 = -1;
                } else {
                    for (String string2 : arrayList3) {
                        if (string2.equals("all")) {
                            n2 |= 0xFFFFFFFF;
                            continue;
                        }
                        if (string2.equals("none")) {
                            n2 |= 0xFFFFFFFF;
                            continue;
                        }
                        if (string2.equals("all")) {
                            n2 &= 0;
                            continue;
                        }
                        if (string2.equals("classslot")) {
                            n2 |= 1;
                            continue;
                        }
                        if (string2.equals("range")) {
                            n2 |= 2;
                            continue;
                        }
                        if (string2.equals("flags")) {
                            n2 |= 8;
                            continue;
                        }
                        this._printHelp = true;
                        this._engine.getReporter().println("GC Check: unrecognized option '" + string2 + "'");
                    }
                }
            } else {
                n2 = -1;
            }
            if (arrayList.size() > 2) {
                for (String string4 : (ArrayList)arrayList.get(2)) {
                    if (string4.equals("verbose")) {
                        n3 |= 1;
                        continue;
                    }
                    if (string4.equals("manual")) {
                        n3 |= 0x2000;
                        continue;
                    }
                    if (string4.equals("quiet")) {
                        n3 &= 0xFFFFFFFE;
                        n3 |= 0x800;
                        continue;
                    }
                    if (string4.equals("scan")) {
                        n3 |= 0x200;
                        continue;
                    }
                    if (string4.equals("noscan")) {
                        n3 &= 0xFFFFFDFF;
                        continue;
                    }
                    if (string4.equals("check")) {
                        n3 |= 0x400;
                        continue;
                    }
                    if (string4.equals("nocheck")) {
                        n3 &= 0xFFFFFBFF;
                        continue;
                    }
                    if (string4.startsWith("maxerrors=")) {
                        int n4 = Integer.parseInt(string4.substring("maxerrors=".length()));
                        this._engine.setMaxErrorsToReport(n4);
                        continue;
                    }
                    if (string4.equals("darkmatter")) {
                        n3 |= 0x8000;
                        continue;
                    }
                    if ((J9BuildFlags.gc_modronScavenger || J9BuildFlags.gc_vlhgc) && string4.equals("midscavenge")) {
                        n3 |= 0x10000;
                        continue;
                    }
                    if (string4.equals("abort")) {
                        n3 |= 0x1000;
                        continue;
                    }
                    if (string4.equals("noabort")) {
                        n3 &= 0xFFFFEFFF;
                        continue;
                    }
                    if (string4.equals("dumpstack")) {
                        n3 |= 0x4000;
                        continue;
                    }
                    if (string4.equals("nodumpstack")) {
                        n3 &= 0xFFFFBFFF;
                        continue;
                    }
                    if (string4.startsWith("interval=")) {
                        n3 |= 2;
                        continue;
                    }
                    if (J9BuildFlags.gc_modronScavenger && string4.startsWith("localinterval=")) {
                        n3 |= 8;
                        continue;
                    }
                    if (string4.startsWith("globalinterval=")) {
                        n3 |= 4;
                        continue;
                    }
                    if (string4.startsWith("startindex=")) {
                        n3 |= 0x10;
                        continue;
                    }
                    if (J9BuildFlags.gc_modronScavenger) {
                        if (string4.equals("scavengerbackout")) {
                            n3 |= 0x20;
                            continue;
                        }
                        if (string4.equals("suppresslocal")) {
                            n3 |= 0x40;
                            continue;
                        }
                    }
                    if (string4.equals("suppressglobal")) {
                        n3 |= 0x80;
                        continue;
                    }
                    if (J9BuildFlags.gc_generational && string4.equals("rememberedsetoverflow")) {
                        n3 |= 0x100;
                        continue;
                    }
                    if (string4.equals("ownablesynchronizerconsistency")) {
                        n3 |= 0x20000;
                        continue;
                    }
                    this._printHelp = true;
                    this._engine.getReporter().println("GC Check: unrecognized option '" + string4 + "'");
                }
            }
        }
        for (n = 0; n < checkNames.length; ++n) {
            if (!((Boolean)hashMap.get(checkNames[n])).booleanValue()) continue;
            try {
                Check check = checkClasses[n].newInstance();
                check.initialize(this._engine);
                arrayList2.add(check);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                continue;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
        }
        this._checks = arrayList2.toArray(new Check[arrayList2.size()]);
        this._checkFlags = n2;
        this._miscFlags = n3;
        if (((Boolean)hashMap.get("objectheap")).booleanValue()) {
            this._engine.initializeOwnableSynchronizerCountOnHeap();
        }
        if (((Boolean)hashMap.get("ownablesynchronizer")).booleanValue()) {
            this._engine.initializeOwnableSynchronizerCountOnList();
        }
    }

    public void run() throws CorruptDataException {
        if (this._printHelp) {
            this.printHelp();
        } else {
            this._engine.startCheckCycle(this);
            for (int i = 0; i < this._checks.length; ++i) {
                boolean bl = 1024 == (this._miscFlags & 0x400);
                boolean bl2 = 512 == (this._miscFlags & 0x200);
                this._checks[i].run(bl, bl2);
            }
            this._engine.endCheckCycle();
        }
    }

    public int nextErrorCount() {
        return ++this._errorCount;
    }

    public int getCheckFlags() {
        return this._checkFlags;
    }

    public int getMiscFlags() {
        return this._miscFlags;
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Class<CheckVMThreadStacks>> arrayList2 = new ArrayList<Class<CheckVMThreadStacks>>();
        arrayList.add("objectheap");
        arrayList2.add(CheckObjectHeap.class);
        arrayList.add("classheap");
        arrayList2.add(CheckClassHeap.class);
        if (J9BuildFlags.gc_generational) {
            arrayList.add("rememberedset");
            arrayList2.add(CheckRememberedSet.class);
        }
        if (J9BuildFlags.gc_finalization) {
            arrayList.add("unfinalized");
            arrayList2.add(CheckUnfinalizedList.class);
            arrayList.add("finalizable");
            arrayList2.add(CheckFinalizableList.class);
        }
        arrayList.add("ownablesynchronizer");
        arrayList2.add(CheckOwnableSynchronizerList.class);
        arrayList.add("stringtable");
        arrayList2.add(CheckStringTable.class);
        arrayList.add("classloaders");
        arrayList2.add(CheckClassLoaders.class);
        arrayList.add("jniglobalrefs");
        arrayList2.add(CheckJNIGlobalReferences.class);
        arrayList.add("jniweakglobalrefs");
        arrayList2.add(CheckJNIWeakGlobalReferences.class);
        if (J9BuildFlags.opt_jvmti) {
            arrayList.add("jvmtiobjecttagtables");
            arrayList2.add(CheckJVMTIObjectTagTables.class);
        }
        arrayList.add("vmclassslots");
        arrayList2.add(CheckVMClassSlots.class);
        arrayList.add("monitortable");
        arrayList2.add(CheckMonitorTable.class);
        arrayList.add("vmthreads");
        arrayList2.add(CheckVMThreads.class);
        arrayList.add("threadstacks");
        arrayList2.add(CheckVMThreadStacks.class);
        checkNames = arrayList.toArray(new String[arrayList.size()]);
        checkClasses = arrayList2.toArray(new Class[arrayList2.size()]);
    }
}

