/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.StackMap;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class StackmapCommand
extends Command {
    static final int MAX_STACKSLOTS_COUNT = 65536;
    static final int INT_SIZE_IN_BITS = 32;

    public StackmapCommand() {
        this.addCommand("stackmap", "<pc>", "calculate the stack slot map for the specified PC");
    }

    private void printUsage(PrintStream printStream) {
        printStream.println("stackmap <pc> - calculate the stack slot map for the specified PC");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length != 1) {
            this.printUsage(printStream);
            return;
        }
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (null == j9JavaVMPointer) {
                printStream.println("vm can not be found.");
            }
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.env_data64);
            U8Pointer u8Pointer = U8Pointer.cast(l);
            CommandUtils.dbgPrint(printStream, "Searching for PC=%d in VM=%s...\n", u8Pointer.longValue(), j9JavaVMPointer.getHexAddress());
            J9MethodPointer j9MethodPointer = J9JavaVMHelper.getMethodFromPC(j9JavaVMPointer, u8Pointer);
            if (j9MethodPointer.notNull()) {
                long l2;
                int[] nArray = new int[2048];
                int n = Integer.MIN_VALUE;
                CommandUtils.dbgPrint(printStream, "Found method %s !j9method %s\n", J9MethodHelper.getName(j9MethodPointer), j9MethodPointer.getHexAddress());
                UDATA uDATA = new UDATA(u8Pointer.sub(U8Pointer.cast(j9MethodPointer.bytecodes())));
                CommandUtils.dbgPrint(printStream, "Relative PC = %d\n", uDATA.longValue());
                J9ClassPointer j9ClassPointer = this.J9_CLASS_FROM_CP(j9MethodPointer.constantPool());
                CommandUtils.dbgPrint(printStream, "Method index is %d\n", l2);
                J9ROMMethodPointer j9ROMMethodPointer = this.J9ROMCLASS_ROMMETHODS(j9ClassPointer.romClass());
                for (l2 = new UDATA(j9MethodPointer.sub(j9ClassPointer.ramMethods())).longValue(); l2 != 0L; --l2) {
                    j9ROMMethodPointer = ROMHelp.nextROMMethod(j9ROMMethodPointer);
                }
                CommandUtils.dbgPrint(printStream, "Using ROM method %s\n", j9ROMMethodPointer.getHexAddress());
                int n2 = StackMap.j9stackmap_StackBitsForPC(uDATA, j9ClassPointer.romClass(), j9ROMMethodPointer, null, 0);
                if (0 > n2) {
                    CommandUtils.dbgPrint(printStream, "Stack map failed, error code = %d\n", n2);
                } else {
                    int n3 = 0;
                    if (0 != n2) {
                        n2 = StackMap.j9stackmap_StackBitsForPC(uDATA, j9ClassPointer.romClass(), j9ROMMethodPointer, nArray, n2);
                        int n4 = nArray[n3];
                        int n5 = 0;
                        CommandUtils.dbgPrint(printStream, "Stack map (%d slots mapped): ", n2);
                        long l3 = n2 % 32;
                        if (l3 != 0L) {
                            n5 = n4 << (int)(32L - l3);
                            ++n4;
                        }
                        while (n2 != 0) {
                            if (l3 == 0L) {
                                n5 = n4;
                                n4 = nArray[++n3];
                                l3 = 32L;
                            }
                            CommandUtils.dbgPrint(printStream, "%d", (n5 & n) != 0 ? 1 : 0);
                            n5 <<= 1;
                            --l3;
                            --n2;
                        }
                        CommandUtils.dbgPrint(printStream, "\n");
                    } else {
                        CommandUtils.dbgPrint(printStream, "Stack is empty\n");
                    }
                }
            } else {
                CommandUtils.dbgPrint(printStream, "Not found\n");
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    private J9ROMMethodPointer J9ROMCLASS_ROMMETHODS(J9ROMClassPointer j9ROMClassPointer) throws CorruptDataException {
        return j9ROMClassPointer.romMethods();
    }

    private J9ClassPointer J9_CLASS_FROM_CP(J9ConstantPoolPointer j9ConstantPoolPointer) throws CorruptDataException {
        return j9ConstantPoolPointer.ramClass();
    }
}

