/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.exceptions.UnknownArchitectureException;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import java.io.PrintStream;

public class VMRegMapHelper {
    public static void printRegisters(J9JavaVMPointer j9JavaVMPointer, int n, PrintStream printStream) throws UnknownArchitectureException {
        IProcess iProcess = j9JavaVMPointer.getProcess();
        ICore iCore = iProcess.getAddressSpace().getCore();
        Platform platform = iCore.getPlatform();
        boolean bl = iProcess.bytesPerPointer() == 8;
        switch (platform) {
            case AIX: {
                if (bl) {
                    VMRegMapHelper.printRegistersForAIX64BitPPC(n, printStream);
                    break;
                }
                VMRegMapHelper.printRegistersForAIX32BitPPC(n, printStream);
                break;
            }
            case LINUX: {
                String string = iCore.getProperties().getProperty("cpu.type");
                if (bl) {
                    if (string.equals("amd64")) {
                        VMRegMapHelper.printRegistersForLinux64BitAMD64(n, printStream);
                        break;
                    }
                    if (string.equals("ppc")) {
                        VMRegMapHelper.printRegistersForLinux64BitPPC(n, printStream);
                        break;
                    }
                    if (!string.equals("s390")) break;
                    VMRegMapHelper.printRegistersForLinux64BitS390(n, printStream);
                    break;
                }
                if (string.equals("x86")) {
                    VMRegMapHelper.printRegistersForLinux32BitX86(n, printStream);
                    break;
                }
                if (string.equals("ppc")) {
                    VMRegMapHelper.printRegistersForLinux32BitPPC(n, printStream);
                    break;
                }
                if (!string.equals("s390")) break;
                VMRegMapHelper.printRegistersForLinux32BitS390(n, printStream);
                break;
            }
            case OSX: {
                VMRegMapHelper.printRegistersForLinux64BitAMD64(n, printStream);
                break;
            }
            case WINDOWS: {
                if (bl) {
                    VMRegMapHelper.printRegistersForWindows64Bit(n, printStream);
                    break;
                }
                VMRegMapHelper.printRegistersForWindows32Bit(n, printStream);
                break;
            }
            case ZOS: {
                if (bl) {
                    VMRegMapHelper.printRegistersForZOS64BitS390(n, printStream);
                    break;
                }
                VMRegMapHelper.printRegistersForZOS32BitS390(n, printStream);
                break;
            }
            default: {
                throw new UnknownArchitectureException(iProcess, "Could not determine platform of core file.");
            }
        }
    }

    private static void printRegistersForAIX64BitPPC(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r15"));
            printStream.println(String.format("%16s --> %s", "sp", "r14"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r21"));
            printStream.println(String.format("%16s --> %s", "pc", "r16"));
            printStream.println(String.format("%16s --> %s", "literals", "r17"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r18"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r19"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r20"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r19"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r21"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r21"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r20"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r21"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r19"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r10"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r20"));
            printStream.println(String.format("%16s --> %s", "saved_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r19"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r20"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r21"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r6"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "64BitReservedThrds", "r13"));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r5"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r6"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r7"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r8"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r9"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r10"));
            printStream.println(String.format("%16s --> %s", "CR", "CR"));
            printStream.println(String.format("%16s --> %s", "CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "destEA", "r28"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "inParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "inParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "inParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "inParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "inParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "LR", "LR"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r1"));
            printStream.println(String.format("%16s --> %s", "oldSP", "r30"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "outParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "outParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "outParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "outParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "outParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r4"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r4"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r3"));
            printStream.println(String.format("%16s --> %s", "sourceEA", "r31"));
            printStream.println(String.format("%16s --> %s", "stringCopy5", "r5"));
            printStream.println(String.format("%16s --> %s", "stringCopy6", "r6"));
            printStream.println(String.format("%16s --> %s", "stringCopy7", "r7"));
            printStream.println(String.format("%16s --> %s", "stringCopy8", "r8"));
            printStream.println(String.format("%16s --> %s", "stringCopyCount", "r9"));
            printStream.println(String.format("%16s --> %s", "stringCopyDest", "r3"));
            printStream.println(String.format("%16s --> %s", "stringCopySource", "r4"));
            printStream.println(String.format("%16s --> %s", "tempEA", "r27"));
            printStream.println(String.format("%16s --> %s", "TOC", "r2"));
            printStream.println(String.format("%16s --> %s", "XER", "XER"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_CR", "CR"));
            printStream.println(String.format("%16s --> %s", "_CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp16", "fp16"));
            printStream.println(String.format("%16s --> %s", "_fp17", "fp17"));
            printStream.println(String.format("%16s --> %s", "_fp18", "fp18"));
            printStream.println(String.format("%16s --> %s", "_fp19", "fp19"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp20", "fp20"));
            printStream.println(String.format("%16s --> %s", "_fp21", "fp21"));
            printStream.println(String.format("%16s --> %s", "_fp22", "fp22"));
            printStream.println(String.format("%16s --> %s", "_fp23", "fp23"));
            printStream.println(String.format("%16s --> %s", "_fp24", "fp24"));
            printStream.println(String.format("%16s --> %s", "_fp25", "fp25"));
            printStream.println(String.format("%16s --> %s", "_fp26", "fp26"));
            printStream.println(String.format("%16s --> %s", "_fp27", "fp27"));
            printStream.println(String.format("%16s --> %s", "_fp28", "fp28"));
            printStream.println(String.format("%16s --> %s", "_fp29", "fp29"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp30", "fp30"));
            printStream.println(String.format("%16s --> %s", "_fp31", "fp31"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_LR", "LR"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "_XER", "XER"));
            printStream.println(String.format("%16s --> %s", "jit_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "jit_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "jit_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "jit_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "jit_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "jit_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "jit_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "jit_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "jit_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "jit_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "jit_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "jit_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "jit_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "jit_fpr31", "fp31"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_lr", "LR"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "jit_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "jit_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "jit_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "jit_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "jit_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "jit_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "jit_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "jit_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "jit_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "jit_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "jit_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "jit_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "jit_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "jit_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "jit_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "saved_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "saved_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "saved_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "saved_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "saved_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "saved_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "saved_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "saved_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "saved_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "saved_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "saved_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "saved_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "saved_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "saved_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "saved_fpr31", "fp31"));
        }
    }

    private static void printRegistersForAIX32BitPPC(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r13"));
            printStream.println(String.format("%16s --> %s", "sp", "r14"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r21"));
            printStream.println(String.format("%16s --> %s", "pc", "r16"));
            printStream.println(String.format("%16s --> %s", "literals", "r17"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r18"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r19"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r20"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r19"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r21"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r21"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r20"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r21"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r19"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r10"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r20"));
            printStream.println(String.format("%16s --> %s", "saved_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r19"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r20"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r21"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r6"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r5"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r6"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r7"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r8"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r9"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r10"));
            printStream.println(String.format("%16s --> %s", "CR", "CR"));
            printStream.println(String.format("%16s --> %s", "CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "destEA", "r28"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "inParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "inParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "inParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "inParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "inParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "LR", "LR"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r1"));
            printStream.println(String.format("%16s --> %s", "oldSP", "r30"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "outParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "outParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "outParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "outParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "outParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r4"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r4"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r3"));
            printStream.println(String.format("%16s --> %s", "sourceEA", "r31"));
            printStream.println(String.format("%16s --> %s", "stringCopy5", "r5"));
            printStream.println(String.format("%16s --> %s", "stringCopy6", "r6"));
            printStream.println(String.format("%16s --> %s", "stringCopy7", "r7"));
            printStream.println(String.format("%16s --> %s", "stringCopy8", "r8"));
            printStream.println(String.format("%16s --> %s", "stringCopyCount", "r9"));
            printStream.println(String.format("%16s --> %s", "stringCopyDest", "r3"));
            printStream.println(String.format("%16s --> %s", "stringCopySource", "r4"));
            printStream.println(String.format("%16s --> %s", "tempEA", "r27"));
            printStream.println(String.format("%16s --> %s", "TOC", "r2"));
            printStream.println(String.format("%16s --> %s", "XER", "XER"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_CR", "CR"));
            printStream.println(String.format("%16s --> %s", "_CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp16", "fp16"));
            printStream.println(String.format("%16s --> %s", "_fp17", "fp17"));
            printStream.println(String.format("%16s --> %s", "_fp18", "fp18"));
            printStream.println(String.format("%16s --> %s", "_fp19", "fp19"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp20", "fp20"));
            printStream.println(String.format("%16s --> %s", "_fp21", "fp21"));
            printStream.println(String.format("%16s --> %s", "_fp22", "fp22"));
            printStream.println(String.format("%16s --> %s", "_fp23", "fp23"));
            printStream.println(String.format("%16s --> %s", "_fp24", "fp24"));
            printStream.println(String.format("%16s --> %s", "_fp25", "fp25"));
            printStream.println(String.format("%16s --> %s", "_fp26", "fp26"));
            printStream.println(String.format("%16s --> %s", "_fp27", "fp27"));
            printStream.println(String.format("%16s --> %s", "_fp28", "fp28"));
            printStream.println(String.format("%16s --> %s", "_fp29", "fp29"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp30", "fp30"));
            printStream.println(String.format("%16s --> %s", "_fp31", "fp31"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_LR", "LR"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "_XER", "XER"));
            printStream.println(String.format("%16s --> %s", "jit_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "jit_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "jit_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "jit_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "jit_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "jit_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "jit_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "jit_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "jit_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "jit_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "jit_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "jit_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "jit_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "jit_fpr31", "fp31"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_lr", "LR"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "jit_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "jit_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "jit_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "jit_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "jit_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "jit_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "jit_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "jit_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "jit_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "jit_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "jit_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "jit_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "jit_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "jit_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "jit_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "saved_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "saved_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "saved_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "saved_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "saved_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "saved_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "saved_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "saved_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "saved_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "saved_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "saved_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "saved_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "saved_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "saved_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "saved_fpr31", "fp31"));
        }
    }

    private static void printRegistersForLinux64BitAMD64(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "%rbp"));
            printStream.println(String.format("%16s --> %s", "sp", "%rsp"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "%rcx"));
            printStream.println(String.format("%16s --> %s", "pc", "%rsi"));
            printStream.println(String.format("%16s --> %s", "literals", "%rbx"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "allButLowByteZero", "%rax"));
            printStream.println(String.format("%16s --> %s", "bytecodes", "%r14"));
            printStream.println(String.format("%16s --> %s", "cacheIndex", "%rcx"));
            printStream.println(String.format("%16s --> %s", "callInAddress", "%rsi"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "%rdi"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "%rax"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "%rdi"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "%rcx"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "%rcx"));
            printStream.println(String.format("%16s --> %s", "moduleName", "%rdi"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "%rax"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "%rdi"));
            printStream.println(String.format("%16s --> %s", "resolveType", "%rcx"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "%rdi"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "%rdi"));
            printStream.println(String.format("%16s --> %s", "returnSP", "%rax"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "%rdi"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "%rax"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "%rcx"));
            printStream.println(String.format("%16s --> %s", "signalHandlerNewSP", "%rax"));
            printStream.println(String.format("%16s --> %s", "signalHandlerOldSP", "%r12"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm1", "%rdi"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm2", "%rsi"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm3", "%rdx"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm4", "%rcx"));
            printStream.println(String.format("%16s --> %s", "syncObject", "%rcx"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "%", "%rip"));
            printStream.println(String.format("%16s --> %s", "%eax", "%rax"));
            printStream.println(String.format("%16s --> %s", "%ebp", "%rbp"));
            printStream.println(String.format("%16s --> %s", "%ebx", "%rbx"));
            printStream.println(String.format("%16s --> %s", "%ecx", "%rcx"));
            printStream.println(String.format("%16s --> %s", "%edi", "%rdi"));
            printStream.println(String.format("%16s --> %s", "%edx", "%rdx"));
            printStream.println(String.format("%16s --> %s", "%esi", "%rsi"));
            printStream.println(String.format("%16s --> %s", "%esp", "%rsp"));
            printStream.println(String.format("%16s --> %s", "%r10d", "%r10"));
            printStream.println(String.format("%16s --> %s", "%r11d", "%r11"));
            printStream.println(String.format("%16s --> %s", "%r12d", "%r12"));
            printStream.println(String.format("%16s --> %s", "%r13d", "%r13"));
            printStream.println(String.format("%16s --> %s", "%r14d", "%r14"));
            printStream.println(String.format("%16s --> %s", "%r15d", "%r15"));
            printStream.println(String.format("%16s --> %s", "%r8d", "%r8"));
            printStream.println(String.format("%16s --> %s", "%r9d", "%r9"));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "%rax"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "%rcx"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "%rbx"));
            printStream.println(String.format("%16s --> %s", "asmData1", "%rdx"));
            printStream.println(String.format("%16s --> %s", "asmData2", "%rsi"));
            printStream.println(String.format("%16s --> %s", "asmData3", "%rdi"));
            printStream.println(String.format("%16s --> %s", "cmpxchgValue", "%rax"));
            printStream.println(String.format("%16s --> %s", "divideQuotient", "%rax"));
            printStream.println(String.format("%16s --> %s", "divideRemainder", "%rdx"));
            printStream.println(String.format("%16s --> %s", "floatStatusWord", "%rax"));
            printStream.println(String.format("%16s --> %s", "fpParmCount", "%rax"));
            printStream.println(String.format("%16s --> %s", "inParm1", "%rdi"));
            printStream.println(String.format("%16s --> %s", "inParm2", "%rsi"));
            printStream.println(String.format("%16s --> %s", "inParm3", "%rdx"));
            printStream.println(String.format("%16s --> %s", "inParm4", "%rcx"));
            printStream.println(String.format("%16s --> %s", "inParm5", "%r8"));
            printStream.println(String.format("%16s --> %s", "inParm6", "%r9"));
            printStream.println(String.format("%16s --> %s", "instructionPointer", "%rip"));
            printStream.println(String.format("%16s --> %s", "machineBP", "%rbp"));
            printStream.println(String.format("%16s --> %s", "machineSP", "%rsp"));
            printStream.println(String.format("%16s --> %s", "memCount", "%rcx"));
            printStream.println(String.format("%16s --> %s", "memDest", "%rdi"));
            printStream.println(String.format("%16s --> %s", "memSource", "%rsi"));
            printStream.println(String.format("%16s --> %s", "memValue", "%rax"));
            printStream.println(String.format("%16s --> %s", "outParm1", "%rdi"));
            printStream.println(String.format("%16s --> %s", "outParm2", "%rsi"));
            printStream.println(String.format("%16s --> %s", "outParm3", "%rdx"));
            printStream.println(String.format("%16s --> %s", "outParm4", "%rcx"));
            printStream.println(String.format("%16s --> %s", "outParm5", "%r8"));
            printStream.println(String.format("%16s --> %s", "outParm6", "%r9"));
            printStream.println(String.format("%16s --> %s", "rdtscHi", "%rdx"));
            printStream.println(String.format("%16s --> %s", "rdtscLo", "%rax"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "%rdx"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "%rdx"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "%rax"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "%rax"));
            printStream.println(String.format("%16s --> %s", "returnValue", "%rax"));
            printStream.println(String.format("%16s --> %s", "shiftSource", "%rcx"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_", "%xmm15"));
            printStream.println(String.format("%16s --> %s", "_%r10", "%r10"));
            printStream.println(String.format("%16s --> %s", "_%r11", "%r11"));
            printStream.println(String.format("%16s --> %s", "_%r12", "%r12"));
            printStream.println(String.format("%16s --> %s", "_%r13", "%r13"));
            printStream.println(String.format("%16s --> %s", "_%r14", "%r14"));
            printStream.println(String.format("%16s --> %s", "_%r15", "%r15"));
            printStream.println(String.format("%16s --> %s", "_%r8", "%r8"));
            printStream.println(String.format("%16s --> %s", "_%r9", "%r9"));
            printStream.println(String.format("%16s --> %s", "_%rax", "%rax"));
            printStream.println(String.format("%16s --> %s", "_%rbp", "%rbp"));
            printStream.println(String.format("%16s --> %s", "_%rbx", "%rbx"));
            printStream.println(String.format("%16s --> %s", "_%rcx", "%rcx"));
            printStream.println(String.format("%16s --> %s", "_%rdi", "%rdi"));
            printStream.println(String.format("%16s --> %s", "_%rdx", "%rdx"));
            printStream.println(String.format("%16s --> %s", "_%rip", "%rip"));
            printStream.println(String.format("%16s --> %s", "_%rsi", "%rsi"));
            printStream.println(String.format("%16s --> %s", "_%rsp", "%rsp"));
            printStream.println(String.format("%16s --> %s", "_%xmm0", "%xmm0"));
            printStream.println(String.format("%16s --> %s", "_%xmm1", "%xmm1"));
            printStream.println(String.format("%16s --> %s", "_%xmm10", "%xmm10"));
            printStream.println(String.format("%16s --> %s", "_%xmm11", "%xmm11"));
            printStream.println(String.format("%16s --> %s", "_%xmm12", "%xmm12"));
            printStream.println(String.format("%16s --> %s", "_%xmm13", "%xmm13"));
            printStream.println(String.format("%16s --> %s", "_%xmm14", "%xmm14"));
            printStream.println(String.format("%16s --> %s", "_%xmm15", "%xmm15"));
            printStream.println(String.format("%16s --> %s", "_%xmm2", "%xmm2"));
            printStream.println(String.format("%16s --> %s", "_%xmm3", "%xmm3"));
            printStream.println(String.format("%16s --> %s", "_%xmm4", "%xmm4"));
            printStream.println(String.format("%16s --> %s", "_%xmm5", "%xmm5"));
            printStream.println(String.format("%16s --> %s", "_%xmm6", "%xmm6"));
            printStream.println(String.format("%16s --> %s", "_%xmm7", "%xmm7"));
            printStream.println(String.format("%16s --> %s", "_%xmm8", "%xmm8"));
            printStream.println(String.format("%16s --> %s", "_%xmm9", "%xmm9"));
            printStream.println(String.format("%16s --> %s", "_EAX", "%rax"));
            printStream.println(String.format("%16s --> %s", "_EBP", "%rbp"));
            printStream.println(String.format("%16s --> %s", "_EBX", "%rbx"));
            printStream.println(String.format("%16s --> %s", "_ECX", "%rcx"));
            printStream.println(String.format("%16s --> %s", "_EDI", "%rdi"));
            printStream.println(String.format("%16s --> %s", "_EDX", "%rdx"));
            printStream.println(String.format("%16s --> %s", "_ESI", "%rsi"));
            printStream.println(String.format("%16s --> %s", "_ESP", "%rsp"));
            printStream.println(String.format("%16s --> %s", "_R10", "%r10"));
            printStream.println(String.format("%16s --> %s", "_R10D", "%r10"));
            printStream.println(String.format("%16s --> %s", "_R11", "%r11"));
            printStream.println(String.format("%16s --> %s", "_R11D", "%r11"));
            printStream.println(String.format("%16s --> %s", "_R12", "%r12"));
            printStream.println(String.format("%16s --> %s", "_R12D", "%r12"));
            printStream.println(String.format("%16s --> %s", "_R13", "%r13"));
            printStream.println(String.format("%16s --> %s", "_R13D", "%r13"));
            printStream.println(String.format("%16s --> %s", "_R14", "%r14"));
            printStream.println(String.format("%16s --> %s", "_R14D", "%r14"));
            printStream.println(String.format("%16s --> %s", "_R15", "%r15"));
            printStream.println(String.format("%16s --> %s", "_R15D", "%r15"));
            printStream.println(String.format("%16s --> %s", "_R8", "%r8"));
            printStream.println(String.format("%16s --> %s", "_R8D", "%r8"));
            printStream.println(String.format("%16s --> %s", "_R9", "%r9"));
            printStream.println(String.format("%16s --> %s", "_R9D", "%r9"));
            printStream.println(String.format("%16s --> %s", "_RAX", "%rax"));
            printStream.println(String.format("%16s --> %s", "_RBP", "%rbp"));
            printStream.println(String.format("%16s --> %s", "_RBX", "%rbx"));
            printStream.println(String.format("%16s --> %s", "_RCX", "%rcx"));
            printStream.println(String.format("%16s --> %s", "_RDI", "%rdi"));
            printStream.println(String.format("%16s --> %s", "_RDX", "%rdx"));
            printStream.println(String.format("%16s --> %s", "_RIP", "%rip"));
            printStream.println(String.format("%16s --> %s", "_RSI", "%rsi"));
            printStream.println(String.format("%16s --> %s", "_RSP", "%rsp"));
            printStream.println(String.format("%16s --> %s", "_xmm0", "%xmm0"));
            printStream.println(String.format("%16s --> %s", "_xmm1", "%xmm1"));
            printStream.println(String.format("%16s --> %s", "_xmm10", "%xmm10"));
            printStream.println(String.format("%16s --> %s", "_xmm11", "%xmm11"));
            printStream.println(String.format("%16s --> %s", "_xmm12", "%xmm12"));
            printStream.println(String.format("%16s --> %s", "_xmm13", "%xmm13"));
            printStream.println(String.format("%16s --> %s", "_xmm14", "%xmm14"));
            printStream.println(String.format("%16s --> %s", "_xmm15", "%xmm15"));
            printStream.println(String.format("%16s --> %s", "_xmm2", "%xmm2"));
            printStream.println(String.format("%16s --> %s", "_xmm3", "%xmm3"));
            printStream.println(String.format("%16s --> %s", "_xmm4", "%xmm4"));
            printStream.println(String.format("%16s --> %s", "_xmm5", "%xmm5"));
            printStream.println(String.format("%16s --> %s", "_xmm6", "%xmm6"));
            printStream.println(String.format("%16s --> %s", "_xmm7", "%xmm7"));
            printStream.println(String.format("%16s --> %s", "_xmm8", "%xmm8"));
            printStream.println(String.format("%16s --> %s", "_xmm9", "%xmm9"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "%xmm0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "%xmm1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "%xmm10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "%xmm11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "%xmm12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "%xmm13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "%xmm14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "%xmm15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "%xmm2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "%xmm3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "%xmm4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "%xmm5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "%xmm6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "%xmm7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "%xmm8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "%xmm9"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "%r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "%r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "%r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "%r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "%r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "%r15"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "%r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "%r9"));
            printStream.println(String.format("%16s --> %s", "jit_rax", "%rax"));
            printStream.println(String.format("%16s --> %s", "jit_rbx", "%rbx"));
            printStream.println(String.format("%16s --> %s", "jit_rcx", "%rcx"));
            printStream.println(String.format("%16s --> %s", "jit_rdi", "%rdi"));
            printStream.println(String.format("%16s --> %s", "jit_rdx", "%rdx"));
            printStream.println(String.format("%16s --> %s", "jit_rsi", "%rsi"));
        }
    }

    private static void printRegistersForLinux64BitPPC(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r15"));
            printStream.println(String.format("%16s --> %s", "sp", "r14"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r21"));
            printStream.println(String.format("%16s --> %s", "pc", "r16"));
            printStream.println(String.format("%16s --> %s", "literals", "r17"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r18"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r19"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r20"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r19"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r21"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r21"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r20"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r21"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r19"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r10"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r20"));
            printStream.println(String.format("%16s --> %s", "saved_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r19"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r20"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r21"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r6"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "64BitReservedThrds", "r13"));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r5"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r6"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r7"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r8"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r9"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r10"));
            printStream.println(String.format("%16s --> %s", "CR", "CR"));
            printStream.println(String.format("%16s --> %s", "CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "destEA", "r28"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "inParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "inParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "inParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "inParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "inParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "LR", "LR"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r1"));
            printStream.println(String.format("%16s --> %s", "oldSP", "r30"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "outParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "outParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "outParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "outParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "outParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r4"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r4"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r3"));
            printStream.println(String.format("%16s --> %s", "sourceEA", "r31"));
            printStream.println(String.format("%16s --> %s", "stringCopy5", "r5"));
            printStream.println(String.format("%16s --> %s", "stringCopy6", "r6"));
            printStream.println(String.format("%16s --> %s", "stringCopy7", "r7"));
            printStream.println(String.format("%16s --> %s", "stringCopy8", "r8"));
            printStream.println(String.format("%16s --> %s", "stringCopyCount", "r9"));
            printStream.println(String.format("%16s --> %s", "stringCopyDest", "r3"));
            printStream.println(String.format("%16s --> %s", "stringCopySource", "r4"));
            printStream.println(String.format("%16s --> %s", "tempEA", "r27"));
            printStream.println(String.format("%16s --> %s", "TOC", "r2"));
            printStream.println(String.format("%16s --> %s", "XER", "XER"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_CR", "CR"));
            printStream.println(String.format("%16s --> %s", "_CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp16", "fp16"));
            printStream.println(String.format("%16s --> %s", "_fp17", "fp17"));
            printStream.println(String.format("%16s --> %s", "_fp18", "fp18"));
            printStream.println(String.format("%16s --> %s", "_fp19", "fp19"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp20", "fp20"));
            printStream.println(String.format("%16s --> %s", "_fp21", "fp21"));
            printStream.println(String.format("%16s --> %s", "_fp22", "fp22"));
            printStream.println(String.format("%16s --> %s", "_fp23", "fp23"));
            printStream.println(String.format("%16s --> %s", "_fp24", "fp24"));
            printStream.println(String.format("%16s --> %s", "_fp25", "fp25"));
            printStream.println(String.format("%16s --> %s", "_fp26", "fp26"));
            printStream.println(String.format("%16s --> %s", "_fp27", "fp27"));
            printStream.println(String.format("%16s --> %s", "_fp28", "fp28"));
            printStream.println(String.format("%16s --> %s", "_fp29", "fp29"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp30", "fp30"));
            printStream.println(String.format("%16s --> %s", "_fp31", "fp31"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_LR", "LR"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "_XER", "XER"));
            printStream.println(String.format("%16s --> %s", "jit_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "jit_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "jit_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "jit_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "jit_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "jit_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "jit_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "jit_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "jit_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "jit_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "jit_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "jit_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "jit_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "jit_fpr31", "fp31"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_lr", "LR"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "jit_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "jit_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "jit_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "jit_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "jit_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "jit_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "jit_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "jit_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "jit_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "jit_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "jit_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "jit_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "jit_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "jit_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "jit_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "saved_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "saved_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "saved_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "saved_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "saved_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "saved_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "saved_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "saved_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "saved_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "saved_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "saved_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "saved_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "saved_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "saved_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "saved_fpr31", "fp31"));
        }
    }

    private static void printRegistersForLinux64BitS390(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r13"));
            printStream.println(String.format("%16s --> %s", "sp", "r5"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r10"));
            printStream.println(String.format("%16s --> %s", "pc", "r8"));
            printStream.println(String.format("%16s --> %s", "literals", "r9"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r7"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r4"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r11"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r4"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r10"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r10"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r4"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r11"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r4"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r10"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r4"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r7"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r11"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r4"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r11"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r10"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r3"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r2"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r3"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r4"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r5"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r6"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r7"));
            printStream.println(String.format("%16s --> %s", "cmpSlot0", "r0"));
            printStream.println(String.format("%16s --> %s", "cmpSlot1", "r1"));
            printStream.println(String.format("%16s --> %s", "divMulEven", "r0"));
            printStream.println(String.format("%16s --> %s", "divMulOdd", "r1"));
            printStream.println(String.format("%16s --> %s", "expandedDestEA", "r0"));
            printStream.println(String.format("%16s --> %s", "expandedSourceEA", "r1"));
            printStream.println(String.format("%16s --> %s", "globalOffsetTable", "r12"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r2"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r3"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r4"));
            printStream.println(String.format("%16s --> %s", "inParm4", "r5"));
            printStream.println(String.format("%16s --> %s", "inParm5", "r6"));
            printStream.println(String.format("%16s --> %s", "linkRegister", "r14"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r15"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r2"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r3"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm4", "r5"));
            printStream.println(String.format("%16s --> %s", "outParm5", "r6"));
            printStream.println(String.format("%16s --> %s", "pointerToStackParams", "r7"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r2"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r2"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r2"));
            printStream.println(String.format("%16s --> %s", "swapSlot0", "r2"));
            printStream.println(String.format("%16s --> %s", "swapSlot1", "r3"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "saved_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "saved_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "saved_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "saved_fpr9", "fp9"));
        }
    }

    private static void printRegistersForLinux32BitX86(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "%ebp"));
            printStream.println(String.format("%16s --> %s", "sp", "%esp"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "%ecx"));
            printStream.println(String.format("%16s --> %s", "pc", "%esi"));
            printStream.println(String.format("%16s --> %s", "literals", "%ebx"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "allButLowByteZero", "%eax"));
            printStream.println(String.format("%16s --> %s", "bp", "%edx"));
            printStream.println(String.format("%16s --> %s", "bytecodes", "%edi"));
            printStream.println(String.format("%16s --> %s", "cacheIndex", "%ecx"));
            printStream.println(String.format("%16s --> %s", "callInAddress", "%esi"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "%edi"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "%eax"));
            printStream.println(String.format("%16s --> %s", "globalOffsetTable", "%ebx"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "%edi"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "%ecx"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "%ecx"));
            printStream.println(String.format("%16s --> %s", "moduleName", "%edi"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "%eax"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "%edi"));
            printStream.println(String.format("%16s --> %s", "resolveType", "%ecx"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "%edi"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "%eax"));
            printStream.println(String.format("%16s --> %s", "returnSP", "%eax"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "%edi"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "%eax"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "%ecx"));
            printStream.println(String.format("%16s --> %s", "signalHandlerNewSP", "%edi"));
            printStream.println(String.format("%16s --> %s", "signalHandlerOldSP", "%esi"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm1", "%eax"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm2", "%ebp"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm3", "%ecx"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm4", "%edx"));
            printStream.println(String.format("%16s --> %s", "syncObject", "%ecx"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "%eax"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "%ecx"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "%ebx"));
            printStream.println(String.format("%16s --> %s", "asmData1", "%edx"));
            printStream.println(String.format("%16s --> %s", "asmData2", "%esi"));
            printStream.println(String.format("%16s --> %s", "asmData3", "%edi"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bcmpVal1", "%eax"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bcmpVal2", "%edx"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bdstVal1", "%ebx"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bdstVal2", "%ecx"));
            printStream.println(String.format("%16s --> %s", "cmpxchgValue", "%eax"));
            printStream.println(String.format("%16s --> %s", "divideQuotient", "%eax"));
            printStream.println(String.format("%16s --> %s", "divideRemainder", "%edx"));
            printStream.println(String.format("%16s --> %s", "floatStatusWord", "%eax"));
            printStream.println(String.format("%16s --> %s", "machineBP", "%ebp"));
            printStream.println(String.format("%16s --> %s", "machineSP", "%esp"));
            printStream.println(String.format("%16s --> %s", "memCount", "%ecx"));
            printStream.println(String.format("%16s --> %s", "memDest", "%edi"));
            printStream.println(String.format("%16s --> %s", "memSource", "%esi"));
            printStream.println(String.format("%16s --> %s", "memValue", "%eax"));
            printStream.println(String.format("%16s --> %s", "rdtscHi", "%edx"));
            printStream.println(String.format("%16s --> %s", "rdtscLo", "%eax"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "%edx"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "%edx"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "%eax"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "%eax"));
            printStream.println(String.format("%16s --> %s", "returnValue", "%eax"));
            printStream.println(String.format("%16s --> %s", "shiftSource", "%ecx"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_%eax", "%eax"));
            printStream.println(String.format("%16s --> %s", "_%ebp", "%ebp"));
            printStream.println(String.format("%16s --> %s", "_%ebx", "%ebx"));
            printStream.println(String.format("%16s --> %s", "_%ecx", "%ecx"));
            printStream.println(String.format("%16s --> %s", "_%edi", "%edi"));
            printStream.println(String.format("%16s --> %s", "_%edx", "%edx"));
            printStream.println(String.format("%16s --> %s", "_%esi", "%esi"));
            printStream.println(String.format("%16s --> %s", "_%esp", "%esp"));
            printStream.println(String.format("%16s --> %s", "_%xmm0", "%xmm0"));
            printStream.println(String.format("%16s --> %s", "_%xmm1", "%xmm1"));
            printStream.println(String.format("%16s --> %s", "_%xmm2", "%xmm2"));
            printStream.println(String.format("%16s --> %s", "_%xmm3", "%xmm3"));
            printStream.println(String.format("%16s --> %s", "_%xmm4", "%xmm4"));
            printStream.println(String.format("%16s --> %s", "_%xmm5", "%xmm5"));
            printStream.println(String.format("%16s --> %s", "_%xmm6", "%xmm6"));
            printStream.println(String.format("%16s --> %s", "_%xmm7", "%xmm7"));
            printStream.println(String.format("%16s --> %s", "_EAX", "%eax"));
            printStream.println(String.format("%16s --> %s", "_EBP", "%ebp"));
            printStream.println(String.format("%16s --> %s", "_EBX", "%ebx"));
            printStream.println(String.format("%16s --> %s", "_ECX", "%ecx"));
            printStream.println(String.format("%16s --> %s", "_EDI", "%edi"));
            printStream.println(String.format("%16s --> %s", "_EDX", "%edx"));
            printStream.println(String.format("%16s --> %s", "_ESI", "%esi"));
            printStream.println(String.format("%16s --> %s", "_ESP", "%esp"));
            printStream.println(String.format("%16s --> %s", "_xmm0", "%xmm0"));
            printStream.println(String.format("%16s --> %s", "_xmm1", "%xmm1"));
            printStream.println(String.format("%16s --> %s", "_xmm2", "%xmm2"));
            printStream.println(String.format("%16s --> %s", "_xmm3", "%xmm3"));
            printStream.println(String.format("%16s --> %s", "_xmm4", "%xmm4"));
            printStream.println(String.format("%16s --> %s", "_xmm5", "%xmm5"));
            printStream.println(String.format("%16s --> %s", "_xmm6", "%xmm6"));
            printStream.println(String.format("%16s --> %s", "_xmm7", "%xmm7"));
            printStream.println(String.format("%16s --> %s", "jit_eax", "%eax"));
            printStream.println(String.format("%16s --> %s", "jit_ebx", "%ebx"));
            printStream.println(String.format("%16s --> %s", "jit_ecx", "%ecx"));
            printStream.println(String.format("%16s --> %s", "jit_edi", "%edi"));
            printStream.println(String.format("%16s --> %s", "jit_edx", "%edx"));
            printStream.println(String.format("%16s --> %s", "jit_esi", "%esi"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "%xmm0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "%xmm1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "%xmm2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "%xmm3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "%xmm4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "%xmm5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "%xmm6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "%xmm7"));
        }
    }

    private static void printRegistersForLinux32BitPPC(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r13"));
            printStream.println(String.format("%16s --> %s", "sp", "r14"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r21"));
            printStream.println(String.format("%16s --> %s", "pc", "r16"));
            printStream.println(String.format("%16s --> %s", "literals", "r17"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r18"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r19"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r20"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r19"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r21"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r21"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r20"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r19"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r21"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r19"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r10"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r20"));
            printStream.println(String.format("%16s --> %s", "saved_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r19"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r20"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r21"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r6"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r5"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r6"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r7"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r8"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r9"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r10"));
            printStream.println(String.format("%16s --> %s", "CR", "CR"));
            printStream.println(String.format("%16s --> %s", "CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "destEA", "r28"));
            printStream.println(String.format("%16s --> %s", "globalOffsetTable", "r29"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "inParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "inParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "inParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "inParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "inParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "LR", "LR"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r1"));
            printStream.println(String.format("%16s --> %s", "oldSP", "r30"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r3"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r5"));
            printStream.println(String.format("%16s --> %s", "outParm4", "r6"));
            printStream.println(String.format("%16s --> %s", "outParm5", "r7"));
            printStream.println(String.format("%16s --> %s", "outParm6", "r8"));
            printStream.println(String.format("%16s --> %s", "outParm7", "r9"));
            printStream.println(String.format("%16s --> %s", "outParm8", "r10"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r4"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r4"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r3"));
            printStream.println(String.format("%16s --> %s", "sourceEA", "r31"));
            printStream.println(String.format("%16s --> %s", "stringCopy5", "r5"));
            printStream.println(String.format("%16s --> %s", "stringCopy6", "r6"));
            printStream.println(String.format("%16s --> %s", "stringCopy7", "r7"));
            printStream.println(String.format("%16s --> %s", "stringCopy8", "r8"));
            printStream.println(String.format("%16s --> %s", "stringCopyCount", "r9"));
            printStream.println(String.format("%16s --> %s", "stringCopyDest", "r3"));
            printStream.println(String.format("%16s --> %s", "stringCopySource", "r4"));
            printStream.println(String.format("%16s --> %s", "tempEA", "r27"));
            printStream.println(String.format("%16s --> %s", "XER", "XER"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_CR", "CR"));
            printStream.println(String.format("%16s --> %s", "_CTR", "CTR"));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp16", "fp16"));
            printStream.println(String.format("%16s --> %s", "_fp17", "fp17"));
            printStream.println(String.format("%16s --> %s", "_fp18", "fp18"));
            printStream.println(String.format("%16s --> %s", "_fp19", "fp19"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp20", "fp20"));
            printStream.println(String.format("%16s --> %s", "_fp21", "fp21"));
            printStream.println(String.format("%16s --> %s", "_fp22", "fp22"));
            printStream.println(String.format("%16s --> %s", "_fp23", "fp23"));
            printStream.println(String.format("%16s --> %s", "_fp24", "fp24"));
            printStream.println(String.format("%16s --> %s", "_fp25", "fp25"));
            printStream.println(String.format("%16s --> %s", "_fp26", "fp26"));
            printStream.println(String.format("%16s --> %s", "_fp27", "fp27"));
            printStream.println(String.format("%16s --> %s", "_fp28", "fp28"));
            printStream.println(String.format("%16s --> %s", "_fp29", "fp29"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp30", "fp30"));
            printStream.println(String.format("%16s --> %s", "_fp31", "fp31"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_LR", "LR"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "_XER", "XER"));
            printStream.println(String.format("%16s --> %s", "jit_cr", "CR"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "jit_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "jit_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "jit_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "jit_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "jit_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "jit_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "jit_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "jit_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "jit_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "jit_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "jit_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "jit_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "jit_fpr31", "fp31"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_lr", "LR"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "jit_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "jit_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "jit_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "jit_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "jit_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "jit_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "jit_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "jit_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "jit_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "jit_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "jit_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "jit_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "jit_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "jit_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr16", "fp16"));
            printStream.println(String.format("%16s --> %s", "saved_fpr17", "fp17"));
            printStream.println(String.format("%16s --> %s", "saved_fpr18", "fp18"));
            printStream.println(String.format("%16s --> %s", "saved_fpr19", "fp19"));
            printStream.println(String.format("%16s --> %s", "saved_fpr20", "fp20"));
            printStream.println(String.format("%16s --> %s", "saved_fpr21", "fp21"));
            printStream.println(String.format("%16s --> %s", "saved_fpr22", "fp22"));
            printStream.println(String.format("%16s --> %s", "saved_fpr23", "fp23"));
            printStream.println(String.format("%16s --> %s", "saved_fpr24", "fp24"));
            printStream.println(String.format("%16s --> %s", "saved_fpr25", "fp25"));
            printStream.println(String.format("%16s --> %s", "saved_fpr26", "fp26"));
            printStream.println(String.format("%16s --> %s", "saved_fpr27", "fp27"));
            printStream.println(String.format("%16s --> %s", "saved_fpr28", "fp28"));
            printStream.println(String.format("%16s --> %s", "saved_fpr29", "fp29"));
            printStream.println(String.format("%16s --> %s", "saved_fpr30", "fp30"));
            printStream.println(String.format("%16s --> %s", "saved_fpr31", "fp31"));
        }
    }

    private static void printRegistersForLinux32BitS390(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r13"));
            printStream.println(String.format("%16s --> %s", "sp", "r5"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r10"));
            printStream.println(String.format("%16s --> %s", "pc", "r8"));
            printStream.println(String.format("%16s --> %s", "literals", "r9"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r7"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r4"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r11"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r4"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r10"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r10"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r4"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r11"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r4"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r10"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r4"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r7"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r11"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r4"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r11"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r10"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r3"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r2"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r3"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r4"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r5"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r6"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r7"));
            printStream.println(String.format("%16s --> %s", "cmpSlot0", "r0"));
            printStream.println(String.format("%16s --> %s", "cmpSlot1", "r1"));
            printStream.println(String.format("%16s --> %s", "divMulEven", "r0"));
            printStream.println(String.format("%16s --> %s", "divMulOdd", "r1"));
            printStream.println(String.format("%16s --> %s", "expandedDestEA", "r0"));
            printStream.println(String.format("%16s --> %s", "expandedSourceEA", "r1"));
            printStream.println(String.format("%16s --> %s", "globalOffsetTable", "r12"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r2"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r3"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r4"));
            printStream.println(String.format("%16s --> %s", "inParm4", "r5"));
            printStream.println(String.format("%16s --> %s", "inParm5", "r6"));
            printStream.println(String.format("%16s --> %s", "linkRegister", "r14"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r15"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r2"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r3"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm4", "r5"));
            printStream.println(String.format("%16s --> %s", "outParm5", "r6"));
            printStream.println(String.format("%16s --> %s", "pointerToStackParams", "r7"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r2"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r2"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r2"));
            printStream.println(String.format("%16s --> %s", "swapSlot0", "r2"));
            printStream.println(String.format("%16s --> %s", "swapSlot1", "r3"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "jit_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "jit_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "jit_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "jit_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "jit_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "jit_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "jit_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "jit_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "jit_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "jit_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "jit_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "jit_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "jit_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "jit_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "jit_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "saved_fpr6", "fp6"));
        }
    }

    private static void printRegistersForWindows64Bit(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "RBP"));
            printStream.println(String.format("%16s --> %s", "sp", "RSP"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "RCX"));
            printStream.println(String.format("%16s --> %s", "pc", "RSI"));
            printStream.println(String.format("%16s --> %s", "literals", "RBX"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "allButLowByteZero", "RAX"));
            printStream.println(String.format("%16s --> %s", "bytecodes", "R14"));
            printStream.println(String.format("%16s --> %s", "cacheIndex", "RCX"));
            printStream.println(String.format("%16s --> %s", "callInAddress", "RSI"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "RDI"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "RAX"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "RDI"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "RCX"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "RCX"));
            printStream.println(String.format("%16s --> %s", "moduleName", "RDI"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "RAX"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "RDI"));
            printStream.println(String.format("%16s --> %s", "resolveType", "RCX"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "RDI"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "RDI"));
            printStream.println(String.format("%16s --> %s", "returnSP", "RAX"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "RDI"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "RAX"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "RCX"));
            printStream.println(String.format("%16s --> %s", "signalHandlerNewSP", "RAX"));
            printStream.println(String.format("%16s --> %s", "signalHandlerOldSP", "R12"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm1", "RCX"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm2", "RDX"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm3", "R8"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm4", "R9"));
            printStream.println(String.format("%16s --> %s", "syncObject", "RCX"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "RAX"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "RCX"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "RBX"));
            printStream.println(String.format("%16s --> %s", "asmData1", "RDX"));
            printStream.println(String.format("%16s --> %s", "asmData2", "RSI"));
            printStream.println(String.format("%16s --> %s", "asmData3", "RDI"));
            printStream.println(String.format("%16s --> %s", "cmpxchgValue", "RAX"));
            printStream.println(String.format("%16s --> %s", "divideQuotient", "RAX"));
            printStream.println(String.format("%16s --> %s", "divideRemainder", "RDX"));
            printStream.println(String.format("%16s --> %s", "EAX", "RAX"));
            printStream.println(String.format("%16s --> %s", "EBP", "RBP"));
            printStream.println(String.format("%16s --> %s", "EBX", "RBX"));
            printStream.println(String.format("%16s --> %s", "ECX", "RCX"));
            printStream.println(String.format("%16s --> %s", "EDI", "RDI"));
            printStream.println(String.format("%16s --> %s", "EDX", "RDX"));
            printStream.println(String.format("%16s --> %s", "ESI", "RSI"));
            printStream.println(String.format("%16s --> %s", "ESP", "RSP"));
            printStream.println(String.format("%16s --> %s", "floatStatusWord", "RAX"));
            printStream.println(String.format("%16s --> %s", "fpParmCount", "RAX"));
            printStream.println(String.format("%16s --> %s", "inParm1", "RCX"));
            printStream.println(String.format("%16s --> %s", "inParm2", "RDX"));
            printStream.println(String.format("%16s --> %s", "inParm3", "R8"));
            printStream.println(String.format("%16s --> %s", "inParm4", "R9"));
            printStream.println(String.format("%16s --> %s", "instructionPointer", "RIP"));
            printStream.println(String.format("%16s --> %s", "machineBP", "RBP"));
            printStream.println(String.format("%16s --> %s", "machineSP", "RSP"));
            printStream.println(String.format("%16s --> %s", "memCount", "RCX"));
            printStream.println(String.format("%16s --> %s", "memDest", "RDI"));
            printStream.println(String.format("%16s --> %s", "memSource", "RSI"));
            printStream.println(String.format("%16s --> %s", "memValue", "RAX"));
            printStream.println(String.format("%16s --> %s", "outParm1", "RCX"));
            printStream.println(String.format("%16s --> %s", "outParm2", "RDX"));
            printStream.println(String.format("%16s --> %s", "outParm3", "R8"));
            printStream.println(String.format("%16s --> %s", "outParm4", "R9"));
            printStream.println(String.format("%16s --> %s", "R10D", "R10"));
            printStream.println(String.format("%16s --> %s", "R11D", "R11"));
            printStream.println(String.format("%16s --> %s", "R12D", "R12"));
            printStream.println(String.format("%16s --> %s", "R13D", "R13"));
            printStream.println(String.format("%16s --> %s", "R14D", "R14"));
            printStream.println(String.format("%16s --> %s", "R15D", "R15"));
            printStream.println(String.format("%16s --> %s", "R8D", "R8"));
            printStream.println(String.format("%16s --> %s", "R9D", "R9"));
            printStream.println(String.format("%16s --> %s", "rdtscHi", "RDX"));
            printStream.println(String.format("%16s --> %s", "rdtscLo", "RAX"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "RDX"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "RDX"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "RAX"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "RAX"));
            printStream.println(String.format("%16s --> %s", "returnValue", "RAX"));
            printStream.println(String.format("%16s --> %s", "shiftSource", "RCX"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "", "RIP"));
            printStream.println(String.format("%16s --> %s", "_", "xmm15"));
            printStream.println(String.format("%16s --> %s", "_EAX", "RAX"));
            printStream.println(String.format("%16s --> %s", "_EBP", "RBP"));
            printStream.println(String.format("%16s --> %s", "_EBX", "RBX"));
            printStream.println(String.format("%16s --> %s", "_ECX", "RCX"));
            printStream.println(String.format("%16s --> %s", "_EDI", "RDI"));
            printStream.println(String.format("%16s --> %s", "_EDX", "RDX"));
            printStream.println(String.format("%16s --> %s", "_ESI", "RSI"));
            printStream.println(String.format("%16s --> %s", "_ESP", "RSP"));
            printStream.println(String.format("%16s --> %s", "_R10", "R10"));
            printStream.println(String.format("%16s --> %s", "_R10D", "R10"));
            printStream.println(String.format("%16s --> %s", "_R11", "R11"));
            printStream.println(String.format("%16s --> %s", "_R11D", "R11"));
            printStream.println(String.format("%16s --> %s", "_R12", "R12"));
            printStream.println(String.format("%16s --> %s", "_R12D", "R12"));
            printStream.println(String.format("%16s --> %s", "_R13", "R13"));
            printStream.println(String.format("%16s --> %s", "_R13D", "R13"));
            printStream.println(String.format("%16s --> %s", "_R14", "R14"));
            printStream.println(String.format("%16s --> %s", "_R14D", "R14"));
            printStream.println(String.format("%16s --> %s", "_R15", "R15"));
            printStream.println(String.format("%16s --> %s", "_R15D", "R15"));
            printStream.println(String.format("%16s --> %s", "_R8", "R8"));
            printStream.println(String.format("%16s --> %s", "_R8D", "R8"));
            printStream.println(String.format("%16s --> %s", "_R9", "R9"));
            printStream.println(String.format("%16s --> %s", "_R9D", "R9"));
            printStream.println(String.format("%16s --> %s", "_RAX", "RAX"));
            printStream.println(String.format("%16s --> %s", "_RBP", "RBP"));
            printStream.println(String.format("%16s --> %s", "_RBX", "RBX"));
            printStream.println(String.format("%16s --> %s", "_RCX", "RCX"));
            printStream.println(String.format("%16s --> %s", "_RDI", "RDI"));
            printStream.println(String.format("%16s --> %s", "_RDX", "RDX"));
            printStream.println(String.format("%16s --> %s", "_RIP", "RIP"));
            printStream.println(String.format("%16s --> %s", "_RSI", "RSI"));
            printStream.println(String.format("%16s --> %s", "_RSP", "RSP"));
            printStream.println(String.format("%16s --> %s", "_xmm0", "xmm0"));
            printStream.println(String.format("%16s --> %s", "_xmm1", "xmm1"));
            printStream.println(String.format("%16s --> %s", "_xmm10", "xmm10"));
            printStream.println(String.format("%16s --> %s", "_xmm11", "xmm11"));
            printStream.println(String.format("%16s --> %s", "_xmm12", "xmm12"));
            printStream.println(String.format("%16s --> %s", "_xmm13", "xmm13"));
            printStream.println(String.format("%16s --> %s", "_xmm14", "xmm14"));
            printStream.println(String.format("%16s --> %s", "_xmm15", "xmm15"));
            printStream.println(String.format("%16s --> %s", "_xmm2", "xmm2"));
            printStream.println(String.format("%16s --> %s", "_xmm3", "xmm3"));
            printStream.println(String.format("%16s --> %s", "_xmm4", "xmm4"));
            printStream.println(String.format("%16s --> %s", "_xmm5", "xmm5"));
            printStream.println(String.format("%16s --> %s", "_xmm6", "xmm6"));
            printStream.println(String.format("%16s --> %s", "_xmm7", "xmm7"));
            printStream.println(String.format("%16s --> %s", "_xmm8", "xmm8"));
            printStream.println(String.format("%16s --> %s", "_xmm9", "xmm9"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "xmm0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "xmm1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "xmm10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "xmm11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "xmm12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "xmm13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "xmm14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "xmm15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "xmm2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "xmm3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "xmm4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "xmm5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "xmm6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "xmm7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "xmm8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "xmm9"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "R10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "R11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "R12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "R13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "R14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "R15"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "R8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "R9"));
            printStream.println(String.format("%16s --> %s", "jit_rax", "RAX"));
            printStream.println(String.format("%16s --> %s", "jit_rbx", "RBX"));
            printStream.println(String.format("%16s --> %s", "jit_rcx", "RCX"));
            printStream.println(String.format("%16s --> %s", "jit_rdi", "RDI"));
            printStream.println(String.format("%16s --> %s", "jit_rdx", "RDX"));
            printStream.println(String.format("%16s --> %s", "jit_rsi", "RSI"));
            printStream.println(String.format("%16s --> %s", "saved_fpr10", "xmm10"));
            printStream.println(String.format("%16s --> %s", "saved_fpr11", "xmm11"));
            printStream.println(String.format("%16s --> %s", "saved_fpr12", "xmm12"));
            printStream.println(String.format("%16s --> %s", "saved_fpr13", "xmm13"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "xmm14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "xmm15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr6", "xmm6"));
            printStream.println(String.format("%16s --> %s", "saved_fpr7", "xmm7"));
            printStream.println(String.format("%16s --> %s", "saved_fpr8", "xmm8"));
            printStream.println(String.format("%16s --> %s", "saved_fpr9", "xmm9"));
        }
    }

    private static void printRegistersForWindows32Bit(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "EBP"));
            printStream.println(String.format("%16s --> %s", "sp", "ESP"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "ECX"));
            printStream.println(String.format("%16s --> %s", "pc", "ESI"));
            printStream.println(String.format("%16s --> %s", "literals", "EBX"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "allButLowByteZero", "EAX"));
            printStream.println(String.format("%16s --> %s", "bp", "EDX"));
            printStream.println(String.format("%16s --> %s", "cacheIndex", "ECX"));
            printStream.println(String.format("%16s --> %s", "callInAddress", "ESI"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "EDI"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "EAX"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "EDI"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "ECX"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "ECX"));
            printStream.println(String.format("%16s --> %s", "moduleName", "EDI"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "EAX"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "EDI"));
            printStream.println(String.format("%16s --> %s", "resolveType", "ECX"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "EDI"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "EDI"));
            printStream.println(String.format("%16s --> %s", "returnSP", "EAX"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "EDI"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "EAX"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "ECX"));
            printStream.println(String.format("%16s --> %s", "signalHandlerNewSP", "EDI"));
            printStream.println(String.format("%16s --> %s", "signalHandlerOldSP", "ESI"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm1", "EAX"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm2", "EBP"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm3", "ECX"));
            printStream.println(String.format("%16s --> %s", "signalHandlerParm4", "EDX"));
            printStream.println(String.format("%16s --> %s", "syncObject", "ECX"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "EAX"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "ECX"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "EBX"));
            printStream.println(String.format("%16s --> %s", "asmData1", "EDX"));
            printStream.println(String.format("%16s --> %s", "asmData2", "ESI"));
            printStream.println(String.format("%16s --> %s", "asmData3", "EDI"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bcmpVal1", "EAX"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bcmpVal2", "EDX"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bdstVal1", "EBX"));
            printStream.println(String.format("%16s --> %s", "cmpxchg8bdstVal2", "ECX"));
            printStream.println(String.format("%16s --> %s", "cmpxchgValue", "EAX"));
            printStream.println(String.format("%16s --> %s", "divideQuotient", "EAX"));
            printStream.println(String.format("%16s --> %s", "divideRemainder", "EDX"));
            printStream.println(String.format("%16s --> %s", "floatStatusWord", "EAX"));
            printStream.println(String.format("%16s --> %s", "machineBP", "EBP"));
            printStream.println(String.format("%16s --> %s", "machineSP", "ESP"));
            printStream.println(String.format("%16s --> %s", "memberThis", "ECX"));
            printStream.println(String.format("%16s --> %s", "memCount", "ECX"));
            printStream.println(String.format("%16s --> %s", "memDest", "EDI"));
            printStream.println(String.format("%16s --> %s", "memSource", "ESI"));
            printStream.println(String.format("%16s --> %s", "memValue", "EAX"));
            printStream.println(String.format("%16s --> %s", "pascalParmCount", "EDI"));
            printStream.println(String.format("%16s --> %s", "rdtscHi", "EDX"));
            printStream.println(String.format("%16s --> %s", "rdtscLo", "EAX"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "EDX"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "EDX"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "EAX"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "EAX"));
            printStream.println(String.format("%16s --> %s", "returnValue", "EAX"));
            printStream.println(String.format("%16s --> %s", "shiftSource", "ECX"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_EAX", "EAX"));
            printStream.println(String.format("%16s --> %s", "_EBP", "EBP"));
            printStream.println(String.format("%16s --> %s", "_EBX", "EBX"));
            printStream.println(String.format("%16s --> %s", "_ECX", "ECX"));
            printStream.println(String.format("%16s --> %s", "_EDI", "EDI"));
            printStream.println(String.format("%16s --> %s", "_EDX", "EDX"));
            printStream.println(String.format("%16s --> %s", "_ESI", "ESI"));
            printStream.println(String.format("%16s --> %s", "_ESP", "ESP"));
            printStream.println(String.format("%16s --> %s", "_xmm0", "xmm0"));
            printStream.println(String.format("%16s --> %s", "_xmm1", "xmm1"));
            printStream.println(String.format("%16s --> %s", "_xmm2", "xmm2"));
            printStream.println(String.format("%16s --> %s", "_xmm3", "xmm3"));
            printStream.println(String.format("%16s --> %s", "_xmm4", "xmm4"));
            printStream.println(String.format("%16s --> %s", "_xmm5", "xmm5"));
            printStream.println(String.format("%16s --> %s", "_xmm6", "xmm6"));
            printStream.println(String.format("%16s --> %s", "_xmm7", "xmm7"));
            printStream.println(String.format("%16s --> %s", "jit_eax", "EAX"));
            printStream.println(String.format("%16s --> %s", "jit_ebx", "EBX"));
            printStream.println(String.format("%16s --> %s", "jit_ecx", "ECX"));
            printStream.println(String.format("%16s --> %s", "jit_edi", "EDI"));
            printStream.println(String.format("%16s --> %s", "jit_edx", "EDX"));
            printStream.println(String.format("%16s --> %s", "jit_esi", "ESI"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "xmm0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "xmm1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "xmm2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "xmm3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "xmm4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "xmm5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "xmm6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "xmm7"));
        }
    }

    private static void printRegistersForZOS64BitS390(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r13"));
            printStream.println(String.format("%16s --> %s", "sp", "r5"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r10"));
            printStream.println(String.format("%16s --> %s", "pc", "r8"));
            printStream.println(String.format("%16s --> %s", "literals", "r9"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r7"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r15"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r11"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r15"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r10"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r10"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r15"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r11"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r15"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r10"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r15"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r10"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r11"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r15"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r11"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r10"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r2"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r1"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r2"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r3"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r8"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r9"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r10"));
            printStream.println(String.format("%16s --> %s", "cmpSlot0", "r0"));
            printStream.println(String.format("%16s --> %s", "cmpSlot1", "r1"));
            printStream.println(String.format("%16s --> %s", "divMulEven", "r0"));
            printStream.println(String.format("%16s --> %s", "divMulOdd", "r1"));
            printStream.println(String.format("%16s --> %s", "expandedDestEA", "r0"));
            printStream.println(String.format("%16s --> %s", "expandedSourceEA", "r1"));
            printStream.println(String.format("%16s --> %s", "globalOffsetTable", "r12"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r1"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r2"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r3"));
            printStream.println(String.format("%16s --> %s", "linkRegister", "r7"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r1"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r2"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r3"));
            printStream.println(String.format("%16s --> %s", "pointerToStackParams", "r5"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r2"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r2"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r3"));
            printStream.println(String.format("%16s --> %s", "swapSlot0", "r2"));
            printStream.println(String.format("%16s --> %s", "swapSlot1", "r3"));
            printStream.println(String.format("%16s --> %s", "zos_entrypoint", "r6"));
            printStream.println(String.format("%16s --> %s", "zos_environment", "r5"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "saved_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "saved_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "saved_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "saved_fpr9", "fp9"));
        }
    }

    private static void printRegistersForZOS32BitS390(int n, PrintStream printStream) {
        if (n >= 1) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 1));
            printStream.println(String.format("%16s --> %s", "vmStruct", "r13"));
            printStream.println(String.format("%16s --> %s", "sp", "r5"));
            printStream.println(String.format("%16s --> %s", "arg0EA", "r10"));
            printStream.println(String.format("%16s --> %s", "pc", "r8"));
            printStream.println(String.format("%16s --> %s", "literals", "r9"));
        }
        if (n >= 2) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 2));
            printStream.println(String.format("%16s --> %s", "bytecodes", "r7"));
            printStream.println(String.format("%16s --> %s", "detailMessage", "r15"));
            printStream.println(String.format("%16s --> %s", "exceptionIndex", "r11"));
            printStream.println(String.format("%16s --> %s", "javaNewClass", "r15"));
            printStream.println(String.format("%16s --> %s", "messageNumber", "r10"));
            printStream.println(String.format("%16s --> %s", "methodHandle", "r10"));
            printStream.println(String.format("%16s --> %s", "moduleName", "r15"));
            printStream.println(String.format("%16s --> %s", "resolveBytecode", "r11"));
            printStream.println(String.format("%16s --> %s", "resolveIndex", "r15"));
            printStream.println(String.format("%16s --> %s", "resolveType", "r10"));
            printStream.println(String.format("%16s --> %s", "returnAddress", "r15"));
            printStream.println(String.format("%16s --> %s", "returnPoint", "r10"));
            printStream.println(String.format("%16s --> %s", "returnSP", "r11"));
            printStream.println(String.format("%16s --> %s", "sendArgs", "r15"));
            printStream.println(String.format("%16s --> %s", "sendMethod", "r11"));
            printStream.println(String.format("%16s --> %s", "sendReturn", "r10"));
            printStream.println(String.format("%16s --> %s", "syncObject", "r2"));
        }
        if (n >= 3) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 3));
            printStream.println(String.format("%16s --> %s", "asmAddr1", "r1"));
            printStream.println(String.format("%16s --> %s", "asmAddr2", "r2"));
            printStream.println(String.format("%16s --> %s", "asmAddr3", "r3"));
            printStream.println(String.format("%16s --> %s", "asmData1", "r8"));
            printStream.println(String.format("%16s --> %s", "asmData2", "r9"));
            printStream.println(String.format("%16s --> %s", "asmData3", "r10"));
            printStream.println(String.format("%16s --> %s", "cmpSlot0", "r0"));
            printStream.println(String.format("%16s --> %s", "cmpSlot1", "r1"));
            printStream.println(String.format("%16s --> %s", "divMulEven", "r0"));
            printStream.println(String.format("%16s --> %s", "divMulOdd", "r1"));
            printStream.println(String.format("%16s --> %s", "expandedDestEA", "r0"));
            printStream.println(String.format("%16s --> %s", "expandedSourceEA", "r1"));
            printStream.println(String.format("%16s --> %s", "globalOffsetTable", "r12"));
            printStream.println(String.format("%16s --> %s", "inParm1", "r1"));
            printStream.println(String.format("%16s --> %s", "inParm2", "r2"));
            printStream.println(String.format("%16s --> %s", "inParm3", "r3"));
            printStream.println(String.format("%16s --> %s", "linkRegister", "r7"));
            printStream.println(String.format("%16s --> %s", "machineSP", "r4"));
            printStream.println(String.format("%16s --> %s", "outParm1", "r1"));
            printStream.println(String.format("%16s --> %s", "outParm2", "r2"));
            printStream.println(String.format("%16s --> %s", "outParm3", "r3"));
            printStream.println(String.format("%16s --> %s", "pointerToStackParams", "r5"));
            printStream.println(String.format("%16s --> %s", "return64hiRead", "r2"));
            printStream.println(String.format("%16s --> %s", "return64hiWrite", "r2"));
            printStream.println(String.format("%16s --> %s", "return64loRead", "r3"));
            printStream.println(String.format("%16s --> %s", "return64loWrite", "r3"));
            printStream.println(String.format("%16s --> %s", "returnValue", "r3"));
            printStream.println(String.format("%16s --> %s", "swapSlot0", "r2"));
            printStream.println(String.format("%16s --> %s", "swapSlot1", "r3"));
            printStream.println(String.format("%16s --> %s", "zos_entrypoint", "r6"));
            printStream.println(String.format("%16s --> %s", "zos_environment", "r5"));
        }
        if (n >= 4) {
            printStream.println(String.format("=========== Level %d Registers ===========\n", 4));
            printStream.println(String.format("%16s --> %s", "_fp0", "fp0"));
            printStream.println(String.format("%16s --> %s", "_fp1", "fp1"));
            printStream.println(String.format("%16s --> %s", "_fp10", "fp10"));
            printStream.println(String.format("%16s --> %s", "_fp11", "fp11"));
            printStream.println(String.format("%16s --> %s", "_fp12", "fp12"));
            printStream.println(String.format("%16s --> %s", "_fp13", "fp13"));
            printStream.println(String.format("%16s --> %s", "_fp14", "fp14"));
            printStream.println(String.format("%16s --> %s", "_fp15", "fp15"));
            printStream.println(String.format("%16s --> %s", "_fp2", "fp2"));
            printStream.println(String.format("%16s --> %s", "_fp3", "fp3"));
            printStream.println(String.format("%16s --> %s", "_fp4", "fp4"));
            printStream.println(String.format("%16s --> %s", "_fp5", "fp5"));
            printStream.println(String.format("%16s --> %s", "_fp6", "fp6"));
            printStream.println(String.format("%16s --> %s", "_fp7", "fp7"));
            printStream.println(String.format("%16s --> %s", "_fp8", "fp8"));
            printStream.println(String.format("%16s --> %s", "_fp9", "fp9"));
            printStream.println(String.format("%16s --> %s", "_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "jit_fpr0", "fp0"));
            printStream.println(String.format("%16s --> %s", "jit_fpr1", "fp1"));
            printStream.println(String.format("%16s --> %s", "jit_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "jit_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "jit_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "jit_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "jit_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "jit_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "jit_fpr2", "fp2"));
            printStream.println(String.format("%16s --> %s", "jit_fpr3", "fp3"));
            printStream.println(String.format("%16s --> %s", "jit_fpr4", "fp4"));
            printStream.println(String.format("%16s --> %s", "jit_fpr5", "fp5"));
            printStream.println(String.format("%16s --> %s", "jit_fpr6", "fp6"));
            printStream.println(String.format("%16s --> %s", "jit_fpr7", "fp7"));
            printStream.println(String.format("%16s --> %s", "jit_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "jit_fpr9", "fp9"));
            printStream.println(String.format("%16s --> %s", "jit_r0", "r0"));
            printStream.println(String.format("%16s --> %s", "jit_r1", "r1"));
            printStream.println(String.format("%16s --> %s", "jit_r10", "r10"));
            printStream.println(String.format("%16s --> %s", "jit_r11", "r11"));
            printStream.println(String.format("%16s --> %s", "jit_r12", "r12"));
            printStream.println(String.format("%16s --> %s", "jit_r13", "r13"));
            printStream.println(String.format("%16s --> %s", "jit_r14", "r14"));
            printStream.println(String.format("%16s --> %s", "jit_r15", "r15"));
            printStream.println(String.format("%16s --> %s", "jit_r16", "r16"));
            printStream.println(String.format("%16s --> %s", "jit_r17", "r17"));
            printStream.println(String.format("%16s --> %s", "jit_r18", "r18"));
            printStream.println(String.format("%16s --> %s", "jit_r19", "r19"));
            printStream.println(String.format("%16s --> %s", "jit_r2", "r2"));
            printStream.println(String.format("%16s --> %s", "jit_r20", "r20"));
            printStream.println(String.format("%16s --> %s", "jit_r21", "r21"));
            printStream.println(String.format("%16s --> %s", "jit_r22", "r22"));
            printStream.println(String.format("%16s --> %s", "jit_r23", "r23"));
            printStream.println(String.format("%16s --> %s", "jit_r24", "r24"));
            printStream.println(String.format("%16s --> %s", "jit_r25", "r25"));
            printStream.println(String.format("%16s --> %s", "jit_r26", "r26"));
            printStream.println(String.format("%16s --> %s", "jit_r27", "r27"));
            printStream.println(String.format("%16s --> %s", "jit_r28", "r28"));
            printStream.println(String.format("%16s --> %s", "jit_r29", "r29"));
            printStream.println(String.format("%16s --> %s", "jit_r3", "r3"));
            printStream.println(String.format("%16s --> %s", "jit_r30", "r30"));
            printStream.println(String.format("%16s --> %s", "jit_r31", "r31"));
            printStream.println(String.format("%16s --> %s", "jit_r4", "r4"));
            printStream.println(String.format("%16s --> %s", "jit_r5", "r5"));
            printStream.println(String.format("%16s --> %s", "jit_r6", "r6"));
            printStream.println(String.format("%16s --> %s", "jit_r7", "r7"));
            printStream.println(String.format("%16s --> %s", "jit_r8", "r8"));
            printStream.println(String.format("%16s --> %s", "jit_r9", "r9"));
            printStream.println(String.format("%16s --> %s", "saved_fpr10", "fp10"));
            printStream.println(String.format("%16s --> %s", "saved_fpr11", "fp11"));
            printStream.println(String.format("%16s --> %s", "saved_fpr12", "fp12"));
            printStream.println(String.format("%16s --> %s", "saved_fpr13", "fp13"));
            printStream.println(String.format("%16s --> %s", "saved_fpr14", "fp14"));
            printStream.println(String.format("%16s --> %s", "saved_fpr15", "fp15"));
            printStream.println(String.format("%16s --> %s", "saved_fpr8", "fp8"));
            printStream.println(String.format("%16s --> %s", "saved_fpr9", "fp9"));
        }
    }
}

