/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.HiddenInstanceField;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.LinkedList;

public class ObjectFieldInfo {
    J9ROMClassPointer romClass;
    int superclassFieldsSize;
    boolean objectCanUseBackfill;
    public static final int fj9object_t_SizeOf = J9BuildFlags.gc_compressedPointers ? 4 : UDATA.SIZEOF;
    public static final int j9objectmonitor_t_SizeOf;
    int instanceObjectCount = 0;
    int instanceSingleCount = 0;
    int instanceDoubleCount = 0;
    int totalObjectCount = 0;
    int totalSingleCount = 0;
    int totalDoubleCount = 0;
    boolean instanceFieldBackfillEligible;
    int hiddenFieldCount = 0;
    int superclassBackfillOffset;
    int myBackfillOffset;
    int subclassBackfillOffset;
    public static final int NO_BACKFILL_AVAILABLE = -1;
    public static final int BACKFILL_SIZE = 4;
    public static final int LOCKWORD_SIZE;
    public static final int FINALIZE_LINK_SIZE;

    ObjectFieldInfo(J9ROMClassPointer j9ROMClassPointer) {
        this.romClass = j9ROMClassPointer;
        this.superclassFieldsSize = -1;
        this.superclassBackfillOffset = -1;
        this.myBackfillOffset = -1;
        this.subclassBackfillOffset = -1;
        this.objectCanUseBackfill = fj9object_t_SizeOf == 4;
        this.instanceFieldBackfillEligible = false;
    }

    int getTotalDoubleCount() {
        return this.totalDoubleCount;
    }

    int getTotalObjectCount() {
        return this.totalObjectCount;
    }

    int getTotalSingleCount() {
        return this.totalSingleCount;
    }

    int getNonBackfilledObjectCount() {
        int n = this.totalObjectCount;
        if (this.isBackfillSuitableObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --n;
        }
        return n;
    }

    int getNonBackfilledSingleCount() {
        int n = this.totalSingleCount;
        if (this.isBackfillSuitableSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --n;
        }
        return n;
    }

    int getNonBackfilledInstanceObjectCount() {
        int n = this.instanceObjectCount;
        if (this.isBackfillSuitableInstanceObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --n;
        }
        return n;
    }

    int getNonBackfilledInstanceSingleCount() {
        int n = this.instanceSingleCount;
        if (this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --n;
        }
        return n;
    }

    int getInstanceDoubleCount() {
        return this.instanceDoubleCount;
    }

    int getInstanceObjectCount() {
        return this.instanceObjectCount;
    }

    int getInstanceSingleCount() {
        return this.instanceSingleCount;
    }

    int getHiddenFieldCount() {
        return this.hiddenFieldCount;
    }

    boolean isBackfillSuitableSingleAvailable() {
        return 0 != this.getTotalSingleCount();
    }

    boolean isBackfillSuitableObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getTotalObjectCount();
    }

    boolean isBackfillSuitableInstanceSingleAvailable() {
        return 0 != this.getInstanceSingleCount();
    }

    boolean isBackfillSuitableInstanceObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getInstanceObjectCount();
    }

    boolean isBackfillSuitableFieldAvailable() {
        return this.isBackfillSuitableSingleAvailable() || this.isBackfillSuitableObjectAvailable();
    }

    UDATA getMyBackfillOffsetForHiddenField() {
        return new UDATA((long)this.myBackfillOffset + J9Object.SIZEOF);
    }

    int getSuperclassFieldsSize() {
        return this.superclassFieldsSize;
    }

    long getSuperclassObjectSize() {
        return (long)this.superclassFieldsSize + J9Object.SIZEOF;
    }

    void setSuperclassFieldsSize(int n) {
        this.superclassFieldsSize = n;
    }

    boolean isMyBackfillSlotAvailable() {
        return this.myBackfillOffset >= 0;
    }

    boolean isSuperclassBackfillSlotAvailable() {
        return this.superclassBackfillOffset >= 0;
    }

    int calculateFieldDataStart() {
        int n = this.getSuperclassFieldsSize();
        if (this.getSuperclassObjectSize() % ObjectModel.getObjectAlignmentInBytes() != 0L && (this.totalDoubleCount > 0 || !this.objectCanUseBackfill && this.totalObjectCount > 0)) {
            n += 4;
        }
        return n;
    }

    int addDoublesArea(int n) {
        return n + this.totalDoubleCount * 8;
    }

    int addObjectsArea(int n) {
        int n2 = this.getNonBackfilledObjectCount();
        return n + n2 * fj9object_t_SizeOf;
    }

    int getMyBackfillOffset() {
        return this.myBackfillOffset;
    }

    int getSubclassBackfillOffset() {
        return this.subclassBackfillOffset;
    }

    void setSuperclassBackfillOffset(int n) {
        this.superclassBackfillOffset = n;
    }

    int getSuperclassBackfillOffset() {
        return this.superclassBackfillOffset;
    }

    boolean isInstanceFieldBackfillEligible() {
        return this.instanceFieldBackfillEligible;
    }

    void countInstanceFields() throws CorruptDataException {
        J9ROMFieldShapeIterator j9ROMFieldShapeIterator = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
        for (J9ROMFieldShapePointer j9ROMFieldShapePointer : j9ROMFieldShapeIterator) {
            UDATA uDATA = j9ROMFieldShapePointer.modifiers();
            if (uDATA.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this.instanceObjectCount;
                ++this.totalObjectCount;
                continue;
            }
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.instanceDoubleCount;
                ++this.totalDoubleCount;
                continue;
            }
            ++this.instanceSingleCount;
            ++this.totalSingleCount;
        }
        this.instanceFieldBackfillEligible = this.instanceSingleCount > 0 || this.objectCanUseBackfill && this.instanceSingleCount > 0;
    }

    int countAndCopyHiddenFields(LinkedList<HiddenInstanceField> linkedList, ArrayList<HiddenInstanceField> arrayList) throws CorruptDataException {
        String string = J9UTF8Helper.stringValue(this.romClass.className());
        this.hiddenFieldCount = 0;
        for (HiddenInstanceField hiddenInstanceField : linkedList) {
            if (hiddenInstanceField.className() != null && !string.equals(hiddenInstanceField.className())) continue;
            UDATA uDATA = hiddenInstanceField.shape().modifiers();
            if (uDATA.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this.totalObjectCount;
            } else if (uDATA.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.totalDoubleCount;
            } else {
                ++this.totalSingleCount;
            }
            arrayList.add(hiddenInstanceField);
            ++this.hiddenFieldCount;
        }
        return this.hiddenFieldCount;
    }

    int calculateTotalFieldsSizeAndBackfill() {
        long l = (long)this.superclassFieldsSize + (long)this.totalObjectCount * J9Object.SIZEOF + (long)(this.totalSingleCount * 4) + (long)(this.totalDoubleCount * 8);
        if (this.getSuperclassObjectSize() % ObjectModel.getObjectAlignmentInBytes() != 0L && (this.totalDoubleCount > 0 || !this.objectCanUseBackfill && this.totalObjectCount > 0)) {
            this.superclassBackfillOffset = this.getSuperclassFieldsSize();
            l += 4L;
        }
        if (this.isSuperclassBackfillSlotAvailable() && this.isBackfillSuitableFieldAvailable()) {
            l -= 4L;
            this.myBackfillOffset = this.superclassBackfillOffset;
            this.superclassBackfillOffset = -1;
        }
        if ((l + J9Object.SIZEOF) % ObjectModel.getObjectAlignmentInBytes() != 0L) {
            this.subclassBackfillOffset = (int)l;
            l += 4L;
        } else {
            this.subclassBackfillOffset = this.superclassBackfillOffset;
        }
        return (int)l;
    }

    static {
        LOCKWORD_SIZE = j9objectmonitor_t_SizeOf = J9BuildFlags.gc_compressedPointers ? 4 : UDATA.SIZEOF;
        FINALIZE_LINK_SIZE = fj9object_t_SizeOf;
    }
}

