/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDOMComparator {
    protected HashMap<String, File> opts = new HashMap();
    protected static final String OPT_J9DDR_FILE = "-ddr";
    protected static final String OPT_JEXTRACT_FILE = "-jx";
    protected static final String OPT_CONFIG_FILE = "-f";
    private Document xmlJ9DDR = null;
    private Document xmlJExtract = null;
    private Properties xpathQueries = null;
    private ArrayList<String> messages = new ArrayList();

    public Iterator<String> getMessages() {
        return this.messages.iterator();
    }

    public static void main(String[] stringArray) {
        XMLDOMComparator xMLDOMComparator = new XMLDOMComparator();
        xMLDOMComparator.parseArgs(stringArray);
        xMLDOMComparator.compareXML();
    }

    public boolean compareXML() {
        this.parseXML();
        this.loadXPathProperties();
        return this.areDOMsEqual();
    }

    private boolean areDOMsEqual() {
        boolean bl = true;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPath xPath2 = xPathFactory.newXPath();
        for (String string : this.xpathQueries.keySet()) {
            String string2 = this.xpathQueries.getProperty(string);
            this.messages.add("Test : " + string + " : " + string2);
            try {
                NodeList nodeList = (NodeList)xPath.evaluate(string2, this.xmlJ9DDR, XPathConstants.NODESET);
                NodeList nodeList2 = (NodeList)xPath2.evaluate(string2, this.xmlJExtract, XPathConstants.NODESET);
                boolean bl2 = this.areNodeListsEqual(nodeList, nodeList2);
                if (!bl2) {
                    this.messages.add("Test failed : node lists are not equal");
                }
                bl &= bl2;
            }
            catch (XPathExpressionException xPathExpressionException) {
                this.messages.add("Skipping test, error in XPath expression : " + xPathExpressionException.getMessage());
            }
        }
        return bl;
    }

    private boolean areNodeListsEqual(NodeList nodeList, NodeList nodeList2) {
        boolean bl = true;
        if (nodeList.getLength() != nodeList2.getLength()) {
            this.messages.add("The number of nodes returned does not match");
            return false;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Node node2 = nodeList2.item(i);
            bl &= this.areNodeListsEqual(node.getChildNodes(), node2.getChildNodes());
            String string = node.getNodeName();
            if (!node.getNodeName().equals(node2.getNodeName())) {
                this.messages.add("The node names did not match : " + node.getNodeName() + " != " + node2.getNodeName());
                return false;
            }
            if (node.getNodeValue() == null) {
                if (node2.getNodeValue() != null) {
                    this.messages.add("One node had a null value whilst the other was non-null : Node : " + string);
                    return false;
                }
            } else if (!node.getNodeValue().equals(node2.getNodeValue())) {
                this.messages.add("The values for node " + string + " do not match : " + node.getNodeValue() + " != " + node2.getNodeValue());
                return false;
            }
            if (node.hasAttributes() ^ node2.hasAttributes()) {
                this.messages.add("The number of attributes for " + string + " do not match");
                return false;
            }
            if (!node.hasAttributes() || !node2.hasAttributes()) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
                this.messages.add("The number of attributes for " + string + " do not match");
                return false;
            }
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Node node3 = namedNodeMap.item(j);
                Node node4 = namedNodeMap2.item(j);
                if (!node3.getNodeName().equals(node4.getNodeName())) {
                    this.messages.add("The attribute for " + string + " does not match : " + node3.getNodeName() + " != " + node4.getNodeName());
                    return false;
                }
                if (node3.getNodeValue().equals(node4.getNodeValue())) continue;
                this.messages.add("The attribute " + node3.getNodeName() + " for node " + string + " does not match : " + node3.getNodeValue() + " != " + node4.getNodeValue());
                return false;
            }
        }
        return bl;
    }

    private void loadXPathProperties() {
        try {
            this.xpathQueries = new Properties();
            FileInputStream fileInputStream = new FileInputStream(this.opts.get(OPT_CONFIG_FILE));
            this.xpathQueries.load(fileInputStream);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("General failure parsing the XPath config : " + this.opts.get(OPT_CONFIG_FILE).getAbsolutePath() + ". " + exception.getMessage());
        }
    }

    private void parseXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.xmlJ9DDR = documentBuilder.parse(this.opts.get(OPT_J9DDR_FILE));
            this.xmlJExtract = documentBuilder.parse(this.opts.get(OPT_JEXTRACT_FILE));
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("The XML file contains invalid XML");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Failed to read from XML file : " + iOException.getMessage());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("General failure parsing the XML : " + exception.getMessage());
        }
    }

    public XMLDOMComparator() {
        this.opts.put(OPT_J9DDR_FILE, null);
        this.opts.put(OPT_JEXTRACT_FILE, null);
        this.opts.put(OPT_CONFIG_FILE, null);
    }

    public void parseArgs(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; i += 2) {
                File object;
                if (this.opts.containsKey(stringArray[i])) {
                    object = new File(stringArray[i + 1]);
                    if (!object.exists()) {
                        throw new IllegalArgumentException("The file " + object.getAbsolutePath() + " does not exist or cannot be found");
                    }
                } else {
                    throw new IllegalArgumentException("Invalid option : " + stringArray[i]);
                }
                this.opts.put(stringArray[i], object);
            }
            for (String string : this.opts.keySet()) {
                File file = this.opts.get(string);
                if (file != null) continue;
                throw new IllegalArgumentException("The option " + string + " has not been set.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            XMLDOMComparator.printHelp();
            System.exit(1);
        }
    }

    private static final void printHelp() {
        System.out.println("Usage :\n\njava XMLDOMComparator -ddr <path to J9DDR XML file> -jx <path to JExtract XML file> -f <path to config file>\n");
        System.out.println("<path to J9DDR XML file> : full path to the XML file which has been generated by J9DDR");
        System.out.println("<path to JExtract XML file> : full path to the XML file which has been generated by JExtract");
        System.out.println("<path to config file> : full path to the XPath properties file which controls the nodes to be tested");
    }
}

