/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindInfo;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindModule;

public class UnwindCode {
    private long address;
    private UnwindModule module;
    private UnwindInfo info;
    private IAddressSpace process;
    private static final int OFFSET_CODEOFFSET = 0;
    private static final int OFFSET_UNWINDOP = 1;
    private static final int OFFSET_OPINFO = 1;
    private static final int OFFSET_SLOT1 = 2;
    private static final int OFFSET_SLOT2 = 4;
    static final String[] REGISTERS = new String[]{"RAX", "RCX", "RDX", "RBX", "RSP", "RBP", "RSI", "RDI", "R8", "R9", "R10", "R11", "R12", "R13", "R14", "R15"};

    public UnwindCode(IAddressSpace iAddressSpace, UnwindModule unwindModule, UnwindInfo unwindInfo, long l) {
        this.process = iAddressSpace;
        this.module = unwindModule;
        this.info = unwindInfo;
        this.address = l;
    }

    private byte getOffSet() throws MemoryFault {
        byte by = this.process.getByteAt(0L + this.module.getLoadAddress() + this.address);
        return by;
    }

    private byte getOpCode() throws MemoryFault {
        byte by = (byte)(this.process.getByteAt(1L + this.module.getLoadAddress() + this.address) & 0xF);
        return by;
    }

    private byte getOpInfo() throws MemoryFault {
        byte by = (byte)(this.process.getByteAt(1L + this.module.getLoadAddress() + this.address) & 0xFFFFFFF0);
        by = (byte)(by >> 4 & 0xF);
        return by;
    }

    private short getNode1() throws MemoryFault {
        short s = this.process.getShortAt(2L + this.module.getLoadAddress() + this.address);
        return s;
    }

    private short getNode2() throws MemoryFault {
        short s = this.process.getShortAt(4L + this.module.getLoadAddress() + this.address);
        return s;
    }

    public String formatOp() throws CorruptDataException {
        byte by = this.getOpCode();
        byte by2 = this.getOpInfo();
        switch (by) {
            case 0: {
                return String.format("Op: PUSH_NONVOL, Info: 0x%x, register = %s", by2, REGISTERS[by2]);
            }
            case 1: {
                if (by2 == 0) {
                    return String.format("Op: ALLOC_LARGE, Info: 0x%x, size = 0x%x", by2, this.getNode1() * 8);
                }
                return String.format("Op: ALLOC_LARGE - Untested", new Object[0]);
            }
            case 2: {
                return String.format("Op: ALLOC_SMALL, Info: 0x%x, size = 0x%x", by2, by2 * 8 + 8);
            }
            case 3: {
                return String.format("Op: SET_FPREG,Info: 0x%x, Set %s to  RSP + FrameOffset", by2, "FrameRegister");
            }
            case 4: {
                return String.format("Op: SAVE_NONVOL, Info: 0x%x, register = %s, offset=0x%x", by2, REGISTERS[by2], this.getNode1() * 8);
            }
            case 5: {
                return String.format("Op: SAVE_NONVOL_FAR, Info: 0x%x, register = %s, offset=0x%x", by2, REGISTERS[by2], this.getNode1() << 16 + this.getNode2());
            }
            case 8: {
                return String.format("Op: SAVE_XMM128, Info: 0x%x, register = %s, offset=0x%x", by2, REGISTERS[by2], this.getNode1() * 16);
            }
            case 9: {
                return String.format("Op: SAVE_XMM128_FAR, Info:  register = %s, offset=0x%x", REGISTERS[by2], this.getNode1() << 16 + this.getNode2());
            }
            case 10: {
                if (by2 == 0) {
                    return "Op: UWOP_PUSH_MACHFRAME with no error code - Untested";
                }
                return "Op: UWOP_PUSH_MACHFRAME with error code - Untested";
            }
        }
        throw new CorruptDataException("Invalid stack unwind opcode " + by);
    }

    public int getNodeCount() throws CorruptDataException {
        byte by = this.getOpCode();
        byte by2 = this.getOpInfo();
        switch (by) {
            case 0: {
                return 1;
            }
            case 1: {
                if (by2 == 0) {
                    return 2;
                }
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 10: {
                return 1;
            }
        }
        throw new CorruptDataException("Invalid stack unwind opcode " + by);
    }

    public long getNewSP(long l) throws CorruptDataException {
        byte by = this.getOpCode();
        byte by2 = this.getOpInfo();
        switch (by) {
            case 0: {
                return l + 8L;
            }
            case 1: {
                if (by2 == 0) {
                    return l + (long)(this.getNode1() * 8);
                }
                throw new CorruptDataException("Untested stack unwind opcode " + by);
            }
            case 2: {
                return l + (long)(by2 * 8 + 8);
            }
            case 3: {
                throw new CorruptDataException("Untested stack unwind opcode " + by);
            }
            case 4: {
                return l;
            }
            case 5: {
                return l;
            }
            case 8: {
                return l;
            }
            case 9: {
                return l;
            }
            case 10: {
                throw new CorruptDataException("Untested stack unwind opcode " + by);
            }
        }
        throw new CorruptDataException("Invalid stack unwind opcode " + by);
    }

    public String toString() {
        try {
            return String.format("Offset 0x%02x : ", this.getOffSet()) + this.formatOp();
        }
        catch (MemoryFault memoryFault) {
            return "MemoryFault: " + memoryFault.getMessage();
        }
        catch (CorruptDataException corruptDataException) {
            return "CorruptDataException: " + corruptDataException.getMessage();
        }
    }
}

