/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.minidump.Stream;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class ThreadInfoStream
extends Stream {
    private final long baseMillisOffset;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    protected ThreadInfoStream(int n, long l) {
        super(n, l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.clear();
        gregorianCalendar.set(1601, 0, 1, 0, 0, 0);
        this.baseMillisOffset = gregorianCalendar.getTimeInMillis();
    }

    public void readFrom(MiniDumpReader miniDumpReader, IAddressSpace iAddressSpace, boolean bl, List<IOSThread> list) throws CorruptDataException, IOException {
        miniDumpReader.seek(this.getLocation());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        HashMap<Long, Properties> hashMap = new HashMap<Long, Properties>();
        n = miniDumpReader.readInt();
        n2 = miniDumpReader.readInt();
        n3 = miniDumpReader.readInt();
        miniDumpReader.seek(this.getLocation() + (long)n);
        for (int i = 0; i < n3; ++i) {
            Properties object = new Properties();
            int n4 = miniDumpReader.readInt();
            int n5 = miniDumpReader.readInt();
            int n6 = miniDumpReader.readInt();
            int n7 = miniDumpReader.readInt();
            long l = miniDumpReader.readLong();
            long l2 = miniDumpReader.readLong();
            long l3 = miniDumpReader.readLong();
            long l4 = miniDumpReader.readLong();
            long l5 = miniDumpReader.readLong();
            long l6 = miniDumpReader.readLong();
            object.put("DumpFlags", String.format("0x%08X", n5));
            object.put("DumpError", String.format("0x%08X", n6));
            object.put("ExitStatus", String.format("0x%08X", n7));
            object.put("CreateTime", Long.toString(l));
            object.put("ExitTime", Long.toString(l2));
            object.put("KernelTime", Long.toString(l3));
            object.put("UserTime", Long.toString(l4));
            object.put("StartAddress", String.format(bl ? "0x%016X" : "0x%08X", l5));
            object.put("Affinity", String.format("0x%016X", l6));
            long l7 = l / 10000L + this.baseMillisOffset;
            String string = this.dateFormat.format(new Date(l7));
            object.put("CreateTime_Formatted", string);
            if (l2 != 0L) {
                long l8 = l2 / 10000L + this.baseMillisOffset;
                String string2 = this.dateFormat.format(new Date(l8));
                object.put("ExitTime_Formatted", string2);
            }
            hashMap.put(new Long(n4), object);
        }
        for (IOSThread iOSThread : list) {
            Properties properties = (Properties)hashMap.get(iOSThread.getThreadId());
            if (properties == null) continue;
            iOSThread.getProperties().putAll((Map<?, ?>)properties);
        }
    }
}

