/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.AbstractCoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.macho.DylibCommand;
import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import com.ibm.j9ddr.corereaders.macho.OSXProcessAddressSpace;
import com.ibm.j9ddr.corereaders.macho.SegmentCommand64;
import com.ibm.j9ddr.corereaders.macho.ThreadCommand;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.UnbackedMemorySource;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class MachoDumpReader
extends AbstractCoreReader
implements ILibraryDependentCore {
    private static final int MACHO_64 = -17958193;
    private static final int MACHO_64_REV = -805638658;
    public static final int MH_OBJECT = 1;
    public static final int MH_EXECUTE = 2;
    public static final int MH_FVMLIB = 3;
    public static final int MH_CORE = 4;
    public static final int MH_PRELOAD = 5;
    public static final int MH_DYLIB = 6;
    public static final int MH_DYLINKER = 7;
    public static final int MH_BUNDLE = 8;
    public static final int MH_DYLIB_STUB = 9;
    public static final int MH_DSYM = 10;
    public static final int MH_KEXT_BUNDLE = 11;
    private static final int MH_NOUNDEFS = 1;
    private static final int MH_INCRLINK = 2;
    private static final int MH_DYLDLINK = 4;
    private static final int MH_BINDATLOAD = 8;
    private static final int MH_PREBOUND = 16;
    private static final int MH_SPLIT_SEGS = 32;
    private static final int MH_LAZY_INIT = 64;
    private static final int MH_TWOLEVEL = 128;
    private static final int MH_FORCE_FLAT = 256;
    private static final int MH_NOMULTIDEFS = 512;
    private static final int MH_NOFIXPREBINDING = 1024;
    private static final int MH_PREBINDABLE = 2048;
    private static final int MH_ALLMODSBOUND = 4096;
    private static final int MH_SUBSECTIONS_VIA_SYMBOLS = 8192;
    private static final int MH_CANONICAL = 16384;
    private static final int MH_WEAK_DEFINES = 32768;
    private static final int MH_BINDS_TO_WEAK = 65536;
    private static final int MH_ALLOW_STACK_EXECUTION = 131072;
    private static final int MH_ROOT_SAFE = 262144;
    private static final int MH_SETUID_SAFE = 524288;
    private static final int MH_NO_REEXPORTED_DYLIBS = 0x100000;
    private static final int MH_PIE = 0x200000;
    private static final int MH_DEAD_STRIPPABLE_DYLIB = 0x400000;
    private static final int MH_HAS_TLV_DESCRIPTORS = 0x800000;
    private static final int MH_NO_HEAP_EXECUTION = 0x1000000;
    private static final int MH_APP_EXTENSION_SAFE = 0x2000000;
    private static final int CPU_TYPE_X86 = 7;
    private static final int CPU_TYPE_X86_64 = 0x1000007;
    private static final int header64Size = 32;
    private static final int loadCommandSize = 8;
    private MachFile64 dumpFile;
    private MachFile64 executableMachFile;
    private MachFile64 dylinkerMachFile;
    private List<MachFile64> dylibMachFiles;
    private OSXProcessAddressSpace _process;
    private IModule _executable;
    private List<IModule> _modules;
    private int _signalNumber = -1;

    public MachoDumpReader(ImageInputStream imageInputStream) throws IOException, InvalidDumpFormatException {
        this.coreFile = null;
        this._modules = new ArrayList<IModule>();
        this.dylibMachFiles = new ArrayList<MachFile64>();
        this.setReader(imageInputStream);
        this.readCore();
    }

    public static boolean isMACHO(byte[] byArray) {
        int n = MachoDumpReader.readInt(byArray, 0);
        return MachoDumpReader.isMACHO(n);
    }

    private static boolean isMACHO(int n) {
        return n == -17958193 || n == -805638658;
    }

    public static ICore getReaderForFile(File file) throws IOException, InvalidDumpFormatException {
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        return MachoDumpReader.getReaderForFile(fileImageInputStream);
    }

    public static ICore getReaderForFile(ImageInputStream imageInputStream) throws IOException, InvalidDumpFormatException {
        int n = imageInputStream.readInt();
        if (!MachoDumpReader.isMACHO(n)) {
            throw new InvalidDumpFormatException("The supplied file is not an Mach-O core dump.");
        }
        return new MachoDumpReader(imageInputStream);
    }

    public String getCommandLine() throws DataUnavailableException {
        throw new DataUnavailableException("No command line available on OSX");
    }

    @Override
    public Platform getPlatform() {
        return Platform.OSX;
    }

    @Override
    public String getDumpFormat() {
        return "macho";
    }

    @Override
    public Collection<? extends IAddressSpace> getAddressSpaces() {
        return Collections.singletonList(this._process);
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("system.type", "OSX");
        properties.setProperty("cpu.type", this.getCpuType());
        properties.setProperty("cpu.subtype", "");
        return properties;
    }

    @Override
    public void executablePathHint(String string) {
        if (this._executable != null) {
            try {
                this._executable = new Module(this._process, string, (List)this._executable.getSymbols(), this._executable.getMemoryRanges(), this._executable.getLoadAddress(), this._executable.getProperties());
            }
            catch (DataUnavailableException dataUnavailableException) {
                // empty catch block
            }
        }
    }

    public IModule getExecutable() {
        return this._executable;
    }

    public List<? extends IModule> getModules() {
        return this._modules;
    }

    public long getProcessId() {
        return 0L;
    }

    public List<? extends IOSThread> getThreads() throws CorruptDataException {
        ArrayList<OSXThread> arrayList = new ArrayList<OSXThread>(this.dumpFile.threads.size());
        for (ThreadCommand threadCommand : this.dumpFile.threads) {
            OSXThread oSXThread = new OSXThread(0L, threadCommand);
            arrayList.add(oSXThread);
            if (this._signalNumber != -1) continue;
            if (oSXThread.registers.containsKey("err")) {
                this._signalNumber = ((Number)oSXThread.registers.get("err")).intValue();
                continue;
            }
            throw new CorruptDataException("Core dump missing thread exception registers.");
        }
        return arrayList;
    }

    public int getSignalNumber() throws DataUnavailableException {
        if (this._signalNumber == -1) {
            try {
                this.getThreads();
            }
            catch (CorruptDataException corruptDataException) {
                throw new DataUnavailableException("Core dump missing thread exception registers.", corruptDataException);
            }
        }
        return this._signalNumber;
    }

    private void readCore() throws IOException, InvalidDumpFormatException {
        this.dumpFile = this.readMachFile(0L);
        if (this.dumpFile.header.fileType != 4) {
            throw new InvalidDumpFormatException("The supplied file is not an Mach-O core dump.");
        }
        this._process = new OSXProcessAddressSpace(8, this._fileReader.getByteOrder(), this);
        Collection<? extends IMemorySource> collection = this.dumpFile.getMemoryRangesWithOffset(0L);
        this._process.addMemorySources(collection);
        for (SegmentCommand64 segmentCommand64 : this.dumpFile.segments) {
            this.seek(segmentCommand64.fileOffset);
            try {
                int n = this.readInt();
                if (!MachoDumpReader.isMACHO(n)) continue;
                MachFile64 machFile64 = this.readMachFile(segmentCommand64.fileOffset);
                switch (machFile64.header.fileType) {
                    case 2: {
                        this.executableMachFile = machFile64;
                        this._executable = this.processExecutableFile(machFile64, segmentCommand64);
                        break;
                    }
                    case 6: {
                        this.dylibMachFiles.add(machFile64);
                        this._modules.add(this.processModuleFile(machFile64, segmentCommand64));
                        break;
                    }
                    case 7: {
                        this.dylinkerMachFile = machFile64;
                        break;
                    }
                }
            }
            catch (EOFException eOFException) {}
        }
    }

    public MachFile64 readMachFile(long l) throws IOException, InvalidDumpFormatException {
        MachFile64 machFile64 = new MachFile64();
        machFile64.streamOffset = l;
        machFile64.header = this.readHeader(l);
        if (machFile64.header.numCommands > 0) {
            machFile64.loadCommands = new ArrayList<LoadCommand>(machFile64.header.numCommands);
            machFile64.segments = new ArrayList<SegmentCommand64>();
            machFile64.otherLoads = new ArrayList<LoadCommand>();
            machFile64.threads = new ArrayList<ThreadCommand>();
        }
        long l2 = l + 32L;
        for (int i = 0; i < machFile64.header.numCommands; ++i) {
            LoadCommand loadCommand = LoadCommand.readFullCommand(this._fileReader, l2, l);
            if (loadCommand instanceof SegmentCommand64) {
                SegmentCommand64 segmentCommand64 = (SegmentCommand64)loadCommand;
                machFile64.segments.add(segmentCommand64);
            } else if (loadCommand instanceof ThreadCommand) {
                machFile64.threads.add((ThreadCommand)loadCommand);
            } else {
                machFile64.otherLoads.add(loadCommand);
            }
            machFile64.loadCommands.add(loadCommand);
            l2 += loadCommand.cmdSize;
        }
        return machFile64;
    }

    private IModule processExecutableFile(MachFile64 machFile64, SegmentCommand64 segmentCommand64) throws IOException, InvalidDumpFormatException {
        ArrayList arrayList = new ArrayList();
        Collection<? extends IMemorySource> collection = machFile64.getMemoryRangesWithOffset(segmentCommand64.vmaddr);
        Module module = new Module(this._process, "executable", arrayList, collection, machFile64.streamOffset, new Properties());
        return module;
    }

    private IModule processModuleFile(MachFile64 machFile64, SegmentCommand64 segmentCommand64) throws IOException, InvalidDumpFormatException {
        DylibCommand dylibCommand = (DylibCommand)machFile64.otherLoads.stream().filter(loadCommand -> loadCommand.cmdType == 13).findFirst().get();
        String string = dylibCommand.dylib.name.value;
        ArrayList arrayList = new ArrayList();
        Collection<? extends IMemorySource> collection = machFile64.getMemoryRangesWithOffset(segmentCommand64.vmaddr);
        Module module = new Module(this._process, string, arrayList, collection, machFile64.streamOffset, new Properties());
        return module;
    }

    public MachHeader64 readHeader(long l) throws IOException, InvalidDumpFormatException {
        this.seek(l);
        MachHeader64 machHeader64 = new MachHeader64();
        machHeader64.magic = this.readInt();
        if (machHeader64.magic == -805638658) {
            this._fileReader.setByteOrder(this._fileReader.getByteOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        machHeader64.cpuType = this.readInt();
        machHeader64.cpuSubtype = this.readInt();
        machHeader64.fileType = this.readInt();
        machHeader64.numCommands = this.readInt();
        machHeader64.sizeCommands = Integer.toUnsignedLong(this.readInt());
        machHeader64.flags = this.readInt();
        this.readInt();
        return machHeader64;
    }

    private String getCpuType() {
        if (this.dumpFile.header.cpuType == 0x1000007) {
            return "X86_64";
        }
        return "";
    }

    public class OSXThread
    implements IOSThread {
        private final Map<String, Number> registers;
        private final Properties properties;
        private final long threadId;
        private final List<IMemoryRange> memoryRanges = new LinkedList<IMemoryRange>();
        private final List<IOSStackFrame> stackFrames = new LinkedList<IOSStackFrame>();

        public OSXThread(long l, ThreadCommand threadCommand) {
            this.threadId = l;
            this.registers = new TreeMap<String, Number>();
            for (ThreadCommand.ThreadState threadState : threadCommand.states) {
                this.registers.putAll(threadState.registers);
            }
            this.properties = new Properties();
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            return this.threadId;
        }

        @Override
        public List<? extends IOSStackFrame> getStackFrames() {
            return null;
        }

        @Override
        public Collection<? extends IRegister> getRegisters() {
            ArrayList<Register> arrayList = new ArrayList<Register>(this.registers.size());
            for (String string : this.registers.keySet()) {
                Number number = this.registers.get(string);
                arrayList.add(new Register(string, number));
            }
            return arrayList;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return this.memoryRanges;
        }

        @Override
        public long getInstructionPointer() {
            return this.registers.get("rip").longValue();
        }

        @Override
        public long getBasePointer() {
            return this.registers.get("rbp").longValue();
        }

        @Override
        public long getStackPointer() {
            return this.registers.get("rsp").longValue();
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }
    }

    public class MachFile64 {
        public MachHeader64 header;
        public List<LoadCommand> loadCommands;
        public List<SegmentCommand64> segments;
        public List<LoadCommand> otherLoads;
        public List<ThreadCommand> threads;
        long streamOffset;

        public Collection<? extends IMemorySource> getMemoryRangesWithOffset(long l) throws IOException {
            LinkedList<ProtectedMemoryRange> linkedList = new LinkedList<ProtectedMemoryRange>();
            for (SegmentCommand64 segmentCommand64 : this.segments) {
                if (segmentCommand64.fileSize == 0L) continue;
                if (MachoDumpReader.this._fileReader.length() < 0L || this.streamOffset + segmentCommand64.fileOffset + segmentCommand64.fileSize <= MachoDumpReader.this._fileReader.length()) {
                    linkedList.add(new DumpMemorySource(segmentCommand64.vmaddr + l, segmentCommand64.fileSize, this.streamOffset + segmentCommand64.fileOffset, MachoDumpReader.this));
                    continue;
                }
                linkedList.add(new UnbackedMemorySource(segmentCommand64.vmaddr + l, segmentCommand64.fileSize, "segment is beyond file end"));
            }
            return linkedList;
        }
    }

    public class MachHeader64 {
        public int magic;
        public int cpuType;
        public int cpuSubtype;
        public int fileType;
        public int numCommands;
        public long sizeCommands;
        public int flags;

        public MachHeader64() {
        }

        public MachHeader64(int n, int n2, int n3, int n4, int n5, long l, int n6) {
            this.magic = n;
            this.cpuType = n2;
            this.cpuSubtype = n3;
            this.fileType = n4;
            this.numCommands = n5;
            this.sizeCommands = l;
            this.flags = n6;
        }
    }
}

