/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.debugger.JniRegisters;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;

class JniThread
implements IOSThread {
    private final JniRegisters registers;
    private final Properties properties;
    private final long tid;
    private final List<IMemoryRange> memoryRanges = new LinkedList<IMemoryRange>();
    private final List<IOSStackFrame> stackFrames = new LinkedList<IOSStackFrame>();
    private boolean stackWalked = false;

    JniThread(long l, JniRegisters jniRegisters, Properties properties) {
        this.registers = jniRegisters;
        this.properties = properties;
        this.tid = l;
    }

    @Override
    public Collection<? extends IMemoryRange> getMemoryRanges() {
        if (!this.stackWalked) {
            this.walkStack();
        }
        return this.memoryRanges;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public List<? extends IRegister> getRegisters() {
        SortedMap<String, Number> sortedMap = this.registers.getRegisters();
        ArrayList<Register> arrayList = new ArrayList<Register>(this.registers.size());
        for (String string : sortedMap.keySet()) {
            Number number = (Number)sortedMap.get(string);
            System.out.println("getRegisters: name " + string + " val " + number);
            arrayList.add(new Register(string, number));
        }
        return arrayList;
    }

    @Override
    public long getInstructionPointer() {
        return this.registers.getInstructionPointer();
    }

    @Override
    public List<? extends IOSStackFrame> getStackFrames() {
        if (!this.stackWalked) {
            this.walkStack();
        }
        return this.stackFrames;
    }

    private void walkStack() {
        System.err.println("walkStack not implemented yet");
    }

    @Override
    public long getThreadId() throws CorruptDataException {
        return this.tid;
    }

    @Override
    public long getBasePointer() {
        System.err.println("getBasePointer not implemented yet");
        return 0L;
    }

    @Override
    public long getStackPointer() {
        System.err.println("getStackPointer not implemented yet");
        return 0L;
    }
}

