/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.debugger.DataEntry;
import com.ibm.j9ddr.corereaders.debugger.JniAddressSpace;
import com.ibm.j9ddr.corereaders.debugger.JniOutputStream;
import com.ibm.j9ddr.corereaders.debugger.JniRegisters;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersAMD64;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersIA32;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersPPC32;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersPPC64;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersS39031;
import com.ibm.j9ddr.corereaders.debugger.JniRegistersS39064;
import com.ibm.j9ddr.corereaders.debugger.JniSearchableMemory;
import com.ibm.j9ddr.corereaders.debugger.JniThread;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class JniProcess
extends JniSearchableMemory
implements IProcess {
    public static final int TARGET_TYPE_UNKNOWN = 0;
    public static final int TARGET_TYPE_X86_32 = 1;
    public static final int TARGET_TYPE_X86_64 = 2;
    public static final int TARGET_TYPE_S390_31 = 3;
    public static final int TARGET_TYPE_S390_64 = 4;
    public static final int TARGET_TYPE_PPC_32 = 5;
    public static final int TARGET_TYPE_PPC_64 = 6;
    public static final int TARGET_TYPE_ARM = 7;
    public static final int TARGET_TYPE_IA64 = 8;
    private final JniAddressSpace addressSpace;
    private JniRegisters _registers;
    private List<DataEntry> _threadEntries = new ArrayList<DataEntry>();

    @Override
    public native int bytesPerPointer();

    @Override
    public native int getSignalNumber() throws DataUnavailableException;

    @Override
    public native long getProcessId() throws CorruptDataException;

    public native long[] getThreadIds();

    public native int getTargetArchitecture();

    public JniProcess(JniAddressSpace jniAddressSpace) {
        this.addressSpace = jniAddressSpace;
        try {
            this._registers = this.getRegisterFile();
        }
        catch (DataUnavailableException dataUnavailableException) {
            PrintWriter printWriter = new PrintWriter(new JniOutputStream());
            dataUnavailableException.printStackTrace(printWriter);
        }
    }

    private JniRegisters getRegisterFile() throws DataUnavailableException {
        int n = this.getTargetArchitecture();
        switch (n) {
            case 1: {
                return new JniRegistersIA32();
            }
            case 2: {
                return new JniRegistersAMD64();
            }
            case 5: {
                return new JniRegistersPPC32();
            }
            case 6: {
                return new JniRegistersPPC64();
            }
            case 3: {
                return new JniRegistersS39031();
            }
            case 4: {
                return new JniRegistersS39064();
            }
        }
        throw new DataUnavailableException("Architecture type " + n + " not implemented");
    }

    @Override
    public long getPointerAt(long l) throws MemoryFault {
        return super.getPointerAt(l, this.bytesPerPointer());
    }

    @Override
    public String getCommandLine() throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public Properties getEnvironmentVariables() throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public String getProcedureNameForAddress(long l) throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public String getProcedureNameForAddress(long l, boolean bl) throws DataUnavailableException, CorruptDataException {
        throw new DataUnavailableException("not implemented yet");
    }

    @Override
    public IAddressSpace getAddressSpace() {
        return this.addressSpace;
    }

    @Override
    public IModule getExecutable() throws CorruptDataException {
        throw new CorruptDataException("Unimplemented");
    }

    @Override
    public Collection<? extends IModule> getModules() throws CorruptDataException {
        throw new CorruptDataException("Unimplemented");
    }

    @Override
    public Collection<? extends IOSThread> getThreads() throws CorruptDataException {
        ArrayList<JniThread> arrayList = new ArrayList<JniThread>(this._threadEntries.size());
        long[] lArray = this.getThreadIds();
        if (lArray == null) {
            return null;
        }
        for (long l : lArray) {
            this._registers.readRegisters(l);
            JniThread jniThread = new JniThread(l, this._registers, null);
            arrayList.add(jniThread);
        }
        return arrayList;
    }

    @Override
    public boolean isFailingProcess() throws DataUnavailableException {
        throw new DataUnavailableException("Not available here");
    }
}

