/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class Aix32Dump
extends NewAixDump {
    private static final int CONTEXT_OFFSET_IN_THREAD = 200;
    private static final int IAR_OFFSET_IN_CONTEXT = 24;
    private static final int GPR_OFFSET_IN_CONTEXT = 208;
    private static final int GPR_COUNT = 32;

    protected Aix32Dump(DumpReader dumpReader) throws IOException {
        super(dumpReader);
        this.readCore();
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return 0;
    }

    @Override
    protected long userInfoOffset() {
        return 1008L;
    }

    @Override
    protected int pointerSize() {
        return 32;
    }

    @Override
    protected Map readRegisters(long l) throws IOException {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        this.coreSeek(l + 200L + 24L);
        treeMap.put("iar", this.coreReadInt());
        treeMap.put("msr", this.coreReadInt());
        treeMap.put("cr", this.coreReadInt());
        treeMap.put("lr", this.coreReadInt());
        treeMap.put("ctr", this.coreReadInt());
        treeMap.put("xer", this.coreReadInt());
        treeMap.put("mq", this.coreReadInt());
        treeMap.put("tid", this.coreReadInt());
        treeMap.put("fpscr", this.coreReadInt());
        this.coreSeek(l + 200L + 208L);
        for (int i = 0; i < 32; ++i) {
            treeMap.put("gpr" + i, this.coreReadInt());
        }
        return treeMap;
    }

    @Override
    protected long threadSize(long l) {
        return 792L;
    }

    @Override
    protected long getStackPointerFrom(Map map) {
        return (long)((Integer)map.get("gpr1")).intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getInstructionPointerFrom(Map map) {
        return (long)((Integer)map.get("iar")).intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected long getLinkRegisterFrom(Map map) {
        return (long)((Integer)map.get("lr")).intValue() & 0xFFFFFFFFL;
    }

    @Override
    protected int sizeofTopOfStack() {
        return 144;
    }
}

