/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PointerGenerator {
    private static final String BEGIN_USER_IMPORTS = "[BEGIN USER IMPORTS]";
    private static final String END_USER_IMPORTS = "[END USER IMPORTS]";
    private static final String BEGIN_USER_CODE = "[BEGIN USER CODE]";
    private static final String END_USER_CODE = "[END USER CODE]";
    private final Map<String, String> opts = new HashMap<String, String>();
    StructureReader structureReader;
    File outputDir;
    File outputDirHelpers;
    private boolean cacheClass = false;
    private boolean cacheFields = false;
    private Properties cacheProperties = null;
    private StructureTypeManager typeManager;
    private static final Pattern offsetPattern = Pattern.compile("^(.+)_v\\d+$");
    private int errorCount = 0;
    private static final Pattern ConstPattern = Pattern.compile("\\s*\\bconst\\s+");
    private static final Pattern TypeTagPattern = Pattern.compile("\\s*\\b(class|enum|struct)\\s+");

    public PointerGenerator() {
        this.opts.put("-p", null);
        this.opts.put("-o", null);
        this.opts.put("-f", null);
        this.opts.put("-v", null);
        this.opts.put("-s", null);
        this.opts.put("-h", null);
        this.opts.put("-u", "true");
        this.opts.put("-c", "");
        this.opts.put("-l", "false");
    }

    public static void main(String[] stringArray) throws Exception {
        PointerGenerator pointerGenerator = new PointerGenerator();
        pointerGenerator.parseArgs(stringArray);
        pointerGenerator.generateClasses();
        if (pointerGenerator.errorCount == 0) {
            System.out.println("Processing complete");
        } else {
            System.out.println("Processing failed");
            System.exit(1);
        }
    }

    private void generateClasses() {
        String string = this.opts.get("-f");
        String string2 = this.opts.get("-s");
        try {
            J9DDRStructureStore j9DDRStructureStore = new J9DDRStructureStore(string, string2);
            System.out.println("superset directory name : " + string);
            System.out.println("superset file name : " + j9DDRStructureStore.getSuperSetFileName());
            InputStream object = j9DDRStructureStore.getSuperset();
            this.structureReader = new StructureReader(object);
            object.close();
        }
        catch (IOException iOException) {
            ++this.errorCount;
            System.out.println("Problem with file: " + string);
            iOException.printStackTrace();
            return;
        }
        this.outputDir = this.getOutputDir("-p");
        if (this.opts.get("-h") != null) {
            this.outputDirHelpers = this.getOutputDir("-h");
        }
        this.typeManager = new StructureTypeManager(this.structureReader.getStructures());
        for (StructureReader.StructureDescriptor structureDescriptor : this.structureReader.getStructures()) {
            String string3;
            try {
                if (FlagStructureList.isFlagsStructure(structureDescriptor.getName())) {
                    this.generateBuildFlags(structureDescriptor);
                    continue;
                }
                this.generateClass(structureDescriptor);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ++this.errorCount;
                string3 = String.format("File not found processing: %s: %s", structureDescriptor.getPointerName(), fileNotFoundException.getMessage());
                System.out.println(string3);
            }
            catch (IOException iOException) {
                ++this.errorCount;
                string3 = String.format("IOException processing: %s: %s", structureDescriptor.getPointerName(), iOException.getMessage());
                System.out.println(string3);
            }
        }
    }

    private void generateBuildFlags(StructureReader.StructureDescriptor structureDescriptor) throws IOException {
        Closeable closeable;
        File file = new File(this.outputDir, structureDescriptor.getName() + ".java");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.collectMergeData(file, arrayList, arrayList2, structureDescriptor);
        byte[] byArray = null;
        int n = 0;
        if (file.exists()) {
            n = (int)file.length();
            byArray = new byte[n];
            closeable = new FileInputStream(file);
            ((FileInputStream)closeable).read(byArray);
            ((FileInputStream)closeable).close();
        }
        closeable = new ByteArrayOutputStream(n);
        PrintWriter printWriter = new PrintWriter((OutputStream)closeable);
        PointerGenerator.writeCopyright(printWriter);
        printWriter.format("package %s;%n", this.opts.get("-p"));
        this.writeBuildFlagImports(printWriter);
        printWriter.println();
        this.writeClassComment(printWriter, structureDescriptor.getName());
        printWriter.format("public final class %s {%n", structureDescriptor.getName());
        printWriter.println();
        printWriter.println("\t// Do not instantiate constant classes");
        printWriter.format("\tprivate %s() {%n", structureDescriptor.getName());
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        this.writeBuildFlags(printWriter, structureDescriptor);
        printWriter.println();
        this.writeBuildFlagsStaticInitializer(printWriter, structureDescriptor);
        printWriter.println("}");
        printWriter.close();
        byte[] byArray2 = ((ByteArrayOutputStream)closeable).toByteArray();
        if (null == byArray || !Arrays.equals(byArray, byArray2)) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray2);
            fileOutputStream.close();
        }
    }

    private void writeBuildFlagsStaticInitializer(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        Collections.sort(structureDescriptor.getConstants());
        printWriter.println("\tstatic {");
        printWriter.println("\t\tHashMap<String, Boolean> defaultValues = new HashMap<String, Boolean>();");
        printWriter.println();
        printWriter.println("\t\t// Edit default values here");
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            printWriter.format("\t\tdefaultValues.put(\"%s\", Boolean.FALSE);%n", constantDescriptor.getName());
        }
        printWriter.println();
        printWriter.println("\t\ttry {");
        printWriter.println("\t\t\tClassLoader loader = " + structureDescriptor.getName() + ".class.getClassLoader();");
        printWriter.println("\t\t\tif (!(loader instanceof com.ibm.j9ddr.J9DDRClassLoader)) {");
        printWriter.println("\t\t\t\tthrow new IllegalArgumentException(\"Cannot determine the runtime loader\");");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t\tClass<?> runtimeClass = ((com.ibm.j9ddr.J9DDRClassLoader) loader).loadClassRelativeToStream(\"structure." + structureDescriptor.getName() + "\", false);");
        printWriter.println("\t\t\tField[] fields = runtimeClass.getFields();");
        printWriter.println("\t\t\tfor (int i = 0; i < fields.length; i++) {");
        printWriter.println("\t\t\t\tField field = fields[i];");
        printWriter.println("\t\t\t\t// Overwrite default value with real value if it exists.");
        printWriter.println("\t\t\t\tdefaultValues.put(field.getName(), field.getLong(runtimeClass) != 0);");
        printWriter.println("\t\t\t}");
        printWriter.println("\t\t} catch (ClassNotFoundException e) {");
        printWriter.println("\t\t\tthrow new IllegalArgumentException(String.format(\"Can not initialize flags from core file.%n%s\", e.getMessage()));");
        printWriter.println("\t\t} catch (IllegalAccessException e) {");
        printWriter.println("\t\t\tthrow new IllegalArgumentException(String.format(\"Can not initialize flags from core file.%n%s\", e.getMessage()));");
        printWriter.println("\t\t}");
        printWriter.println();
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            printWriter.format("\t\t%s = defaultValues.get(\"%s\");%n", constantDescriptor.getName(), constantDescriptor.getName());
        }
        printWriter.println("\t}");
    }

    private void generateClass(StructureReader.StructureDescriptor structureDescriptor) throws IOException {
        Object object;
        Closeable closeable;
        File file = new File(this.outputDir, structureDescriptor.getPointerName() + ".java");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.opts.get("-u").equals("true")) {
            this.collectMergeData(file, arrayList, arrayList2, structureDescriptor);
        } else {
            this.setCacheStatusFromPropertyFile(structureDescriptor);
        }
        if (this.cacheClass || this.cacheFields) {
            System.out.println("Caching enabled for " + structureDescriptor.getName() + "=" + this.cacheClass + "," + this.cacheFields);
        }
        int n = 0;
        byte[] byArray = null;
        if (file.exists()) {
            n = (int)file.length();
            byArray = new byte[n];
            closeable = new FileInputStream(file);
            ((FileInputStream)closeable).read(byArray);
            ((FileInputStream)closeable).close();
        }
        closeable = new ByteArrayOutputStream(n);
        PrintWriter printWriter = new PrintWriter((OutputStream)closeable);
        PointerGenerator.writeCopyright(printWriter);
        printWriter.println();
        this.writeGeneratedWarning(printWriter);
        printWriter.format("package %s;%n", this.opts.get("-p"));
        printWriter.println();
        if (this.opts.get("-u").equals("true")) {
            PointerGenerator.writerUserData(BEGIN_USER_IMPORTS, END_USER_IMPORTS, arrayList, printWriter);
        }
        printWriter.println();
        this.writeImports(printWriter, structureDescriptor);
        printWriter.println();
        this.writeClassComment(printWriter, structureDescriptor.getPointerName());
        printWriter.format("@com.ibm.j9ddr.GeneratedPointerClass(structureClass=%s.class)", structureDescriptor.getName());
        printWriter.println();
        String string = structureDescriptor.getSuperName();
        if (string.isEmpty()) {
            string = "Structure";
        }
        printWriter.format("public class %s extends %sPointer {%n", structureDescriptor.getPointerName(), string);
        printWriter.println();
        printWriter.println("\t// NULL");
        printWriter.format("\tpublic static final %s NULL = new %s(0);%n", structureDescriptor.getPointerName(), structureDescriptor.getPointerName());
        printWriter.println();
        if (this.cacheClass) {
            printWriter.println("\t// Class Cache");
            if (this.opts.get("-u").equals("false")) {
                printWriter.println("\tprivate static final boolean CACHE_CLASS = true;");
            }
            printWriter.format("\tprivate static HashMap<Long, %s> CLASS_CACHE = new HashMap<Long, %s>();%n", structureDescriptor.getPointerName(), structureDescriptor.getPointerName());
            printWriter.println();
        }
        if (this.cacheFields && this.opts.get("-u").equals("false")) {
            printWriter.println("\tprivate static final boolean CACHE_FIELDS = true;");
        }
        if (this.opts.get("-u").equals("true")) {
            PointerGenerator.writerUserData(BEGIN_USER_CODE, END_USER_CODE, arrayList2, printWriter);
        }
        printWriter.println();
        this.writeConstructor(printWriter, structureDescriptor);
        if (this.cacheClass) {
            printWriter.println("\t// Caching support methods");
            printWriter.println();
            this.generateCacheSupportMethods(printWriter, structureDescriptor);
        }
        printWriter.println("\t// Implementation methods");
        printWriter.println();
        this.generateImplementationMethods(printWriter, structureDescriptor);
        printWriter.println("}");
        printWriter.close();
        byte[] byArray2 = ((ByteArrayOutputStream)closeable).toByteArray();
        if (null == byArray || !Arrays.equals(byArray, byArray2)) {
            object = new FileOutputStream(file);
            ((FileOutputStream)object).write(byArray2);
            ((FileOutputStream)object).close();
        }
        if (this.outputDirHelpers != null && arrayList2.size() > 4) {
            object = new File(this.outputDirHelpers, structureDescriptor.getPointerName() + ".java");
            PrintWriter printWriter2 = new PrintWriter((File)object);
            for (String string2 : arrayList) {
                printWriter2.println(string2);
            }
            for (String string2 : arrayList2) {
                printWriter2.println(string2);
            }
            printWriter2.close();
        }
    }

    private void setCacheStatusFromPropertyFile(StructureReader.StructureDescriptor structureDescriptor) {
        String string = this.opts.get("-c");
        if (string == null || string.length() == 0) {
            this.cacheClass = false;
            this.cacheFields = false;
        } else {
            Object object;
            Object object2;
            if (this.cacheProperties == null) {
                this.cacheProperties = new Properties();
                object2 = new File(string);
                if (((File)object2).exists()) {
                    try {
                        object = new FileInputStream((File)object2);
                        this.cacheProperties.load((InputStream)object);
                    }
                    catch (Exception exception) {
                        String string2 = String.format("The cache properties file [%s] specified by the -c option could not be read", ((File)object2).getAbsolutePath());
                        throw new IllegalArgumentException(string2, exception);
                    }
                } else {
                    String string3 = String.format("The cache properties file [%s] specified by the -c option does not exist", ((File)object2).getAbsolutePath());
                    throw new IllegalArgumentException(string3);
                }
            }
            if (((String[])(object = ((String)(object2 = this.cacheProperties.getProperty(structureDescriptor.getName(), "false,false"))).split(","))).length != 2) {
                String string4 = String.format("The cache properties file [%s] contains an invalid setting for the key [%s]. The value should be in the format <boolean>,<boolean>", string);
                throw new IllegalArgumentException(string4);
            }
            this.cacheClass = Boolean.parseBoolean(object[0]);
            this.cacheFields = Boolean.parseBoolean(object[1]);
        }
    }

    private void generateCacheSupportMethods(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        if (this.cacheClass) {
            printWriter.format("\tprivate static void setCache(Long address, %s clazz) {%n", structureDescriptor.getPointerName());
            printWriter.format("\t\tCLASS_CACHE.put(address, clazz);%n", new Object[0]);
            printWriter.format("\t}%n", new Object[0]);
            printWriter.println();
            printWriter.format("\tprivate static %s checkCache(Long address) {%n", structureDescriptor.getPointerName());
            printWriter.format("\t\treturn CLASS_CACHE.get(address);%n", new Object[0]);
            printWriter.format("\t}%n", new Object[0]);
            printWriter.println();
        }
    }

    private void writeBuildFlags(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        printWriter.println("\t// Build Flags");
        Collections.sort(structureDescriptor.getConstants());
        for (StructureReader.ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
            printWriter.format("\tpublic static final boolean %s;%n", constantDescriptor.getName());
        }
    }

    private void collectMergeData(File file, List<String> list, List<String> list2, StructureReader.StructureDescriptor structureDescriptor) throws IOException {
        if (file.exists()) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.contains(BEGIN_USER_IMPORTS)) {
                    PointerGenerator.collectUserData(list, bufferedReader, END_USER_IMPORTS);
                    continue;
                }
                if (!string.contains(BEGIN_USER_CODE)) continue;
                PointerGenerator.collectUserData(list2, bufferedReader, END_USER_CODE);
            }
            bufferedReader.close();
        }
        this.cacheClass = false;
        this.cacheFields = false;
        for (String string : list2) {
            int n = 0;
            n = string.indexOf("private static final boolean CACHE_FIELDS");
            if (n != -1) {
                this.cacheFields |= PointerGenerator.getFlagValue(string, n);
            }
            if ((n = string.indexOf("private static final boolean CACHE_CLASS")) == -1) continue;
            this.cacheClass |= PointerGenerator.getFlagValue(string, n);
        }
    }

    private static boolean getFlagValue(String string, int n) {
        int n2;
        int n3 = string.indexOf("=", n);
        if (n3 != -1 && (n2 = string.indexOf(";", n3)) != -1) {
            String string2 = string.substring(n3 + 1, n2).trim();
            return Boolean.parseBoolean(string2);
        }
        return false;
    }

    private static void collectUserData(List<String> list, BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        while ((string2 = bufferedReader.readLine()) != null && !string2.contains(string)) {
            list.add(string2);
        }
    }

    private static void writerUserData(String string, String string2, List<String> list, PrintWriter printWriter) {
        printWriter.print("/*");
        printWriter.print(string);
        printWriter.println("*/");
        for (String string3 : list) {
            printWriter.println(string3);
        }
        printWriter.print("/*");
        printWriter.print(string2);
        printWriter.println("*/");
    }

    private void writeGeneratedWarning(PrintWriter printWriter) {
        printWriter.println("/**");
        printWriter.println(" * WARNING!!! GENERATED FILE");
        printWriter.println(" *");
        printWriter.println(" * This class is generated.");
        printWriter.println(" * Do not use the Eclipse \"Organize Imports\" feature on this class.");
        if (this.opts.get("-u").equals("true")) {
            printWriter.println(" *");
            printWriter.println(" * It can contain user content, but that content must be delimited with the");
            printWriter.println(" * the tags");
            printWriter.println(" * [BEGIN USER IMPORTS]");
            printWriter.println(" * [END USER IMPORTS]");
            printWriter.println(" *");
            printWriter.println(" * or");
            printWriter.println(" *");
            printWriter.println(" * [BEGIN USER CODE]");
            printWriter.println(" * [END USER CODE]");
            printWriter.println(" *");
            printWriter.println(" * These tags are entered as comments.  Characters before [ and after ] are ignored.");
            printWriter.println(" * Lines between the tags are inserted into the newly generated file.");
            printWriter.println(" *");
            printWriter.println(" * IMPORTS are combined and inserted above newly generated imports.  CODE is combined");
            printWriter.println(" * and inserted immediately after the class declaration");
            printWriter.println(" *");
            printWriter.println(" * All lines outside these tags are lost and replaced with newly generated code.");
        }
        printWriter.println(" */");
    }

    private void writeClassComment(PrintWriter printWriter, String string) {
        printWriter.println("/**");
        printWriter.format(" * Structure: %s%n", string);
        printWriter.println(" *");
        printWriter.println(" * A generated implementation of a VM structure");
        printWriter.println(" *");
        if (this.opts.get("-u").equals("true")) {
            printWriter.println(" * This class contains generated code and MAY contain hand written user code.");
            printWriter.println(" *");
            printWriter.println(" * Hand written user code must be contained at the top of");
            printWriter.println(" * the class file, specifically above");
            printWriter.println(" * the comment line containing WARNING!!! GENERATED CODE");
            printWriter.println(" *");
            printWriter.println(" * ALL code below the GENERATED warning will be replaced with new generated code");
            printWriter.println(" * each time the PointerGenerator utility is run.");
            printWriter.println(" *");
            printWriter.format(" * The generated code will provide getters for all elements in the %s%n", string);
            printWriter.println(" * structure.  Where possible, meaningful return types are inferred.");
            printWriter.println(" *");
            printWriter.println(" * The user may add methods to provide meaningful return types where only pointers");
            printWriter.println(" * could be automatically inferred.");
        } else {
            printWriter.println(" * Do not place hand written user code in this class as it will be overwritten.");
        }
        printWriter.println(" */");
    }

    private void generateImplementationMethods(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        Collections.sort(structureDescriptor.getFields());
        block23: for (StructureReader.FieldDescriptor fieldDescriptor : structureDescriptor.getFields()) {
            if (PointerGenerator.omitFieldImplementation(structureDescriptor, fieldDescriptor)) continue;
            String string = fieldDescriptor.getType();
            int n = this.typeManager.getType(string);
            switch (n) {
                case 120: {
                    this.writeStructureMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 121: {
                    this.writeStructurePointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 110: {
                    this.writePointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 113: {
                    this.writeArrayMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 111: {
                    this.writeSRPMethod(printWriter, structureDescriptor, fieldDescriptor, false);
                    continue block23;
                }
                case 112: {
                    this.writeSRPMethod(printWriter, structureDescriptor, fieldDescriptor, true);
                    continue block23;
                }
                case 114: {
                    this.writeSRPPointerMethod(printWriter, structureDescriptor, fieldDescriptor, false);
                    continue block23;
                }
                case 115: {
                    this.writeSRPPointerMethod(printWriter, structureDescriptor, fieldDescriptor, true);
                    continue block23;
                }
                case 130: {
                    this.writeFJ9ObjectMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 131: {
                    this.writeFJ9ObjectPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 132: {
                    this.writeJ9ObjectClassMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 133: {
                    this.writeJ9ObjectClassPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 134: {
                    this.writeJ9ObjectMonitorMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 135: {
                    this.writeJ9ObjectMonitorPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 0: {
                    this.writeStructureMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 100: {
                    this.writeBoolMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 102: {
                    this.writeDoubleMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 103: {
                    this.writeFloatMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 101: {
                    this.writeEnumMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 105: {
                    this.writeEnumPointerMethod(printWriter, structureDescriptor, fieldDescriptor);
                    continue block23;
                }
                case 104: {
                    int n2 = string.indexOf(58);
                    if (n2 == -1) {
                        throw new IllegalArgumentException(String.format("%s is not a bitfield", fieldDescriptor));
                    }
                    this.writeBitFieldMethod(printWriter, structureDescriptor, fieldDescriptor, n, fieldDescriptor.getName());
                    continue block23;
                }
            }
            if (1 <= n && n <= 99) {
                this.writeSimpleTypeMethod(printWriter, structureDescriptor, fieldDescriptor, n);
                continue;
            }
            String string2 = String.format("Unhandled structure type: %s->%s %s", structureDescriptor.getPointerName(), fieldDescriptor.getName(), string);
            System.out.println(string2);
        }
    }

    private void writeSRPPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        String string;
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        String string4 = string = bl ? "WideSelfRelativePointer" : "SelfRelativePointer";
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string2);
            printWriter.format("\t\t\t\t%s_cache = %s.cast(getPointerAtOffset(%s._%sOffset_));%n", string2, string, structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(getPointerAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string3);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeBitFieldMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, int n, String string) {
        CTypeParser cTypeParser = new CTypeParser(fieldDescriptor.getType());
        String string2 = cTypeParser.getCoreType();
        if (string.length() == 0) {
            printWriter.format("\t// %s %s%n", fieldDescriptor.getDeclaredType(), fieldDescriptor.getName());
            printWriter.println();
            return;
        }
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string2, string);
        }
        this.writeMethodSignature(printWriter, string2, string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = get%sBitfield(%s._%s_s_, %s._%s_b_);%n", string, string2, structureDescriptor.getName(), string, structureDescriptor.getName(), string);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn get%sBitfield(%s._%s_s_, %s._%s_b_);%n", string2, structureDescriptor.getName(), string, structureDescriptor.getName(), string);
        if (this.cacheFields) {
            printWriter.println("\t\t}");
        }
        this.writeMethodClose(printWriter);
    }

    static boolean omitFieldImplementation(StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = structureDescriptor.getPointerName() + "." + fieldDescriptor.getName();
        return string.contains("#");
    }

    private void writeMethodSignature(PrintWriter printWriter, String string, String string2, StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        printWriter.format("\t// %s %s%n", fieldDescriptor.getDeclaredType(), fieldDescriptor.getDeclaredName());
        if (bl) {
            printWriter.format("\t@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName=\"_%sOffset_\", declaredType=\"%s\")", this.getOffsetConstant(fieldDescriptor), fieldDescriptor.getDeclaredType());
            printWriter.println();
        }
        printWriter.format("\tpublic %s %s() throws CorruptDataException {%n", string, string2);
    }

    private void writeEAMethod(PrintWriter printWriter, String string, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %sEA_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2 + "EA", fieldDescriptor, false);
        this.writeZeroCheck(printWriter);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%sEA_cache == null) {%n", string2);
            printWriter.format("\t\t\t\t%sEA_cache = %s.cast(address + %s._%sOffset_);%n", string2, string, structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %sEA_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(address + %s._%sOffset_);%n", string, structureDescriptor.getName(), string3);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
    }

    private void writeZeroCheck(PrintWriter printWriter) {
        printWriter.format("\t\tif (address == 0) {%n", new Object[0]);
        printWriter.format("\t\t\tthrow new NullPointerDereference();%n", new Object[0]);
        printWriter.format("\t\t}%n", new Object[0]);
        printWriter.println();
    }

    private void writeEnumEAMethod(PrintWriter printWriter, String string, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        String string4 = PointerGenerator.getEnumType(fieldDescriptor.getType());
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %sEA_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2 + "EA", fieldDescriptor, false);
        this.writeZeroCheck(printWriter);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%sEA_cache == null) {%n", string2);
            printWriter.format("\t\t\t\t%sEA_cache = %s.cast(address + %s._%sOffset_, %s.class);%n", string2, string, structureDescriptor.getName(), string3, string4);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %sEA_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(address + %s._%sOffset_, %s.class);%n", string, structureDescriptor.getName(), string3, string4);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
    }

    private String getOffsetConstant(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        if (this.opts.get("-l").equals("true")) {
            return PointerGenerator.getOffsetConstant(string);
        }
        return string;
    }

    public static String getOffsetConstant(String string) {
        Matcher matcher = offsetPattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return string;
    }

    private void writeSRPEAMethod(PrintWriter printWriter, String string, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %sEA_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2 + "EA", fieldDescriptor, false);
        this.writeZeroCheck(printWriter);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%sEA_cache == null) {%n", string2);
            printWriter.format("\t\t\t\t%sEA_cache = %s.cast(address + (%s._%sOffset_ + getIntAtOffset(%s._%sOffset_)));%n", string2, string, structureDescriptor.getName(), string3, structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %sEA_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(address + %s._%sOffset_);%n", string, structureDescriptor.getName(), string3, structureDescriptor.getName(), string3);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
    }

    private void writeMethodClose(PrintWriter printWriter) {
        printWriter.println("\t}");
        printWriter.println();
    }

    private void writePointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        String string3 = PointerGenerator.getPointerType(fieldDescriptor.getType());
        String string4 = PointerGenerator.generalizeSimplePointer(string3);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string3, string);
        }
        this.writeMethodSignature(printWriter, string4, string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = %s.cast(getPointerAtOffset(%s._%sOffset_));%n", string, string3, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(getPointerAtOffset(%s._%sOffset_));%n", string3, structureDescriptor.getName(), string2);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private static String getPointerType(String string) {
        int n;
        String string2 = ConstPattern.matcher(string).replaceAll("").trim();
        if (string2.indexOf(42, (n = string2.indexOf(42)) + 1) > 0) {
            return "PointerPointer";
        }
        if ((string2 = string2.substring(0, n).trim()).equals("bool")) {
            return "BoolPointer";
        }
        if (string2.equals("double")) {
            return "DoublePointer";
        }
        if (string2.equals("float")) {
            return "FloatPointer";
        }
        if (string2.equals("void")) {
            return "VoidPointer";
        }
        return string2 + "Pointer";
    }

    private void writeArrayMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        try {
            String string = this.getArrayType(fieldDescriptor.getType());
            if (string.equals("EnumPointer")) {
                this.writeEnumEAMethod(printWriter, string, structureDescriptor, fieldDescriptor);
            } else {
                this.writeEAMethod(printWriter, string, structureDescriptor, fieldDescriptor);
            }
        }
        catch (RuntimeException runtimeException) {
            ++this.errorCount;
            if (this.errorCount < 100) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
    }

    private static String getEnumType(String string) {
        int n = 0;
        int n2 = string.length();
        if (string.startsWith("enum ")) {
            n = "enum ".length();
        }
        if (string.endsWith("[]")) {
            n2 -= 2;
        }
        return string.substring(n, n2);
    }

    private String getArrayType(String string) {
        String string2 = string.substring(0, string.lastIndexOf(91)).trim();
        int n = this.typeManager.getType(string2);
        switch (n) {
            case 100: {
                return "BoolPointer";
            }
            case 101: {
                return "EnumPointer";
            }
            case 102: {
                return "DoublePointer";
            }
            case 103: {
                return "FloatPointer";
            }
            case 104: {
                break;
            }
            case 110: 
            case 113: 
            case 121: 
            case 131: 
            case 133: 
            case 135: {
                return "PointerPointer";
            }
            case 111: 
            case 112: {
                break;
            }
            case 120: {
                return PointerGenerator.removeTypeTags(string2) + "Pointer";
            }
            case 130: {
                return "ObjectReferencePointer";
            }
            case 132: {
                return "ObjectClassReferencePointer";
            }
            case 134: {
                return "ObjectMonitorReferencePointer";
            }
            default: {
                if (1 > n || n > 99) break;
                return string2 + "Pointer";
            }
        }
        throw new IllegalArgumentException("Type is not a recognized array: " + string);
    }

    private void writeBoolMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate Boolean %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "boolean", string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = new Boolean(getBoolAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache.booleanValue();%n", string);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn getBoolAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string2);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "BoolPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeDoubleMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate Double %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "double", string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = new Double(getDoubleAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache.doubleValue();%n", string);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn getDoubleAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string2);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "DoublePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeEnumMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        String string3 = PointerGenerator.getEnumType(fieldDescriptor.getType());
        if (this.cacheFields) {
            printWriter.format("\tprivate Long %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "long", string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\tif (%s.SIZEOF == 1) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = new Long(getByteAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t\t} else if (%s.SIZEOF == 2) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = new Long(getShortAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t\t} else if (%s.SIZEOF == 4) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = new Long(getIntAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t\t} else if (%s.SIZEOF == 8) {%n", string3);
            printWriter.format("\t\t\t\t\t%s_cache = new Long(getLongAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t\t} else {%n", new Object[0]);
            printWriter.format("\t\t\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
            printWriter.format("\t\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache.longValue();%n", string);
            printWriter.format("\t\t} else {%n", new Object[0]);
        }
        printWriter.format("\t\t\tif (%s.SIZEOF == 1) {%n", string3);
        printWriter.format("\t\t\t\treturn getByteAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string2);
        printWriter.format("\t\t\t} else if (%s.SIZEOF == 2) {%n", string3);
        printWriter.format("\t\t\t\treturn getShortAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string2);
        printWriter.format("\t\t\t} else if (%s.SIZEOF == 4) {%n", string3);
        printWriter.format("\t\t\t\treturn getIntAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string2);
        printWriter.format("\t\t\t} else if (%s.SIZEOF == 8) {%n", string3);
        printWriter.format("\t\t\t\treturn getLongAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string2);
        printWriter.format("\t\t\t} else {%n", new Object[0]);
        printWriter.format("\t\t\t\tthrow new IllegalArgumentException(\"Unexpected ENUM size in core file\");%n", new Object[0]);
        printWriter.format("\t\t\t}%n", new Object[0]);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEnumEAMethod(printWriter, "EnumPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeEnumPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        String string3 = "EnumPointer";
        String string4 = fieldDescriptor.getType();
        String string5 = PointerGenerator.getEnumType(string4.substring(0, string4.indexOf(42)));
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string3, string);
        }
        this.writeMethodSignature(printWriter, string3, string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = %s.cast(getPointerAtOffset(%s._%sOffset_), %s.class);%n", string, string3, structureDescriptor.getName(), string2, string5);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(getPointerAtOffset(%s._%sOffset_), %s.class);%n", string3, structureDescriptor.getName(), string2, string5);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeFloatMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate Float %s_cache;%n", string);
        }
        this.writeMethodSignature(printWriter, "float", string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = new Float(getFloatAtOffset(%s._%sOffset_));%n", string, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache.floatValue();%n", string);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn getFloatAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string2);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "FloatPointer", structureDescriptor, fieldDescriptor);
    }

    private static String generalizeSimpleType(String string) {
        if ("I32".equals(string) || "I64".equals(string)) {
            return "IDATA";
        }
        if ("U32".equals(string) || "U64".equals(string)) {
            return "UDATA";
        }
        return string;
    }

    private static String generalizeSimplePointer(String string) {
        if ("I32Pointer".equals(string) || "I64Pointer".equals(string)) {
            return "IDATAPointer";
        }
        if ("U32Pointer".equals(string) || "U64Pointer".equals(string)) {
            return "UDATAPointer";
        }
        return string;
    }

    private void writeSimpleTypeMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, int n) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        String string3 = fieldDescriptor.getType();
        String string4 = PointerGenerator.generalizeSimpleType(string3);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string3, string);
        }
        this.writeMethodSignature(printWriter, string4, string, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\t%s_cache = new %s(%s(%s._%sOffset_));%n", string, string3, StructureTypeManager.simpleTypeAccessorMap.get(n), structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn new %s(%s(%s._%sOffset_));%n", string3, StructureTypeManager.simpleTypeAccessorMap.get(n), structureDescriptor.getName(), string2);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, string4 + "Pointer", structureDescriptor, fieldDescriptor);
    }

    private static String removeTypeTags(String string) {
        return TypeTagPattern.matcher(string).replaceAll("").trim();
    }

    private void writeSRPMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        String string = fieldDescriptor.getName();
        String string2 = this.getOffsetConstant(fieldDescriptor);
        String string3 = fieldDescriptor.getType();
        String string4 = bl ? "J9WSRP" : "J9SRP";
        int n = string4.length();
        String string5 = bl ? "getPointerAtOffset" : "getIntAtOffset";
        String string6 = null;
        string6 = string3.startsWith(string4) && string3.startsWith("(", n) ? string3.substring(n + 1, string3.length() - 1).trim() : "void";
        int n2 = this.typeManager.getType(string6);
        String string7 = null;
        switch (n2) {
            case 120: {
                string7 = PointerGenerator.removeTypeTags(string6) + "Pointer";
                break;
            }
            case 0: {
                string7 = "VoidPointer";
                break;
            }
            case 111: {
                string7 = "SelfRelativePointer";
                break;
            }
            case 112: {
                string7 = "WideSelfRelativePointer";
                break;
            }
            default: {
                if (1 <= n2 && n2 <= 99) {
                    string7 = string6 + "Pointer";
                    break;
                }
                throw new RuntimeException("Unexpected SRP reference type: " + n2 + " from " + string3);
            }
        }
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string7, string);
        }
        this.writeMethodSignature(printWriter, string7, string, fieldDescriptor, true);
        this.writeZeroCheck(printWriter);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string);
            printWriter.format("\t\t\t\tlong nextAddress = %s(%s._%sOffset_);%n", string5, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t\tif (nextAddress == 0) {%n", new Object[0]);
            printWriter.format("\t\t\t\t\t%s_cache = %s.NULL;%n", string, string7);
            printWriter.format("\t\t\t\t} else {%n", new Object[0]);
            printWriter.format("\t\t\t\t\t%s_cache = %s.cast(address + (%s._%sOffset_ + nextAddress));%n", string, string7, structureDescriptor.getName(), string2);
            printWriter.format("\t\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string);
            printWriter.format("\t\t}%n", new Object[0]);
        }
        printWriter.format("\t\tlong nextAddress = %s(%s._%sOffset_);%n", string5, structureDescriptor.getName(), string2);
        printWriter.format("\t\tif (nextAddress == 0) {%n", new Object[0]);
        printWriter.format("\t\t\treturn %s.NULL;%n", string7);
        printWriter.format("\t\t}%n", new Object[0]);
        printWriter.format("\t\treturn %s.cast(address + (%s._%sOffset_ + nextAddress));%n", string7, structureDescriptor.getName(), string2);
        this.writeMethodClose(printWriter);
        this.writeSRPEAMethod(printWriter, bl ? "WideSelfRelativePointer" : "SelfRelativePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeStructurePointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getType();
        String string2 = string.substring(0, string.indexOf(42));
        String string3 = PointerGenerator.removeTypeTags(string2) + "Pointer";
        String string4 = fieldDescriptor.getName();
        String string5 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string3, string4);
        }
        this.writeMethodSignature(printWriter, string3, string4, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string4);
            printWriter.format("\t\t\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string5);
            printWriter.format("\t\t\t\t%s_cache = %s.cast(pointer);%n", string4, string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string4);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string5);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(pointer);%n", string3);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeFJ9ObjectMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "J9ObjectPointer";
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string2);
            printWriter.format("\t\t\t\t%s_cache = getObjectReferenceAtOffset(%s._%sOffset_);%n", string2, structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn getObjectReferenceAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string3);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "ObjectReferencePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeFJ9ObjectPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "ObjectReferencePointer";
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string2);
            printWriter.format("\t\t\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t\t%s_cache = %s.cast(pointer);%n", string2, string);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\tlong pointer = getPointerAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string3);
        printWriter.format("\t\t\treturn %s.cast(pointer);%n", string);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectClassMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "J9ClassPointer";
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string2);
            printWriter.format("\t\t\t\t%s_cache = getObjectClassAtOffset(%s._%sOffset_);%n", string2, structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn getObjectClassAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string3);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "ObjectClassReferencePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectClassPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "ObjectClassReferencePointer";
        String string2 = fieldDescriptor.getName();
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        printWriter.format("\t\t// j9objectclass_t* method goes here%n", new Object[0]);
        printWriter.format("\t\treturn null;%n", new Object[0]);
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "J9ObjectMonitorPointer";
        String string2 = fieldDescriptor.getName();
        String string3 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string, string2);
        }
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string2);
            printWriter.format("\t\t\t\t%s_cache = getObjectMonitorAtOffset(%s._%sOffset_);%n", string2, structureDescriptor.getName(), string3);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string2);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn getObjectMonitorAtOffset(%s._%sOffset_);%n", structureDescriptor.getName(), string3);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "ObjectMonitorReferencePointer", structureDescriptor, fieldDescriptor);
    }

    private void writeJ9ObjectMonitorPointerMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = "ObjectMonitorReferencePointer";
        String string2 = fieldDescriptor.getName();
        this.writeMethodSignature(printWriter, string, string2, fieldDescriptor, true);
        printWriter.format("\t\t// j9objectmonitor_t* method goes here%n", new Object[0]);
        printWriter.format("\t\treturn null;%n", new Object[0]);
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeStructureMethod(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor, StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getType();
        String string2 = string.equals("void") ? "VoidPointer" : PointerGenerator.removeTypeTags(string) + "Pointer";
        String string3 = fieldDescriptor.getName();
        String string4 = this.getOffsetConstant(fieldDescriptor);
        if (this.cacheFields) {
            printWriter.format("\tprivate %s %s_cache;%n", string2, string3);
        }
        this.writeMethodSignature(printWriter, string2, string3, fieldDescriptor, true);
        this.writeZeroCheck(printWriter);
        if (this.cacheFields) {
            printWriter.format("\t\tif (CACHE_FIELDS) {%n", new Object[0]);
            printWriter.format("\t\t\tif (%s_cache == null) {%n", string3);
            printWriter.format("\t\t\t\t%s_cache = %s.cast(address + %s._%sOffset_);%n", string3, string2, structureDescriptor.getName(), string4);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn %s_cache;%n", string3);
            printWriter.format("\t\t} else {%n\t", new Object[0]);
        }
        printWriter.format("\t\treturn %s.cast(address + %s._%sOffset_);%n", string2, structureDescriptor.getName(), string4);
        if (this.cacheFields) {
            printWriter.format("\t\t}%n", new Object[0]);
        }
        this.writeMethodClose(printWriter);
        this.writeEAMethod(printWriter, "PointerPointer", structureDescriptor, fieldDescriptor);
    }

    private void writeConstructor(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        String string = structureDescriptor.getPointerName();
        String string2 = structureDescriptor.getName();
        printWriter.println("\t// Do not call this constructor.  Use static method cast instead.");
        printWriter.format("\tprotected %s(long address) {%n", string);
        printWriter.println("\t\tsuper(address);");
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic static %s cast(AbstractPointer structure) {%n", string);
        printWriter.format("\t\treturn cast(structure.getAddress());%n", new Object[0]);
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic static %s cast(UDATA udata) {%n", string);
        printWriter.format("\t\treturn cast(udata.longValue());%n", new Object[0]);
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic static %s cast(long address) {%n", string);
        printWriter.format("\t\tif (address == 0) {%n", new Object[0]);
        printWriter.format("\t\t\treturn NULL;%n", new Object[0]);
        printWriter.format("\t\t}%n", new Object[0]);
        printWriter.println();
        if (this.cacheClass) {
            printWriter.format("\t\tif (CACHE_CLASS) {%n", new Object[0]);
            printWriter.format("\t\t\t%s clazz = checkCache(address);%n", string);
            printWriter.format("\t\t\tif (null == clazz) {%n", new Object[0]);
            printWriter.format("\t\t\t\tclazz = new %s(address);%n", string, string);
            printWriter.format("\t\t\t\tsetCache(address, clazz);%n", new Object[0]);
            printWriter.format("\t\t\t}%n", new Object[0]);
            printWriter.format("\t\t\treturn clazz;%n", new Object[0]);
            printWriter.format("\t\t}%n", new Object[0]);
        }
        printWriter.format("\t\treturn new %s(address);%n", string, string);
        printWriter.println("\t}");
        printWriter.println();
        printWriter.format("\tpublic %s add(long count) {%n", string);
        printWriter.format("\t\treturn %s.cast(address + (%s.SIZEOF * count));%n", string, string2);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s add(Scalar count) {%n", string);
        printWriter.format("\t\treturn add(count.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s addOffset(long offset) {%n", string);
        printWriter.format("\t\treturn %s.cast(address + offset);%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s addOffset(Scalar offset) {%n", string);
        printWriter.format("\t\treturn addOffset(offset.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s sub(long count) {%n", string);
        printWriter.format("\t\treturn %s.cast(address - (%s.SIZEOF * count));%n", string, string2);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s sub(Scalar count) {%n", string);
        printWriter.format("\t\treturn sub(count.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s subOffset(long offset) {%n", string);
        printWriter.format("\t\treturn %s.cast(address - offset);%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s subOffset(Scalar offset) {%n", string);
        printWriter.format("\t\treturn subOffset(offset.longValue());%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s untag(long mask) {%n", string);
        printWriter.format("\t\treturn %s.cast(address & ~mask);%n", string);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tpublic %s untag() {%n", string);
        printWriter.format("\t\treturn untag(UDATA.SIZEOF - 1);%n", new Object[0]);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
        printWriter.format("\tprotected long sizeOfBaseType() {%n", new Object[0]);
        printWriter.format("\t\treturn %s.SIZEOF;%n", string2);
        printWriter.format("\t}%n", new Object[0]);
        printWriter.println();
    }

    private void writeImports(PrintWriter printWriter, StructureReader.StructureDescriptor structureDescriptor) {
        if (structureDescriptor.getFields().size() > 0) {
            printWriter.println("import com.ibm.j9ddr.CorruptDataException;");
            printWriter.println("import com.ibm.j9ddr.NullPointerDereference;");
        }
        String string = this.opts.get("-v");
        printWriter.println(String.format("import com.ibm.j9ddr.vm%s.pointer.*;", string));
        printWriter.println(String.format("import com.ibm.j9ddr.vm%s.structure.*;", string));
        printWriter.println(String.format("import com.ibm.j9ddr.vm%s.types.*;", string));
        if (this.cacheClass) {
            printWriter.println("import java.util.HashMap;");
        }
    }

    private void writeBuildFlagImports(PrintWriter printWriter) {
        printWriter.println("import java.util.HashMap;");
        printWriter.println("import java.lang.reflect.Field;");
    }

    private void parseArgs(String[] stringArray) {
        if (stringArray.length == 0 || stringArray.length % 2 != 0) {
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (this.opts.containsKey(stringArray[i])) {
                this.opts.put(stringArray[i], stringArray[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + stringArray[i]);
            PointerGenerator.printHelp();
            System.exit(1);
        }
        for (String string : this.opts.keySet()) {
            String string2 = this.opts.get(string);
            if (string2 != null || string.equals("-s") || string.equals("-h")) continue;
            System.err.println("The option " + string + " has not been set.\n");
            PointerGenerator.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava PointerGenerator -p <package name> -o <output path> -f <path to structure file> -v <vm version> [-s <superset file name> -h <helper class package> -u <user code support> -c <cache properties> -l <legacy mode>]\n");
        System.out.println("<package name>           : the package name for all the generated classes e.g. com.ibm.j9ddr.vm.pointer.generated");
        System.out.println("<relative output path>   : where to write out the class files.  Full path to base of package hierarchy e.g. c:\\src\\");
        System.out.println("<path to structure file> : full path to the J9 structure file");
        System.out.println("<vm version>             : the version of the VM for which the pointers are generated e.g. 23 and corresponds to the stub package name");
        System.out.println("<superset file name>     : optional filename of the superset to be used as input / output");
        System.out.println("<helper class package>   : optional package for pointer helper files to be generated in from user code");
        System.out.println("<user code support>      : optional set to true or false to enable or disable user code support in the generated pointers, default if not specified is true");
        System.out.println("<cache properties>       : optional properties file which controls the class and field caching of generated pointers");
        System.out.println("<legacy mode>            : optional flag set to true or false indicating if legacy DDR is used");
    }

    private File getOutputDir(String string) {
        String string2 = this.opts.get("-o").replace('\\', '/');
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        string2 = string2 + this.opts.get(string).replace('.', '/');
        System.out.println("Writing generated classes to " + string2);
        File file = new File(string2);
        file.mkdirs();
        return file;
    }

    private static void writeCopyright(PrintWriter printWriter) {
        int n = Calendar.getInstance().get(1);
        printWriter.println("/*******************************************************************************");
        printWriter.println(" * Copyright (c) 1991, " + n + " IBM Corp. and others");
        printWriter.println(" *");
        printWriter.println(" * This program and the accompanying materials are made available under");
        printWriter.println(" * the terms of the Eclipse Public License 2.0 which accompanies this");
        printWriter.println(" * distribution and is available at https://www.eclipse.org/legal/epl-2.0/");
        printWriter.println(" * or the Apache License, Version 2.0 which accompanies this distribution");
        printWriter.println(" * and is available at https://www.apache.org/licenses/LICENSE-2.0.");
        printWriter.println(" *");
        printWriter.println(" * This Source Code may also be made available under the following");
        printWriter.println(" * Secondary Licenses when the conditions for such availability set");
        printWriter.println(" * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU");
        printWriter.println(" * General Public License, version 2 with the GNU Classpath");
        printWriter.println(" * Exception [1] and GNU General Public License, version 2 with the");
        printWriter.println(" * OpenJDK Assembly Exception [2].");
        printWriter.println(" *");
        printWriter.println(" * [1] https://www.gnu.org/software/classpath/license.html");
        printWriter.println(" * [2] http://openjdk.java.net/legal/assembly-exception.html");
        printWriter.println(" *");
        printWriter.println(" *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception");
        printWriter.println(" *******************************************************************************/");
    }
}

