/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.Image;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DTFJWalker {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Stack<String> path = new Stack();
    private final ArrayList<InvocationResult> results = new ArrayList();

    public static void main(String[] stringArray) {
        DTFJWalker dTFJWalker = new DTFJWalker();
        if (stringArray.length != 1) {
            DTFJWalker.printHelp();
            System.exit(1);
        }
        dTFJWalker.walkCoreFile(stringArray[0]);
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava com.ibm.j9ddr.tools.DTFJWalker <core file>\n");
        System.out.println("<core file>       : the path and file name of the core file");
    }

    public void walkCoreFile(String string) {
        File file = new File(string);
        this.walkCoreFile(file);
    }

    public void walkCoreFile(File file) {
        J9DDRImageFactory j9DDRImageFactory = new J9DDRImageFactory();
        Image image = null;
        try {
            image = j9DDRImageFactory.getImage(file);
        }
        catch (IOException iOException) {
            System.err.println("Failed to create an Image from the core file : " + iOException.getMessage());
            this.logger.log(Level.WARNING, "Failed to create Image from core file", iOException);
            return;
        }
        try {
            Method method = image.getClass().getDeclaredMethod("getAddressSpaces", null);
            this.iterate(image, method, 100);
        }
        catch (Exception exception) {
            System.err.println("Failed to get address space iterator method : " + exception.getMessage());
            this.logger.log(Level.WARNING, "Failed to get address space iterator method", exception);
            return;
        }
        System.out.println("Walk complete");
        this.showResults();
    }

    private void showResults() {
        for (InvocationResult invocationResult : this.results) {
            System.out.println(invocationResult.toString());
        }
    }

    private void iterate(Object object, Method method, int n) {
        this.path.push(this.getNameFromMethod(method));
        method.setAccessible(true);
        try {
            Object object2 = method.invoke(object, (Object[])null);
            if (object2 instanceof Iterator) {
                Iterator iterator = (Iterator)object2;
                for (int i = 0; iterator.hasNext() && i < n; ++i) {
                    Method[] methodArray;
                    Object e = iterator.next();
                    if (e instanceof CorruptData) {
                        this.results.add(new InvocationResult(this.getCurrentPath(), (CorruptData)e));
                        continue;
                    }
                    for (Method method2 : methodArray = e.getClass().getMethods()) {
                        if (!method2.getReturnType().getSimpleName().equals("Iterator")) continue;
                        this.path.push("[" + i + "]/");
                        this.iterate(e, method2, n);
                        this.path.pop();
                    }
                }
            }
            if (object2 instanceof CorruptData) {
                this.results.add(new InvocationResult(this.getCurrentPath(), (CorruptData)object2));
            }
        }
        catch (Exception exception) {
            System.err.println("Exception thrown by iterator : " + exception.getMessage());
            this.logger.log(Level.WARNING, "Exception thrown by iterator", exception);
            this.results.add(new InvocationResult(this.getCurrentPath(), exception.getCause()));
        }
        this.path.pop();
    }

    private String getCurrentPath() {
        Iterator iterator = this.path.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
        }
        return stringBuilder.toString();
    }

    private String getNameFromMethod(Method method) {
        String string = method.getName();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= 'a') continue;
            return string.substring(i);
        }
        return string;
    }

    private class InvocationResult {
        private final String path;
        private final CorruptData corruptData;
        private final Throwable exception;

        InvocationResult(String string, CorruptData corruptData, Throwable throwable) {
            this.path = string;
            this.corruptData = corruptData;
            this.exception = throwable;
        }

        InvocationResult(String string, CorruptData corruptData) {
            this.path = string;
            this.corruptData = corruptData;
            this.exception = null;
        }

        InvocationResult(String string, Throwable throwable) {
            this.path = string;
            this.corruptData = null;
            this.exception = throwable;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.path);
            stringBuilder.append(" = ");
            if (null != this.corruptData) {
                stringBuilder.append(this.corruptData.toString());
            }
            if (null != this.exception) {
                stringBuilder.append(this.exception.getClass().getName());
                stringBuilder.append("[");
                stringBuilder.append(this.exception.getMessage());
                stringBuilder.append("] ");
            }
            return stringBuilder.toString();
        }
    }
}

