/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit;

import com.ibm.jit.DecimalFormatHelper;
import com.ibm.oti.vm.J9UnmodifiableClass;
import com.ibm.oti.vm.VM;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

@J9UnmodifiableClass
public final class JITHelpers {
    private static final JITHelpers helpers;
    private static final Unsafe unsafe;
    private static final DecimalFormatHelper dummyDecFormat;
    private static final int CLASS_IS_INTERFACE_OR_PRIMITIVE;
    private static final long JLCLASS_J9CLASS_OFFSET;
    private static final int POINTER_SIZE;
    private static final boolean IS_32_BIT;
    public static final boolean IS_PLATFORM_LITTLE_ENDIAN;
    private static final int DESCRIPTION_WORD_SIZE;
    private static final int DESCRIPTION_WORD_BIT_SIZE;
    private static final int SLOT_SIZE;

    private JITHelpers() {
    }

    @CallerSensitive
    public static JITHelpers getHelpers() {
        if (Reflection.getCallerClass().getClassLoader() != null) {
            throw new SecurityException("JITHelpers");
        }
        return helpers;
    }

    private static JITHelpers jitHelpers() {
        return helpers;
    }

    public native int transformedEncodeUTF16Big(long var1, long var3, int var5);

    public native int transformedEncodeUTF16Little(long var1, long var3, int var5);

    private static native int javaLangClassJ9ClassOffset();

    private static int classIsInterfaceFlag() {
        return 512;
    }

    public Class<?> getSuperclass(Class<?> clazz) {
        if (IS_32_BIT) {
            int n = unsafe.getInt(clazz, JLCLASS_J9CLASS_OFFSET);
            int n2 = unsafe.getInt(n + VM.J9CLASS_ROMCLASS_OFFSET);
            int n3 = unsafe.getInt(n2 + VM.J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (n3 & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                int n4 = unsafe.getInt(n + VM.J9CLASS_SUPERCLASSES_OFFSET);
                int n5 = unsafe.getInt(n + VM.J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                int n6 = n5 & VM.J9_JAVA_CLASS_DEPTH_MASK;
                if (n6 > 0) {
                    int n7 = unsafe.getInt(n4 + POINTER_SIZE * (n6 - 1));
                    return this.getClassFromJ9Class32(n7);
                }
            }
        } else {
            long l = unsafe.getLong(clazz, JLCLASS_J9CLASS_OFFSET);
            long l2 = unsafe.getLong(l + (long)VM.J9CLASS_ROMCLASS_OFFSET);
            int n = unsafe.getInt(l2 + (long)VM.J9ROMCLASS_MODIFIERS_OFFSET);
            if (0 == (n & CLASS_IS_INTERFACE_OR_PRIMITIVE)) {
                long l3 = unsafe.getLong(l + (long)VM.J9CLASS_SUPERCLASSES_OFFSET);
                long l4 = unsafe.getLong(l + (long)VM.J9CLASS_CLASS_DEPTH_AND_FLAGS_OFFSET);
                long l5 = l4 & (long)VM.J9_JAVA_CLASS_DEPTH_MASK;
                if (l5 > 0L) {
                    long l6 = unsafe.getLong(l3 + (long)POINTER_SIZE * (l5 - 1L));
                    return this.getClassFromJ9Class64(l6);
                }
            }
        }
        return null;
    }

    public boolean isArray(Object object) {
        if (this.is32Bit()) {
            int n = this.getJ9ClassFromObject32(object);
            int n2 = this.getClassDepthAndFlagsFromJ9Class32(n);
            return (n2 & VM.J9_ACC_CLASS_ARRAY) != 0;
        }
        long l = this.getJ9ClassFromObject64(object);
        int n = (int)this.getClassDepthAndFlagsFromJ9Class64(l);
        return (n & VM.J9_ACC_CLASS_ARRAY) != 0;
    }

    public long getJ9ClassFromObject64(Object object) {
        Class<? extends Object> clazz = object.getClass();
        return this.getJ9ClassFromClass64(clazz);
    }

    public int getJ9ClassFromObject32(Object object) {
        Class<? extends Object> clazz = object.getClass();
        return this.getJ9ClassFromClass32(clazz);
    }

    public boolean supportsIntrinsicCaseConversion() {
        return false;
    }

    public boolean toUpperIntrinsicLatin1(byte[] byArray, byte[] byArray2, int n) {
        return false;
    }

    public boolean toLowerIntrinsicLatin1(byte[] byArray, byte[] byArray2, int n) {
        return false;
    }

    public boolean toUpperIntrinsicUTF16(byte[] byArray, byte[] byArray2, int n) {
        return false;
    }

    public boolean toLowerIntrinsicUTF16(byte[] byArray, byte[] byArray2, int n) {
        return false;
    }

    public boolean toUpperIntrinsicLatin1(char[] cArray, char[] cArray2, int n) {
        return false;
    }

    public boolean toLowerIntrinsicLatin1(char[] cArray, char[] cArray2, int n) {
        return false;
    }

    public boolean toUpperIntrinsicUTF16(char[] cArray, char[] cArray2, int n) {
        return false;
    }

    public boolean toLowerIntrinsicUTF16(char[] cArray, char[] cArray2, int n) {
        return false;
    }

    public int getIntFromObject(Object object, long l) {
        return unsafe.getInt(object, l);
    }

    public int getIntFromObjectVolatile(Object object, long l) {
        return unsafe.getIntVolatile(object, l);
    }

    public long getLongFromObject(Object object, long l) {
        return unsafe.getLong(object, l);
    }

    public long getLongFromObjectVolatile(Object object, long l) {
        return unsafe.getLongVolatile(object, l);
    }

    public Object getObjectFromObject(Object object, long l) {
        return unsafe.getObject(object, l);
    }

    public Object getObjectFromObjectVolatile(Object object, long l) {
        return unsafe.getObjectVolatile(object, l);
    }

    public void putIntInObject(Object object, long l, int n) {
        unsafe.putInt(object, l, n);
    }

    public void putIntInObjectVolatile(Object object, long l, int n) {
        unsafe.putIntVolatile(object, l, n);
    }

    public void putLongInObject(Object object, long l, long l2) {
        unsafe.putLong(object, l, l2);
    }

    public void putLongInObjectVolatile(Object object, long l, long l2) {
        unsafe.putLongVolatile(object, l, l2);
    }

    public void putObjectInObject(Object object, long l, Object object2) {
        unsafe.putObject(object, l, object2);
    }

    public void putObjectInObjectVolatile(Object object, long l, Object object2) {
        unsafe.putObjectVolatile(object, l, object2);
    }

    public boolean compareAndSwapIntInObject(Object object, long l, int n, int n2) {
        return unsafe.compareAndSwapInt(object, l, n, n2);
    }

    public boolean compareAndSwapLongInObject(Object object, long l, long l2, long l3) {
        return unsafe.compareAndSwapLong(object, l, l2, l3);
    }

    public boolean compareAndSwapObjectInObject(Object object, long l, Object object2, Object object3) {
        return unsafe.compareAndSwapObject(object, l, object2, object3);
    }

    public byte getByteFromArray(Object object, long l) {
        return unsafe.getByte(object, l);
    }

    public byte getByteFromArrayVolatile(Object object, long l) {
        return unsafe.getByteVolatile(object, l);
    }

    public char getCharFromArray(Object object, long l) {
        return unsafe.getChar(object, l);
    }

    public char getCharFromArrayVolatile(Object object, long l) {
        return unsafe.getCharVolatile(object, l);
    }

    public int getIntFromArray(Object object, long l) {
        return unsafe.getInt(object, l);
    }

    public int getIntFromArrayVolatile(Object object, long l) {
        return unsafe.getIntVolatile(object, l);
    }

    public long getLongFromArray(Object object, long l) {
        return unsafe.getLong(object, l);
    }

    public long getLongFromArrayVolatile(Object object, long l) {
        return unsafe.getLongVolatile(object, l);
    }

    public Object getObjectFromArray(Object object, long l) {
        return unsafe.getObject(object, l);
    }

    public Object getObjectFromArrayVolatile(Object object, long l) {
        return unsafe.getObjectVolatile(object, l);
    }

    public void putByteInArray(Object object, long l, byte by) {
        unsafe.putByte(object, l, by);
    }

    public void putByteInArrayVolatile(Object object, long l, byte by) {
        unsafe.putByteVolatile(object, l, by);
    }

    public void putCharInArray(Object object, long l, char c) {
        unsafe.putChar(object, l, c);
    }

    public void putCharInArrayVolatile(Object object, long l, char c) {
        unsafe.putCharVolatile(object, l, c);
    }

    public void putIntInArray(Object object, long l, int n) {
        unsafe.putInt(object, l, n);
    }

    public void putIntInArrayVolatile(Object object, long l, int n) {
        unsafe.putIntVolatile(object, l, n);
    }

    public void putLongInArray(Object object, long l, long l2) {
        unsafe.putLong(object, l, l2);
    }

    public void putLongInArrayVolatile(Object object, long l, long l2) {
        unsafe.putLongVolatile(object, l, l2);
    }

    public void putObjectInArray(Object object, long l, Object object2) {
        unsafe.putObject(object, l, object2);
    }

    public void putObjectInArrayVolatile(Object object, long l, Object object2) {
        unsafe.putObjectVolatile(object, l, object2);
    }

    public boolean compareAndSwapIntInArray(Object object, long l, int n, int n2) {
        return unsafe.compareAndSwapInt(object, l, n, n2);
    }

    public boolean compareAndSwapLongInArray(Object object, long l, long l2, long l3) {
        return unsafe.compareAndSwapLong(object, l, l2, l3);
    }

    public boolean compareAndSwapObjectInArray(Object object, long l, Object object2, Object object3) {
        return unsafe.compareAndSwapObject(object, l, object2, object3);
    }

    public char byteToCharUnsigned(byte by) {
        return (char)((char)by & 0xFF);
    }

    public native boolean acmplt(Object var1, Object var2);

    private static long storeBits(long l, int n, long l2, int n2, int n3) {
        int n4 = IS_PLATFORM_LITTLE_ENDIAN ? n3 * n2 % n : n - 1 - n3 * n2 % n;
        long l3 = -1 >>> (8 - n2) * 8;
        long l4 = l3 << 8 * n4 ^ 0xFFFFFFFFFFFFFFFFL;
        return l & l4 | (l2 & l3) << 8 * n4;
    }

    private static long readBits(long l, int n, int n2, int n3) {
        int n4 = IS_PLATFORM_LITTLE_ENDIAN ? n3 * n2 % n : n - 1 - n3 * n2 % n;
        long l2 = -1 >>> (8 - n2) * 8;
        long l3 = l2 << 8 * n4;
        return (l & l3) >>> 8 * n4;
    }

    public void putByteInArrayByIndex(Object object, int n, byte by) {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == byte[].class) {
            ((byte[])object)[n] = by;
        } else if (clazz == char[].class) {
            char[] cArray = (char[])object;
            int n2 = n >> 1;
            char c = cArray[n2];
            cArray[n2] = (char)JITHelpers.storeBits(c, 2, by, 1, n);
        } else if (clazz == int[].class) {
            int[] nArray = (int[])object;
            int n3 = n >> 2;
            int n4 = nArray[n3];
            nArray[n3] = (int)JITHelpers.storeBits(n4, 4, by, 1, n);
        } else if (clazz == long[].class) {
            long[] lArray = (long[])object;
            int n5 = n >> 3;
            long l = lArray[n5];
            lArray[n5] = JITHelpers.storeBits(l, 8, by, 1, n);
        }
    }

    public byte getByteFromArrayByIndex(Object object, int n) {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == byte[].class) {
            return ((byte[])object)[n];
        }
        if (clazz == char[].class) {
            return (byte)JITHelpers.readBits(((char[])object)[n >> 1], 2, 1, n);
        }
        if (clazz == int[].class) {
            return (byte)JITHelpers.readBits(((int[])object)[n >> 2], 4, 1, n);
        }
        if (clazz == long[].class) {
            return (byte)JITHelpers.readBits(((long[])object)[n >> 3], 8, 1, n);
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    public void putCharInArrayByIndex(Object object, int n, char c) {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == byte[].class) {
            n <<= 1;
            byte[] byArray = (byte[])object;
            if (IS_PLATFORM_LITTLE_ENDIAN) {
                byArray[n] = (byte)c;
                byArray[n + 1] = (byte)(c >>> 8);
            } else {
                byArray[n] = (byte)(c >>> 8);
                byArray[n + 1] = (byte)c;
            }
        } else if (clazz == char[].class) {
            ((char[])object)[n] = c;
        } else if (clazz == int[].class) {
            int[] nArray = (int[])object;
            int n2 = n >> 1;
            int n3 = nArray[n2];
            nArray[n2] = (int)JITHelpers.storeBits(n3, 4, c, 2, n);
        } else if (clazz == long[].class) {
            long[] lArray = (long[])object;
            int n4 = n >> 2;
            long l = lArray[n4];
            lArray[n4] = JITHelpers.storeBits(l, 8, c, 2, n);
        }
    }

    public char getCharFromArrayByIndex(Object object, int n) {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == byte[].class) {
            n <<= 1;
            byte[] byArray = (byte[])object;
            if (IS_PLATFORM_LITTLE_ENDIAN) {
                return (char)(this.byteToCharUnsigned(byArray[n + 1]) << 8 | this.byteToCharUnsigned(byArray[n]));
            }
            return (char)(this.byteToCharUnsigned(byArray[n + 1]) | this.byteToCharUnsigned(byArray[n]) << 8);
        }
        if (clazz == char[].class) {
            return ((char[])object)[n];
        }
        if (clazz == int[].class) {
            return (char)JITHelpers.readBits(((int[])object)[n >> 1], 4, 2, n);
        }
        if (clazz == long[].class) {
            return (char)JITHelpers.readBits(((long[])object)[n >> 2], 8, 2, n);
        }
        throw new RuntimeException("Unknown array type for bit manipulation");
    }

    public int intrinsicIndexOfStringLatin1(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        char c = this.byteToCharUnsigned(this.getByteFromArrayByIndex(cArray2, 0));
        while (true) {
            int n4 = -1;
            if (n3 < n) {
                n4 = this.intrinsicIndexOfLatin1(cArray, (byte)c, n3, n);
            }
            if (n4 == -1 || n2 + n4 > n) {
                return -1;
            }
            int n5 = n4;
            int n6 = 0;
            while (++n6 < n2 && this.getByteFromArrayByIndex(cArray, ++n5) == this.getByteFromArrayByIndex(cArray2, n6)) {
            }
            if (n6 == n2) {
                return n4;
            }
            n3 = n4 + 1;
        }
    }

    public int intrinsicIndexOfStringUTF16(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        char c = cArray2[0];
        int n4;
        while ((n4 = this.intrinsicIndexOfUTF16(cArray, c, n3, n)) != -1 && n2 + n4 <= n) {
            int n5 = n4;
            int n6 = 0;
            while (++n6 < n2 && cArray[++n5] == cArray2[n6]) {
            }
            if (n6 == n2) {
                return n4;
            }
            n3 = n4 + 1;
        }
        return -1;
    }

    public int intrinsicIndexOfLatin1(Object object, byte by, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (this.getByteFromArrayByIndex(object, i) != by) continue;
            return i;
        }
        return -1;
    }

    public int intrinsicIndexOfUTF16(Object object, char c, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (this.getCharFromArrayByIndex(object, i) != c) continue;
            return i;
        }
        return -1;
    }

    private static boolean isDescriptorPointerTagged(int n) {
        return (n & 1) == 1;
    }

    private static boolean isDescriptorPointerTagged(long l) {
        return (l & 1L) == 1L;
    }

    public final void unsafeObjectShallowCopy32(Object object, Object object2, int n) {
        int n2;
        int n3 = unsafe.getInt(n + VM.J9CLASS_INSTANCESIZE_OFFSET);
        int n4 = unsafe.getInt(n + VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
        int n5 = n3 / SLOT_SIZE;
        int n6 = n4;
        int n7 = DESCRIPTION_WORD_BIT_SIZE - 1;
        if ((n6 & 1) == 1) {
            n6 >>= 1;
        } else {
            n6 = unsafe.getInt(n4);
            n4 += DESCRIPTION_WORD_SIZE;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            if ((n6 & 1) == 1) {
                Object object3 = this.getObjectFromObject(object, VM.OBJECT_HEADER_SIZE + n2 * SLOT_SIZE);
                this.putObjectInObject(object2, VM.OBJECT_HEADER_SIZE + n2 * SLOT_SIZE, object3);
            } else {
                int n8 = this.getIntFromObject(object, VM.OBJECT_HEADER_SIZE + n2 * SLOT_SIZE);
                this.putIntInObject(object2, VM.OBJECT_HEADER_SIZE + n2 * SLOT_SIZE, n8);
            }
            n6 >>= 1;
            if (n7-- != 0) continue;
            n6 = unsafe.getInt(n4);
            n4 += DESCRIPTION_WORD_SIZE;
            n7 = DESCRIPTION_WORD_BIT_SIZE - 1;
        }
        n2 = unsafe.getInt(n + VM.J9CLASS_LOCK_OFFSET_OFFSET);
        if (n2 != 0) {
            int n9 = this.getClassFlagsFromJ9Class32(n);
            boolean bl = (n9 & VM.J9CLASS_RESERVABLE_LOCK_WORD_INIT) != 0;
            int n10 = bl ? VM.OBJECT_HEADER_LOCK_RESERVED : 0;
            this.putIntInObject(object2, n2, n10);
        }
        unsafe.storeFence();
    }

    public final void unsafeObjectShallowCopy64(Object object, Object object2, long l) {
        long l2 = unsafe.getLong(l + (long)VM.J9CLASS_INSTANCESIZE_OFFSET);
        long l3 = unsafe.getLong(l + (long)VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
        int n = VM.OBJECT_HEADER_SIZE;
        int n2 = (int)(l2 / (long)SLOT_SIZE);
        long l4 = l3;
        int n3 = DESCRIPTION_WORD_BIT_SIZE - 1;
        if ((l4 & 1L) == 1L) {
            l4 >>= 1;
        } else {
            l4 = unsafe.getLong(l3);
            l3 += (long)DESCRIPTION_WORD_SIZE;
        }
        for (int i = 0; i < n2; ++i) {
            if ((l4 & 1L) == 1L) {
                Object object3 = this.getObjectFromObject(object, n + i * SLOT_SIZE);
                this.putObjectInObject(object2, n + i * SLOT_SIZE, object3);
            } else if (SLOT_SIZE == 4) {
                int n4 = this.getIntFromObject(object, n + i * SLOT_SIZE);
                this.putIntInObject(object2, n + i * SLOT_SIZE, n4);
            } else {
                long l5 = this.getLongFromObject(object, n + i * SLOT_SIZE);
                this.putLongInObject(object2, n + i * SLOT_SIZE, l5);
            }
            l4 >>= 1;
            if (n3-- != 0) continue;
            l4 = unsafe.getLong(l3);
            l3 += (long)DESCRIPTION_WORD_SIZE;
            n3 = DESCRIPTION_WORD_BIT_SIZE - 1;
        }
        long l6 = unsafe.getLong(l + (long)VM.J9CLASS_LOCK_OFFSET_OFFSET);
        if (l6 != 0L) {
            int n5;
            int n6 = this.getClassFlagsFromJ9Class64(l);
            boolean bl = (n6 & VM.J9CLASS_RESERVABLE_LOCK_WORD_INIT) != 0;
            int n7 = n5 = bl ? VM.OBJECT_HEADER_LOCK_RESERVED : 0;
            if (SLOT_SIZE == 4) {
                this.putIntInObject(object2, l6, n5);
            } else {
                this.putLongInObject(object2, l6, n5);
            }
        }
        unsafe.storeFence();
    }

    public Object optimizedClone(Object object) throws CloneNotSupportedException {
        Class<? extends Object> clazz = object.getClass();
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            int n = Array.getLength(object);
            Object object2 = Array.newInstance(clazz2, n);
            System.arraycopy(object, 0, object2, 0, n);
            return object2;
        }
        if (!(object instanceof Cloneable)) {
            throw new CloneNotSupportedException();
        }
        Object object3 = null;
        try {
            object3 = unsafe.allocateInstance(clazz);
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        int n = 0;
        if (IS_32_BIT) {
            long l;
            int n2 = unsafe.getInt(clazz, JLCLASS_J9CLASS_OFFSET);
            int n3 = unsafe.getInt(n2 + VM.J9CLASS_INSTANCESIZE_OFFSET);
            int n4 = unsafe.getInt(n2 + VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
            int n5 = n3 / SLOT_SIZE;
            int n6 = 0;
            if (JITHelpers.isDescriptorPointerTagged(n4)) {
                ++n;
                n6 = n4 >>> 1;
            } else {
                n6 = unsafe.getInt(n4);
            }
            int n7 = 0;
            int n8 = 0;
            while (n5 != 0) {
                if (JITHelpers.isDescriptorPointerTagged(n6)) {
                    Object object4 = unsafe.getObject(object, VM.OBJECT_HEADER_SIZE + n7 * SLOT_SIZE);
                    unsafe.putObject(object3, VM.OBJECT_HEADER_SIZE + n8 * SLOT_SIZE, object4);
                } else {
                    int n9 = unsafe.getInt(object, VM.OBJECT_HEADER_SIZE + n7 * SLOT_SIZE);
                    unsafe.putInt(object3, VM.OBJECT_HEADER_SIZE + n8 * SLOT_SIZE, n9);
                }
                if (++n7 >= n5) break;
                if (n == DESCRIPTION_WORD_BIT_SIZE - 1) {
                    n = 0;
                    n6 = unsafe.getInt(n4 += DESCRIPTION_WORD_SIZE);
                } else {
                    n6 >>>= 1;
                    ++n;
                }
                ++n8;
            }
            if ((l = (long)unsafe.getInt(n2 + VM.J9CLASS_LOCK_OFFSET_OFFSET)) != 0L) {
                int n10 = this.getClassFlagsFromJ9Class32(n2);
                boolean bl = (n10 & VM.J9CLASS_RESERVABLE_LOCK_WORD_INIT) != 0;
                int n11 = bl ? VM.OBJECT_HEADER_LOCK_RESERVED : 0;
                unsafe.putInt(object3, l, n11);
            }
        } else {
            long l;
            long l2 = unsafe.getLong(clazz, JLCLASS_J9CLASS_OFFSET);
            long l3 = unsafe.getLong(l2 + (long)VM.J9CLASS_INSTANCESIZE_OFFSET);
            long l4 = unsafe.getLong(l2 + (long)VM.J9CLASS_INSTANCE_DESCRIPTION_OFFSET);
            int n12 = (int)(l3 / (long)SLOT_SIZE);
            long l5 = 0L;
            if (JITHelpers.isDescriptorPointerTagged(l4)) {
                ++n;
                l5 = l4 >>> 1;
            } else {
                l5 = unsafe.getLong(l4);
            }
            int n13 = 0;
            int n14 = 0;
            while (n12 != 0) {
                if (JITHelpers.isDescriptorPointerTagged(l5)) {
                    Object object5 = unsafe.getObject(object, VM.OBJECT_HEADER_SIZE + n13 * SLOT_SIZE);
                    unsafe.putObject(object3, VM.OBJECT_HEADER_SIZE + n14 * SLOT_SIZE, object5);
                } else {
                    long l6 = unsafe.getLong(object, VM.OBJECT_HEADER_SIZE + n13 * SLOT_SIZE);
                    unsafe.putLong(object3, VM.OBJECT_HEADER_SIZE + n14 * SLOT_SIZE, l6);
                }
                if (++n13 >= n12) break;
                if (n == DESCRIPTION_WORD_BIT_SIZE - 1) {
                    n = 0;
                    l5 = unsafe.getLong(l4 += (long)DESCRIPTION_WORD_SIZE);
                } else {
                    l5 >>>= 1;
                    ++n;
                }
                ++n14;
            }
            if ((l = unsafe.getLong(l2 + (long)VM.J9CLASS_LOCK_OFFSET_OFFSET)) != 0L) {
                int n15;
                int n16 = this.getClassFlagsFromJ9Class64(l2);
                boolean bl = (n16 & VM.J9CLASS_RESERVABLE_LOCK_WORD_INIT) != 0;
                int n17 = n15 = bl ? VM.OBJECT_HEADER_LOCK_RESERVED : 0;
                if (SLOT_SIZE == 4) {
                    unsafe.putInt(object3, l, n15);
                } else {
                    unsafe.putLong(object3, l, (long)n15);
                }
            }
        }
        unsafe.storeFence();
        return object3;
    }

    public final int getClassInitializeStatus(Class<?> clazz) {
        long l = 0L;
        l = this.is32Bit() ? (long)this.getJ9ClassFromClass32(clazz) : this.getJ9ClassFromClass64(clazz);
        int n = 0;
        n = 4 == VM.ADDRESS_SIZE ? unsafe.getInt(l + (long)VM.J9CLASS_INITIALIZE_STATUS_OFFSET) : (int)unsafe.getLong(l + (long)VM.J9CLASS_INITIALIZE_STATUS_OFFSET);
        return n;
    }

    private static final native boolean isPlatformLittleEndian();

    public final native void GPUHelper();

    public native boolean is32Bit();

    public native int getNumBitsInReferenceField();

    public native int getNumBytesInReferenceField();

    public native int getNumBitsInDescriptionWord();

    public native int getNumBytesInDescriptionWord();

    public native int getNumBytesInJ9ObjectHeader();

    public native int getJ9ClassFromClass32(Class var1);

    public native Class getClassFromJ9Class32(int var1);

    public native int getTotalInstanceSizeFromJ9Class32(int var1);

    public native int getInstanceDescriptionFromJ9Class32(int var1);

    public native int getDescriptionWordFromPtr32(int var1);

    public native long getJ9ClassFromClass64(Class var1);

    public native Class getClassFromJ9Class64(long var1);

    public native long getTotalInstanceSizeFromJ9Class64(long var1);

    public native long getInstanceDescriptionFromJ9Class64(long var1);

    public native long getDescriptionWordFromPtr64(long var1);

    public native int getNumSlotsInObject(Class var1);

    public native int getSlotIndex(Field var1);

    public native boolean isDescriptorPointerTagged(int var1, long var2);

    public native int getRomClassFromJ9Class32(int var1);

    public native int getSuperClassesFromJ9Class32(int var1);

    public native int getClassDepthAndFlagsFromJ9Class32(int var1);

    public native int getBackfillOffsetFromJ9Class32(int var1);

    public native int getArrayShapeFromRomClass32(int var1);

    public native int getModifiersFromRomClass32(int var1);

    public native long getRomClassFromJ9Class64(long var1);

    public native long getSuperClassesFromJ9Class64(long var1);

    public native long getClassDepthAndFlagsFromJ9Class64(long var1);

    public native long getBackfillOffsetFromJ9Class64(long var1);

    public native int getArrayShapeFromRomClass64(long var1);

    public native int getModifiersFromRomClass64(long var1);

    public native int getClassFlagsFromJ9Class32(int var1);

    public native int getClassFlagsFromJ9Class64(long var1);

    static {
        dummyDecFormat = new DecimalFormatHelper();
        CLASS_IS_INTERFACE_OR_PRIMITIVE = JITHelpers.classIsInterfaceFlag() | VM.J9_ACC_CLASS_INTERNAL_PRIMITIVE_TYPE;
        JLCLASS_J9CLASS_OFFSET = JITHelpers.javaLangClassJ9ClassOffset();
        POINTER_SIZE = VM.ADDRESS_SIZE;
        IS_32_BIT = POINTER_SIZE == 4;
        IS_PLATFORM_LITTLE_ENDIAN = JITHelpers.isPlatformLittleEndian();
        helpers = new JITHelpers();
        unsafe = Unsafe.getUnsafe();
        DESCRIPTION_WORD_SIZE = VM.ADDRESS_SIZE;
        DESCRIPTION_WORD_BIT_SIZE = DESCRIPTION_WORD_SIZE * 8;
        SLOT_SIZE = VM.FJ9OBJECT_SIZE;
    }
}

