/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import com.ibm.dataaccess.CommonData;
import com.ibm.dataaccess.DecimalData;
import java.math.BigInteger;
import java.util.Arrays;

public final class PackedDecimal {
    private static final ThreadLocal<PackedDecimalOperand> op1_threadLocal = new ThreadLocal<PackedDecimalOperand>(){

        @Override
        protected PackedDecimalOperand initialValue() {
            return new PackedDecimalOperand();
        }
    };
    private static final ThreadLocal<PackedDecimalOperand> op2_threadLocal = new ThreadLocal<PackedDecimalOperand>(){

        @Override
        protected PackedDecimalOperand initialValue() {
            return new PackedDecimalOperand();
        }
    };
    private static final ThreadLocal<PackedDecimalOperand> sum_threadLocal = new ThreadLocal<PackedDecimalOperand>(){

        @Override
        protected PackedDecimalOperand initialValue() {
            return new PackedDecimalOperand();
        }
    };
    private static final int MULTIPLY = 1;
    private static final int DIVIDE = 2;
    private static final int REMAINDER = 3;

    private PackedDecimal() {
    }

    public static int checkPackedDecimal(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. checkPackedDecimal is trying to access byteArray[" + n + "] to byteArray[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        return PackedDecimal.checkPackedDecimal_(byArray, n, n2, bl, bl2);
    }

    private static int checkPackedDecimal_(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        if (n2 < 1) {
            throw new IllegalArgumentException("Illegal Precision.");
        }
        boolean bl3 = n2 % 2 == 0;
        int n4 = n + CommonData.getPackedByteCount(n2) - 1;
        int n5 = 0;
        if (bl2 && bl3) {
            byArray[n] = (byte)(byArray[n] & 0xF);
        }
        if (bl3 && bl) {
            if ((byArray[n] & 0xF) > 9) {
                n5 = 2;
            }
            ++n;
        }
        for (n3 = n; n3 < n4 && byArray[n3] == 0; ++n3) {
        }
        while (n3 < n4) {
            if ((byArray[n3] & 0xF) > 9 || (byArray[n3] & 0xF0 & 0xFF) > 144) {
                n5 = 2;
                break;
            }
            ++n3;
        }
        if (n3 == n4 && (byArray[n4] & 0xF0 & 0xFF) > 144) {
            n5 = 2;
        }
        if ((byArray[n4] & 0xF) < 10) {
            ++n5;
        }
        return n5;
    }

    public static int checkPackedDecimal(byte[] byArray, int n, int n2, boolean bl) {
        return PackedDecimal.checkPackedDecimal(byArray, n, n2, bl, false);
    }

    public static int checkPackedDecimal(byte[] byArray, int n, int n2) {
        return PackedDecimal.checkPackedDecimal(byArray, n, n2, false, false);
    }

    private static void copyRemainingDigits(PackedDecimalOperand packedDecimalOperand, PackedDecimalOperand packedDecimalOperand2, boolean bl) throws ArithmeticException {
        int n;
        PackedDecimalOperand packedDecimalOperand3 = sum_threadLocal.get();
        if (packedDecimalOperand.currentOffset >= packedDecimalOperand.offset) {
            n = packedDecimalOperand.currentOffset - packedDecimalOperand.offset + 1;
            int n2 = packedDecimalOperand3.currentOffset - packedDecimalOperand3.offset + 1;
            if (n >= n2) {
                if (bl && n > n2) {
                    throw new ArithmeticException("Decimal overflow during addition/subtraction.");
                }
                n = packedDecimalOperand3.currentOffset - packedDecimalOperand3.offset + 1;
                packedDecimalOperand3.currentOffset = packedDecimalOperand3.currentOffset - n + 1;
                packedDecimalOperand.currentOffset += -n + 1;
                System.arraycopy((Object)packedDecimalOperand.byteArray, packedDecimalOperand.currentOffset, (Object)packedDecimalOperand3.byteArray, packedDecimalOperand3.currentOffset, n);
                if (packedDecimalOperand3.precision % 2 == 0) {
                    byte by = (byte)(packedDecimalOperand3.byteArray[packedDecimalOperand3.currentOffset] & 0xF0);
                    if (bl && n == n2 && by != 0) {
                        throw new ArithmeticException("Decimal overflow during addition/subtraction.");
                    }
                    int n3 = packedDecimalOperand3.currentOffset;
                    packedDecimalOperand3.byteArray[n3] = (byte)(packedDecimalOperand3.byteArray[n3] & 0xF);
                }
            } else {
                packedDecimalOperand3.currentOffset = packedDecimalOperand3.currentOffset - n + 1;
                System.arraycopy((Object)packedDecimalOperand.byteArray, packedDecimalOperand.offset, (Object)packedDecimalOperand3.byteArray, packedDecimalOperand3.currentOffset, n);
            }
            --packedDecimalOperand3.currentOffset;
        }
        if (packedDecimalOperand3.currentOffset >= packedDecimalOperand3.offset) {
            n = packedDecimalOperand3.currentOffset - packedDecimalOperand3.offset + 1;
            Arrays.fill(packedDecimalOperand3.byteArray, packedDecimalOperand3.offset, packedDecimalOperand3.offset + n, (byte)0);
        }
    }

    public static void addPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) throws ArithmeticException {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. addPackedDecimal is trying to access result[" + n + "] to result[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. addPackedDecimal is trying to access op1Decimal[" + n3 + "] to op1Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        if (n5 < 0 || n5 + (n6 / 2 + 1) > byArray3.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. addPackedDecimal is trying to access op2Decimal[" + n5 + "] to op2Decimal[" + (n5 + n6 / 2) + "] but valid indices are from 0 to " + (byArray3.length - 1) + ".");
        }
        PackedDecimal.addPackedDecimal_(byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    private static void addPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) throws ArithmeticException {
        sum_threadLocal.get().setSumOperand(byArray, n, n2);
        op1_threadLocal.get().setOperand(byArray2, n3, n4);
        op2_threadLocal.get().setOperand(byArray3, n5, n6);
        PackedDecimal.computeValue(bl);
    }

    public static void subtractPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) throws ArithmeticException {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. subtractPackedDecimal is trying to access result[" + n + "] to result[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. subtractPackedDecimal is trying to access op1Decimal[" + n3 + "] to op1Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        if (n5 < 0 || n5 + (n6 / 2 + 1) > byArray3.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. subtractPackedDecimal is trying to access op2Decimal[" + n5 + "] to op2Decimal[" + (n5 + n6 / 2) + "] but valid indices are from 0 to " + (byArray3.length - 1) + ".");
        }
        PackedDecimal.subtractPackedDecimal_(byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    private static void subtractPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) throws ArithmeticException {
        PackedDecimalOperand packedDecimalOperand = sum_threadLocal.get();
        PackedDecimalOperand packedDecimalOperand2 = op1_threadLocal.get();
        PackedDecimalOperand packedDecimalOperand3 = op2_threadLocal.get();
        packedDecimalOperand.setSumOperand(byArray, n, n2);
        packedDecimalOperand2.setOperand(byArray2, n3, n4);
        packedDecimalOperand3.setOperand(byArray3, n5, n6);
        packedDecimalOperand3.sign = (packedDecimalOperand3.sign & 0xF) == 12 ? packedDecimalOperand3.sign & 0xF0 | 0xD : packedDecimalOperand3.sign & 0xF0 | 0xC;
        PackedDecimal.computeValue(bl);
    }

    public static void setPackedZero(byte[] byArray, int n, int n2) {
        int n3 = CommonData.getPackedByteCount(n2);
        Arrays.fill(byArray, n, n + n3 - 1, (byte)0);
        byArray[n + n3 - 1] = 12;
    }

    private static void computeSum(PackedDecimalOperand packedDecimalOperand, PackedDecimalOperand packedDecimalOperand2, boolean bl) throws ArithmeticException {
        PackedDecimalOperand packedDecimalOperand3 = sum_threadLocal.get();
        packedDecimalOperand3.indexValue = packedDecimalOperand.signDigit + packedDecimalOperand2.signDigit << 1 & 0x3FF;
        packedDecimalOperand3.byteValue = CommonData.getPackedSumValues(packedDecimalOperand3.indexValue);
        boolean bl2 = packedDecimalOperand3.byteValue < packedDecimalOperand.signDigit;
        packedDecimalOperand3.byteArray[packedDecimalOperand3.signOffset] = (byte)(packedDecimalOperand3.byteValue | packedDecimalOperand.sign & 0xF);
        while (packedDecimalOperand2.currentOffset >= packedDecimalOperand2.offset && packedDecimalOperand3.currentOffset >= packedDecimalOperand3.offset) {
            if (bl && packedDecimalOperand3.currentOffset < packedDecimalOperand3.offset) {
                throw new ArithmeticException("Decimal overflow in addPackedDecimal.");
            }
            packedDecimalOperand.byteValue = packedDecimalOperand.byteArray[packedDecimalOperand.currentOffset] & 0xFF;
            packedDecimalOperand2.byteValue = packedDecimalOperand2.byteArray[packedDecimalOperand2.currentOffset] & 0xFF;
            packedDecimalOperand.indexValue = packedDecimalOperand.byteValue + (packedDecimalOperand.byteValue & 0xF0);
            packedDecimalOperand2.indexValue = packedDecimalOperand2.byteValue + (packedDecimalOperand2.byteValue & 0xF0);
            packedDecimalOperand3.indexValue = packedDecimalOperand.indexValue + packedDecimalOperand2.indexValue;
            packedDecimalOperand3.byteValue = bl2 ? (int)CommonData.getPackedSumPlusOneValues(packedDecimalOperand3.indexValue) : CommonData.getPackedSumValues(packedDecimalOperand3.indexValue);
            bl2 = (packedDecimalOperand3.byteValue & 0xFF) < (packedDecimalOperand.byteValue & 0xFF) + (packedDecimalOperand2.byteValue & 0xFF);
            packedDecimalOperand3.byteArray[packedDecimalOperand3.currentOffset] = (byte)packedDecimalOperand3.byteValue;
            --packedDecimalOperand2.currentOffset;
            --packedDecimalOperand.currentOffset;
            --packedDecimalOperand3.currentOffset;
        }
        while (bl2 && packedDecimalOperand.currentOffset >= packedDecimalOperand.offset && packedDecimalOperand3.currentOffset >= packedDecimalOperand3.offset) {
            if (bl && packedDecimalOperand3.currentOffset < packedDecimalOperand3.offset) {
                throw new ArithmeticException("Decimal overflow in addPackedDecimal");
            }
            packedDecimalOperand3.byteValue = CommonData.getPackedAddOneValues(packedDecimalOperand.byteArray[packedDecimalOperand.currentOffset]) & 0xFF;
            bl2 = packedDecimalOperand3.byteValue == 0;
            packedDecimalOperand3.byteArray[packedDecimalOperand3.currentOffset] = (byte)packedDecimalOperand3.byteValue;
            --packedDecimalOperand.currentOffset;
            --packedDecimalOperand3.currentOffset;
        }
        if (packedDecimalOperand3.currentOffset < packedDecimalOperand3.offset) {
            if (bl2 && bl || bl && packedDecimalOperand.currentOffset >= packedDecimalOperand.offset) {
                throw new ArithmeticException("Decimal overflow in addPackedDecimal");
            }
            if (packedDecimalOperand3.precision % 2 == 0) {
                if ((byte)(packedDecimalOperand3.byteArray[packedDecimalOperand3.offset] & 0xF0) > 0 && bl) {
                    throw new ArithmeticException("Decimal overflow in addPackedDecimal");
                }
                int n = packedDecimalOperand3.offset;
                packedDecimalOperand3.byteArray[n] = (byte)(packedDecimalOperand3.byteArray[n] & 0xF);
            }
            return;
        }
        if (bl2) {
            packedDecimalOperand3.byteArray[packedDecimalOperand3.currentOffset] = 1;
            --packedDecimalOperand3.currentOffset;
        }
        PackedDecimal.copyRemainingDigits(packedDecimalOperand, packedDecimalOperand2, bl);
    }

    private static void computeDifference(PackedDecimalOperand packedDecimalOperand, PackedDecimalOperand packedDecimalOperand2, boolean bl) throws ArithmeticException {
        PackedDecimalOperand packedDecimalOperand3 = sum_threadLocal.get();
        boolean bl2 = packedDecimalOperand.signDigit < packedDecimalOperand2.signDigit;
        packedDecimalOperand3.byteValue = Math.abs((packedDecimalOperand.signDigit >> 4) - (packedDecimalOperand2.signDigit >> 4) + 10) % 10;
        packedDecimalOperand3.byteArray[packedDecimalOperand3.signOffset] = (byte)(packedDecimalOperand3.byteValue << 4 | packedDecimalOperand.sign & 0xF);
        packedDecimalOperand2.currentOffset = packedDecimalOperand2.signOffset - 1;
        packedDecimalOperand.currentOffset = packedDecimalOperand.signOffset - 1;
        while (packedDecimalOperand2.currentOffset >= packedDecimalOperand2.offset && packedDecimalOperand3.currentOffset >= packedDecimalOperand3.offset) {
            if (bl && packedDecimalOperand3.currentOffset < packedDecimalOperand3.offset) {
                throw new ArithmeticException("Decimal overflow in subtractPackedDecimal");
            }
            packedDecimalOperand.byteValue = packedDecimalOperand.byteArray[packedDecimalOperand.currentOffset] & 0xFF;
            packedDecimalOperand2.byteValue = packedDecimalOperand2.byteArray[packedDecimalOperand2.currentOffset] & 0xFF;
            packedDecimalOperand.indexValue = packedDecimalOperand.byteValue + (packedDecimalOperand.byteValue & 0xF0);
            packedDecimalOperand2.indexValue = packedDecimalOperand2.byteValue + (packedDecimalOperand2.byteValue & 0xF0);
            packedDecimalOperand3.indexValue = packedDecimalOperand.indexValue - packedDecimalOperand2.indexValue & 0x3FF;
            packedDecimalOperand3.byteValue = bl2 ? (int)CommonData.getPackedDifferenceMinusOneValues(packedDecimalOperand3.indexValue) : (int)CommonData.getPackedDifferenceValues(packedDecimalOperand3.indexValue);
            boolean bl3 = bl2 = (packedDecimalOperand3.byteValue & 0xFF) > (packedDecimalOperand.byteValue & 0xFF) - (packedDecimalOperand2.byteValue & 0xFF);
            if (packedDecimalOperand3.currentOffset >= packedDecimalOperand3.offset) {
                packedDecimalOperand3.byteArray[packedDecimalOperand3.currentOffset] = (byte)packedDecimalOperand3.byteValue;
            }
            --packedDecimalOperand2.currentOffset;
            --packedDecimalOperand.currentOffset;
            --packedDecimalOperand3.currentOffset;
        }
        while (bl2 && packedDecimalOperand.currentOffset >= packedDecimalOperand.offset && packedDecimalOperand3.currentOffset >= packedDecimalOperand3.offset) {
            if (bl && packedDecimalOperand3.currentOffset < packedDecimalOperand3.offset) {
                throw new ArithmeticException("Decimal overflow in subtractPackedDecimal");
            }
            packedDecimalOperand3.byteValue = CommonData.getPackedBorrowOneValues(packedDecimalOperand.byteArray[packedDecimalOperand.currentOffset]) & 0xFF;
            boolean bl4 = bl2 = packedDecimalOperand3.byteValue == 153;
            if (packedDecimalOperand3.currentOffset >= packedDecimalOperand3.offset) {
                packedDecimalOperand3.byteArray[packedDecimalOperand3.currentOffset] = (byte)packedDecimalOperand3.byteValue;
            }
            --packedDecimalOperand.currentOffset;
            --packedDecimalOperand3.currentOffset;
        }
        PackedDecimal.copyRemainingDigits(packedDecimalOperand, packedDecimalOperand2, bl);
    }

    private static void computeValue(boolean bl) throws ArithmeticException {
        PackedDecimalOperand packedDecimalOperand = sum_threadLocal.get();
        PackedDecimalOperand packedDecimalOperand2 = op1_threadLocal.get();
        PackedDecimalOperand packedDecimalOperand3 = op2_threadLocal.get();
        if ((packedDecimalOperand2.sign & 0xF) == (packedDecimalOperand3.sign & 0xF)) {
            if (packedDecimalOperand2.bytes < packedDecimalOperand3.bytes) {
                PackedDecimal.computeSum(packedDecimalOperand3, packedDecimalOperand2, bl);
            } else {
                PackedDecimal.computeSum(packedDecimalOperand2, packedDecimalOperand3, bl);
            }
        } else if (packedDecimalOperand2.bytes < packedDecimalOperand3.bytes) {
            PackedDecimal.computeDifference(packedDecimalOperand3, packedDecimalOperand2, bl);
        } else if (packedDecimalOperand2.bytes > packedDecimalOperand3.bytes) {
            PackedDecimal.computeDifference(packedDecimalOperand2, packedDecimalOperand3, bl);
        } else {
            block13: {
                while (packedDecimalOperand2.offset < packedDecimalOperand2.signOffset) {
                    packedDecimalOperand2.byteValue = packedDecimalOperand2.byteArray[packedDecimalOperand2.offset];
                    packedDecimalOperand3.byteValue = packedDecimalOperand3.byteArray[packedDecimalOperand3.offset];
                    if (packedDecimalOperand2.byteValue == packedDecimalOperand3.byteValue) {
                        ++packedDecimalOperand2.offset;
                        ++packedDecimalOperand3.offset;
                        continue;
                    }
                    break block13;
                }
                packedDecimalOperand2.byteValue = packedDecimalOperand2.byteArray[packedDecimalOperand2.offset] & 0xF0;
                packedDecimalOperand3.byteValue = packedDecimalOperand3.byteArray[packedDecimalOperand3.offset] & 0xF0;
                if (packedDecimalOperand2.byteValue == packedDecimalOperand3.byteValue) {
                    PackedDecimal.setPackedZero(packedDecimalOperand.byteArray, packedDecimalOperand.offset, packedDecimalOperand.precision);
                    return;
                }
            }
            if ((packedDecimalOperand2.byteValue & 0xFF) > (packedDecimalOperand3.byteValue & 0xFF)) {
                PackedDecimal.computeDifference(packedDecimalOperand2, packedDecimalOperand3, bl);
            } else {
                PackedDecimal.computeDifference(packedDecimalOperand3, packedDecimalOperand2, bl);
            }
        }
    }

    public static void multiplyPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. multiplyPackedDecimal is trying to access result[" + n + "] to result[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. multiplyPackedDecimal is trying to access op1Decimal[" + n3 + "] to op1Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        if (n5 < 0 || n5 + (n6 / 2 + 1) > byArray3.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. multiplyPackedDecimal is trying to access op2Decimal[" + n5 + "] to op2Decimal[" + (n5 + n6 / 2) + "] but valid indices are from 0 to " + (byArray3.length - 1) + ".");
        }
        PackedDecimal.multiplyPackedDecimal_(byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    private static void multiplyPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) {
        PackedDecimal.packedDecimalBinaryOp(1, byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    public static void dividePackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. dividePackedDecimal is trying to access result[" + n + "] to result[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. dividePackedDecimal is trying to access op1Decimal[" + n3 + "] to op1Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        if (n5 < 0 || n5 + (n6 / 2 + 1) > byArray3.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. dividePackedDecimal is trying to access op2Decimal[" + n5 + "] to op2Decimal[" + (n5 + n6 / 2) + "] but valid indices are from 0 to " + (byArray3.length - 1) + ".");
        }
        PackedDecimal.dividePackedDecimal_(byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    private static void dividePackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) {
        PackedDecimal.packedDecimalBinaryOp(2, byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    public static void remainderPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. remainderPackedDecimal is trying to access result[" + n + "] to result[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. remainderPackedDecimal is trying to access op1Decimal[" + n3 + "] to op1Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        if (n5 < 0 || n5 + (n6 / 2 + 1) > byArray3.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. remainderPackedDecimal is trying to access op2Decimal[" + n5 + "] to op2Decimal[" + (n5 + n6 / 2) + "] but valid indices are from 0 to " + (byArray3.length - 1) + ".");
        }
        PackedDecimal.remainderPackedDecimal_(byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    private static void remainderPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6, boolean bl) {
        PackedDecimal.packedDecimalBinaryOp(3, byArray, n, n2, byArray2, n3, n4, byArray3, n5, n6, bl);
    }

    private static BigInteger getBigInteger(byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        StringBuilder stringBuilder = new StringBuilder();
        if ((byArray[n3] & 0xF) == 11 || (byArray[n3] & 0xF) == 13) {
            stringBuilder.append('-');
        }
        for (int i = n; i < n3; ++i) {
            stringBuilder.append((char)(48 + (byArray[i] >> 4 & 0xF)));
            stringBuilder.append((char)(48 + (byArray[i] & 0xF)));
        }
        stringBuilder.append((char)(48 + (byArray[n3] >> 4 & 0xF)));
        return new BigInteger(stringBuilder.toString());
    }

    private static void putBigInteger(byte[] byArray, int n, int n2, BigInteger bigInteger, boolean bl) throws ArithmeticException {
        int n3 = n + n2 - 1;
        char[] cArray = bigInteger.toString().toCharArray();
        boolean bl2 = cArray[0] == '-';
        int n4 = bl2 ? 1 : 0;
        int n5 = cArray.length - 1;
        byArray[n3--] = (byte)((bl2 ? 13 : 12) | cArray[n5--] - 48 << 4);
        while (n3 >= n) {
            byte by = 0;
            if (n5 >= n4) {
                by = (byte)(cArray[n5--] - 48);
                if (n5 >= n4) {
                    by = (byte)(by | cArray[n5--] - 48 << 4);
                }
            }
            byArray[n3--] = by;
        }
        if (bl && n5 < n4) {
            while (n5 >= n4) {
                if (cArray[n5--] == '0') continue;
                throw new ArithmeticException("Packed Decimal overflow during multiplication/division, non-zero digits lost");
            }
        }
    }

    private static void zeroTopNibbleIfEven(byte[] byArray, int n, int n2) {
        if (n2 % 2 == 0) {
            int n3 = n;
            byArray[n3] = (byte)(byArray[n3] & 0xF);
        }
    }

    private static void packedDecimalBinaryOp(int n, byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, byte[] byArray3, int n6, int n7, boolean bl) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        PackedDecimal.zeroTopNibbleIfEven(byArray2, n4, n5);
        PackedDecimal.zeroTopNibbleIfEven(byArray3, n6, n7);
        switch (n) {
            case 1: {
                if (n5 + n7 > 18 || n3 > 18) break;
                long l = DecimalData.convertPackedDecimalToLong(byArray2, n4, n5, bl);
                long l2 = DecimalData.convertPackedDecimalToLong(byArray3, n6, n7, bl);
                long l3 = l * l2;
                DecimalData.convertLongToPackedDecimal(l3, byArray, n2, n3, bl);
                if (l3 == 0L) {
                    PackedDecimal.forceSign(byArray, n2, n3, byArray2, n4, n5, byArray3, n6, n7);
                }
                return;
            }
            case 2: 
            case 3: {
                if (n5 > 18 || n7 > 18 || n3 > 18) break;
                long l = DecimalData.convertPackedDecimalToLong(byArray2, n4, n5, bl);
                long l4 = DecimalData.convertPackedDecimalToLong(byArray3, n6, n7, bl);
                long l5 = n == 2 ? l / l4 : l % l4;
                DecimalData.convertLongToPackedDecimal(l5, byArray, n2, n3, bl);
                if (l5 == 0L) {
                    PackedDecimal.forceSign(byArray, n2, n3, byArray2, n4, n5, byArray3, n6, n7);
                }
                return;
            }
        }
        try {
            bigInteger2 = PackedDecimal.getBigInteger(byArray2, n4, PackedDecimal.precisionToByteLength(n5));
            bigInteger = PackedDecimal.getBigInteger(byArray3, n6, PackedDecimal.precisionToByteLength(n7));
        }
        catch (NumberFormatException numberFormatException) {
            if (bl) {
                throw new IllegalArgumentException("Invalid packed data value", numberFormatException);
            }
            return;
        }
        BigInteger bigInteger3 = null;
        switch (n) {
            case 1: {
                bigInteger3 = bigInteger2.multiply(bigInteger);
                break;
            }
            case 2: {
                bigInteger3 = bigInteger2.divide(bigInteger);
                break;
            }
            case 3: {
                bigInteger3 = bigInteger2.remainder(bigInteger);
            }
        }
        PackedDecimal.putBigInteger(byArray, n2, PackedDecimal.precisionToByteLength(n3), bigInteger3, bl);
        if (BigInteger.ZERO.equals(bigInteger3)) {
            PackedDecimal.forceSign(byArray, n2, n3, byArray2, n4, n5, byArray3, n6, n7);
        }
    }

    private static void forceSign(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, byte[] byArray3, int n5, int n6) {
        int n7;
        int n8 = n3 + PackedDecimal.precisionToByteLength(n4) - 1;
        int n9 = n5 + PackedDecimal.precisionToByteLength(n6) - 1;
        int n10 = n7 = n + PackedDecimal.precisionToByteLength(n2) - 1;
        byArray[n10] = (byte)(byArray[n10] | 0xF);
        int n11 = n7;
        byArray[n11] = (byte)(byArray[n11] & PackedDecimal.signMask(byArray2[n8], byArray3[n9]));
    }

    private static int precisionToByteLength(int n) {
        return (n + 2) / 2;
    }

    private static byte signMask(byte by, byte by2) {
        return (byte)(PackedDecimal.sign(by) * PackedDecimal.sign(by2) > 0 ? 252 : 253);
    }

    private static int sign(byte by) {
        return CommonData.getSign(by & 0xF) == 13 ? -1 : 1;
    }

    public static boolean lessThanPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanPackedDecimal is trying to access op1Decimal[" + n + "] to op1Decimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanPackedDecimal is trying to access op2Decimal[" + n3 + "] to op2Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        return PackedDecimal.lessThanPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    private static boolean lessThanPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return PackedDecimal.greaterThanPackedDecimal_(byArray2, n3, n4, byArray, n, n2);
    }

    public static boolean lessThanOrEqualsPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanOrEqualsPackedDecimal is trying to access op1Decimal[" + n + "] to op1Decimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanOrEqualsPackedDecimal is trying to access op2Decimal[" + n3 + "] to op2Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        return PackedDecimal.lessThanOrEqualsPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    private static boolean lessThanOrEqualsPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return !PackedDecimal.greaterThanPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    public static boolean greaterThanPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanPackedDecimal is trying to access op1Decimal[" + n + "] to op1Decimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanPackedDecimal is trying to access op2Decimal[" + n3 + "] to op2Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        return PackedDecimal.greaterThanPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    private static boolean greaterThanPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl;
        if (n2 < 1 || n4 < 1) {
            throw new IllegalArgumentException("Invalid Precision for an operand");
        }
        int n7 = n + PackedDecimal.precisionToByteLength(n2) - 1;
        int n8 = n3 + PackedDecimal.precisionToByteLength(n4) - 1;
        byte by = CommonData.getSign((byte)(byArray[n7] & 0xF));
        byte by2 = CommonData.getSign((byte)(byArray2[n8] & 0xF));
        boolean bl2 = bl = by == 13;
        while (n < n7 && byArray[n] == 0) {
            ++n;
        }
        while (n3 < n8 && byArray2[n3] == 0) {
            ++n3;
        }
        int n9 = n7 - n;
        int n10 = n8 - n3;
        if (n9 + n10 == 0) {
            int n11 = byArray[n] >> 4 & 0xF;
            int n12 = byArray2[n3] >> 4 & 0xF;
            if (n11 + n12 == 0) {
                return false;
            }
            if (by < by2) {
                return true;
            }
            if (by > by2) {
                return false;
            }
            return n11 > n12 && !bl || n11 < n12 && bl;
        }
        if (by < by2) {
            return true;
        }
        if (by > by2) {
            return false;
        }
        if (n9 > n10 && !bl || n9 < n10 && bl) {
            return true;
        }
        if (n9 < n10 && !bl || n9 > n10 && bl) {
            return false;
        }
        while (n < n7 && n3 < n8) {
            n6 = byArray[n] & 0xFF;
            n5 = byArray2[n3] & 0xFF;
            int n13 = n6 - n5;
            if (n13 < 0 && !bl || n13 > 0 && bl) {
                return false;
            }
            if (n13 > 0 && !bl || n13 < 0 && bl) {
                return true;
            }
            ++n;
            ++n3;
        }
        n6 = byArray[n] >> 4 & 0xF;
        n5 = byArray2[n3] >> 4 & 0xF;
        return n6 > n5 && !bl || n6 < n5 && bl;
    }

    public static boolean greaterThanOrEqualsPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanOrEqualsPackedDecimal is trying to access op1Decimal[" + n + "] to op1Decimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanOrEqualsPackedDecimal is trying to access op2Decimal[" + n3 + "] to op2Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        return PackedDecimal.greaterThanOrEqualsPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    private static boolean greaterThanOrEqualsPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return !PackedDecimal.lessThanPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    public static boolean equalsPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. equalsPackedDecimal is trying to access op1Decimal[" + n + "] to op1Decimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. equalsPackedDecimal is trying to access op2Decimal[" + n3 + "] to op2Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        return PackedDecimal.equalsPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    private static boolean equalsPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        boolean bl;
        if (n2 < 1 || n4 < 1) {
            throw new IllegalArgumentException("Invalid Precision for an operand");
        }
        int n5 = n + PackedDecimal.precisionToByteLength(n2) - 1;
        int n6 = n3 + PackedDecimal.precisionToByteLength(n4) - 1;
        byte by = CommonData.getSign((byte)(byArray[n5] & 0xF));
        byte by2 = CommonData.getSign((byte)(byArray2[n6] & 0xF));
        boolean bl2 = n2 % 2 == 0;
        boolean bl3 = bl = n4 % 2 == 0;
        if (by != by2) {
            return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(byArray, n, n5, bl2, true) && PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(byArray2, n3, n6, bl, true);
        }
        if ((byArray[n5] & 0xF0) != (byArray2[n6] & 0xF0)) {
            return false;
        }
        if (n5 > n && n6 > n3) {
            --n5;
            --n6;
        }
        while (n5 > n && n6 > n3) {
            if (byArray[n5] != byArray2[n6]) {
                return false;
            }
            --n5;
            --n6;
        }
        if (n5 == n) {
            if (bl2) {
                if ((byArray[n5] & 0xF) == (byArray2[n6] & 0xF)) {
                    return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(byArray2, n3, n6, bl, !bl || n6 != n3);
                }
            } else if (byArray[n5] == byArray2[n6]) {
                return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(byArray2, n3, n6, bl, false);
            }
        } else if (bl) {
            if ((byArray[n5] & 0xF) == (byArray2[n6] & 0xF)) {
                return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(byArray, n, n5, bl2, !bl2 || n5 != n);
            }
        } else if (byArray[n5] == byArray2[n6]) {
            return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(byArray, n, n5, bl2, false);
        }
        return false;
    }

    private static boolean checkZeroBetweenOpOffsetAndOpEnd(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        if (bl2 && (byArray[n2] & 0xF0) != 0) {
            return false;
        }
        if (n2-- > n) {
            while (n2 > n) {
                if (byArray[n2--] == 0) continue;
                return false;
            }
            if (bl ? (byArray[n2] & 0xF) != 0 : byArray[n2] != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean notEqualsPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. notEqualsPackedDecimal is trying to access op1Decimal[" + n + "] to op1Decimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. notEqualsPackedDecimal is trying to access op2Decimal[" + n3 + "] to op2Decimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        return PackedDecimal.notEqualsPackedDecimal_(byArray, n, n2, byArray2, n3, n4);
    }

    private static boolean notEqualsPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return !PackedDecimal.equalsPackedDecimal(byArray, n, n2, byArray2, n3, n4);
    }

    private static void roundUpPackedDecimal(byte[] byArray, int n, int n2, int n3, int n4, boolean bl) {
        byArray[n2] = CommonData.getPackedAddOneSignValues(byArray[n2]);
        if ((byte)(byArray[n2] & 0xF0) == 0) {
            byte[] byArray2 = new byte[]{1, byArray[n2]};
            PackedDecimal.addPackedDecimal(byArray, n, n3, byArray, n, n3, byArray2, 0, 2, bl);
        }
    }

    private static void checkIfZero(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (CommonData.getSign(byArray[n2] & 0xF) != 13) {
            return;
        }
        if (bl && (byArray[n] & 0xF) != 0) {
            return;
        }
        for (n4 = n; n4 < n2 && byArray[n4] == 0; ++n4) {
        }
        if (n4 < n2) {
            return;
        }
        if ((byArray[n2] & 0xF0) == 0) {
            byArray[n2] = 12;
        }
    }

    public static void shiftRightPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftRightPackedDecimal is trying to access destinationDecimal[" + n + "] to destinationDecimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftRightPackedDecimal is trying to access sourceDecimal[" + n3 + "] to sourceDecimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        PackedDecimal.shiftRightPackedDecimal_(byArray, n, n2, byArray2, n3, n4, n5, bl, bl2);
    }

    private static void shiftRightPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n3 + PackedDecimal.precisionToByteLength(n4) - 1;
        byte by = CommonData.getSign(byArray2[n11] & 0xF);
        int n12 = n;
        int n13 = n2;
        int n14 = n + PackedDecimal.precisionToByteLength(n2) - 1;
        int n15 = n4 - 1;
        int n16 = 0;
        int n17 = n4 - n2;
        boolean bl3 = n4 % 2 == 0;
        boolean bl4 = false;
        boolean bl5 = false;
        int n18 = 0;
        boolean bl6 = false;
        if (n2 < 1 || n4 < 1 || n5 < 0) {
            throw new IllegalArgumentException("Invalid Precisions or shift amount");
        }
        if (PackedDecimal.checkPackedDecimal_(byArray2, n3, n4, true, false) != 0) {
            throw new IllegalArgumentException("Invalid sign or digit code in input packed decimal");
        }
        n16 += n5;
        if ((n17 -= n5) > 0) {
            n15 -= n17;
            if (bl2) {
                n10 = 0;
                if (bl3) {
                    --n17;
                    ++n10;
                    if ((byte)(byArray2[n3] & 0xF) != 0) {
                        throw new ArithmeticException("Decimal overflow in shiftRightPackedDecimal.");
                    }
                }
                n9 = n17 / 2;
                n17 -= n9 * 2;
                for (n8 = 0; n8 < n9; ++n8) {
                    if (byArray2[n8 + n3 + n10] == 0) continue;
                    throw new ArithmeticException("Decimal overflow in shiftRightPackedDecimal.");
                }
                if (n17 == 1 && (byte)(byArray2[n9 + n3] & 0xF0) != 0) {
                    throw new ArithmeticException("Decimal overflow in shiftRightPackedDecimal.");
                }
            }
        }
        n9 = n15 + 1 - n16;
        if (bl2 && n9 < 1) {
            bl6 = true;
        }
        n10 = n4 - (n15 + 1);
        if (bl3 && n9 % 2 == 0) {
            if (n10 % 2 == 0) {
                bl5 = true;
                bl4 = true;
                n7 = n3 + n10 / 2;
                n6 = n11 - n16 / 2;
            } else {
                n7 = n3 + (n10 + 1) / 2;
                n6 = n11 - (n16 + 1) / 2;
            }
        } else if (bl3 && n9 % 2 != 0) {
            if (n10 % 2 != 0) {
                bl4 = true;
                n7 = n3 + (n10 + 1) / 2;
                n6 = n11 - n16 / 2;
            } else {
                bl5 = true;
                n7 = n3 + n10 / 2;
                n6 = n11 - (n16 + 1) / 2;
            }
        } else if (!bl3 && n9 % 2 == 0) {
            if (n10 % 2 == 0) {
                n7 = n3 + n10 / 2;
                n6 = n11 - (n16 + 1) / 2;
            } else {
                bl5 = true;
                bl4 = true;
                n7 = n3 + n10 / 2;
                n6 = n11 - n16 / 2;
            }
        } else if (n10 % 2 == 0) {
            bl4 = true;
            n7 = n3 + n10 / 2;
            n6 = n11 - n16 / 2;
        } else {
            bl5 = true;
            n7 = n3 + n10 / 2;
            n6 = n11 - (n16 + 1) / 2;
        }
        if (bl && n5 > 0 && n9 > -1) {
            n18 = bl4 ? byArray2[n6] & 0xF : byArray2[n6 + 1] >> 4 & 0xF;
        }
        while (n17 < 0) {
            byArray[n12] = 0;
            if (n13 % 2 == 0 || n17 == -1) {
                if (n13 % 2 == 0) {
                    ++n12;
                }
                ++n17;
                --n13;
                continue;
            }
            if (n17 / -2 < 1) continue;
            n17 += 2;
            n13 -= 2;
            ++n12;
        }
        if (bl4 && !bl6) {
            if (!bl5) {
                System.arraycopy((Object)byArray2, n7, (Object)byArray, n12, n6 - n7 + 1);
            } else {
                byArray[n12] = (byte)(byArray2[n7] & 0xF);
                System.arraycopy((Object)byArray2, ++n7, (Object)byArray, ++n12, n6 - n7 + 1);
            }
        } else if (!bl6) {
            n8 = n12 + PackedDecimal.precisionToByteLength(n13) - 1;
            byte by2 = n6 < n3 ? (byte)0 : byArray2[n6];
            byArray[n8] = (byte)(by2 << 4 & 0xF0);
            --n8;
            --n13;
            byte by3 = 0;
            while (n6 > n7 && n8 > n12) {
                by3 = (byte)(byArray2[n6] >> 4 & 0xF);
                byArray[n8] = by3 = (byte)(by3 | (byte)(byArray2[--n6] << 4 & 0xF0));
                --n8;
                n13 -= 2;
            }
            if (n13 > 0) {
                byArray[n8] = (byte)(byArray2[n6] >> 4 & 0xF);
                --n6;
                if (--n13 > 0 && bl5) {
                    int n19 = n8;
                    byArray[n19] = (byte)(byArray[n19] | (byte)(byArray2[n6] << 4 & 0xF0));
                }
            }
        }
        if (bl6 && n18 < 5 && by != 12) {
            byArray[n14] = (byte)(byArray[n14] & 0xF0 | by);
        } else {
            byArray[n14] = (byte)(byArray[n14] & 0xF0 | by);
            if (bl && n18 >= 5) {
                PackedDecimal.roundUpPackedDecimal(byArray, n, n14, n2, n18, bl2);
            }
            if (bl2 || bl) {
                PackedDecimal.checkIfZero(byArray, n, n14, n2, n2 % 2 == 0);
            }
        }
    }

    public static void shiftLeftPackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, boolean bl) {
        if (n + (n2 / 2 + 1) > byArray.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftLeftPackedDecimal is trying to access destinationDecimal[" + n + "] to destinationDecimal[" + (n + n2 / 2) + "] but valid indices are from 0 to " + (byArray.length - 1) + ".");
        }
        if (n3 < 0 || n3 + (n4 / 2 + 1) > byArray2.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftLeftPackedDecimal is trying to access sourceDecimal[" + n3 + "] to sourceDecimal[" + (n3 + n4 / 2) + "] but valid indices are from 0 to " + (byArray2.length - 1) + ".");
        }
        PackedDecimal.shiftLeftPackedDecimal_(byArray, n, n2, byArray2, n3, n4, n5, bl);
    }

    private static void shiftLeftPackedDecimal_(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8;
        if (n2 < 1 || n4 < 1 || n5 < 0) {
            throw new IllegalArgumentException("Invalid Precisions or shift amount");
        }
        if (PackedDecimal.checkPackedDecimal_(byArray2, n3, n4, true, false) != 0) {
            throw new IllegalArgumentException("Invalid sign or digit code in input packed decimal");
        }
        int n9 = n3 + PackedDecimal.precisionToByteLength(n4) - 1;
        byte by = CommonData.getSign(byArray2[n9] & 0xF);
        boolean bl2 = false;
        int n10 = PackedDecimal.precisionToByteLength(n4);
        int n11 = PackedDecimal.precisionToByteLength(n2);
        int n12 = n5 / 2;
        int n13 = 0;
        int n14 = 0;
        if (n4 % 2 != 0) {
            for (n13 = 0; n13 < n10 && byArray2[n13 + n3] == 0; ++n13) {
            }
            if ((byte)(byArray2[n13 + n3] & 0xF0) == 0) {
                ++n14;
            }
        } else if ((byte)(byArray2[n3] & 0xF) == 0) {
            ++n14;
            for (n8 = 1; n8 < n10 && byArray2[n8 + n3] == 0; ++n8) {
                ++n13;
            }
            if ((byte)(byArray2[n13 + n3 + 1] & 0xF0) == 0) {
                ++n14;
            }
        }
        if (bl && n2 + (n14 += n13 * 2) < n4 + n5) {
            throw new ArithmeticException("Overflow - Destination precision not enough to hold the result of the shift operation");
        }
        Arrays.fill(byArray, n, n + n11, (byte)0);
        n8 = n13 + n3;
        int n15 = n11 - n10;
        int n16 = n + n13 - n12 + n15;
        int n17 = n10 - n13;
        int n18 = n16 + n17 - 1;
        if (n2 <= n5) {
            if (bl && by != 12) {
                bl2 = true;
            }
        } else if (n5 % 2 == 0) {
            if (n16 < n) {
                n7 = n4 - (n2 - n5);
                n6 = n4 % 2 == 0 ? n3 + (n7 + 1) / 2 : n3 + n7 / 2;
                System.arraycopy((Object)byArray2, n6, (Object)byArray, n, n11 - n5 / 2);
            } else {
                System.arraycopy((Object)byArray2, n8, (Object)byArray, n16, n10 - n13);
            }
            if (n18 >= 0) {
                byArray[n18] = (byte)(byArray[n18] & 0xF0);
            }
        } else {
            for (int i = 0; i < n17; ++i) {
                n7 = (byte)(byArray2[n8 + i] & 0xF0);
                n6 = (byte)(byArray2[n8 + i] & 0xF);
                if (n16 - 1 + i >= n) {
                    byArray[n16 - 1 + i] = (byte)(n7 >> 4 & 0xF | (byte)(byArray[n16 - 1 + i] & 0xF0));
                }
                if (n16 + i < n) continue;
                byArray[n16 + i] = (byte)(n6 << 4);
            }
            if (n18 >= 0) {
                byArray[n18] = 0;
            }
        }
        n7 = n + n11 - 1;
        int n19 = n6 = n2 % 2 == 0 ? 1 : 0;
        if (n6 != 0) {
            byArray[n] = (byte)(byArray[n] & 0xF);
        }
        if (bl2) {
            byArray[n7] = (byte)(0xC | byArray[n7]);
        } else {
            byArray[n7] = (byte)(by | byArray[n7]);
            if (bl) {
                PackedDecimal.checkIfZero(byArray, n, n7, n2, n6 != 0);
            }
        }
    }

    public static void movePackedDecimal(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, boolean bl) {
        PackedDecimal.shiftLeftPackedDecimal(byArray, n, n2, byArray2, n3, n4, 0, bl);
    }

    private static class PackedDecimalOperand {
        private static final byte PACKED_ZERO = 0;
        byte[] byteArray;
        int offset;
        int precision;
        int bytes;
        int signOffset;
        int currentOffset;
        int signByteValue;
        int sign;
        int signDigit;
        int byteValue;
        int indexValue;

        private PackedDecimalOperand() {
        }

        public void setOperand(byte[] byArray, int n, int n2) {
            this.byteArray = byArray;
            this.offset = n;
            this.precision = n2;
            this.bytes = CommonData.getPackedByteCount(n2);
            this.signOffset = this.offset + this.bytes - 1;
            this.currentOffset = this.signOffset - 1;
            while (byArray[this.offset] == 0 && this.offset < this.signOffset) {
                ++this.offset;
            }
            this.bytes = this.signOffset - this.offset + 1;
            this.signByteValue = this.byteArray[this.signOffset] & 0xFF;
            this.signDigit = this.signByteValue & 0xF0;
            this.sign = CommonData.getSign(this.signByteValue & 0xF);
        }

        public void setSumOperand(byte[] byArray, int n, int n2) {
            this.byteArray = byArray;
            this.offset = n;
            this.precision = n2;
            this.bytes = CommonData.getPackedByteCount(n2);
            this.signOffset = this.offset + this.bytes - 1;
            this.currentOffset = this.signOffset - 1;
        }
    }
}

