/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCRememberedSetIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCRememberedSetSlotIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckRememberedSet
extends Check {
    CheckRememberedSet() {
    }

    @Override
    public void check() {
        try {
            if (!J9BuildFlags.gc_modronScavenger || !this._extensions.scavengerEnabled()) {
                return;
            }
            GCRememberedSetIterator gCRememberedSetIterator = GCRememberedSetIterator.from();
            while (gCRememberedSetIterator.hasNext()) {
                MM_SublistPuddlePointer mM_SublistPuddlePointer = gCRememberedSetIterator.next();
                GCRememberedSetSlotIterator gCRememberedSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(mM_SublistPuddlePointer);
                while (gCRememberedSetSlotIterator.hasNext()) {
                    PointerPointer pointerPointer = PointerPointer.cast(gCRememberedSetSlotIterator.nextAddress());
                    if (this._engine.checkSlotRememberedSet(pointerPointer, mM_SublistPuddlePointer) == 0) continue;
                    return;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "REMEMBERED SET";
    }

    @Override
    public void print() {
        try {
            GCRememberedSetIterator gCRememberedSetIterator = GCRememberedSetIterator.from();
            ScanFormatter scanFormatter = new ScanFormatter(this, "RememberedSet Sublist", this.getGCExtensions().rememberedSetEA());
            while (gCRememberedSetIterator.hasNext()) {
                MM_SublistPuddlePointer mM_SublistPuddlePointer = gCRememberedSetIterator.next();
                scanFormatter.section("puddle", mM_SublistPuddlePointer);
                GCRememberedSetSlotIterator gCRememberedSetSlotIterator = GCRememberedSetSlotIterator.fromSublistPuddle(mM_SublistPuddlePointer);
                while (gCRememberedSetSlotIterator.hasNext()) {
                    scanFormatter.entry(gCRememberedSetSlotIterator.next());
                }
                scanFormatter.endSection();
            }
            scanFormatter.end("RememberedSet Sublist", this.getGCExtensions().rememberedSetEA());
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

