/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.base;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;

public class DiagnosticProperties {
    private final Properties baseProperties;
    private static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String DEBUG_PROPERTY = "openj9.tools.attach.diagnostics.debug";
    public static boolean isDebug = Boolean.getBoolean("openj9.tools.attach.diagnostics.debug");

    public DiagnosticProperties(Properties properties) {
        this.baseProperties = properties;
    }

    public DiagnosticProperties() {
        this.baseProperties = new Properties();
    }

    public void put(String string, int n) {
        this.baseProperties.setProperty(string, Integer.toString(n));
    }

    public void put(String string, String string2) {
        this.baseProperties.setProperty(string, string2);
    }

    public void put(String string, long l) {
        this.baseProperties.setProperty(string, Long.toString(l));
    }

    public void put(String string, boolean bl) {
        this.baseProperties.setProperty(string, Boolean.toString(bl));
    }

    private void checkExists(String string) throws IOException {
        if (!this.containsField(string)) {
            throw new IOException("key " + string + " not found");
        }
    }

    public boolean containsField(String string) {
        return this.baseProperties.containsKey(string);
    }

    public int getInt(String string) throws NumberFormatException, IOException {
        this.checkExists(string);
        return Integer.parseInt(this.baseProperties.getProperty(string));
    }

    public long getLong(String string) throws NumberFormatException, IOException {
        this.checkExists(string);
        return Long.parseLong(this.baseProperties.getProperty(string));
    }

    public boolean getBoolean(String string) throws IOException {
        this.checkExists(string);
        return Boolean.parseBoolean(this.baseProperties.getProperty(string));
    }

    public String getPropertyOrNull(String string) {
        return this.baseProperties.getProperty(string);
    }

    public Object getSimple(String string, String string2) throws NumberFormatException {
        Object object = null;
        String string3 = this.baseProperties.getProperty(string2);
        if (null != string3 && (JAVA_LANG_STRING.equals(string) || !string3.isEmpty())) {
            switch (string) {
                case "java.lang.Boolean": {
                    object = Boolean.valueOf(string3);
                    break;
                }
                case "java.lang.Character": {
                    object = Character.valueOf(string3.charAt(0));
                    break;
                }
                case "java.lang.Byte": {
                    object = Byte.valueOf(string3);
                    break;
                }
                case "java.lang.Short": {
                    object = Short.valueOf(string3);
                    break;
                }
                case "java.lang.Integer": {
                    object = Integer.valueOf(string3);
                    break;
                }
                case "java.lang.Long": {
                    object = Long.valueOf(string3);
                    break;
                }
                case "java.lang.Float": {
                    object = Float.valueOf(string3);
                    break;
                }
                case "java.lang.Double": {
                    object = Double.valueOf(string3);
                    break;
                }
                case "java.lang.String": {
                    object = string3;
                    break;
                }
            }
        }
        return object;
    }

    public static void dumpPropertiesIfDebug(String string, DiagnosticProperties diagnosticProperties) {
        DiagnosticProperties.dumpPropertiesIfDebug(string, diagnosticProperties.baseProperties);
    }

    public static void dumpPropertiesIfDebug(String string, Properties properties) {
        if (isDebug) {
            if (null != string) {
                System.err.println(string);
            }
            if (null != properties) {
                String string2 = DiagnosticProperties.printProperties(properties);
                System.err.print(string2);
            }
        }
    }

    public static String printProperties(Properties properties) {
        StringWriter stringWriter = new StringWriter(1000);
        try (Object object = new PrintWriter(stringWriter);){
            properties.entrySet().stream().sorted(Comparator.comparing(entry -> entry.getKey().toString())).forEach(arg_0 -> DiagnosticProperties.lambda$printProperties$1((PrintWriter)object, arg_0));
        }
        object = stringWriter.toString();
        return object;
    }

    public Properties toProperties() {
        return this.baseProperties;
    }

    private static /* synthetic */ void lambda$printProperties$1(PrintWriter printWriter, Map.Entry entry) {
        printWriter.print(entry.getKey());
        printWriter.print("=");
        printWriter.println((String)entry.getValue());
    }
}

