/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.vm.VM;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.VirtualHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

abstract class PrimitiveHandle
extends MethodHandle {
    long vmSlot;
    int rawModifiers;
    Class<?> defc;
    final Class<?> referenceClass;
    final String name;
    Class<?> specialCaller;

    PrimitiveHandle(MethodType methodType, Class<?> clazz, String string, byte by, int n, Object object) {
        super(methodType, by, object);
        this.referenceClass = clazz;
        this.defc = clazz;
        this.name = string;
        this.rawModifiers = n;
    }

    PrimitiveHandle(MethodType methodType, Class<?> clazz, String string, byte by, Object object) {
        this(methodType, clazz, string, by, 0, object);
    }

    PrimitiveHandle(PrimitiveHandle primitiveHandle, MethodType methodType) {
        super(primitiveHandle, methodType);
        this.referenceClass = primitiveHandle.referenceClass;
        this.defc = primitiveHandle.defc;
        this.name = primitiveHandle.name;
        this.rawModifiers = primitiveHandle.rawModifiers;
        this.specialCaller = primitiveHandle.specialCaller;
        this.vmSlot = primitiveHandle.vmSlot;
    }

    @Override
    Class<?> getDefc() {
        return this.defc;
    }

    @Override
    Class<?> getReferenceClass() {
        return this.referenceClass;
    }

    @Override
    Class<?> getSpecialCaller() {
        return this.specialCaller;
    }

    @Override
    String getMethodName() {
        return this.name;
    }

    @Override
    int getModifiers() {
        return this.rawModifiers;
    }

    private native Class<?> lookupMethod(Class<?> var1, String var2, String var3, byte var4, Class<?> var5);

    final native Class<?> lookupField(Class<?> var1, String var2, String var3, boolean var4, Class<?> var5);

    static native boolean setVMSlotAndRawModifiersFromField(PrimitiveHandle var0, Field var1);

    static native boolean setVMSlotAndRawModifiersFromMethod(PrimitiveHandle var0, Class<?> var1, Method var2, byte var3, Class<?> var4);

    static native boolean setVMSlotAndRawModifiersFromConstructor(PrimitiveHandle var0, Constructor var1);

    static native boolean setVMSlotAndRawModifiersFromSpecialHandle(VirtualHandle var0, DirectHandle var1);

    final void initializeClassIfRequired() {
        if (Modifier.isStatic(this.rawModifiers) && JITHELPERS.getClassInitializeStatus(this.defc) != VM.J9CLASS_INIT_SUCCEEDED) {
            UNSAFE.ensureClassInitialized(this.defc);
        }
    }

    @Override
    public MethodHandle asVarargsCollector(Class<?> clazz) throws IllegalArgumentException {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz2 = this.type().lastParameterType();
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        return new VarargsCollectorHandle(this, clazz, MethodHandles.Lookup.isVarargs(this.rawModifiers));
    }

    final Class<?> finishMethodInitialization(Class<?> clazz, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
        try {
            String string = methodType.toMethodDescriptorString();
            return this.lookupMethod(this.referenceClass, this.name, string, this.kind, clazz);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new NoSuchMethodException(noSuchMethodError.getMessage());
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            throw new IllegalAccessException(incompatibleClassChangeError.getMessage());
        }
    }
}

