/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.ThreadMap;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=ThreadMap.class)
public class ThreadMapPointer
extends StructurePointer {
    public static final ThreadMapPointer NULL = new ThreadMapPointer(0L);

    protected ThreadMapPointer(long l) {
        super(l);
    }

    public static ThreadMapPointer cast(AbstractPointer abstractPointer) {
        return ThreadMapPointer.cast(abstractPointer.getAddress());
    }

    public static ThreadMapPointer cast(UDATA uDATA) {
        return ThreadMapPointer.cast(uDATA.longValue());
    }

    public static ThreadMapPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new ThreadMapPointer(l);
    }

    @Override
    public ThreadMapPointer add(long l) {
        return ThreadMapPointer.cast(this.address + ThreadMap.SIZEOF * l);
    }

    @Override
    public ThreadMapPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public ThreadMapPointer addOffset(long l) {
        return ThreadMapPointer.cast(this.address + l);
    }

    @Override
    public ThreadMapPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public ThreadMapPointer sub(long l) {
        return ThreadMapPointer.cast(this.address - ThreadMap.SIZEOF * l);
    }

    @Override
    public ThreadMapPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public ThreadMapPointer subOffset(long l) {
        return ThreadMapPointer.cast(this.address - l);
    }

    @Override
    public ThreadMapPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public ThreadMapPointer untag(long l) {
        return ThreadMapPointer.cast(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ThreadMapPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return ThreadMap.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="IDATA")
    public IDATA index() throws CorruptDataException {
        return new IDATA(this.getIDATAAtOffset(ThreadMap._indexOffset_));
    }

    public IDATAPointer indexEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return IDATAPointer.cast(this.address + (long)ThreadMap._indexOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_threadOffset_", declaredType="J9VMThread*")
    public J9VMThreadPointer thread() throws CorruptDataException {
        long l = this.getPointerAtOffset(ThreadMap._threadOffset_);
        return J9VMThreadPointer.cast(l);
    }

    public PointerPointer threadEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)ThreadMap._threadOffset_);
    }
}

