/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.VMDataFactory;
import com.ibm.j9ddr.command.CommandParser;
import com.ibm.j9ddr.command.CommandReader;
import com.ibm.j9ddr.command.ConsoleCommandReader;
import com.ibm.j9ddr.command.JNICommandReader;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.debugger.JniOutputStream;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.exceptions.JVMNotDDREnabledException;
import com.ibm.j9ddr.exceptions.JVMNotFoundException;
import com.ibm.j9ddr.exceptions.MissingDDRStructuresException;
import com.ibm.j9ddr.tools.ddrinteractive.ASNoProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ExtractMemoryCommand;
import com.ibm.j9ddr.tools.ddrinteractive.FindInMemoryCommand;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.J9XCommand;
import com.ibm.j9ddr.tools.ddrinteractive.MemoryRangesCommand;
import com.ibm.j9ddr.tools.ddrinteractive.MissingVMData;
import com.ibm.j9ddr.tools.ddrinteractive.commands.ForeachCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.LookupSymbolCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.NativeLibrariesCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.NativeStacksCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.TimeCommand;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginCommand;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImage;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageAddressSpace;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DDRInteractive
implements Runnable {
    private final PrintStream out;
    private final CommandReader commandReader;
    private static String path;
    private final List<Context> contexts = new LinkedList<Context>();
    private Context currentContext;
    private ICore currentCore;
    private final List<ICommand> nonVMCommands;

    public DDRInteractive(Object object, PrintStream printStream) throws Exception {
        Object object2 = new LinkedList<Command>();
        object2.add(new J9XCommand());
        object2.add(new ContextCommand());
        object2.add(new MemoryRangesCommand());
        object2.add(new FindInMemoryCommand());
        object2.add(new J9HelpCommand());
        object2.add(new PluginCommand());
        object2.add(new NativeLibrariesCommand());
        object2.add(new LookupSymbolCommand());
        object2.add(new NativeStacksCommand());
        object2.add(new ExtractMemoryCommand());
        object2.add(new TimeCommand());
        object2.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(object2);
        this.out = printStream;
        this.commandReader = new ConsoleCommandReader(printStream);
        path = null;
        if (object instanceof J9DDRImage) {
            object2 = ((J9DDRImage)object).getCore();
            this.locateRuntimes((ICore)object2);
            return;
        }
        if (object instanceof IProcess) {
            this.addContextFromProcess((IProcess)object);
            return;
        }
        if (object instanceof ICore) {
            this.locateRuntimes((ICore)object);
            return;
        }
        throw new IllegalArgumentException("The object parameter was not an instance of ICore, IProcess or J9DDRImage, it was " + object.getClass().getName());
    }

    public DDRInteractive(IProcess iProcess, IVMData iVMData, PrintStream printStream) throws Exception {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        linkedList.add(new J9XCommand());
        linkedList.add(new ContextCommand());
        linkedList.add(new MemoryRangesCommand());
        linkedList.add(new FindInMemoryCommand());
        linkedList.add(new J9HelpCommand());
        linkedList.add(new PluginCommand());
        linkedList.add(new NativeLibrariesCommand());
        linkedList.add(new LookupSymbolCommand());
        linkedList.add(new NativeStacksCommand());
        linkedList.add(new ExtractMemoryCommand());
        linkedList.add(new TimeCommand());
        linkedList.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(linkedList);
        this.out = printStream;
        this.commandReader = new ConsoleCommandReader(printStream);
        path = null;
        if (iVMData != null) {
            this.contexts.add(new Context(iProcess, iVMData, this.nonVMCommands));
        } else {
            this.addMissingJVMToContexts(iProcess);
        }
        this.currentContext = this.contexts.get(0);
    }

    public DDRInteractive(List<Object> list, PrintStream printStream) throws Exception {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        linkedList.add(new J9XCommand());
        linkedList.add(new ContextCommand());
        linkedList.add(new MemoryRangesCommand());
        linkedList.add(new FindInMemoryCommand());
        linkedList.add(new J9HelpCommand());
        linkedList.add(new PluginCommand());
        linkedList.add(new NativeLibrariesCommand());
        linkedList.add(new LookupSymbolCommand());
        linkedList.add(new NativeStacksCommand());
        linkedList.add(new ExtractMemoryCommand());
        linkedList.add(new TimeCommand());
        linkedList.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(linkedList);
        this.out = printStream;
        this.commandReader = new ConsoleCommandReader(printStream);
        path = null;
        for (Object e : list) {
            if (!this.hasInterface(e.getClass(), "com.ibm.java.diagnostics.utils.IDTFJContext")) continue;
            this.addDDRContextFromDTFJ(e);
        }
        if (this.contexts.size() > 0) {
            this.currentContext = this.contexts.get(0);
        }
    }

    private boolean hasInterface(Class<?> clazz, String string) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!clazz2.getName().equals(string)) continue;
            return true;
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return this.hasInterface(clazz3, string);
    }

    private Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (clazz.getSuperclass() == null) {
                throw noSuchMethodException;
            }
            return this.findMethod(clazz.getSuperclass(), string, classArray);
        }
    }

    private void addDDRContextFromDTFJ(Object object) throws Exception {
        Method method = this.findMethod(object.getClass(), "getAddressSpace", null);
        Method method2 = this.findMethod(object.getClass(), "getProcess", null);
        Method method3 = this.findMethod(object.getClass(), "getRuntime", null);
        Object object2 = method.invoke(object, (Object[])null);
        Object object3 = method2.invoke(object, (Object[])null);
        Object object4 = method3.invoke(object, (Object[])null);
        if (object2 == null) {
            throw new IOException("Cannot create a context without an associated address space");
        }
        if (!(object2 instanceof J9DDRImageAddressSpace)) {
            throw new UnsupportedOperationException("The supplied DTFJ context is not backed by a DDR implementation");
        }
        IAddressSpace iAddressSpace = ((J9DDRImageAddressSpace)object2).getIAddressSpace();
        IProcess iProcess = null;
        if (object3 != null) {
            iProcess = ((J9DDRImageProcess)object3).getIProcess();
        }
        if (iProcess == null) {
            ASNoProcess aSNoProcess = new ASNoProcess(iAddressSpace);
            this.addMissingJVMToContexts(aSNoProcess);
            return;
        }
        if (object4 == null) {
            this.addMissingJVMToContexts(iProcess);
            return;
        }
        IVMData iVMData = VMDataFactory.getVMData(iProcess);
        if (iVMData != null) {
            this.contexts.add(new Context(iProcess, iVMData, this.nonVMCommands));
        } else {
            this.addMissingJVMToContexts(iProcess);
        }
    }

    private void addContextFromProcess(IProcess iProcess) throws IOException {
        IVMData iVMData = VMDataFactory.getVMData(iProcess);
        if (iVMData != null) {
            this.contexts.add(new Context(iProcess, iVMData, this.nonVMCommands));
        } else {
            this.addMissingJVMToContexts(iProcess);
        }
    }

    public DDRInteractive(String string, PrintStream printStream) throws Exception {
        this(string, new ConsoleCommandReader(printStream), printStream);
    }

    public DDRInteractive(String string, CommandReader commandReader, PrintStream printStream) throws Exception {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        linkedList.add(new J9XCommand());
        linkedList.add(new ContextCommand());
        linkedList.add(new MemoryRangesCommand());
        linkedList.add(new FindInMemoryCommand());
        linkedList.add(new J9HelpCommand());
        linkedList.add(new PluginCommand());
        linkedList.add(new NativeLibrariesCommand());
        linkedList.add(new LookupSymbolCommand());
        linkedList.add(new NativeStacksCommand());
        linkedList.add(new ExtractMemoryCommand());
        linkedList.add(new TimeCommand());
        linkedList.add(new ForeachCommand());
        this.nonVMCommands = Collections.unmodifiableList(linkedList);
        this.commandReader = commandReader;
        this.out = printStream;
        path = string;
        this.locateRuntimes(string);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            DDRInteractive dDRInteractive = new DDRInteractive(stringArray[0], new PrintStream(System.out));
            dDRInteractive.startDDR();
        }
    }

    public static DDRInteractive instantiateDDR() {
        DDRInteractive dDRInteractive = null;
        JniOutputStream jniOutputStream = new JniOutputStream();
        PrintStream printStream = new PrintStream(jniOutputStream);
        JNICommandReader jNICommandReader = new JNICommandReader(printStream);
        try {
            dDRInteractive = new DDRInteractive(null, jNICommandReader, printStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger logger = Logger.getLogger("j9ddr.interactive.context");
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            logger.logp(Level.FINE, null, null, stringWriter.toString());
        }
        return dDRInteractive;
    }

    public Object[] getCommandNames() {
        Vector<String> vector = this.currentContext.getCommandNames();
        return vector.toArray();
    }

    public Context getCurrentContext() {
        return this.currentContext;
    }

    public void startDDR() throws Exception {
        this.showContexts();
        this.out.print("Run !j9help to see a list of commands\n");
        this.commandReader.processInput(this);
    }

    public void setInputStream(InputStream inputStream) {
        this.commandReader.setInputStream(inputStream);
    }

    public void processLine(String string) throws Exception {
        this.commandReader.processLine(this, string);
    }

    public void showContexts() {
        try {
            this.commandReader.processLine(this, "!context");
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    @Override
    public void run() {
        try {
            this.startDDR();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void execute(CommandParser commandParser) {
        this.currentContext.execute(commandParser, this.out);
    }

    public void execute(String string, String[] stringArray) {
        this.currentContext.execute(string, stringArray, this.out);
    }

    private void locateRuntimes(String string) throws Exception {
        ICore iCore = CoreReader.readCoreFile(string);
        if (null == iCore) {
            throw new RuntimeException("Cannot find Core Reader for file: " + string);
        }
        this.locateRuntimes(iCore);
    }

    private void locateRuntimes(ICore iCore) {
        this.currentCore = iCore;
        Collection<? extends IAddressSpace> collection = iCore.getAddressSpaces();
        for (IAddressSpace object : collection) {
            boolean bl = false;
            Collection<? extends IProcess> collection2 = object.getProcesses();
            for (IProcess iProcess : collection2) {
                bl = true;
                try {
                    IVMData jVMNotFoundException = VMDataFactory.getVMData(iProcess);
                    if (jVMNotFoundException != null) {
                        this.contexts.add(new Context(iProcess, jVMNotFoundException, this.nonVMCommands));
                        continue;
                    }
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (JVMNotDDREnabledException missingDDRStructuresException) {
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (JVMNotFoundException iOException) {
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (MissingDDRStructuresException missingDDRStructuresException) {
                    this.addMissingJVMToContexts(iProcess);
                }
                catch (IOException iOException) {
                    System.err.println("Problem searching for VMData in process " + iProcess);
                    iOException.printStackTrace();
                    Logger logger = Logger.getLogger("j9ddr.interactive.context");
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    iOException.printStackTrace(printWriter);
                    logger.logp(Level.FINE, null, null, stringWriter.toString());
                }
            }
            if (bl) continue;
            ASNoProcess aSNoProcess = new ASNoProcess(object);
            this.addMissingJVMToContexts(aSNoProcess);
        }
        if (this.contexts.size() == 0) {
            throw new RuntimeException("Couldn't find any address spaces in this dump");
        }
        this.currentContext = this.contexts.get(0);
        for (Context context : this.contexts) {
            if (context.vmData instanceof MissingVMData) continue;
            this.currentContext = context;
            break;
        }
    }

    private void addMissingJVMToContexts(IProcess iProcess) {
        MissingVMData missingVMData = new MissingVMData();
        Context context = new Context(iProcess, missingVMData, this.nonVMCommands);
        this.contexts.add(context);
    }

    public Collection getStructuresForCurrentContext() {
        return this.currentContext.vmData.getStructures();
    }

    public static String getPath() {
        return System.getProperty("com.ibm.j9ddr.tools.ddrinteractive.filepath", path);
    }

    public void close() throws Exception {
        if (this.currentCore != null) {
            this.currentCore.close();
        }
        VMDataFactory.clearCache();
    }

    public class ContextCommand
    extends Command {
        public ContextCommand() {
            this.addCommand("context", "[ctx#]", "Lists or selects context (VM) to work with");
        }

        @Override
        public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
            if (stringArray.length == 0) {
                this.printContextList(false);
            } else if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase("short")) {
                    this.printContextList(true);
                } else {
                    this.switchContext(stringArray);
                }
            } else {
                throw new DDRInteractiveCommandException("Unexpected arguments. Usage: !context to list contexts, !context <id> to select a context.");
            }
        }

        private void switchContext(String[] stringArray) throws DDRInteractiveCommandException {
            try {
                int n = Integer.parseInt(stringArray[0]);
                if (n < 0 || n >= DDRInteractive.this.contexts.size()) {
                    throw new DDRInteractiveCommandException("Context ID out of range. Range should be between 0 and " + (DDRInteractive.this.contexts.size() - 1) + " inclusive");
                }
                DDRInteractive.this.currentContext = (Context)DDRInteractive.this.contexts.get(n);
                DDRInteractive.this.out.println("Switched to " + DDRInteractive.this.currentContext);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DDRInteractiveCommandException("Couldn't parse context ID", numberFormatException);
            }
        }

        private void printContextList(boolean bl) {
            int n = 0;
            for (Context context : DDRInteractive.this.contexts) {
                if (context == DDRInteractive.this.currentContext) {
                    DDRInteractive.this.out.print("*");
                } else {
                    DDRInteractive.this.out.print(" ");
                }
                DDRInteractive.this.out.print(n);
                DDRInteractive.this.out.print(" : ");
                DDRInteractive.this.out.println(context.toString(bl));
                ++n;
            }
        }
    }

    public class J9HelpCommand
    extends Command {
        public J9HelpCommand() {
            this.addCommand("j9help", "", "Prints the help table");
            this.addCommand("exit", "", "Exits from DDR Interactive");
            this.addCommand("quit", "", "Quits DDR Interactive: a synonym for \"exit\"");
        }

        @Override
        public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (ICommand object : DDRInteractive.this.nonVMCommands) {
                for (String string2 : object.getCommandDescriptions()) {
                    if (!string2.endsWith("\n")) {
                        string2 = string2 + "\n";
                    }
                    treeSet.add(string2);
                }
            }
            for (ICommand iCommand : context.commands) {
                for (String string2 : iCommand.getCommandDescriptions()) {
                    if (!string2.endsWith("\n")) {
                        string2 = string2 + "\n";
                    }
                    treeSet.add(string2);
                }
            }
            for (String string3 : treeSet) {
                printStream.print(string3);
            }
        }
    }
}

