/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.CommandParser;
import com.ibm.jvm.dtfjview.CombinedContext;
import com.ibm.jvm.dtfjview.ConsoleOutputChannel;
import com.ibm.jvm.dtfjview.FileOutputChannel;
import com.ibm.jvm.dtfjview.JdmpviewContextManager;
import com.ibm.jvm.dtfjview.JdmpviewInitException;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.OutputChannelRedirector;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import com.ibm.jvm.dtfjview.spi.IOutputManager;
import com.ibm.jvm.dtfjview.spi.ISession;
import com.ibm.jvm.dtfjview.spi.ISessionContextManager;
import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.ToolsRegistryOutputChannels;
import com.ibm.jvm.dtfjview.tools.impl.CmdFileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Session
implements ISession {
    public static final String LOGGER_PROPERTY = "com.ibm.jvm.dtfjview.logger";
    private String factoryName;
    private IOutputManager out;
    private static final String PROMPT_FORMAT_DEFAULT = "> ";
    private static final String PROMPT_FORMAT_MULTICONTEXT = "CTX:%d> ";
    public static String prompt = "> ";
    private static final String ARG_CORE = "-core";
    private static final String ARG_XML = "-xml";
    private static final String ARG_ZIP = "-zip";
    private static final String ARG_VERSION = "-version";
    private static final String ARG_VERBOSE = "-verbose";
    private static final String ARG_CMDFILE = "-cmdfile";
    private static final String ARG_CHARSET = "-charset";
    private static final String ARG_OUTFILE = "-outfile";
    private static final String ARG_OVERWRITE = "-overwrite";
    private static final String ARG_APPEND = "-append";
    private static final String ARG_NOEXTRACT = "-notemp";
    private static final String ARG_LEGACYZIP = "-legacyzip";
    private CmdLineParseStateEnum parseState = CmdLineParseStateEnum.PARSE_SCAN;
    private final Map<String, String> args = new HashMap<String, String>();
    private final Set<String> singleargs = new HashSet<String>();
    private final Set<String> pairedargs = new HashSet<String>();
    private final Queue<String> commands = new LinkedList<String>();
    private final Set<String> sessioncommands = new HashSet<String>();
    private boolean isInteractiveSession = false;
    private boolean isVerboseEnabled = false;
    private IOutputChannel defaultOutputChannel = null;
    private FileOutputChannel foc = null;
    private String charsetName = null;
    private CombinedContext ctxroot = null;
    private int ctxid = 0;
    private ICombinedContext currentContext = null;
    private static final String CMD_CONTEXT = "context";
    private static final String CMD_OPEN = "open";
    private static final String CMD_CLOSE = "close";
    private static final String CMD_CD = "cd";
    private static final String CMD_PWD = "pwd";
    private boolean isZOS = false;
    private final HashMap<String, Object> variables = new HashMap();
    private final Logger logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger");
    private final ISessionContextManager ctxmgr = new JdmpviewContextManager();

    public static ISession getInstance(String[] stringArray) {
        return new Session(stringArray);
    }

    private Session(String[] stringArray) {
        this.singleargs.add(ARG_VERBOSE);
        this.singleargs.add(ARG_VERSION);
        this.singleargs.add(ARG_OVERWRITE);
        this.singleargs.add(ARG_APPEND);
        this.singleargs.add(ARG_NOEXTRACT);
        this.singleargs.add(ARG_LEGACYZIP);
        this.pairedargs.add(ARG_CMDFILE);
        this.pairedargs.add(ARG_CORE);
        this.pairedargs.add(ARG_OUTFILE);
        this.pairedargs.add(ARG_CHARSET);
        this.pairedargs.add(ARG_XML);
        this.pairedargs.add(ARG_ZIP);
        this.sessioncommands.add(CMD_CLOSE);
        this.sessioncommands.add(CMD_OPEN);
        this.sessioncommands.add(CMD_CD);
        this.sessioncommands.add(CMD_PWD);
        this.sessionInit(stringArray);
    }

    @Override
    public IOutputManager getOutputManager() {
        return this.out;
    }

    public String getCharset() {
        return this.charsetName;
    }

    private void sessionInit(String[] stringArray) {
        this.out = new Output();
        this.defaultOutputChannel = new ConsoleOutputChannel();
        this.out.addChannel(this.defaultOutputChannel);
        this.variables.put(CMD_PWD, new File(System.getProperty("user.dir")));
        this.variables.put(LOGGER_PROPERTY, Logger.getLogger(LOGGER_PROPERTY));
        this.parseCommandLineArgs(stringArray);
        this.variables.put("extract.mode", !this.hasFlagBeenSet(ARG_NOEXTRACT));
        this.variables.put("zip.mode.legacy", this.hasFlagBeenSet(ARG_LEGACYZIP));
        this.isVerboseEnabled = this.hasFlagBeenSet(ARG_VERBOSE);
        this.charsetName = this.args.get(ARG_CHARSET);
        ToolsRegistry.initialize(this);
        ToolsRegistryOutputChannels.addChannel(this.defaultOutputChannel);
        if (this.isVerboseEnabled) {
            this.enableConsoleLogging(this.logger);
            this.enableConsoleLogging(Logger.getLogger("com.ibm.dtfj.log"));
            this.variables.put("verbose.mode", "true");
        }
        this.logCommandLineArgs();
        this.processCommandFile();
        this.processOutfile();
        this.isInteractiveSession = this.args.get(ARG_CMDFILE) == null && this.commands.isEmpty();
        this.ctxroot = new CombinedContext(0, 0, null, null, null, null, -1);
        this.initializeContext(this.ctxroot);
        this.currentContext = this.ctxroot;
        System.setProperty("com.ibm.j9ddr.noextrasearchfornode", "true");
        if (this.args.containsKey(ARG_CORE) || this.args.containsKey(ARG_ZIP) || this.args.containsKey(ARG_VERSION)) {
            this.imageFromCommandLine();
        }
    }

    private void initializeContext(IDTFJContext iDTFJContext) {
        iDTFJContext.refresh();
        iDTFJContext.getProperties().put("session", this);
        for (String string : this.variables.keySet()) {
            iDTFJContext.getProperties().put(string, this.variables.get(string));
        }
    }

    private void setPrompt() {
        prompt = this.ctxmgr.hasMultipleContexts() ? String.format(PROMPT_FORMAT_MULTICONTEXT, this.ctxid) : String.format(PROMPT_FORMAT_DEFAULT, new Object[0]);
    }

    @Override
    public ICombinedContext getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public ISessionContextManager getContextManager() {
        return this.ctxmgr;
    }

    @Override
    public void setContext(int n) throws com.ibm.java.diagnostics.utils.commands.CommandException {
        ICombinedContext iCombinedContext = this.ctxmgr.getContext(n);
        if (iCombinedContext == null) {
            throw new com.ibm.java.diagnostics.utils.commands.CommandException("The specified context ID of " + n + " is not valid. Execute \"" + CMD_CONTEXT + "\" to see the list of valid IDs.");
        }
        this.setContext(iCombinedContext);
    }

    @Override
    public void setContext(ICombinedContext iCombinedContext) throws com.ibm.java.diagnostics.utils.commands.CommandException {
        if (iCombinedContext != null) {
            this.ctxid = iCombinedContext.getID();
            this.currentContext = iCombinedContext;
            iCombinedContext.setAsCurrent();
            this.setPrompt();
        }
    }

    @Override
    public void showContexts(boolean bl) {
        this.out.println("Available contexts (* = currently selected context) : ");
        Map<URI, ArrayList<ICombinedContext>> map = this.ctxmgr.getContexts();
        if (map.size() == 0) {
            this.out.println("\n\tWARNING : no contexts were found");
            return;
        }
        URI uRI = null;
        for (URI uRI2 : map.keySet()) {
            if (!uRI2.equals(uRI)) {
                this.out.println("\nSource : " + uRI2.getScheme() + "://" + uRI2.getPath() + (uRI2.getFragment() != null ? "#" + uRI2.getFragment() : ""));
                uRI = uRI2;
            }
            for (ICombinedContext iCombinedContext : map.get(uRI2)) {
                if (iCombinedContext == this.currentContext) {
                    this.out.print("\t*");
                } else {
                    this.out.print("\t ");
                }
                iCombinedContext.displayContext(this.out, bl);
            }
        }
        this.out.print("\n");
    }

    private void exit(String string, int n) {
        if (System.getProperty("com.ibm.jvm.dtfjview.nosystemexit") == null) {
            if (string != null && string.length() > 0) {
                this.out.println(string);
            }
            if (n != 0 && n != 4) {
                this.printHelp();
            }
        } else {
            throw new JdmpviewInitException(n, string);
        }
        System.exit(n);
    }

    private boolean hasFlagBeenSet(String string) {
        if (this.singleargs.contains(string)) {
            String string2 = this.args.get(string);
            if (string2 == null) {
                return false;
            }
            return Boolean.parseBoolean(string2);
        }
        return false;
    }

    private void parseCommandLineArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            this.exit("No parameters were supplied", 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].contains("'")) {
                if (!stringArray[i].contains("\"")) {
                    stringArray[i] = "\"" + stringArray[i] + "\"";
                    continue;
                }
                this.exit("Ambiguous parameter " + stringArray[i] + " - mixed ' and \" encountered", 1);
                continue;
            }
            if (stringArray[i].contains("\"")) {
                if (!stringArray[i].contains("'")) {
                    stringArray[i] = "'" + stringArray[i] + "'";
                    continue;
                }
                this.exit("Ambiguous parameter " + stringArray[i] + " - mixed ' and \" encountered", 1);
                continue;
            }
            if (!stringArray[i].matches(".*\\s.+")) continue;
            stringArray[i] = "\"" + stringArray[i] + "\"";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        block7: while (n < stringArray.length && this.parseState != CmdLineParseStateEnum.PARSE_COMPLETE) {
            String string = stringArray[n].toLowerCase();
            switch (this.parseState) {
                case PARSE_SCAN: {
                    if (string.charAt(0) == '-') {
                        this.checkArgIsRecognised(stringArray[n]);
                        if (this.singleargs.contains(string)) {
                            this.parseState = CmdLineParseStateEnum.PARSE_SINGLE;
                            continue block7;
                        }
                        this.parseState = CmdLineParseStateEnum.PARSE_PAIR;
                        continue block7;
                    }
                    if (n == 0) {
                        this.exit("A core file or zip file needs to be specified", 1);
                        continue block7;
                    }
                    this.parseState = CmdLineParseStateEnum.PARSE_CMDS;
                    continue block7;
                }
                case PARSE_SINGLE: {
                    this.args.put(string, "true");
                    this.parseState = ++n == stringArray.length ? CmdLineParseStateEnum.PARSE_COMPLETE : CmdLineParseStateEnum.PARSE_SCAN;
                    continue block7;
                }
                case PARSE_PAIR: {
                    if (++n < stringArray.length && stringArray[n].length() > 0 && stringArray[n].charAt(0) != '-') {
                        this.args.put(string, stringArray[n]);
                    } else {
                        this.exit("The parameter " + string + " requires a value to be set", 1);
                    }
                    this.parseState = ++n == stringArray.length ? CmdLineParseStateEnum.PARSE_COMPLETE : CmdLineParseStateEnum.PARSE_SCAN;
                    continue block7;
                }
                case PARSE_CMDS: {
                    if (string.charAt(0) == '-') {
                        this.exit("The startup option " + string + " occurred in an unexpected position", 1);
                    }
                    stringBuilder.append(stringArray[n]);
                    if (++n < stringArray.length) {
                        stringBuilder.append(" ");
                        continue block7;
                    }
                    this.commands.add(stringBuilder.toString());
                    this.parseState = CmdLineParseStateEnum.PARSE_COMPLETE;
                    continue block7;
                }
            }
            this.exit("Internal error occurred an unknown state was reached whilst processing the command line args", 4);
        }
        if (this.parseState != CmdLineParseStateEnum.PARSE_COMPLETE) {
            this.exit("Internal error occurred whilst processing the command line args", 4);
        }
    }

    private void checkArgIsRecognised(String string) {
        if (this.pairedargs.contains(string) || this.singleargs.contains(string)) {
            return;
        }
        this.exit("The command " + string + " was not recognised", 1);
    }

    private void logCommandLineArgs() {
        if (!this.isVerboseEnabled) {
            return;
        }
        this.out.println("Startup parameters: ");
        for (String string : this.args.keySet()) {
            this.out.print("    " + string);
            if (this.args.get(string) == null) {
                this.out.println(" : not set");
                continue;
            }
            this.out.println(" = " + this.args.get(string));
        }
        this.out.println("Batch mode commands: " + this.commands.toString());
    }

    private void printHelp() {
        String string = System.getProperty("com.ibm.jvm.dtfjview.launcher", "dtfjview");
        this.out.print("Usage: \"" + string + " -core <core_file> [-xml <xml_file>] [-verbose]\" or \n       \"" + string + " -zip <zip_file> [-verbose]\" or \n       \"" + string + " -version\"\n\nTo analyze dumps from DDR-enabled JVMs, " + string + " only requires a core file, no XML file is needed.\n\nTo analyze dumps from non DDR-enabled JVMs, " + string + " requires both core and XML files (jextract must be run on the dump first, to produce the XML file).\n\nThe default ImageFactory is " + this.factoryName + ". To change the ImageFactory use: \n\t -J-D" + "com.ibm.dtfj.image.factoryclass" + "=<classname> \n\n");
        this.out.print(string + " can also be used in 'batch mode' whereby commands can be issued without entering an interactive prompt.\nThis processing is controlled via the following command line options :\n        -cmdfile <path to command file> : will read and sequentially execute\n                                          a series of " + string + " commands in the specified file\n        -charset <character set name>   : specifies the character set for the commands in -cmdfile.\n        -outfile <path to output file>  : file to store any output generated by commands\n        -overwrite                      : specifies that the file specified by -outfile should be overwritten\n        -append                         : specifies that the file specified by -outfile should be appended.\n\nIt is possible to execute a single command without specifying a command file by appending the command to the end\n of the command line which executes " + string + "\ne.g. " + string + " -core mycore.dmp info class\n\nFinally, some commands which take the * parameter will need to have that specified on the command line as ALL\nThis is to ensure correct processing by the OS e.g. " + string + " -core mycore.dmp info thread ALL\n");
    }

    private void processOutfile() {
        if (!this.args.containsKey(ARG_OUTFILE)) {
            return;
        }
        String string = this.stripQuotesFromFilename(this.args.get(ARG_OUTFILE));
        File file = new File(string);
        boolean bl = this.hasFlagBeenSet(ARG_APPEND);
        boolean bl2 = this.hasFlagBeenSet(ARG_OVERWRITE);
        if (bl && bl2) {
            this.exit("Option -append and option -overwrite can not be used at the same time.", 6);
        }
        if (file.exists()) {
            boolean bl3;
            if (this.isVerboseEnabled) {
                this.out.println("Specified output file " + this.args.get(ARG_OUTFILE) + " already exists, checking " + ARG_OVERWRITE + " flag and " + ARG_APPEND + " flag");
            }
            if (!bl2 && !bl) {
                this.exit("The output file " + file.getAbsolutePath() + " exists and neither " + ARG_OVERWRITE + " option nor " + ARG_APPEND + " option was specified", 5);
            }
            if (!file.isFile()) {
                this.exit("The output file " + file.getAbsolutePath() + " exists but is not a file", 2);
            }
            if (bl2 && !(bl3 = file.delete())) {
                this.exit("The output file " + file.getAbsolutePath() + " exists, and is a file, but could not be deleted", 2);
            }
        }
        try {
            FileWriter fileWriter = null;
            fileWriter = file.exists() && bl ? new FileWriter(file, true) : new FileWriter(file);
            this.foc = new FileOutputChannel(fileWriter, file);
            this.out.addChannel(this.foc);
            ToolsRegistryOutputChannels.addChannel(this.foc);
        }
        catch (IOException iOException) {
            this.logException("Error creating output file", iOException);
            this.exit("Unexpected error creating the output file " + file.getAbsolutePath(), 4);
        }
    }

    private String stripQuotesFromFilename(String string) {
        if (string.length() > 0 && string.charAt(0) == '\"') {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void processCommandFile() {
        if (!this.args.containsKey(ARG_CMDFILE)) {
            return;
        }
        List<String> list = this.parseCommandsFromFile();
        if (list != null) {
            this.commands.addAll(list);
        }
    }

    private List<String> parseCommandsFromFile() {
        String string = this.stripQuotesFromFilename(this.args.get(ARG_CMDFILE));
        File file = new File(string);
        if (!file.exists() || !file.isFile()) {
            this.exit("The specified command file " + file.getAbsolutePath() + " does not exist or is not a file", 2);
        }
        if (file.length() > Integer.MAX_VALUE) {
            this.exit("The specified command file " + file.getAbsolutePath() + " is too large to be read", 2);
        }
        String string2 = null;
        if (this.args.containsKey(ARG_CHARSET)) {
            string2 = this.args.get(ARG_CHARSET);
        }
        try {
            return CmdFileTool.parseCmdFile(file, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.exit("The supplied charset " + string2 + " for reading the command file is not supported", 1);
            return null;
        }
        catch (IOException iOException) {
            this.logException("Error reading from command file " + file.getAbsolutePath(), iOException);
            this.exit("Error reading from command file " + file.getAbsolutePath(), 2);
            return null;
        }
    }

    private void imageFromCommandLine() {
        if (this.hasFlagBeenSet(ARG_VERSION)) {
            this.ctxroot.execute(CMD_OPEN, this.out.getPrintStream());
            this.exit(null, 0);
        }
        String string = null;
        if (this.hasFlagBeenSet(ARG_VERBOSE)) {
            Logger.getLogger("j9ddr.view.dtfj").setLevel(Level.WARNING);
        }
        long l = System.currentTimeMillis();
        if (this.args.containsKey(ARG_CORE)) {
            if (this.args.containsKey(ARG_ZIP)) {
                this.exit("-zip and -core cannot be specified at the same time", 1);
            } else {
                string = this.args.get(ARG_CORE);
                if (this.args.containsKey(ARG_XML)) {
                    this.ctxroot.execute("open " + string + " " + this.args.get(ARG_XML), this.out.getPrintStream());
                } else {
                    this.ctxroot.execute("open " + string, this.out.getPrintStream());
                }
            }
        } else {
            string = this.args.get(ARG_ZIP);
            this.ctxroot.execute("open " + string, this.out.getPrintStream());
        }
        this.logger.fine(String.format("Time taken to load image %d ms", System.currentTimeMillis() - l));
        this.variables.put("core_file_path", string);
    }

    @Override
    public void findAndSetContextWithJVM() {
        try {
            Collection<ArrayList<ICombinedContext>> collection = this.ctxmgr.getContexts().values();
            if (collection.size() == 0) {
                this.currentContext = this.ctxroot;
                return;
            }
            ICombinedContext iCombinedContext = null;
            for (ArrayList<ICombinedContext> arrayList : collection) {
                for (ICombinedContext iCombinedContext2 : arrayList) {
                    if (iCombinedContext == null) {
                        iCombinedContext = iCombinedContext2;
                    }
                    if (iCombinedContext2.getRuntime() == null) continue;
                    this.setContext(iCombinedContext2);
                    return;
                }
            }
            this.setContext(iCombinedContext);
        }
        catch (com.ibm.java.diagnostics.utils.commands.CommandException commandException) {
            this.out.print("ERROR : Unable to set current context");
        }
    }

    public void run() {
        if (this.currentContext == null) {
            this.out.println("No current context - exiting");
            return;
        }
        try {
            if (this.isInteractiveSession) {
                this.runInteractive();
            } else {
                this.runBatch();
            }
        }
        catch (Exception exception) {
            this.out.println("Unexpected system error, terminating application. Run with -verbose for more information");
            this.logger.log(Level.FINE, "Failed to start the session", exception);
        }
        try {
            this.ctxmgr.removeAllContexts();
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "Error closing contexts: ", exception);
            this.out.println("Error closing contexts: " + exception.getMessage());
        }
    }

    private void runBatch() {
        this.findAndSetContextWithJVM();
        this.showContexts(true);
        String string = null;
        PrintStream printStream = ToolsRegistryOutputChannels.newPrintStream();
        while ((string = this.commands.poll()) != null) {
            printStream.println(prompt + string);
            try {
                ToolsRegistry.recordAndExecute(string);
            }
            catch (CommandException commandException) {
                this.out.println(commandException.getMessage());
            }
        }
        this.out.close();
    }

    private void runInteractive() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "";
        String string2 = "";
        this.out.println("For a list of commands, type \"help\"; for how to use \"help\", type \"help help\"");
        while (string2 == null || !string2.equals("on")) {
            if (this.ctxmgr.hasChanged()) {
                if (this.currentContext instanceof CombinedContext) {
                    int n = this.currentContext.getID();
                    if (this.ctxmgr.getContext(n) == null) {
                        this.findAndSetContextWithJVM();
                    }
                } else {
                    this.findAndSetContextWithJVM();
                }
                this.showContexts(true);
                this.setPrompt();
            }
            this.out.printPrompt(prompt);
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                this.out.print("IOException encountered while reading input; exiting program...");
                break;
            }
            if (null == string) {
                this.out.print("End of input stream has been reached; exiting program...");
                break;
            }
            try {
                ToolsRegistry.recordAndExecute(string);
            }
            catch (CommandException commandException) {
                this.out.println(commandException.getMessage());
            }
            string2 = (String)this.currentContext.getProperties().get("quit");
        }
        this.out.close();
    }

    public void execute(String string, PrintStream printStream) {
        this.out.removeChannel(this.defaultOutputChannel);
        if (this.foc != null) {
            this.out.removeChannel(this.foc);
        }
        OutputChannelRedirector outputChannelRedirector = new OutputChannelRedirector(printStream);
        this.out.addChannel(outputChannelRedirector);
        this.execute(string);
        this.out.removeChannel(outputChannelRedirector);
        if (this.foc != null) {
            this.out.addChannel(this.foc);
        }
        this.out.addChannel(this.defaultOutputChannel);
    }

    @Override
    public void execute(String string) {
        String string2 = string.trim();
        if (!string2.equals("")) {
            try {
                CommandParser commandParser = new CommandParser(string);
                String string3 = commandParser.getCommand();
                if (string3.equals(CMD_CONTEXT)) {
                    this.switchContext(string2.toLowerCase());
                } else if (string3.equals("set") && commandParser.getArguments().length > 0 && commandParser.getArguments()[0].equals("logging")) {
                    String[] stringArray = commandParser.getArguments();
                    String[] stringArray2 = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                    this.ctxroot.execute("set logging", stringArray2, this.out.getPrintStream());
                } else if (string3.equals("show") && commandParser.getArguments().length > 0 && commandParser.getArguments()[0].equals("logging")) {
                    String[] stringArray = commandParser.getArguments();
                    String[] stringArray3 = new String[stringArray.length - 1];
                    System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
                    this.ctxroot.execute("show logging", stringArray3, this.out.getPrintStream());
                } else if (this.sessioncommands.contains(string3)) {
                    this.ctxroot.execute(commandParser, this.out.getPrintStream());
                } else {
                    this.currentContext.execute(commandParser, this.out.getPrintStream());
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.FINEST, "An error occurred while processing the command: " + string, exception);
                this.out.print("An error occurred while processing the command: " + string);
            }
        }
    }

    private void switchContext(String string) {
        String[] stringArray = string.trim().split(" ");
        try {
            switch (stringArray.length) {
                case 1: {
                    this.showContexts(false);
                    return;
                }
                case 2: {
                    int n = stringArray[1].startsWith("0x") ? 16 : 10;
                    int n2 = 0;
                    n2 = n == 16 ? Integer.parseInt(stringArray[1].substring(2), n) : Integer.parseInt(stringArray[1], n);
                    if (n == 16 && this.isZOS) {
                        if (this.switchContextByASID(stringArray[1])) {
                            return;
                        }
                        this.out.println("The ASID " + stringArray[1] + " was not recognised, context is unchanged");
                        break;
                    }
                    this.setContext(n2);
                    break;
                }
                case 3: {
                    if (stringArray[1].equalsIgnoreCase("asid")) {
                        if (this.isZOS) {
                            if (!this.switchContextByASID(stringArray[2])) {
                                this.out.println("The specified context ASID : " + stringArray[2] + " is not a valid ASID");
                            }
                            break;
                        }
                        this.out.println("Switching context by ASID is not supported for this core file");
                        break;
                    }
                    this.out.println("Invalid command parameters, valid parameters are [ID|asid ID]");
                    break;
                }
                default: {
                    this.out.println("Invalid command parameters, valid parameters are [ID|asid ID]");
                    return;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.out.println("The specified context ID : " + string + " is not a valid ID");
        }
        catch (Exception exception) {
            this.out.println(exception.getMessage());
        }
    }

    private boolean switchContextByASID(String string) throws Exception {
        int n;
        int n2 = n = string.startsWith("0x") ? 16 : 10;
        if (n == 16 && this.isZOS) {
            for (ArrayList<ICombinedContext> arrayList : this.ctxmgr.getContexts().values()) {
                for (ICombinedContext iCombinedContext : arrayList) {
                    if (!iCombinedContext.getAddressSpace().getID().equalsIgnoreCase(string)) continue;
                    this.setContext(iCombinedContext);
                    return true;
                }
            }
        }
        return false;
    }

    private void enableConsoleLogging(Logger logger) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINE);
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        consoleHandler.setFormatter(simpleFormatter);
        logger.addHandler(consoleHandler);
        logger.setLevel(Level.FINE);
        if (this.isVerboseEnabled) {
            this.out.println("Console logging is now enabled for " + logger.getName());
        }
    }

    private void logException(String string, Exception exception) {
        Object object = this.variables.get(LOGGER_PROPERTY);
        Logger logger = null;
        if (null == object || !(object instanceof Logger)) {
            logger = Logger.getAnonymousLogger();
            logger.fine("Logger not configured or wrong property type, creating an anonymous one");
        } else {
            logger = (Logger)object;
        }
        logger.log(Level.FINE, string, exception);
    }

    private static enum CmdLineParseStateEnum {
        PARSE_SCAN,
        PARSE_PAIR,
        PARSE_SINGLE,
        PARSE_CMDS,
        PARSE_COMPLETE;

    }
}

