/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.monitor;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.SovereignParserPartManager;
import com.ibm.dtfj.javacore.parser.j9.SovereignSectionParserPart;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.IMonitorTypes;

public class MonitorSectionParser
extends SectionParser
implements IMonitorTypes {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public MonitorSectionParser() {
        super("LOCKS");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.poolInfo();
        this.objectLocks();
        this.systemLocks();
        this.sovOnlyRules("1LKREGMONDUMP");
    }

    private void poolInfo() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.processTagLineRequired("1LKPOOLINFO");
        this.sovOnlyRules("1LKPOOLINFO");
        this.processTagLineRequired("2LKPOOLTOTAL");
        this.sovOnlyRules("2LKPOOLTOTAL");
    }

    private void objectLocks() throws ParserException {
        this.processTagLineRequired("1LKMONPOOLDUMP");
        this.monitorsInUse();
    }

    private void systemLocks() throws ParserException {
        this.processTagLineRequired("1LKREGMONDUMP");
        this.registeredMonitors();
    }

    private void monitorsInUse() throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        while ((iAttributeValueMap = this.processTagLineOptional("2LKMONINUSE")) != null) {
            long l = iAttributeValueMap.getLongValue("mon_system_monitor");
            long l2 = -1L;
            String string = null;
            long l3 = -1L;
            iAttributeValueMap = this.processTagLineRequired("3LKMONOBJECT");
            if (iAttributeValueMap != null) {
                string = iAttributeValueMap.getTokenValue("mon_obj_full_java_name");
                string = MonitorSectionParser.fixMonitorClassName(string);
                l2 = iAttributeValueMap.getLongValue("monitor_object_address");
                l3 = iAttributeValueMap.getLongValue("monitor_thread_id");
            }
            try {
                this.generateMonitor(null, l, l2, string, l3);
            }
            catch (BuilderFailureException builderFailureException) {
                this.handleError("Could not add monitor to builder: " + l, builderFailureException);
            }
        }
    }

    static String fixMonitorClassName(String string) {
        if ((string = string.replaceAll("\\.", "/")).endsWith("]")) {
            int n = string.lastIndexOf(91);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (string.startsWith("[")) {
                string = "[" + string;
            } else if (!string.endsWith("]")) {
                string = "[L" + string + ";";
            } else if (string.equals("byte[]")) {
                string = "[B";
            } else if (string.equals("short[]")) {
                string = "[S";
            } else if (string.equals("int[]")) {
                string = "[I";
            } else if (string.equals("long[]")) {
                string = "[J";
            } else if (string.equals("float[]")) {
                string = "[F";
            } else if (string.equals("double[]")) {
                string = "[D";
            } else if (string.equals("boolean[]")) {
                string = "[Z";
            } else if (string.equals("char[]")) {
                string = "[C";
            }
        }
        return string;
    }

    private JavaMonitor generateMonitor(String string, long l, long l2, String string2, long l3) throws ParserException, BuilderFailureException {
        JavaMonitor javaMonitor = this.fRuntimeBuilder.addJavaMonitor(string, l, l2, string2, l3);
        this.waitOnNotifyOrEnter(javaMonitor);
        return javaMonitor;
    }

    /*
     * Unable to fully structure code
     */
    private void waitOnNotifyOrEnter(JavaMonitor var1_1) throws ParserException {
        var2_2 = false;
        var3_3 = null;
        block0: while (true) {
            var3_3 = "3LKNOTIFYQ";
            var2_2 = this.matchOptional("3LKNOTIFYQ");
            if (!var2_2 && !this.matchOptional("3LKWAITERQ")) break;
            this.consume();
            var4_4 = this.lookAhead(1);
            if (var4_4 != null && var4_4.getType().equals("UNPARSED")) {
                this.consume();
            }
            var3_3 = var2_2 != false ? "3LKWAITNOTIFY" : "3LKWAITER";
            var5_5 = null;
            var5_5 = this.processTagLineRequired(var3_3);
            if (var5_5 == null) continue;
            this.processNotifyOrEnterThreads(var1_1, var5_5, var2_2);
            while (true) {
                if ((var5_5 = this.processTagLineOptional(var3_3)) != null) ** break;
                continue block0;
                this.processNotifyOrEnterThreads(var1_1, var5_5, var2_2);
            }
            break;
        }
    }

    private void processNotifyOrEnterThreads(JavaMonitor javaMonitor, IAttributeValueMap iAttributeValueMap, boolean bl) throws ParserException {
        String string = iAttributeValueMap.getTokenValue("monitor_thd_name");
        if (string != null && string.length() >= 2) {
            string = string.substring(1, string.length() - 1);
        }
        long l = iAttributeValueMap.getLongValue("monitor_thread_id");
        try {
            if (bl) {
                this.fRuntimeBuilder.addWaitOnNotifyThread(javaMonitor, l);
            } else {
                this.fRuntimeBuilder.addBlockedThread(javaMonitor, l);
            }
        }
        catch (BuilderFailureException builderFailureException) {
            String string2 = bl ? "Could not add wait on notify thread" : "could not add blocked thread";
            string2 = string2 + ", thread name: " + string + ", thread ID: " + l;
            ImagePointer imagePointer = javaMonitor.getID();
            if (imagePointer != null) {
                string2 = string2 + ", monitor ID: " + imagePointer.getAddress();
            }
            this.handleError(string2, builderFailureException);
        }
    }

    private void registeredMonitors() throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        while ((iAttributeValueMap = this.processTagLineOptional("2LKREGMON")) != null) {
            this.processRegMonitors(iAttributeValueMap);
        }
    }

    private void processRegMonitors(IAttributeValueMap iAttributeValueMap) throws ParserException {
        if (iAttributeValueMap != null) {
            String string = iAttributeValueMap.getTokenValue("mon_monitor_name");
            long l = iAttributeValueMap.getLongValue("mon_monitor_address");
            try {
                this.generateMonitor(string, l, -1L, null, -1L);
            }
            catch (BuilderFailureException builderFailureException) {
                this.handleError("Failed to add monitor: " + string + ", " + l, builderFailureException);
            }
        }
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
        SovereignSectionParserPart sovereignSectionParserPart = SovereignParserPartManager.getCurrent().getSovPart(this.getSectionName());
        if (sovereignSectionParserPart != null) {
            sovereignSectionParserPart.readIntoDTFJ(this.getLookAheadBuffer(), this.fImageBuilder);
            sovereignSectionParserPart.computeSovRule(string, this.getLookAheadBuffer());
        }
    }
}

