/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaException;
import com.ibm.oti.vm.VM;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Cuda {
    private static native long allocatePinnedBuffer(long var0) throws CudaException;

    public static ByteBuffer allocatePinnedHostBuffer(long l) throws CudaException {
        if (0L <= l && l <= Integer.MAX_VALUE) {
            long l2 = Cuda.allocatePinnedBuffer(l);
            ByteBuffer byteBuffer = Cuda.wrapDirectBuffer(l2, l);
            return Cleaner.instance.insert(byteBuffer, l2).order(ByteOrder.LITTLE_ENDIAN);
        }
        throw new IllegalArgumentException(String.valueOf(l));
    }

    public static native int getDeviceCount() throws CudaException;

    public static native int getDriverVersion() throws CudaException;

    static native String getErrorMessage(int var0);

    public static native int getRuntimeVersion() throws CudaException;

    private static native int initialize(Class<CudaException> var0, Method var1);

    static void loadNatives() {
    }

    private static native ByteBuffer wrapDirectBuffer(long var0, long var2);

    private Cuda() {
    }

    static {
        Method method;
        AccessController.doPrivileged(() -> {
            String string = System.getProperty("com.ibm.oti.vm.library.version", "29");
            System.loadLibrary("cuda4j".concat(string));
            return null;
        });
        try {
            method = Runnable.class.getMethod("run", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
        int n = Cuda.initialize(CudaException.class, method);
        if (n != 0) {
            throw new RuntimeException(Cuda.getErrorMessage(n));
        }
    }

    private static final class Cleaner
    implements Runnable {
        static final Cleaner instance = new Cleaner();
        private static long releaseCount;
        private final Map<Object, Long> inuse = new ConcurrentHashMap<Object, Long>();
        private final ReferenceQueue<Object> queue = new ReferenceQueue();

        private static native void releasePinnedBuffer(long var0) throws CudaException;

        private Cleaner() {
        }

        ByteBuffer insert(ByteBuffer byteBuffer, long l) {
            this.inuse.put(new WeakReference<Object>(byteBuffer, this.queue), l);
            return byteBuffer;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Long l;
                        if ((l = this.inuse.remove(this.queue.remove())) == null) {
                            continue;
                        }
                        Cleaner.releasePinnedBuffer(l);
                        ++releaseCount;
                    }
                }
                catch (CudaException | InterruptedException exception) {
                    continue;
                }
                break;
            }
        }

        static {
            PrivilegedAction<Thread> privilegedAction = () -> VM.getVMLangAccess().createThread(instance, "CUDA pinned buffer cleaner", true, false, true, null);
            Thread thread = AccessController.doPrivileged(privilegedAction);
            thread.start();
        }
    }
}

