/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.walkers.MemoryCategoryIterator;
import com.ibm.j9ddr.vm29.pointer.generated.OMRMemCategoryPointer;
import com.ibm.j9ddr.vm29.pointer.helper.OMRMemCategoryHelper;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Iterator;

public class NativeMemInfoCommand
extends Command {
    private PrintStream out;
    private DecimalFormat myFormatter = new DecimalFormat("#,###");

    public NativeMemInfoCommand() {
        this.addCommand("nativememinfo", "", "Dump the native memory info");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        this.out = printStream;
        try {
            Iterator<? extends OMRMemCategoryPointer> iterator = MemoryCategoryIterator.iterateCategoryRootSet(DTFJContext.getVm().portLibrary());
            while (iterator.hasNext()) {
                OMRMemCategoryPointer oMRMemCategoryPointer = iterator.next();
                this.printSections(oMRMemCategoryPointer, 0);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    void printSections(OMRMemCategoryPointer oMRMemCategoryPointer, int n) throws CorruptDataException {
        ComponentSizeAllocation componentSizeAllocation = this.computeSize(oMRMemCategoryPointer);
        if (componentSizeAllocation.size == 0L) {
            return;
        }
        this.printLine(n, oMRMemCategoryPointer.name().getCStringAtOffset(0L), componentSizeAllocation.size, componentSizeAllocation.allocations);
        int n2 = oMRMemCategoryPointer.numberOfChildren().intValue();
        for (int i = 0; i < n2; ++i) {
            UDATA uDATA = oMRMemCategoryPointer.children().at(i);
            OMRMemCategoryPointer oMRMemCategoryPointer2 = OMRMemCategoryHelper.getMemoryCategory(uDATA);
            this.printSections(oMRMemCategoryPointer2, n + 1);
        }
        long l = oMRMemCategoryPointer.liveBytes().longValue();
        if (l < componentSizeAllocation.size && l != 0L) {
            this.printLine(n + 1, "Other", l, oMRMemCategoryPointer.liveAllocations().longValue());
        }
    }

    private void printLine(int n, String string, long l, long l2) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            this.out.print("|  ");
        }
        this.out.println();
        for (n2 = 0; n2 < n; ++n2) {
            this.out.print(n2 == n - 1 ? "+--" : "|  ");
        }
        CommandUtils.dbgPrint(this.out, "%s: %s bytes / %d allocation%s\n", string, this.myFormatter.format(l), l2, l2 > 1L ? "s" : "");
    }

    private ComponentSizeAllocation computeSize(OMRMemCategoryPointer oMRMemCategoryPointer) throws CorruptDataException {
        ComponentSizeAllocation componentSizeAllocation = new ComponentSizeAllocation();
        componentSizeAllocation.size += oMRMemCategoryPointer.liveBytes().longValue();
        componentSizeAllocation.allocations += oMRMemCategoryPointer.liveAllocations().longValue();
        int n = oMRMemCategoryPointer.numberOfChildren().intValue();
        for (int i = 0; i < n; ++i) {
            UDATA uDATA = oMRMemCategoryPointer.children().at(i);
            OMRMemCategoryPointer oMRMemCategoryPointer2 = OMRMemCategoryHelper.getMemoryCategory(uDATA);
            componentSizeAllocation.add(this.computeSize(oMRMemCategoryPointer2));
        }
        return componentSizeAllocation;
    }

    private class ComponentSizeAllocation {
        protected long size;
        protected long allocations;

        private ComponentSizeAllocation() {
        }

        public void add(ComponentSizeAllocation componentSizeAllocation) {
            this.size += componentSizeAllocation.size;
            this.allocations += componentSizeAllocation.allocations;
        }
    }
}

