/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class FindAllModulesCommand
extends Command {
    public FindAllModulesCommand() {
        this.addCommand("findallmodules", "", "Outputs all the modules loaded by the runtime");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (JavaVersionHelper.ensureJava9AndUp(j9JavaVMPointer, printStream)) {
                GCClassLoaderIterator gCClassLoaderIterator = GCClassLoaderIterator.from();
                while (gCClassLoaderIterator.hasNext()) {
                    J9ClassLoaderPointer j9ClassLoaderPointer = gCClassLoaderIterator.next();
                    HashTable<J9ModulePointer> hashTable = ModuleHashTable.fromJ9HashTable(j9ClassLoaderPointer.moduleHashTable());
                    Iterator iterator = hashTable.iterator();
                    while (iterator.hasNext()) {
                        J9ModulePointer j9ModulePointer = (J9ModulePointer)iterator.next();
                        String string2 = J9ObjectHelper.stringValue(j9ModulePointer.moduleName());
                        String string3 = j9ModulePointer.getHexAddress();
                        printStream.printf("%-30s !j9module %s%n", string2, string3);
                    }
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

