/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class SlidingImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private long length;
    private long start;
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private int bytesAvailable = 0;
    private boolean EOF = false;
    private int bufferPos = 0;
    private long bytesRead = 0L;
    private boolean hasBufferRefreshed = false;
    private long markBytesRead = 0L;
    private long markFilePos = 0L;
    private long bufferStartPos = 0L;

    public SlidingImageInputStream(File file, long l, long l2) throws IOException {
        this.stream = new FileImageInputStream(file);
        this.init(l, l2);
    }

    public SlidingImageInputStream(ImageInputStream imageInputStream, long l, long l2) throws IOException {
        this.stream = imageInputStream;
        this.init(l, l2);
    }

    private void init(long l, long l2) throws IOException {
        this.stream.seek(l);
        this.checkBuffer();
        this.length = l2;
        this.start = l;
        this.markFilePos = this.stream.getStreamPosition();
    }

    @Override
    public int read() throws IOException {
        if (this.EOF) {
            return -1;
        }
        if (this.bytesRead == this.length) {
            this.EOF = true;
            return -1;
        }
        this.checkBuffer();
        ++this.bytesRead;
        return 0xFF & this.buffer[this.bufferPos++];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.EOF) {
            return -1;
        }
        if (this.bytesRead == this.length) {
            this.EOF = true;
            return -1;
        }
        if (n2 + n > byArray.length) {
            String string = String.format("The array is too small to copy %d bytes starting at offset %d", n2, n);
            throw new IndexOutOfBoundsException(string);
        }
        if (n2 < this.bytesAvailable - this.bufferPos) {
            int n5 = (int)Math.min((long)n2, this.length - this.bytesRead);
            System.arraycopy(this.buffer, this.bufferPos, byArray, n, n5);
            this.bufferPos += n5;
            this.bytesRead += (long)n5;
            return n5;
        }
        for (n3 = 0; !this.EOF && n3 < n2 && this.bytesRead < this.length; n3 += n4) {
            n4 = (int)Math.min((long)(this.bytesAvailable - this.bufferPos), this.length - this.bytesRead);
            n4 = Math.min(n4, n2 - n3);
            System.arraycopy(this.buffer, this.bufferPos, byArray, n3, n4);
            this.bufferPos += n4;
            this.bytesRead += (long)n4;
            this.checkBuffer();
        }
        return n3;
    }

    private void checkBuffer() throws IOException {
        if (this.bytesAvailable == this.bufferPos) {
            this.bufferStartPos = this.bytesRead;
            this.hasBufferRefreshed = true;
            this.bytesAvailable = this.stream.read(this.buffer);
            if (this.bytesAvailable == -1) {
                this.EOF = true;
            }
            this.bufferPos = 0;
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void mark() {
        this.hasBufferRefreshed = false;
        this.markBytesRead = this.bytesRead;
        super.mark();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        long l = this.bytesRead - this.markBytesRead;
        this.bytesRead -= l;
        if (this.hasBufferRefreshed) {
            this.bufferPos = 0;
            this.bytesAvailable = 0;
            this.stream.seek(this.markFilePos - l);
        } else {
            this.bufferPos = (int)((long)this.bufferPos - l);
        }
    }

    @Override
    public void seek(long l) throws IOException {
        if (l < this.bufferStartPos || l >= this.bufferStartPos + 4096L) {
            this.stream.seek(this.start + l);
            this.bufferPos = 0;
            this.bytesAvailable = 0;
            this.bytesRead = l;
            this.checkBuffer();
            super.seek(l);
        } else {
            int n = (int)(l - this.bufferStartPos);
            this.bytesRead = this.bufferStartPos + (long)n;
            this.bufferPos = n;
        }
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.bytesRead;
    }
}

