/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.File;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class CdCommand
extends BaseJdmpviewCommand {
    public CdCommand() {
        this.addCommand("cd", "", "changes the current working directory, used for log files");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length == 0) {
            printStream.println("\"cd\" requires exactly one parameter");
            return;
        }
        String string2 = "";
        for (String string3 : stringArray) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2.substring(0, string2.length() - 1);
        File file = Utils.absPath(this.ctx.getProperties(), string2);
        if (!file.isDirectory()) {
            if (file.isFile()) {
                printStream.println("cannot change to specified path because it specifies a file, not a directory");
            } else {
                printStream.println("specified path is not a directory or a file; it probably doesn't exist");
            }
        } else {
            this.ctx.getProperties().put("pwd", file);
        }
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("changes the current working directory, used for log files\n\nparameters: <directory_name>\n\nChanges the current working directory to <directory_name>, checking to see if it exists and is a directory before making the change.  The current working directory is where log files are outputted to; a change to the current working directory has no effect on the current log file setting because the logging filename is converted to an absolute path when set.  Note: to see what the current working directory is set to, use the \"pwd\" command.\n");
    }
}

